//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module MAIN.CPP
//
//-----------------------------------------------------------------------------------

//////////////////////////////////////////////////////////////////////////////
// Includes
//												   
//////////////////////////////////////////////////////////////////////////////
#define DBINITCONSTANTS
#define INITGUID

#include "common.h"
#include "msdaguid.h"	//CLSID_OLEDB_ROWPOSITIONLIBRARY
#include <cguid.h>		//GUID_NULL

#include "CTable.h"
#include "Main.h"  
#include "Spy.h"		//IMallocSpy
#include "CDialog.h"	//CDialog
#include "version.h"	//ABOUT Box

#include <locale.h>		//setLocale
#include <richedit.h>	//RichEdit Control Header

#ifdef TXNJOIN
	#include <xolehlp.h> 
	#include <txdtc.h>
#endif
 

//////////////////////////////////////////////////////////////////////////////
// Defines
//
//////////////////////////////////////////////////////////////////////////////
#define OLEDBFRAMECLASS		"ROWSETMAIN"
#define OLEDBMDICLASS		"ROWSETMDI"

enum PROPICONS
{
	IMAGE_NORMAL	= 0,
	IMAGE_READONLY	= 1,
	IMAGE_INFO		= 2,
	IMAGE_ERROR		= 3,
};

enum STATEICONS
{
	STATE_NORMAL	= 0,
	STATE_CHECKED	= 1,
	STATE_UNCHECKED = 2,
};

enum ROWICONS
{
	IMAGE_NFP_BEFORE = IMAGE_ERROR+1,
	IMAGE_NFP_AFTER,
	IMAGE_ROW_DELETE,
	IMAGE_ROW_CHANGE,
};


//////////////////////////////////////////////////////////////////////////////
// Toolbar
//
//////////////////////////////////////////////////////////////////////////////
TOOLINFO tbToolInfo;
const static TBBUTTON tbButtons[] = {
{ 0, IDMENU_CONNECT,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{ 1, IDMENU_DISCONNECT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},

{ 0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},

{ 2, IDMENU_CREATESESSIONWINDOW, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},

{ 0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},

{ 3, IDMENU_RUN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{ 4, IDMENU_EXECUTE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},

{ 0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},

{ 5, IDMENU_RESTARTPOSITION, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{ 6, IDMENU_REFRESH, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{ 7, IDMENU_GETSCHEMAROWSET, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},

{ 0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},

{ 8, IDMENU_SETDATA, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{ 9, IDMENU_INSERTROW, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{10, IDMENU_DELETEROWS, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},

{ 0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},

{11, IDMENU_UPDATE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
{12, IDMENU_UNDO, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},

{ 0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},

};


//////////////////////////////////////////////////////////////////////////////
// WinMain
//
//////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(
	HINSTANCE hInstance, 
	HINSTANCE hPrevInstance, 
	LPSTR lpCmdLine, 
	int nCmdShow
	)
{
	CMainWindow* pCMainWindow = NULL;
	CMallocSpy* pCMallocSpy = NULL; 

	//Register IMallocSpy
	XTESTC(NULL, MallocSpyRegister(&pCMallocSpy)); 
	
	//Create MainWindow
	pCMainWindow = new CMainWindow(NULL, hInstance, hPrevInstance, lpCmdLine, nCmdShow);
	TESTC_(pCMainWindow != NULL, TRUE);

	//Initialize OLE
	XTESTC(NULL, CoInitialize(NULL));

	// Ensure that common control DLL is loaded
	INITCOMMONCONTROLSEX iccex;
	iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
	iccex.dwICC = ICC_LISTVIEW_CLASSES | ICC_TREEVIEW_CLASSES | ICC_TAB_CLASSES;
	TESTC_(InitCommonControlsEx(&iccex), TRUE);
	
	//Set the Locale for all C runtime functions...
	setlocale(LC_ALL, ".ACP");

	//Display MainWindow and RunApp
	TESTC_(pCMainWindow->Run(), TRUE);

CLEANUP:
	SAFE_DELETE(pCMainWindow);
	SetErrorInfo(0, NULL);
	CoUninitialize();

	XTEST(NULL, MallocSpyDump(pCMallocSpy));
	
	//Unregister
	MallocSpyUnRegister(pCMallocSpy);
	SAFE_RELEASE(pCMallocSpy);
	return TRUE;
}


////////////////////////////////////////////////////////////////
// LONG GetColumnImage
//
/////////////////////////////////////////////////////////////////
LONG GetColumnImage(DBCOLUMNINFO* pColInfo, DBSTATUS dwStatus = DBSTATUS_S_OK)
{
	//ReadOnly Column
	if(pColInfo && !(pColInfo->dwFlags & DBCOLUMNFLAGS_WRITE || pColInfo->dwFlags & DBCOLUMNFLAGS_WRITEUNKNOWN))
		return IMAGE_READONLY;

	//Otherwise determine image from Status
	switch(dwStatus)
	{
		case DBSTATUS_S_OK:
		case DBSTATUS_S_ISNULL:
		case DBSTATUS_S_DEFAULT:
			return IMAGE_NONE;

		case DBSTATUS_S_TRUNCATED:
			return IMAGE_INFO;

		default:
			return IMAGE_ERROR;
	}

	return IMAGE_NORMAL;
}


//static members
ULONG CMainWindow::m_ulChildWindows = 0;
HWND  CMainWindow::m_hWndMDIClient = NULL;
////////////////////////////////////////////////////////////////
// CMainWindow::CMainWindow
//
/////////////////////////////////////////////////////////////////
CMainWindow::CMainWindow(HWND hWnd, HINSTANCE hInst, HINSTANCE hInstPrev, CHAR* pszCmdLine, INT iCmdShow)
	: CDialogBase(hWnd, hInst)
{
	//Objects
	m_pCConnectDlg = NULL;
	m_pCOptionsDlg = NULL;
	
	//controls
	m_hWndToolbar = NULL;
	m_hWndStatusbar = NULL;
	
	//data
	m_hInstPrev = hInstPrev;
	m_pszCmdLine = pszCmdLine;
	m_iCmdShow = iCmdShow;
	m_fWarnMaxEditBuffer = TRUE;

	//Cursors
	m_hCurSizeNS = NULL;
	m_hLibRichEdit = NULL;
}


////////////////////////////////////////////////////////////////
// CMainWindow::~CMainWindow
//
/////////////////////////////////////////////////////////////////
CMainWindow::~CMainWindow()
{
	SAFE_DELETE(m_pCConnectDlg);
	SAFE_DELETE(m_pCOptionsDlg);

//	CloseHandle(m_hWndStatusbar);
	if(m_hLibRichEdit)
		FreeLibrary(m_hLibRichEdit);
}


////////////////////////////////////////////////////////////////
// CMainWindow::Display
//
/////////////////////////////////////////////////////////////////
ULONG CMainWindow::Display()
{
	//Register
	WNDCLASSEX	wc;						//class structure

	// Register window classes for the application - Main Window Class
	wc.cbSize			= sizeof(WNDCLASSEX);
	wc.style			= 0;
	wc.lpfnWndProc		= CMainWindow::MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= m_hInst;
	wc.hIcon			= LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROWSETVIEWER));
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)(COLOR_APPWORKSPACE+1);
	wc.lpszMenuName		= MAKEINTRESOURCE(IDMENU_MAINMENU);
	wc.lpszClassName	= OLEDBFRAMECLASS;
	wc.hIconSm			= LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROWSETVIEWER));

	if(!RegisterClassEx(&wc))
		return FALSE;

	// register MDI Child Window Class
	wc.hIcon 			= LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROWSETICON));
	wc.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wc.cbWndExtra		= DLGWINDOWEXTRA;
	wc.lpszClassName	= OLEDBMDICLASS;
	wc.lpfnWndProc		= CMDIChild::MDIWinProc;
	wc.hIconSm			= LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROWSETICON));

	if(!RegisterClassEx(&wc))
		return FALSE;

	//Create Main window, (with "this" pointer)
	if(!(m_hWnd = CreateWindowEx(
			WS_EX_CONTROLPARENT,
			OLEDBFRAMECLASS, 
			"Microsoft OLE DB RowsetViewer", 
			WS_OVERLAPPEDWINDOW, 
			CW_USEDEFAULT, CW_USEDEFAULT, 
			CW_USEDEFAULT, CW_USEDEFAULT,
			NULL, 
			NULL, 				
			m_hInst, 
			this)))
		goto CLEANUP;

	//Objects
	m_pCConnectDlg = new CConnectDlg(m_hWnd, m_hInst, this);
	m_pCOptionsDlg = new COptionsDlg(m_hWnd, m_hInst, this);

	//Make the window visible; update its client area; and return "success" 
	ShowWindow(m_hWnd, m_iCmdShow);
	UpdateWindow(m_hWnd); 

	//See if we can load the RichEdit Controls
	m_hLibRichEdit = LoadLibrary("RICHED32.DLL");
				  
CLEANUP:
	return m_hWnd ? TRUE : FALSE;      
}


////////////////////////////////////////////////////////////////
// CMainWindow::Destroy
//
/////////////////////////////////////////////////////////////////
ULONG CMainWindow::Destroy()
{
	RemoveAllChildren();
	PostQuitMessage(0);
	m_hWnd = NULL;
	return TRUE;
}
	
////////////////////////////////////////////////////////////////
// CMainWindow::Run
//
/////////////////////////////////////////////////////////////////
ULONG CMainWindow::Run()
{
	MSG		msg;

	if(!Display())
		return FALSE;

	//load accelerators
	HACCEL	hAccel = LoadAccelerators(m_hInst, MAKEINTRESOURCE(IDA_ACCELERATOR));
	
	// acquire and dispatch messages until a WM_QUIT message is received
	while(GetMessage(&msg, NULL, 0, 0))
	{           
		// check for MDI accelerators
		if(m_hWndMDIClient && TranslateMDISysAccel(m_hWndMDIClient, &msg))
			continue;
		
		// check for App accelerators
		if(m_hWnd && TranslateAccelerator(m_hWnd, hAccel, &msg))
			continue;
			
        // if the message does not need special processing, dispatch it
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return TRUE;      
}


////////////////////////////////////////////////////////////////
// CMainWindow::InitControls
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::InitControls(HWND hWnd)
{
	m_hWnd = hWnd;

	//Create ToolBar
	m_hWndToolbar = CreateToolbarEx( 
		hWnd,					// parent
		WS_CHILD | WS_BORDER | WS_VISIBLE | TBSTYLE_TOOLTIPS | TBSTYLE_WRAPABLE | TBSTYLE_ALTDRAG | CCS_ADJUSTABLE,   // window style
		ID_TOOLBAR,             // toolbar id
		8,                      // number of bitmaps
		m_hInst,	            // mod instance
		IDB_TOOLBAR,            // resource ID for bitmap
		(LPCTBBUTTON)&tbButtons,// address of buttons
		NUMELE(tbButtons),      // number of buttons
		16,16,                  // width & height of buttons
		16,16,                  // width & height of bitmaps
		sizeof(TBBUTTON));      // structure size

    //Create ToolTips
    HWND hWndTT = (HWND)SendMessage(m_hWndToolbar, TB_GETTOOLTIPS, 0, 0);
	if(hWndTT)
    {
	    TOOLINFO lpToolInfo;
        // Fill out the TOOLINFO structure.
        lpToolInfo.cbSize = sizeof(lpToolInfo);
		// The uID is the handle of the tool (the combo box).
        lpToolInfo.uFlags = TTF_CENTERTIP;
		// the string ID in the resource
        lpToolInfo.lpszText = (LPSTR)IDB_TOOLBAR;
		// the window that gets the ToolTip messages
        lpToolInfo.hwnd = m_hWndToolbar;
		// the tool
        lpToolInfo.uId = (UINT)m_hWndToolbar;
		// the instance that owns the string resource
        lpToolInfo.hinst = m_hInst;

        // Set up the ToolTips for the combo box.
        SendMessage(hWndTT, TTM_ADDTOOL, 0, (LPARAM)&lpToolInfo);
    }
	
	//Create StatusBar
	m_hWndStatusbar = CreateStatusWindow(WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS, 
		"", hWnd, ID_STATUSBAR);


	//Create MDI Client Window
	CLIENTCREATESTRUCT	ccs;		//MDIclient window structure
	ccs.hWindowMenu = GetSubMenu(GetMenu(hWnd), 10/*IDMENU_WINDOW*/);
	ccs.idFirstChild = IDC_MDICHILD;

	m_hWndMDIClient = CreateWindowEx(NULL, "MDICLIENT", NULL, WS_CHILD | WS_CLIPSIBLINGS |
		WS_CLIPCHILDREN | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE | CS_DBLCLKS, 
		CW_USEDEFAULT, CW_USEDEFAULT, 
		CW_USEDEFAULT, CW_USEDEFAULT,
		hWnd, (HMENU)ID_MDICLIENT, m_hInst, (LPSTR)&ccs);

	// check to see if any of the above window creation failed
	if(!m_hWndToolbar || !m_hWndStatusbar || !m_hWndMDIClient)
	{
		wMessageBox(hWnd, 
			MB_OK|MB_ICONHAND|MB_SYSTEMMODAL,
			wsz_ERROR, L"Unable to load ToolBar, StatusBar, and MDIClient Windows!"); 
		PostMessage(hWnd, WM_CLOSE, 0, 0);
		return FALSE;
	}

	//Load Cursors
	m_hCurSizeNS = LoadCursor(NULL, MAKEINTRESOURCE(IDC_SIZENS));
	return TRUE;
}


////////////////////////////////////////////////////////////////
// CMainWindow::RefreshControls
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::RefreshControls()
{
	if(GetActiveChild() == NULL)
	{
		//Turn off all buttons except for INITIALIZE
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_CONNECT,				TRUE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_DISCONNECT,			FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_CREATESESSIONWINDOW,	FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_RUN,					FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_EXECUTE,				FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_RESTARTPOSITION,		FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_REFRESH,				FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_GETSCHEMAROWSET,		FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_INSERTROW,			FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_DELETEROWS,			FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_SETDATA,				FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_UPDATE,				FALSE);
		SendMessage(m_hWndToolbar, TB_ENABLEBUTTON, IDMENU_UNDO,				FALSE);

		//Reset Window Count
		m_ulChildWindows = 0;
	}
	return TRUE;
}


////////////////////////////////////////////////////////////////
// CMainWindow::DisplayStatusBarItem
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::DisplayStatusBarItem(UINT uResourceID)
{
	CHAR szBuffer[MAX_NAME_LEN+1];
	szBuffer[0] = EOL;

	//Load the string from the StringTable in the resource
	if(uResourceID)
		LoadString(m_hInst, uResourceID, szBuffer, MAX_NAME_LEN);

	return SendMessage(m_hWndStatusbar, WM_SETTEXT, 0, (LPARAM)szBuffer);
}

	
////////////////////////////////////////////////////////////////
// CMainWindow::GetActiveChild
//
/////////////////////////////////////////////////////////////////
HWND CMainWindow::GetActiveChild()
{
	return GetWindow(m_hWndMDIClient, GW_CHILD);
}

////////////////////////////////////////////////////////////////
// CMainWindow::GetActiveChildObj
//
/////////////////////////////////////////////////////////////////
CMDIChild* CMainWindow::GetActiveChildObj()
{
	HWND hWndChild = GetActiveChild();
	return hWndChild ? (CMDIChild*)GetThis(hWndChild) : NULL;
}


////////////////////////////////////////////////////////////////
// CMainWindow::FullConnect
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::FullConnect(HWND hWnd)
{
	//Need to first bring up Connection Dialog
	ASSERT(m_pCConnectDlg);
	return m_pCConnectDlg->Display();
}


////////////////////////////////////////////////////////////////
// CMainWindow::RemoveChild
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::RemoveChild(HWND hWnd)
{
	if(hWnd)
	{
		//Obtain CMDIChild object pointer
		CMDIChild* pCMDIChild = (CMDIChild*)GetThis(hWnd);

		//Tell the window to destroy itself
		SendMessage(m_hWndMDIClient, WM_MDIDESTROY, (WPARAM)hWnd, 0);
		
		//Now that the window has been destoryed
		//Delete our CMDIChild which corresponds to that window
		SAFE_DELETE(pCMDIChild);
	}
	return TRUE;
}


////////////////////////////////////////////////////////////////
// CMainWindow::RemoveAllChildren
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::RemoveAllChildren()
{
	HWND	hWndTemp;	//temp window handle

	//hide MDI Client Windows to avoid repaints
	ShowWindow(m_hWndMDIClient,SW_HIDE);
	
	//Loop through all ChildWindows and Remove
	while(hWndTemp = GetActiveChild())
		RemoveChild(hWndTemp);

	ShowWindow(m_hWndMDIClient, SW_SHOW);
	return TRUE;
}


////////////////////////////////////////////////////////////////
// BOOL CMainWindow::WantedMenuPos
//
/////////////////////////////////////////////////////////////////
BOOL CMainWindow::WantedMenuPos(HMENU hMenu, UINT uPos, DWORD* pdwFlags)
{
	ASSERT(pdwFlags);
	*pdwFlags = 0;
	
	ULONG ulMenuID = GetMenuItemID(hMenu, uPos);

	//Need to handle the "MDI Window" menu
	if(hMenu == GetSubMenu(GetMenu(m_hWnd), 10/*IDMENU_WINDOW*/) && uPos >= 12) 
		return TRUE;
	
	//SubMenu
	if(ulMenuID == ULONG_MAX)
	{
		//Recursive Alogorytm
		HMENU hSubMenu = GetSubMenu(hMenu, uPos);
		INT iItems = GetMenuItemCount(hSubMenu);
		for(LONG i=0; i<iItems; i++)
		{
			if(WantedMenuPos(hSubMenu, i, pdwFlags))
			{
				*pdwFlags = 0;
				return TRUE;
			}
		}
	
		return FALSE;
	}
		
	//Item
	switch(ulMenuID)
	{
		//FILE
		case IDMENU_EXIT:
			return TRUE;

		//WINDOW
		case IDMENU_CLOSE:
		case IDMENU_CLOSEALL:
		case IDMENU_NEXTWINDOW:
		case IDMENU_PREVWINDOW:
		case IDMENU_CASCADE:
		case IDMENU_TILEHORIZONTAL: 
		case IDMENU_TILEVERTICAL: 
		case IDMENU_ICONS: 
			return GetActiveChild() ? TRUE : FALSE;

		//CONNECT
		case IDMENU_CONNECT:
		case IDMENU_OPTIONS:
			return TRUE;
		case IDMENU_DISCONNECT:
			return GetActiveChild() ? TRUE : FALSE;
	
		//Recent Configurations
		case IDMENU_RECENTCONFIG1:
		case IDMENU_RECENTCONFIG2:
		case IDMENU_RECENTCONFIG3:
		case IDMENU_RECENTCONFIG4:
		case IDMENU_RECENTCONFIG5:
		case IDMENU_RECENTCONFIG6:
		case IDMENU_RECENTCONFIG7:
		case IDMENU_RECENTCONFIG8:
		case IDMENU_RECENTCONFIG9:
		case IDMENU_RECENTCONFIG10:
			return m_pCConnectDlg->m_listConfigs.GetCount();

		//Recent Files
		case IDMENU_RECENTFILE1:
		case IDMENU_RECENTFILE2:
		case IDMENU_RECENTFILE3:
		case IDMENU_RECENTFILE4:
		case IDMENU_RECENTFILE5:
		case IDMENU_RECENTFILE6:
		case IDMENU_RECENTFILE7:
		case IDMENU_RECENTFILE8:
		case IDMENU_RECENTFILE9:
		case IDMENU_RECENTFILE10:
			return m_pCConnectDlg->m_listFiles.GetCount();

		//IDataInitialize - Using ServiceComponents
		case IDMENU_IDATAINITIALIZE_CREATEDBINSTANCE:
		case IDMENU_IDATAINITIALIZE_CREATEDBINSTANCEEX:
			return FALSE;

		case IDMENU_IDATAINITIALIZE_GETDATASOURCE:
		case IDMENU_IDATAINITIALIZE_LOADSTRINGFROMSTORAGE:
			return (BOOL)m_pCConnectDlg->pIDataInitialize();

		//IDBPromptInitialize - Using ServiceComponents
		case IDMENU_PROMPTINITIALIZE_PROMPTDATASOURCE:
		case IDMENU_PROMPTINITIALIZE_PROMPTFILENAME:
			return (BOOL)m_pCConnectDlg->pIDBPromptInitialize();

		//HELP
//		case IDMENU_HELP:
		case IDMENU_ABOUT:
			return TRUE;

		//Otherwise we have no clue what this command is...
		default:
			break;
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMainWindow::MainWndProc
//
/////////////////////////////////////////////////////////////////
LONG CALLBACK CMainWindow::MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:
        {
			//Save the "this" pointer
			Busy();
			CREATESTRUCT* pCS = (CREATESTRUCT*)lParam;
			CMainWindow* pThis = (CMainWindow*)SetThis(hWnd, (LPARAM)pCS->lpCreateParams);
			CenterDialog(hWnd);
			
			EXC_TEST(pThis->InitControls(hWnd));
			EXC_TEST(pThis->RefreshControls());
			Busy(OFF);
			return 0;
		}

		// Resize children
		case WM_SIZE:
        {
			//Get the "this" pointer
			CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);

			WORD	wWidth = LOWORD(lParam);	//width of rectangle
			WORD	wHeight = HIWORD(lParam);	//height of rectangle

			// calculate proper text height for tool and status bars
			SIZE sizeToolBar	= GetWindowSize(pThis->m_hWndToolbar);
			SIZE sizeStatusBar	= GetWindowSize(pThis->m_hWndStatusbar);

			if(wWidth && wHeight)
			{
				MoveWindow(pThis->m_hWndToolbar, 0, 0, wWidth, sizeToolBar.cy, TRUE);
				MoveWindow(pThis->m_hWndStatusbar, 0, wHeight-sizeStatusBar.cy, wWidth, sizeStatusBar.cy, TRUE);
				MoveWindow(m_hWndMDIClient, 0, sizeToolBar.cy, wWidth, wHeight-sizeToolBar.cy-sizeStatusBar.cy, TRUE);
			}

			//TODO- for some reason this call makes the MDIChild start under the toolbar?
			//DefFrameProc(hWnd, m_hWndMDIClient, message, wParam, lParam);
			return 0;
        }
		
		// Initialize popup menus
		case WM_INITMENUPOPUP:
        {
	        //Ignore the msg if it is for a system menu
			if(HIWORD(lParam))
				break;
			
			HMENU hPopupMenu = (HMENU)wParam;
			UINT  uPos  = LOWORD(lParam);

			//Get the "this" pointer
			CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);
			 
			//Go through the menu items for current popup menu
			//and enable/disable menu item, if required
			
			//Our algortym is to turn (by defualt) all menu items off.
			//If there are any we want we (know about) then turn them on.
			
			//Also note that WantedMenuPos is a recursive algortym.  This is for the
			//case where I need to detmerine if a "submenu->" is enabled or diasbled.
			//The only way to really tell is to know if there are any subitems that
			//are needed, but some of the subitems inturn may be "submenu->".
			//Therefore a item will be enabled if there is at least one subitem 
			//The is wanted, and disabled if there are no subitems wanted.
			INT iMenuItems = GetMenuItemCount(hPopupMenu);
			DWORD dwFlags = 0;
			for(LONG i=0; i<iMenuItems; i++)
			{
				dwFlags = 0;
				EnableMenuItem(hPopupMenu, i, MF_BYPOSITION | MF_GRAYED);
				if(pThis->WantedMenuPos(hPopupMenu, i, &dwFlags))
				{
					EnableMenuItem(hPopupMenu, i, MF_BYPOSITION | MF_ENABLED);
					CheckMenuItem(hPopupMenu, i, MF_BYPOSITION | dwFlags);
				}
			}

			//Maybe the ChildWindow wants this?
			//TODO we have back pointers now, there is no real reason to send
			//messages arround.  Use GetThis(hWndActive) to get the Child object...
			HWND hWndActive = pThis->GetActiveChild();
			if(hWndActive)
				SendMessage(hWndActive, message, wParam, lParam);
			
			//Reset Resent Configurations
			if(uPos==6 && GetMenuItemID(hPopupMenu, 0)==IDMENU_RECENTCONFIG1)
			{
				CHAR szBuffer[MAX_NAME_LEN+10];
				CList<CHAR*>* pCList = &pThis->m_pCConnectDlg->m_listConfigs;
				ASSERT(pCList);

				//Remove all menu items
				for(i=0; i<iMenuItems; i++)
					DeleteMenu(hPopupMenu, 0, MF_BYPOSITION);

				//Display all Recent Configs
				LONG cRecentConfigs = pCList->GetCount();
				for(i=0; i<cRecentConfigs; i++)
				{
					sprintf(szBuffer, "&%d - %s", i+1, pCList->GetAt(pCList->FindIndex(i)));
					AppendMenu(hPopupMenu, MF_STRING, IDMENU_RECENTCONFIG1 + i, szBuffer);
				}
			}
			
			//Reset Resent Files
			if(uPos==7 && GetMenuItemID(hPopupMenu, 0)==IDMENU_RECENTFILE1)
			{
				CHAR szBuffer[MAX_NAME_LEN+10];
				CList<CHAR*>* pCList = &pThis->m_pCConnectDlg->m_listFiles;
				ASSERT(pCList);

				//Remove all menu items
				for(i=0; i<iMenuItems; i++)
					DeleteMenu(hPopupMenu, 0, MF_BYPOSITION);

				//Display all Recent Files
				LONG cRecentFiles = pCList->GetCount();
				for(i=0; i<cRecentFiles; i++)
				{
					sprintf(szBuffer, "&%d - %s", i+1, pCList->GetAt(pCList->FindIndex(i)));
					AppendMenu(hPopupMenu, MF_STRING, IDMENU_RECENTFILE1 + i, szBuffer);
				}
			}

			return 0;
		}
		
		// Update status bar to reflect menu selection
		case WM_MENUSELECT:
		{	
			//Get the "this" pointer
			CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);
			pThis->DisplayStatusBarItem(LOWORD(wParam));
			return 0;
		}
		
		// Process menu commands
		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				//TODO - I'm not sure why the Frame Window receives the EditBox's
				//Notifications?  It should be the Parent which is the MDIChild.
				switch(GET_WM_COMMAND_CMD(wParam, lParam))
				{
					case EN_MAXTEXT:	
					{
						//Get the "this" pointer
						CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);

						//We may not be interested in this Message...
						if(!pThis->m_fWarnMaxEditBuffer)
							return 0;

						HWND hWndEditBox = (HWND)lParam; // handle of edit control  
						LONG dwSelection = 0;
						BOOL fNotifyWnd = (LOWORD(wParam) == IDC_LISTBOX);

						//Indicate the the user that the Edit Box Buffer
						//Has exceded the Maximum size
 						dwSelection = wMessageBox(hWnd, MB_TASKMODAL | MB_ICONHAND | MB_OKCANCEL | MB_DEFBUTTON1, 
							wsz_ERROR, L"The \"%s\" has exceeded the maximum buffer size.\n\n"
										L"Standard Edit Controls have a limited buffer size, RichEdit Edit Controls do not, please make sure RICHED32.DLL is installed on your system to prevent this message.\n\n"
										L"Press 'OK' to remove all old lines, Press 'Cancel' to ignore all new lines.", fNotifyWnd ? L"Notification Window" : L"Command Window");

						//Handle users request...
						if(dwSelection == IDOK)
						{
							//Remove all old Lines...
							SendMessage(hWndEditBox, WM_SETTEXT, 0, (LPARAM)"");
							pThis->m_fWarnMaxEditBuffer = TRUE;
						}
						else
						{
							//Ignore all new lines...
							//(just bascially ignore this message...)
							pThis->m_fWarnMaxEditBuffer = FALSE;
						}
					}
					return 0;
				};

				break;
			}

			//Get the "this" pointer
			CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);
			HRESULT hr = S_OK;

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				//Bring up FullConnect dialog
				case IDMENU_CONNECT: 
				{	
					EXC_TEST(pThis->FullConnect(hWnd));
					EXC_TEST(pThis->RefreshControls());
					return 0;
				}

				//IDataInitialize - Using ServiceComponents
				case IDMENU_IDATAINITIALIZE_CREATEDBINSTANCE:
				case IDMENU_IDATAINITIALIZE_CREATEDBINSTANCEEX:
					return 0;

				case IDMENU_IDATAINITIALIZE_LOADSTRINGFROMSTORAGE:
					if(pThis->m_pCConnectDlg->pIDataInitialize())
					{
						WCHAR wszFileName[MAX_QUERY_LEN];
						wszFileName[0] = wEOL;

						//Display Common Dialog to obtain File To Load...
						EXC_TEST(hr = BrowseOpenFileName(pThis->m_hInst, hWnd, "IDataInitialize::LoadStringFromStorage", wszFileName, MAX_QUERY_LEN));
						if(SUCCEEDED(hr))
						{
							WCHAR* pwszInitString = NULL;	
	
							//Now LoadStringFromStorage
							EXC_TEST(hr = pThis->m_pCConnectDlg->LoadInitString(wszFileName, &pwszInitString));
							if(SUCCEEDED(hr))
							{
								if(pwszInitString)
								{
									wcsncpy(pThis->m_pCConnectDlg->m_wszInitString, pwszInitString, MAX_QUERY_LEN);
									pThis->m_pCConnectDlg->m_wszInitString[MAX_QUERY_LEN-1] = wEOL;
								}
							
								//Need to bring up the GetDataSource Dialog
								EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_DATAINIT_GETDATASOURCE), hWnd, CConnectDlg::GetDataSourceProc, (LPARAM)pThis->m_pCConnectDlg));
								EXC_TEST(pThis->RefreshControls());
							}
							SAFE_FREE(pwszInitString);
						}
					}
					return 0;

							
				case IDMENU_IDATAINITIALIZE_GETDATASOURCE:
					if(pThis->m_pCConnectDlg->pIDataInitialize())
					{
						//Need to bring up the GetDataSource Dialog
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_DATAINIT_GETDATASOURCE), hWnd, CConnectDlg::GetDataSourceProc, (LPARAM)pThis->m_pCConnectDlg));
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				//Bring up IDBPromptInitialize (PromptDataSource)
				case IDMENU_PROMPTINITIALIZE_PROMPTDATASOURCE: 
					if(pThis->m_pCConnectDlg->pIDBPromptInitialize())
					{
						EXC_TEST(pThis->m_pCConnectDlg->PromptDataSource(DBPROMPTOPTIONS_PROPERTYSHEET));
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				//Bring up IDBPromptInitialize (PromptFileName)
				case IDMENU_PROMPTINITIALIZE_PROMPTFILENAME: 
					if(pThis->m_pCConnectDlg->pIDBPromptInitialize())
					{
						EXC_TEST(pThis->m_pCConnectDlg->PromptFileName());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				//Bring up Recent DataSource
				case IDMENU_RECENTCONFIG1: 
				case IDMENU_RECENTCONFIG2:
				case IDMENU_RECENTCONFIG3: 
				case IDMENU_RECENTCONFIG4: 
				case IDMENU_RECENTCONFIG5: 
				case IDMENU_RECENTCONFIG6: 
				case IDMENU_RECENTCONFIG7: 
				case IDMENU_RECENTCONFIG8: 
				case IDMENU_RECENTCONFIG9: 
				case IDMENU_RECENTCONFIG10: 
					if(pThis->m_pCConnectDlg)
						EXC_TEST(pThis->m_pCConnectDlg->LoadRecentConfig(GET_WM_COMMAND_ID(wParam, lParam) - IDMENU_RECENTCONFIG1));
					return 0;	  

				//Bring up Recent Files
				case IDMENU_RECENTFILE1: 
				case IDMENU_RECENTFILE2:
				case IDMENU_RECENTFILE3: 
				case IDMENU_RECENTFILE4: 
				case IDMENU_RECENTFILE5: 
				case IDMENU_RECENTFILE6: 
				case IDMENU_RECENTFILE7: 
				case IDMENU_RECENTFILE8: 
				case IDMENU_RECENTFILE9: 
				case IDMENU_RECENTFILE10: 
					if(pThis->m_pCConnectDlg)
						EXC_TEST(pThis->m_pCConnectDlg->LoadRecentFile(GET_WM_COMMAND_ID(wParam, lParam) - IDMENU_RECENTFILE1));
					return 0;	  

				//Options
				case IDMENU_OPTIONS:
					if(pThis->m_pCConnectDlg)
						EXC_TEST(pThis->m_pCOptionsDlg->Display());
					return 0;

				case IDMENU_TILEHORIZONTAL: // let MDI Client tile the MDI children
					EXC_TEST(SendMessage(m_hWndMDIClient, WM_MDITILE, MDITILE_HORIZONTAL, 0));
					return 0;

				case IDMENU_TILEVERTICAL: // let MDI Client tile the MDI children
					EXC_TEST(SendMessage(m_hWndMDIClient, WM_MDITILE, MDITILE_VERTICAL, 0));
					return 0;

				case IDMENU_CASCADE: // let MDI Client cascade MDI children
					EXC_TEST(SendMessage(m_hWndMDIClient, WM_MDICASCADE, 0, 0));
					return 0;

				case IDMENU_ICONS: // let MDI Client arrange iconic MDI children
					EXC_TEST(SendMessage(m_hWndMDIClient, WM_MDIICONARRANGE, 0, 0));
					return 0;

				case IDMENU_CLOSEALL: // Close all open windows and free hstmts
					Busy();
					EXC_TEST(pThis->RemoveAllChildren());
					EXC_TEST(pThis->RefreshControls());
					Busy(OFF);
					return 0;
									
				case IDMENU_CLOSE:   // Close Active Window
				case IDMENU_DISCONNECT: 
				{	
					//Disconnect and destroy this window
					Busy();
					EXC_TEST(pThis->RemoveChild(pThis->GetActiveChild()));
					EXC_TEST(pThis->RefreshControls());
					Busy(OFF);
					return 0;
				}
									
				case IDMENU_PREVWINDOW:
				{	
					HWND hWndActive = pThis->GetActiveChild();
					if(hWndActive)
						EXC_TEST(SendMessage(m_hWndMDIClient, WM_MDINEXT, (WPARAM)hWndActive, 0));
					return 0;
				}

				case IDMENU_NEXTWINDOW:
				{	
					HWND hWndActive = pThis->GetActiveChild();
					if(hWndActive)
						EXC_TEST(SendMessage(m_hWndMDIClient, WM_MDINEXT, (WPARAM)hWndActive, 1));
					return 0;
				}

				case IDMENU_ABOUT: // bringup About dialog
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_ABOUT), hWnd, AboutDlgProc, (LPARAM)pThis));
					return 0;
                                                
				case IDMENU_EXIT: // process exit request
					Busy();
					EXC_TEST(pThis->Destroy());
					Busy(OFF);
					return 0;

				default:
					//If we receive a ToolBar or Menu Message that really pertains
					//To a ChildWindow we will just pass the message on to them...
					HWND hWndActive = pThis->GetActiveChild();
					if(hWndActive)
						EXC_TEST(SendMessage(hWndActive, message, wParam, lParam));

					EXC_TEST(DefFrameProc(hWnd, m_hWndMDIClient, WM_COMMAND, wParam, lParam));
					return 0;
			}
			break;
		}

		case WM_NOTIFY:
            switch (((LPNMHDR) lParam)->code) 
            {
                case TTN_NEEDTEXT:    
				{    
					//Get the "this" pointer
					CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);
			
					// Display the ToolTip text.
					static CHAR szBuf[128];
		        	LPTOOLTIPTEXT lpToolTipText = (LPTOOLTIPTEXT)lParam;
    			
					EXC_TEST(LoadString(pThis->m_hInst, lpToolTipText->hdr.idFrom, szBuf, sizeof(szBuf)));
				    lpToolTipText->lpszText = szBuf;
					return 0;
				}
            }
			break;

		case WM_CLOSE:
		{	
			//Get the "this" pointer
			Busy();
			CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);
			EXC_TEST(pThis->Destroy());
			Busy(OFF);
			return 0;
		}

		case WM_DESTROY:
		{	//Get the "this" pointer
			Busy();
			CMainWindow* pThis = (CMainWindow*)GetThis(hWnd);
			EXC_TEST(pThis->Destroy());
			Busy(OFF);
			return 0;
		}

		default:
			break;
	}

	return DefFrameProc(hWnd, m_hWndMDIClient, message, wParam, lParam);
}

				

////////////////////////////////////////////////////////////////
// CMainWindow::AboutDlgProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMainWindow::AboutDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static HICON rgIcons[4];
	static ULONG iIcon = 0;
	
	switch (message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN	
			
			//Save the "this" pointer
			Busy();
			CMainWindow* pThis = (CMainWindow*)SetThis(hWnd, (LPARAM)lParam);

			//Load Images
			rgIcons[0] = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_ROWSETVIEWER));
			rgIcons[1] = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_NORMAL));
			rgIcons[2] = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_ROWSETICON));
			rgIcons[3] = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));

			//Setup a timer
			EXC_TEST(SetTimer(hWnd, ID_TIMER, 100, NULL));

			//Display dynamic ProductName, Version/Build, CopyWrite...
			EXC_TEST(SendMessageFmt(GetDlgItem(hWnd, IDT_FILEINFO), WM_SETTEXT, 0,
				"%s\n"			//ProductName
				"Version %s\n"	//Version/Build
				"%s\n",			//CopyWrite
				
				"Microsoft OLE DB RowsetViewer",
				VER_PRODUCTVERSION_STR,
				VER_LEGALCOPYRIGHT_STR
				));
			
			CenterDialog(hWnd);
			Busy(OFF);
			return TRUE;
			
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
		}

		case WM_TIMER:
		{
			SendMessage(GetDlgItem(hWnd, IDI_ABOUTICON), STM_SETICON, (WPARAM)rgIcons[iIcon], (LPARAM)rgIcons[iIcon]);
			if(++iIcon >= 4)
				iIcon = 0;
			return 0;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				case IDCANCEL:
				{
					//Stop the timer
					KillTimer(hWnd, ID_TIMER);

					EndDialog(hWnd, TRUE);
					return TRUE;
				}
			}
			break;
		}//WM_COMMAND
	}
	
	return FALSE;   
}


////////////////////////////////////////////////////////////////
// CMDIChild::CMDIChild
//
/////////////////////////////////////////////////////////////////
CMDIChild::CMDIChild(HWND hWnd, HINSTANCE hInst, CMainWindow* pCMainWindow)
	: CDialogBase(hWnd, hInst)
{
	m_hWndListView	=	 NULL;
	m_hWndEditBox   =    NULL;
	m_hWndScrollBar	 =   NULL;
	m_ulWindow		= 0;

	//Objects
	ASSERT(pCMainWindow);
	m_pCMainWindow = pCMainWindow;
	
	m_pCListBox		= new CListBox(NULL, m_hInst, pCMainWindow);
	m_pCListBox->Display(pCMainWindow->m_hWnd, 0, 0, 75, 75, WS_BORDER, this);

	m_pCRowset		= new CRowset(this, new CDataSource(this));
	m_pCPropDlg		= new CPropDlg(hWnd, hInst, m_pCMainWindow, m_pCListBox);
	m_pCError		= new CError(this);
	m_pCSchemaDlg	= NULL;		//Defferred Object
	
	//SubClass of EditBox
	m_pSavedEditBoxProc = NULL;
	m_pSavedListBoxProc = NULL;
	m_pSavedListViewProc = NULL;

	//Cursor
	m_fPrevFetchForward = FALSE;
	m_lCurPos = 0;

	//ScrollBar
	m_ulMaxViewItems = 0;
	m_fEndReached = FALSE;
	m_ulScrollMax	= 200;	  

	//Properties
	m_cPropSets		= 0;
	m_rgPropSets	= NULL;

	//LoadBitmap
	m_hBitmapReadOnly = LoadBitmap(m_hInst, MAKEINTRESOURCE(IDB_READONLY));
}


////////////////////////////////////////////////////////////////
// CMDIChild::~CMDIChild
//
/////////////////////////////////////////////////////////////////
CMDIChild::~CMDIChild()
{
	//This window has already been removed, From the WM_DESTROY...
	m_hWnd			= NULL;
	m_hWndListView	= NULL;
	m_hWndEditBox   = NULL;
	m_hWndScrollBar	= NULL;
	m_pCListBox->m_hWnd = NULL;

	SAFE_DELETE(m_pCRowset);
	SAFE_DELETE(m_pCPropDlg);
	SAFE_DELETE(m_pCSchemaDlg);
	SAFE_DELETE(m_pCError);

	//This must happen last, since all object will
	//use the list box when loggin releases...
	SAFE_DELETE(m_pCListBox);

	//Properties
	FreeProperties(&m_cPropSets, &m_rgPropSets);
	DeleteObject(m_hBitmapReadOnly);
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetOptionsObj
//
/////////////////////////////////////////////////////////////////
COptionsDlg* CMDIChild::GetOptionsObj()
{
	ASSERT(m_pCMainWindow);
	ASSERT(m_pCMainWindow->m_pCOptionsDlg);
	return m_pCMainWindow->m_pCOptionsDlg;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetConnectObj
//
/////////////////////////////////////////////////////////////////
CConnectDlg* CMDIChild::GetConnectObj()
{
	ASSERT(m_pCMainWindow);
	ASSERT(m_pCMainWindow->m_pCConnectDlg);
	return m_pCMainWindow->m_pCConnectDlg;
}


////////////////////////////////////////////////////////////////
// CMDIChild::pCSchemaDlg
//
/////////////////////////////////////////////////////////////////
CSchemaDlg* const CMDIChild::pCSchemaDlg()
{
	if(!m_pCSchemaDlg)
		m_pCSchemaDlg	= new CSchemaDlg(m_pCMainWindow->m_hWnd, m_hInst, this);

	return m_pCSchemaDlg;
}



////////////////////////////////////////////////////////////////
// CMDIChild::Display
//
/////////////////////////////////////////////////////////////////
ULONG CMDIChild::Display()
{
	//Need to first obtain Window TitleBar...
	CDataSource* pCDataSource = m_pCRowset->m_pCDataSource;
	
	//Create MDI Child Window, (passing the "this" pointer)
	MDICREATESTRUCT		mcs;
	mcs.szClass = OLEDBMDICLASS;
	mcs.szTitle = NULL;
	mcs.hOwner  = m_hInst;
	mcs.style   = 0;
	mcs.x		= CW_USEDEFAULT;
	mcs.cx		= CW_USEDEFAULT;
	mcs.y		= CW_USEDEFAULT;
	mcs.cy		= 450;
	mcs.lParam  = (LPARAM)this;
	m_hWnd = (HWND)SendMessage(m_pCMainWindow->m_hWndMDIClient, WM_MDICREATE, 0, (LPARAM)&mcs);

    // check if it was created, if it wasn't free up resource and flag warning
    if(!m_hWnd)
    {
		wMessageBox(NULL, MB_OK|MB_ICONERROR|MB_SYSTEMMODAL, wsz_ERROR, L"Unable to create a MDIChild!");
		goto CLEANUP;
    }

	//Increment total ChildWindow count
	m_ulWindow = ++CMainWindow::m_ulChildWindows;

    //Update Window Title
	UpdateWndTitle();

CLEANUP:
	return m_hWnd ? TRUE : FALSE;
}



/////////////////////////////////////////////////////////////////
// CMDIChild::UpdateWndTitle
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::UpdateWndTitle()
{
	//Create Title for ChildWindow
	CHAR*   pszName = NULL;
	ASSERT(m_pCRowset);
	CDataSource* pCDataSource = m_pCRowset->m_pCDataSource;

	//Format text and output to window
	EXC_TEST(SendMessageFmt(m_hWnd, WM_SETTEXT, 0, "%S - %d %S %S %S", 
		pCDataSource->GetEnumInfo()->wszName[0] ? pCDataSource->GetEnumInfo()->wszName : pCDataSource->m_pwszProviderName ? pCDataSource->m_pwszProviderName : L"", 
				m_ulWindow, 
				pCDataSource->m_pwszDataSource!=NULL ? pCDataSource->m_pwszDataSource : pCDataSource->m_EnumInfo.wszName, 
				pCDataSource->m_pwszDBMS!=NULL ? pCDataSource->m_pwszDBMS : L"",
				pCDataSource->m_pwszDBMSVer!=NULL ? pCDataSource->m_pwszDBMSVer : L""));
	
	return S_OK;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CreateNewSessionWindow
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::CreateNewSessionWindow()
{
	//Bascially we want to diplay a new window, but use the existing connection,
	//So we will obtain all interfaces from the existing IDBInitialize
	
	HRESULT hr = E_FAIL;

	//Create a MDIChild and DataSource
	CMDIChild* pCMDIChild = new CMDIChild(NULL, m_hInst, m_pCMainWindow);

	//Connect using the Same DataSource...
	TESTC(hr = pCMDIChild->m_pCRowset->CreateConnection(m_pCRowset));
	
	//Display
	pCMDIChild->Display();

CLEANUP:
	if(FAILED(hr))
		SAFE_DELETE(pCMDIChild);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CreateNewCommandWindow
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::CreateNewCommandWindow()
{
	//Bascially we want to diplay a new window, but use the existing connection,
	//So we will obtain all interfaces from the existing IDBInitialize
	
	HRESULT hr = E_FAIL;

	//Create a MDIChild and DataSource
	CMDIChild* pCMDIChild = new CMDIChild(NULL, m_hInst, m_pCMainWindow);

	//Connect using the Same DataSource, (FALSE == Same Session as well)
	TESTC(hr = pCMDIChild->m_pCRowset->CreateConnection(m_pCRowset, FALSE));
	
	//Display
	pCMDIChild->Display();

CLEANUP:
	if(FAILED(hr))
		SAFE_DELETE(pCMDIChild);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::InitControls
//
/////////////////////////////////////////////////////////////////
BOOL CMDIChild::InitControls(HWND hWnd)
{
	m_hWnd = hWnd;
	HRESULT hr = S_OK;

	// create child windows
	// 1. ListView for rowset data
	// 2. EditBox for entering SQL Text
	// 3. ListBox for notifcations
	// 4. ScrollBar for scrolling through the rowset

	//CreateListView
	m_hWndListView = CreateWindowEx(
								 WS_EX_CLIENTEDGE,          // ex style
                                 WC_LISTVIEW,               // class name - defined in commctrl.h
                                 NULL,                      // window text
                                 WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_VSCROLL | /*LVS_SINGLESEL |*/ LVS_AUTOARRANGE | LVS_REPORT | LVS_EDITLABELS | LVS_SHOWSELALWAYS,
								 0,                         // x position
                                 0,                         // y position
                                 100,			            // width
                                 100,                       // height
                                 m_hWnd,	                // parent
                                 (HMENU)IDC_LISTVIEW,       // ID
                                 m_hInst,                   // instance
                                 this);                     // no extra data

	//Obtain the Approxiamate height to diaply MAX_LISTVIEWROWS items
	DWORD dwValue = GetSystemMetrics(SM_CYHSCROLL) + SendMessage(m_hWndListView, LVM_APPROXIMATEVIEWRECT, MAX_LISTVIEWROWS,  MAKELPARAM(100, 275));
	MoveWindow(m_hWndListView, 0, 0, 100, HIWORD(dwValue), TRUE);

	//SubClass the ListView
	SetThis(m_hWndListView, (LPARAM)this);
	m_pSavedListViewProc = (WNDPROC)GetWindowLong(m_hWndListView, GWL_WNDPROC);
    SetWindowLong(m_hWndListView, GWL_WNDPROC, (LONG)SubClassListViewProc);

	//CreateEditBox
    m_hWndEditBox = CreateWindowEx(
								 WS_EX_CLIENTEDGE,			// ex style
								 m_pCMainWindow->m_hLibRichEdit ? "RICHEDIT" : "EDIT",                // class name - defined in commctrl.h
                                 NULL,                      // window text
                                 WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_HSCROLL | WS_VSCROLL | ES_LEFT | ES_AUTOVSCROLL | /*ES_AUTOHSCROLL |*/ ES_MULTILINE | ES_WANTRETURN | ES_NOHIDESEL,
								 0,	                        // x position
                                 0,                         // y position
                                 65,			            // width
                                 65,						// height
                                 m_hWnd,	                // parent
                                 (HMENU)IDC_EDITBOX,        // ID
                                 m_hInst,                   // instance			
                                 this);                     // no extra data

	//Set Focus to SQL Edit Box
	SendMessage(m_hWndEditBox, EM_FMTLINES, FALSE, 0);
	SendMessage(m_hWndEditBox, EM_SETTEXTMODE | TM_MULTILEVELUNDO, TM_PLAINTEXT, 0);
	SetFocus(m_hWndEditBox);

	//SubClass the EditBox
	SetThis(m_hWndEditBox, (LPARAM)this);
	m_pSavedEditBoxProc = (WNDPROC)GetWindowLong(m_hWndEditBox, GWL_WNDPROC);
    SetWindowLong(m_hWndEditBox, GWL_WNDPROC, (LONG)SubClassEditBoxProc);

	//CreateListBox
	SetParent(m_pCListBox->m_hWnd, m_hWnd);
	SetThis(m_pCListBox->m_hWnd, (LPARAM)this);
	ShowWindow(m_pCListBox->m_hWnd, SW_SHOW);

	//SubClass the ListBox
	m_pSavedListBoxProc = (WNDPROC)GetWindowLong(m_pCListBox->m_hWnd, GWL_WNDPROC);
	SetWindowLong(m_pCListBox->m_hWnd, GWL_WNDPROC, (LONG)SubClassListBoxProc);

	//CreateScrollBar
	m_hWndScrollBar = CreateWindowEx(
								 NULL,			            // ex style
                                 "SCROLLBAR",               // class name - defined in commctrl.h
                                 NULL,                      // window text
                                 WS_CHILD | WS_VISIBLE | SBS_VERT,
								 0,                         // x position
                                 0,                         // y position
                                 GetSystemMetrics(SM_CXVSCROLL),  // width
                                 dwValue,			        // height
                                 m_hWnd,	                // parent
                                 (HMENU)IDC_SCROLLBAR,      // ID
                                 m_hInst,                   // instance
                                 this);                     // no extra data

	//Clear ListView
	ClearListView("No Rowset");

	//Disable Windows
	EnableWindow(m_hWndListView, FALSE);
	EnableWindow(m_hWndScrollBar, FALSE);

	//Get ListView font
	HFONT hFont = (HFONT)SendMessage(m_hWndListView, WM_GETFONT, 0, 0);
	SendMessage(m_hWndEditBox, WM_SETFONT, (WPARAM)hFont, 0);
	SendMessage(m_pCListBox->m_hWnd, WM_SETFONT, (WPARAM)hFont, 0);

	//Use Extended ListView Styles!
	SendMessage(GetDlgItem(hWnd, IDC_LISTVIEW), LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

	//Create the Row ImageList
	HIMAGELIST hRowImageList = ImageList_Create(16, 16, ILC_MASK, 8, 8 );

	//IDI_ROW_NORMAL - normal row icon
	HICON hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROW_NORMAL));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_READONLY));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_COL_INFO));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_COL_ERROR));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_NFP_BEFORE));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_NFP_AFTER));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROW_DELETE));
	ImageList_AddIcon(hRowImageList, hIcon);
	hIcon = LoadIcon(m_hInst, MAKEINTRESOURCE(IDI_ROW_CHANGE));
	ImageList_AddIcon(hRowImageList, hIcon);

	//Set image list to the ListView
	ListView_SetImageList(m_hWndListView, hRowImageList, LVSIL_SMALL);
//	ImageList_Destroy(hRowImageList);

	//Initally setup up some rowset properties that are very useful functionality
	//These are mainly to have the most common operations on the rowset and to
	//be able to obtain blob columns...
	CDataSource* pCDataSource = m_pCRowset->m_pCDataSource;
	CCommand* pCCommand = m_pCRowset->m_pCCommand;

	//Only set these "Default" properties, if requested by the user
	if(GetOptionsObj()->m_dwRowsetOpts & ROWSET_SETDEFAULTPROPS)
	{
		DBPROPOPTIONS dwPropOptions = DBPROPOPTIONS_OPTIONAL;
		
		//Kagera has a problem with OPTIONAL properties, still treating
		//them as SETIFCHEAP and lets you know the NOTSET ones...
		//Instead of always getting DB_S_ERRORSOCCURRED just special case until fixed
		if(pCDataSource->m_pwszProviderName && wcscmp(pCDataSource->m_pwszProviderName, L"MSDASQL.DLL")==0)
			dwPropOptions = DBPROPOPTIONS_REQUIRED;

		//DBPROP_CANHOLDROWS is required by the OLEDB Spec - Level-0 Conformance
		//Since it is also legal to set a ReadOnly property, just blindy set it...
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_CANHOLDROWS, DBPROPSET_ROWSET) || pCDataSource->m_pISourcesRowset)
			SetProperty(DBPROP_CANHOLDROWS, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		
		//We want to provide Scrolling Capabilites to the user (if supported)
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_CANSCROLLBACKWARDS, DBPROPSET_ROWSET))
			SetProperty(DBPROP_CANSCROLLBACKWARDS, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_CANFETCHBACKWARDS, DBPROPSET_ROWSET))
			SetProperty(DBPROP_CANFETCHBACKWARDS, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);

		//Allow the user to change data (if supported)
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_IRowsetChange, DBPROPSET_ROWSET))
			SetProperty(DBPROP_IRowsetChange, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_UPDATABILITY, DBPROPSET_ROWSET))
			SetProperty(DBPROP_UPDATABILITY, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_I4, DBPROPVAL_UP_CHANGE | DBPROPVAL_UP_INSERT | DBPROPVAL_UP_DELETE, dwPropOptions);
		
		//Some providers might need IRowsetLocate to position on BLOBs (MSDASQL)
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_IRowsetLocate, DBPROPSET_ROWSET))
			SetProperty(DBPROP_IRowsetLocate, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		
		//Notifications are very useful debugging info (if supported)
		if(IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_IConnectionPointContainer, DBPROPSET_ROWSET))
			SetProperty(DBPROP_IConnectionPointContainer, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);

		//DBPROP_ISequentialStream 
		if(GetOptionsObj()->m_dwRowsetOpts & ROWSET_BLOB_ISEQSTREAM &&
			IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_ISequentialStream, DBPROPSET_ROWSET))
			SetProperty(DBPROP_ISequentialStream, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		//DBPROP_ILockBytes 
		if(GetOptionsObj()->m_dwRowsetOpts & ROWSET_BLOB_ILOCKBYTES &&
			IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_ILockBytes, DBPROPSET_ROWSET))
			SetProperty(DBPROP_ILockBytes, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		//DBPROP_IStorage
		if(GetOptionsObj()->m_dwRowsetOpts & ROWSET_BLOB_ISTORAGE &&
			IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_IStorage, DBPROPSET_ROWSET))
			SetProperty(DBPROP_IStorage, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);
		//DBPROP_IStream
		if(GetOptionsObj()->m_dwRowsetOpts & ROWSET_BLOB_ISTREAM &&
			IsSettableProperty(pCDataSource->m_pIUnknown, DBPROP_IStream, DBPROPSET_ROWSET))
			SetProperty(DBPROP_IStream, DBPROPSET_ROWSET, &m_cPropSets, &m_rgPropSets, DBTYPE_BOOL, VARIANT_TRUE, dwPropOptions);


		//Now also set these properties on our Command Object
		if(pCCommand->m_pICommandProperties)
		{
			//SetProperties
			m_pCListBox->OutputPreMethod("ICommandProperties::SetProperties(%d, 0x%08x)", m_cPropSets, m_rgPropSets);
			XTEST_(hWnd, hr = pCCommand->m_pICommandProperties->SetProperties(m_cPropSets, m_rgPropSets),S_OK);
			m_pCListBox->OutputPostMethod(hr, "ICommandProperties::SetProperties(%d, 0x%08x)", m_cPropSets, m_rgPropSets);
			if(hr == DB_S_ERRORSOCCURRED || hr == DB_E_ERRORSOCCURRED)
				DisplayPropErrors(hWnd, m_cPropSets, m_rgPropSets);
			TESTC(hr);
		}
	}

CLEANUP:
	return TRUE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::RefreshControls
//
/////////////////////////////////////////////////////////////////
BOOL CMDIChild::RefreshControls()
{
	CDataSource* pCDataSource = m_pCRowset->m_pCDataSource;
	CSession* pCSession = m_pCRowset->m_pCSession;
	CCommand* pCCommand = m_pCRowset->m_pCCommand;
	HWND hWndToolbar = m_pCMainWindow->m_hWndToolbar;

	//ToolBar Buttons
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_CONNECT,				TRUE);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_DISCONNECT,			TRUE);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_CREATESESSIONWINDOW,	(BOOL)pCDataSource->m_pIDBCreateSession);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_RUN,					pCDataSource->m_pISourcesRowset || pCSession->m_pIOpenRowset || pCCommand->m_pICommand);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_EXECUTE,				(BOOL)pCCommand->m_pICommand);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_RESTARTPOSITION,		(BOOL)m_pCRowset->m_pIRowset);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_REFRESH,				(BOOL)m_pCRowset->m_pIRowset);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_GETSCHEMAROWSET,		(BOOL)pCSession->m_pIDBSchemaRowset);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_INSERTROW,				(BOOL)m_pCRowset->m_pIRowsetChange);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_DELETEROWS,			(BOOL)m_pCRowset->m_pIRowsetChange);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_SETDATA,				(BOOL)m_pCRowset->m_pIRowsetChange);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_UPDATE,				(BOOL)m_pCRowset->m_pIRowsetUpdate);
	SendMessage(hWndToolbar, TB_ENABLEBUTTON, IDMENU_UNDO,					(BOOL)m_pCRowset->m_pIRowsetUpdate);

	//Disable ListView window
	EnableWindow(m_hWndListView, (BOOL)m_pCRowset->m_pIUnknown);
	EnableWindow(m_hWndScrollBar, (BOOL)m_pCRowset->m_pIUnknown);

	//Update Window Title (in-case things have changed...)
	UpdateWndTitle();
	return TRUE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CreateRowset
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::CreateRowset(ROWSETSOURCE eRowsetSource, DBID* pTableID, DBID* pIndexID, ULONG cPropSets, DBPROPSET* rgPropSets, REFIID riid, const GUID* pGuidSchema, ULONG cRestrictions, VARIANT* rgRestrictions)
{
	Busy();
	HRESULT hr = S_OK;
	LONG cRowsAffected = DB_COUNTUNAVAILABLE;

	//Create the rowset, (either from Command, IOpenRowset, or Schema's)
	TESTC(hr = m_pCRowset->CreateRowset(eRowsetSource, cPropSets, rgPropSets, &cRowsAffected, pTableID, pIndexID, riid, pGuidSchema, cRestrictions, rgRestrictions));

	//Empty IRowset
	if(hr==S_FALSE || (m_pCRowset->m_pIUnknown == NULL && m_pCRowset->m_pCDataset->m_pIMDDataset == NULL))
	{ 
		//Display RowsAffect - (if desired)
		if(GetOptionsObj()->m_dwCommandOpts & COMMAND_ROWSAFFECTED)
		{
			if(cRowsAffected == DB_COUNTUNAVAILABLE)
				wMessageBox(m_hWnd, MB_TASKMODAL | MB_ICONWARNING | MB_OK, wsz_INFO, 
					L"RowsAffected = DB_COUNTUNAVAILABLE, No Rowset returned, ");
			else
				wMessageBox(m_hWnd, MB_TASKMODAL | MB_ICONWARNING | MB_OK, wsz_INFO, 
					L"RowsAffected = %d, No Rowset returned", cRowsAffected );
		}
		goto CLEANUP;
	}

	//Delegate - Display the Rowset
	TESTC(hr = DisplayRowset());

CLEANUP:
	RefreshControls();
	Busy(OFF);
	return hr;
}

	 
////////////////////////////////////////////////////////////////
// CMDIChild::DisplayRowset
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::DisplayRowset()
{
	Busy();
	HRESULT hr = S_OK;

	//Reset Cursor
	m_fPrevFetchForward = FALSE;
	m_lCurPos = 0;
	BOOL fBindBookmark = GetOptionsObj()->m_dwRowsetOpts & ROWSET_BINDBOOKMARK;

	//Create ColumnInfo
	TESTC(hr = m_pCRowset->GetColInfo());

	//Create Accessors and Setup bindings
	TESTC(hr = m_pCRowset->CreateAccessors(fBindBookmark));

	//Refresh the Columns and Rows
	TESTC(hr = RefreshData());

CLEANUP:
	RefreshControls();
	Busy(OFF);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ExecuteDataset
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::ExecuteDataset(ROWSETSOURCE eRowsetSource)
{
	HRESULT hr = E_FAIL;
	CHAR szBuffer[MAX_QUERY_LEN+1];
	WCHAR wszBuffer[MAX_QUERY_LEN+1];
	LONG cRowsAffected = DB_COUNTUNAVAILABLE;

	ASSERT(eRowsetSource==ROWSET_FROMCOMMANDDATASET);

	// Get the EditBox value (either TableName or SQL Statement)
	GetEditBoxSelection(m_hWndEditBox, szBuffer, MAX_QUERY_LEN);
		
	// Convert to WCHAR (for ICommand and IOpenRowset)
	ConvertToWCHAR(szBuffer, wszBuffer, MAX_QUERY_LEN);

	TESTC(hr = m_pCRowset->CreateDataset(eRowsetSource, &cRowsAffected, wszBuffer));

	// if IMDDataset is empty
	if (m_pCRowset->m_pCDataset->m_pIMDDataset == NULL)
	{ 
		if (cRowsAffected == DB_COUNTUNAVAILABLE)
			wMessageBox(NULL, MB_TASKMODAL | MB_ICONWARNING | MB_OK, wsz_INFO, 
				L"No Rowset returned, RowsAffected = DB_COUNTUNAVAILABLE");
		else
			wMessageBox(NULL, MB_TASKMODAL | MB_ICONWARNING | MB_OK, wsz_INFO, 
				L"No Rowset returned, RowsAffected = %d rows affected", cRowsAffected );
		goto CLEANUP;
	}

	//Clear ListView object
	TESTC(hr = ClearListView());

CLEANUP:
	RefreshControls();
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::DisplayColumnInfo
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::DisplayColumnInfo()
{
	LONG	iResult = 0;
	CHAR	szBuffer[MAX_NAME_LEN+1];		// String Buffer

	//Insert the Column Headers.
	//Only display the columns for which are bound in the Accessor
	ULONG cBindings = m_pCRowset->m_cBindings;
	DBBINDING* rgBindings = m_pCRowset->m_rgBindings;
	
	//Insert Row Header
	LV_InsertColumn(m_hWndListView, 0, m_pCRowset->m_eRowsetSource == ROWSET_FROMCOMMANDDATASET ? "Cell Ordinal" : "Row Handle");

	//Loop through the Bindings
	for(ULONG i=0; i<cBindings; i++)
	{
		DBCOLUMNINFO* pColInfo = m_pCRowset->GetColInfo(rgBindings[i].iOrdinal);
		
		//Get ColumnName
		ConvertToMBCS(m_pCRowset->GetColName(pColInfo->iOrdinal), szBuffer, MAX_NAME_LEN);
		iResult = LV_InsertColumn(m_hWndListView, i+1, szBuffer, GetColumnImage(pColInfo));
	}

	//AutoSize Columns, (including "Row-Handle" column)
	for(i=0; i<cBindings+1; i++)
		SendMessage(m_hWndListView, LVM_SETCOLUMNWIDTH, (WPARAM)i,	(LPARAM)LVSCW_AUTOSIZE_USEHEADER);

	//CLEANUP:    
    return iResult == LVM_ERR ? E_FAIL : S_OK;    
}


////////////////////////////////////////////////////////////////
// CMDIChild::DisplayData
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::DisplayData
(
	REFIID			riid,
	HROW			hRow,
	ULONG			iIndex
)
{
	//Always displays upto m_ulMaxViewItems every time.
	//If unable to display m_ulMaxViewItems, the other rows are emptied...
	ASSERT(iIndex >=0 && iIndex<ULONG_MAX);
	HRESULT hr = E_FAIL;
	
	//First, Set Text and save hRow
	CHAR szBuffer[MAX_COL_SIZE+1];
	sprintf(szBuffer, "0x%x", hRow);
	LV_SetItemText(m_hWndListView, iIndex, 0, szBuffer);
	LV_SetItemParam(m_hWndListView, iIndex, 0, hRow);

	//This displays data from any source.  IRowset*::Get*Data,
	//GetData, GetOriginalData, GetVisibleData
	if(riid == IID_IRowset)
	{
		//GetData wrapper with Argument checking...
		hr = m_pCRowset->GetData(hRow);
	}
	else if(riid == IID_IRowsetUpdate)
	{
		//GetOriginalData wrapper with Argument checking...
		hr = m_pCRowset->GetOriginalData(hRow);
	}
	else if(riid == IID_IRowsetResynch)
	{
		//GetVisibleData wrapper with Argument checking...
		hr = m_pCRowset->GetVisibleData(hRow);
	}
	else
	{
		ASSERT(!"Unhandled Data Source!");
	}

	//Relax the errors here.  With Get*Data both DB_S/DB_E will return a bad
	//status for 1 or more columns.  Or DataGrid will just display the column
	//status if not S_OK.  So for these errors just display the data anyway...
	if(FAILED(hr) && hr!= DB_E_ERRORSOCCURRED)
		goto CLEANUP;
	hr = S_OK;
	
	//Display to the ListView
    TESTC(hr = DumpRow
			(
			hRow,
			m_pCRowset->m_cBindings,
			m_pCRowset->m_rgBindings, 
			m_pCRowset->m_pData,			  
			iIndex
			));
	
CLEANUP:
    return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::DisplayRows
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::DisplayRows
(
	LONG			lOffset,
	LONG			cRows
)
{
	HRESULT hr = E_FAIL;

	ULONG 	i,cRowsObtained =  0;
	HROW	rghRows[MAX_OPENROWS];
	HROW*	phRow = rghRows;
	LONG    iItems = 0;
	CHAR	szRowHandle[10];

	//Only use dynamic memory allocation if more rows than our static array
	if(abs(cRows) > MAX_OPENROWS)
		phRow = NULL;	

	//Calculate the starting position to place rows
	LONG lStartIndex = m_fPrevFetchForward ? m_lCurPos + lOffset + 1 : m_lCurPos + lOffset;
	lStartIndex = cRows > 0 ? lStartIndex : lStartIndex - 1;

	//Deletgate
	TESTC(hr = GetNextRows(lOffset, cRows, &cRowsObtained, &phRow));
	
	//Obtain total ListItems
	iItems = SendMessage(m_hWndListView, LVM_GETITEMCOUNT, 0, 0);
	ASSERT(iItems >= 0);

	//Only remove the neccessary amount of rows from the existing view.
	//We don't want to have both pgup/pgdn show half filled data views...
	if(SUCCEEDED(hr) && cRowsObtained && 0)
	{
		if(cRowsObtained >= m_ulMaxViewItems)
		{
			SendMessage(m_hWndListView, LVM_DELETEALLITEMS, 0, 0);
			iItems = 0;
		}
		else
		{
			while(cRowsObtained + iItems > m_ulMaxViewItems)
			{
				//If we want to add rows to the top, we need to remove from the bottom
				//If we want to add rows to the bottom, we need to remove from the top
				if(lStartIndex == 0)
				{
					SendMessage(m_hWndListView, LVM_DELETEITEM, iItems-1, 0);
				}
				else
				{
					SendMessage(m_hWndListView, LVM_DELETEITEM, 0, 0);
				}
				iItems--;
			}
		}
	}	

	//Adjust boundaries 
	lStartIndex = max(lStartIndex, 0);
	lStartIndex = min(lStartIndex, iItems);

	//Loop over rows obtained, getting data for each and displaying in the ListView
	for(i=0; i<cRowsObtained; i++ )
	{
		//Calulate which direction to start with the hRows
		HROW hRow = phRow[i];
		if(cRows < 0 && m_pCRowset->m_eRowsetSource != ROWSET_FROMCOMMANDDATASET)
			hRow = phRow[cRowsObtained - 1 - i];
		LONG iIndex = cRows > 0 ? lStartIndex + i : lStartIndex - i;
		
		if(iIndex >= iItems)
		{
			//Insert the New hRow into the ListView
			LV_InsertItem(m_hWndListView, iIndex, 0, "", 0, IMAGE_NORMAL);

			//Display GetData in the ListView
			hr = DisplayData(IID_IRowset, hRow, iIndex);
		}
		else
		{
			//Just update the Row Handle
			sprintf(szRowHandle, "0x%x", hRow);
			LV_SetItemText(m_hWndListView, iIndex, 0, szRowHandle);
			LV_SetItemParam(m_hWndListView, iIndex, 0, hRow);
		}
	}

	//Display the NextFetchPosition
	LV_SetItemImage(m_hWndListView, m_lCurPos, 0, m_fPrevFetchForward ? IMAGE_NFP_AFTER : IMAGE_NFP_BEFORE);
	SendMessage(m_hWndListView, LVM_ENSUREVISIBLE, m_lCurPos, TRUE);

	//Adjust ScrollBar on Success
	if(m_fEndReached)
		SetScroll(m_fPrevFetchForward ? m_ulScrollMax : 0);
	else
		SetScroll(GetScrollPos(m_hWndScrollBar, SB_CTL) + lOffset + cRows);

CLEANUP:
	if(cRows > MAX_OPENROWS)
		SAFE_FREE(phRow);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetNextRows
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::GetNextRows(LONG lOffset, LONG cRows, ULONG* pcRowsObtained, HROW** prghRows)
{
	HRESULT hr = S_OK;
	LONG    iItems = 0;
	ULONG   cRowsObtained = 0;
	
	//GetNextRows
	if (m_pCRowset->m_eRowsetSource == ROWSET_FROMCOMMANDDATASET)
	{
		TESTC(hr = m_pCRowset->m_pCDataset->GetNextCells(cRows, &cRowsObtained, *prghRows));
	}
	else
	{
		TESTC(hr = m_pCRowset->GetNextRows(lOffset, cRows, &cRowsObtained, prghRows));
	}
	
	//Obtain total ListItems
	iItems = SendMessage(m_hWndListView, LVM_GETITEMCOUNT, 0, 0);
	ASSERT(iItems >= 0);

	//Adjust the Cursor Position
	if(cRowsObtained)
	{
		//Need to remove the "NextFetchPositon" icon from the "old" row
		LV_SetItemImage(m_hWndListView, m_lCurPos, 0, IMAGE_NORMAL);

		if(cRows > 0)
		{
			m_lCurPos += (m_fPrevFetchForward ? lOffset + cRowsObtained : lOffset + cRowsObtained - 1);
		}
		else
		{
			m_lCurPos += (m_fPrevFetchForward ? lOffset - cRowsObtained + 1: lOffset - cRowsObtained);
		}

		m_lCurPos = max(m_lCurPos, 0);
//		m_lCurPos = min(m_lCurPos, (m_ulMaxViewItems && !GetOptionsObj()->m_dwDisplayAllRows) ? (LONG)m_ulMaxViewItems-1 : m_lCurPos);
		m_lCurPos = min(m_lCurPos, (LONG)cRowsObtained + iItems - 1);
	}

	//Adjust last fetch direction.
	m_fPrevFetchForward = (cRows>0 ? TRUE : FALSE);

	//Indicate End or Rowset was reached
	m_fEndReached = FALSE;
	if(hr == DB_S_ENDOFROWSET)
		m_fEndReached = TRUE;
		
CLEANUP:
	if(pcRowsObtained)
		*pcRowsObtained = cRowsObtained;
    return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::MoveCursor
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::MoveCursor()
{
	HRESULT hr = S_OK;
	HROW hRow = NULL;
	HROW* phRow = &hRow;
	LONG lOffset = 0;
	LONG cRows = 0;
	LONG* rgItems = NULL;
	LONG iFirstRow, iLastRow;
	
	//Find the Selected Rows
	if(!LV_GetSelItems(m_hWndListView, (ULONG*)&cRows, &rgItems))
		goto CLEANUP;

	iFirstRow = rgItems[0];
	iLastRow  = rgItems[cRows-1];
	cRows = iLastRow - iFirstRow + 1;

	//Strictly Forward Fetch
	if(iFirstRow > m_lCurPos)
	{
		lOffset = m_fPrevFetchForward ? iFirstRow - m_lCurPos -1 : iFirstRow - m_lCurPos;
		cRows = cRows;
	}
	//Strictly Backward Fetch
	else if(iLastRow < m_lCurPos)
	{
		lOffset = m_fPrevFetchForward ? iLastRow - m_lCurPos : iLastRow - m_lCurPos + 1;
		cRows = -cRows;
	}
	//Just changing direction
	else if(m_lCurPos == iFirstRow && cRows == 1)
	{
		lOffset = 0;
		cRows = m_fPrevFetchForward ? -cRows : cRows;
	}
	//Otherwise more difficult
	else 
	{
		//Since we are really not sure what the use wants
		//either (-lOffset, +cRows) or (lOffset, -cRows) is possible
		//we will make the decision based upon where the current position is
		
		//Closer to the first row
		if((m_lCurPos - iFirstRow) <= (iLastRow - m_lCurPos))
		{
			lOffset = m_fPrevFetchForward ? iFirstRow - m_lCurPos -1 : iFirstRow - m_lCurPos;
			cRows = cRows;
		}
		//Closer to the last row
		else
		{
			lOffset = m_fPrevFetchForward ? iLastRow - m_lCurPos : iLastRow - m_lCurPos + 1;
			cRows = -cRows;
		}
	}

	//Display the indicated rows
	TESTC(hr = DisplayRows(lOffset, cRows));

CLEANUP:
	SAFE_FREE(rgItems);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ScrollListView
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::ScrollListView(LONG cRows)
{
	HRESULT hr = E_FAIL;
	ASSERT(m_pCRowset->m_pIRowset);

	//Display the Data
	switch(cRows)
	{
	
		//Scroll Down one row
		case 1:
		{	
			//Just fetch one more forward
			TESTC(hr = DisplayRows(0, 1));
			break;
		}

		//Scroll Up one row
		case -1:
		{
			//Just need to fetch on row backward
			TESTC(hr = DisplayRows(0, -1));
			break;
		}

		//Scroll Down one Page
		case MAX_LISTVIEWROWS:
		{	
			//Just fetch a block or rows forward
			TESTC(hr = DisplayRows(0, m_ulMaxViewItems));
			break;
		}

		//Scroll Up one Page
		case -MAX_LISTVIEWROWS:
		{	
			//Just need to fetch a block of rows backward
			TESTC(hr = DisplayRows(0, -(LONG)m_ulMaxViewItems));
			break;
		}
/*
		//Scroll to End
		case LONG_MAX:
		{
			//The user want to view the last rows of the rowset
			//This is caused from bringing the scrollbar thumb to the bottom

			//The dumb way to achive this is to call GetNextRows until EndOfRowset,
			//Then scroll backward x number of rows.  But this requires SCROLLBACKWARDS
			//We might as well go back to the beginging and do cRows == -x to get
			//the last chunk or rows, this also requires SCROLLBACKWARDS

			//Get count of ListView rows
			LONG iItems = SendMessage(m_hWndListView, LVM_GETITEMCOUNT, 0, 0);

			//RestartPosition...
			TESTC(m_pCListBox->OutputPreMethod("IRowset::RestartPosition(NULL)"));
			XTEST(m_hWnd, hr = m_pCRowset->m_pIRowset->RestartPosition(NULL));
			TESTC(m_pCListBox->OutputPostMethod(hr, "IRowset::RestartPosition(NULL)"));

			//Now Fetch Last chunck of rows
			TESTC(hr = DisplayRows(0, -(LONG)m_ulMaxViewItems, iItems, BACKWARD));
			break;
		}
*/
		default:
			ASSERT(!"Not yet supported!");
			break;
	}

CLEANUP:
	return hr;
}

  
////////////////////////////////////////////////////////////////
// CMDIChild::DeleteSelectedRows
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::DeleteSelectedRows()
{
	//Delete the Selected row in the ListView...
	HRESULT hr = E_FAIL;
	ULONG cRows = 0;
	LONG* rgItems = NULL;
	HROW* rghRows = NULL;
	DBROWSTATUS* rgRowStatus = NULL;
	LONG dwSelection = IDYES;

	//Is editing the Rowset allowed?
	if(m_pCRowset->m_pIRowsetChange == NULL)
		return E_FAIL;
	
	//Find the Selected Items in the ListView
	LV_GetSelItems(m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);
	SAFE_ALLOC(rgRowStatus, DBROWSTATUS, cRows); 
	
	//Popup a MessageBox, Asking user if really wants to DeleteRow
	if(cRows)
	{	
		dwSelection = wMessageBox(m_hWnd, MB_TASKMODAL | MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1, 
			L"IRowsetChange::DeleteRows", L"Do you wish to delete the selected row(s)?");
	}

	if(dwSelection == IDYES)
	{
		ASSERT(m_pCRowset->m_pIRowsetChange);
		
		//DeleteRows from Rowset
		TESTC(m_pCListBox->OutputPreMethod("IRowsetChange::DeleteRows(NULL, %d, 0x%08x, 0x%08x)", cRows, rghRows, rgRowStatus));
		XTEST(m_hWnd, hr = m_pCRowset->m_pIRowsetChange->DeleteRows(NULL, cRows, rghRows, rgRowStatus));
		if(hr==DB_S_ERRORSOCCURRED || hr==DB_E_ERRORSOCCURRED)
			DisplayRowErrors(m_hWnd, cRows, rghRows, rgRowStatus);
		TESTC(m_pCListBox->OutputPostMethod(hr, "IRowsetChange::DeleteRows(NULL, %d, 0x%08x, 0x%08x)", cRows, rghRows, rgRowStatus));

		//We are "lazy" about updating the ListView.  Since we are not 
		//sure wither the provider compacts or not after deleted rows,
		//its easier and more correct to just display a "deleted" icon form
		//of the row, rather than guessing...
		//
		//Where, so whenever the users scrolls over the deleted row it will
		//appear or not depending upon the provider, 
		//or whenever they refresh or restartposition...

		//Delete from ListView
		//Need to indicate row was removed, use "deleted" icon
		for(ULONG i=0; i<cRows; i++)
			LV_SetItemImage(m_hWndListView, rgItems[i], 0, IMAGE_ROW_DELETE);
	}
	
CLEANUP:
	SAFE_FREE(rgRowStatus);
	SAFE_FREE(rgItems);
	SAFE_FREE(rghRows);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ChangeSelectedRow
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::ChangeSelectedRow()
{
	//Find the Selected Item in the ListView
	LONG iSelRow = SendMessage(m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
	if(iSelRow == LVM_ERR)
	{
		wMessageBox(m_hWnd, MB_TASKMODAL | MB_ICONHAND | MB_OK | MB_DEFBUTTON1, 
			wsz_ERROR, L"Must first select a row...");
		return E_FAIL;
	}

	//Save the SelectedRow so the new dialog box knows which row were concerned with...
	m_iSelectedRow = iSelRow;
	
	//Create Dialog box, passing the "this" pointer
	m_eSource = ROWSET_SETDATA;
	DialogBoxParam(m_hInst, MAKEINTRESOURCE(IDD_ROWCHANGE), m_hWnd, RowChangeProc, (LPARAM)this);
	return S_OK;
}


////////////////////////////////////////////////////////////////
// CMDIChild::InsertNewRow
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::InsertNewRow()
{
	//Insert a new row into the ListView...
	HRESULT hr = E_FAIL;

	//Find the Selected Item in the ListView
	LONG iSelRow = SendMessage(m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
	//Save the SelectedRow so the new dialog box knows which row were concerned with...
	m_iSelectedRow = iSelRow;

	//Is editing the Rowset allowed?
	if(m_pCRowset->m_pIRowsetChange == NULL)
		return E_FAIL;

	//Bring up the Insert Dialog box...
	m_eSource = ROWSET_INSERTROW;
	DialogBoxParam(m_hInst, MAKEINTRESOURCE(IDD_ROWCHANGE), m_hWnd, RowChangeProc, (LPARAM)this);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::UndoChanges
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::UndoChanges()
{
	//Undo all pending changes, (if in buffered mode)...
	HRESULT hr = E_FAIL;
	ASSERT(m_pCRowset->m_pIRowsetUpdate);

	ULONG i,cRows = 0;
	HROW* rghRows = NULL;
	ULONG cRowsUndone = 0;
	HROW* rghRowsUndone = NULL;
	LONG* rgItems = NULL;
	DBROWSTATUS* rgRowStatus = NULL;
		
	//Get all selected Rows
	LV_GetSelItems(m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);

	//IRowsetUpdate::Undo
	TESTC(m_pCListBox->OutputPreMethod("IRowsetUpdate::Undo(NULL,%d,0x%08x,&%d,&0x%08x,&0x%08x)", cRows, rghRows, cRowsUndone, rghRowsUndone, rgRowStatus));
	XTEST(m_hWnd, hr = m_pCRowset->m_pIRowsetUpdate->Undo(NULL,cRows,rghRows,&cRowsUndone,&rghRowsUndone, &rgRowStatus));
	if(hr==DB_S_ERRORSOCCURRED || hr==DB_E_ERRORSOCCURRED)
		DisplayRowErrors(m_hWnd, cRowsUndone, rghRowsUndone, rgRowStatus);
	TESTC(m_pCListBox->OutputPostMethod(hr, "IRowsetUpdate::Undo(NULL,%d,0x%08x,&%d,&0x%08x,&0x%08x)", cRows, rghRows, cRowsUndone, rghRowsUndone, rgRowStatus));

	//Now GetData for all SelectedRows (a nice helper)
	//We won't worry about updating the case for (0,NULL), its not worth
	//trying to match the rhgRows returned to the correct hRows.  Worse case
	//is the user has to call GetData for one or all rows...
	for(i=0; i<cRows; i++)
	{
		//Need to indicate row was updated, use normal icon
		LV_SetItemImage(m_hWndListView, rgItems[i], 0, IMAGE_NORMAL);

		//Display the Data...
		hr = DisplayData(IID_IRowset, rghRows[i], rgItems[i]);
	}

CLEANUP:
	SAFE_FREE(rghRows);
	SAFE_FREE(rghRowsUndone);
	SAFE_FREE(rgRowStatus);
	SAFE_FREE(rgItems);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::UpdateChanges
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::UpdateChanges()
{
	//Update all pending changes, (if in buffered mode)...
	HRESULT hr = E_FAIL;
	ASSERT(m_pCRowset->m_pIRowsetUpdate);

	ULONG i,cRows = 0;
	HROW* rghRows = NULL;
	ULONG cRowsUpdated = 0;
	HROW* rghRowsUpdated = NULL;
	DBROWSTATUS* rgRowStatus = NULL;
	LONG* rgItems = NULL;
	
	//Get all selected Rows
	LV_GetSelItems(m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);

	//IRowsetUpdate::Update
	TESTC(m_pCListBox->OutputPreMethod("IRowsetUpdate::Update(NULL,%d,0x%08x,&%d, &0x%08x, &0x%08x)", cRows, rghRows, cRowsUpdated, rghRowsUpdated, rgRowStatus));
	XTEST(m_hWnd, hr = m_pCRowset->m_pIRowsetUpdate->Update(NULL,cRows,rghRows,&cRowsUpdated,&rghRowsUpdated,&rgRowStatus));
	if(hr==DB_S_ERRORSOCCURRED || hr==DB_E_ERRORSOCCURRED)
		DisplayRowErrors(m_hWnd, cRowsUpdated, rghRowsUpdated, rgRowStatus);
	TESTC(m_pCListBox->OutputPostMethod(hr, "IRowsetUpdate::Update(NULL,%d,0x%08x,&%d, &0x%08x, &0x%08x)", cRows, rghRows, cRowsUpdated, rghRowsUpdated, rgRowStatus));

	//Now GetData for all SelectedRows (a nice helper)
	//We won't worry about updating the case for (0,NULL), its not worth
	//trying to match the rhgRows returned to the correct hRows.  Worse case
	//is the user has to call GetData for one or all rows...
	for(i=0; i<cRows; i++)
	{
		//Need to indicate row was updated, use normal icon
		LV_SetItemImage(m_hWndListView, rgItems[i], 0, IMAGE_NORMAL);

		//Display the Data...
		hr = DisplayData(IID_IRowset, rghRows[i], rgItems[i]);
	}

CLEANUP:
	SAFE_FREE(rghRows);
	SAFE_FREE(rghRowsUpdated);
	SAFE_FREE(rgRowStatus);
	SAFE_FREE(rgItems);
	return hr;
}

					

////////////////////////////////////////////////////////////////
// CMDIChild::RestartPosition
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::RestartPosition()
{
	Busy();
	HRESULT hr = E_FAIL;
	ASSERT(m_pCRowset->m_pIRowset);
	
	//RestartPosition...
	if (m_pCRowset->m_eRowsetSource == ROWSET_FROMCOMMANDDATASET)
	{
		hr = m_pCRowset->m_pCDataset->RestartPosition();
	}
	else
	{
		TESTC(m_pCListBox->OutputPreMethod("IRowset::RestartPosition(NULL)"));
		XTEST(m_hWnd, hr = m_pCRowset->m_pIRowset->RestartPosition(NULL));
		TESTC(m_pCListBox->OutputPostMethod(hr, "IRowset::RestartPosition(NULL)"));
	}

	//Need to remove the "NextFetchPositon" icon from the "old" row
	LV_SetItemImage(m_hWndListView, m_lCurPos, 0, IMAGE_NORMAL);

	m_fPrevFetchForward = FALSE;
	m_lCurPos = 0;

	//Need to show the "NextFetchPositon" icon 
	LV_SetItemImage(m_hWndListView, m_lCurPos, 0, IMAGE_NFP_BEFORE);
	SendMessage(m_hWndListView, LVM_ENSUREVISIBLE, m_lCurPos, TRUE);

	//Move ScrollBar to beginning
	SetScroll(0);

CLEANUP:
	Busy(OFF);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::RefreshData
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::RefreshData()
{
	Busy();
	HRESULT hr = S_OK;
	LONG cRows = 0;
	DWORD dwRowsetOpts = GetOptionsObj()->m_dwRowsetOpts;
	
	//Clear ListView object
	TESTC(hr = ClearListView());

	//Display the Column Headers
	TESTC(hr = DisplayColumnInfo());

	//Determine the number of rows the user wants (initially)
	cRows = m_ulMaxViewItems;
	if(dwRowsetOpts & ROWSET_GETNOROWS)
		cRows = 0;
	else if(dwRowsetOpts & ROWSET_GETALLROWS)
		cRows = MAX_BLOCK_SIZE;

	//Display the Data (if user wants rows)
	TESTC(hr = DisplayRows(0, cRows));

	//Setup ScrollBar
	//If IRowsetScroll and a 'reasonable' value is returned
	//For the Total number of rows, use that for the Range of the ScrollBar
	m_ulScrollMax = m_pCRowset->m_ulEstimatedRows ? m_pCRowset->m_ulEstimatedRows : MAX_BLOCK_SIZE;
	SB_SetScrollInfo(m_hWndScrollBar, SB_CTL, 0, m_ulScrollMax, m_ulMaxViewItems, TRUE);

CLEANUP:
	RefreshControls();
	Busy(OFF);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CreateEnumChild()
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::CreateEnumChild()
{
	HRESULT hr = S_OK;
	LONG iSelRow = 0;
	CHAR szBuffer[MAX_NAME_LEN+1];
	
	//If enumertor rowset, double-clicking on a row
	//brings up the ParseName object in another window
	CDataSource* pCDataSource = m_pCRowset->m_pCDataSource;
	ULONG iColumn = 1;  //Skip RowHandle column

	//Determine which columns to look at...
	if(m_pCRowset->m_cBindings && m_pCRowset->m_rgBindings[0].iOrdinal==0)
		iColumn = 2;  //Skip Bindings column

	//Obtain SelectedRow
	iSelRow = SendMessage(m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
	ASSERT(iSelRow != LVM_ERR);
			   
	//Obtain SourcesName and description from SelectedRow
	ENUMINFO EnumInfo;
	//SOURCES_NAME
	LV_GetItemText(m_hWndListView, iSelRow, iColumn+0, szBuffer, MAX_NAME_LEN);
	ConvertToWCHAR(szBuffer, EnumInfo.wszName, MAX_NAME_LEN);
	//SOURCES_PARSENAME
	LV_GetItemText(m_hWndListView, iSelRow, iColumn+1, szBuffer, MAX_NAME_LEN);
	ConvertToWCHAR(szBuffer, EnumInfo.wszParseName, MAX_NAME_LEN);
	//SOURCES_DESCRIPTION
	LV_GetItemText(m_hWndListView, iSelRow, iColumn+2, szBuffer, MAX_NAME_LEN);
	ConvertToWCHAR(szBuffer, EnumInfo.wszDescription, MAX_NAME_LEN);
	//SOURCES_TYPE
	LV_GetItemText(m_hWndListView, iSelRow, iColumn+3, szBuffer, MAX_NAME_LEN);
	EnumInfo.wType = (DBTYPE)strtoul(szBuffer, NULL, 10);
	//SOURCES_ISPARENT
	LV_GetItemText(m_hWndListView, iSelRow, iColumn+4, szBuffer, MAX_NAME_LEN);
	EnumInfo.fIsParent = strcmp(szBuffer, "True") ? TRUE : FALSE;

	//Now Connect using the Connect Dialog
	ASSERT(m_pCMainWindow);
	ASSERT(m_pCMainWindow->m_pCConnectDlg);
	TESTC(hr = m_pCMainWindow->m_pCConnectDlg->Display(pCDataSource->m_pIParseDisplayName, &EnumInfo));

CLEANUP:
	return hr;
}



////////////////////////////////////////////////////////////////
// CMDIChild::GetListViewValues
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::GetListViewValues(HWND hWndNames, HWND hWndValues, ULONG cBindings, DBBINDING* rgBindings, void* pData)
{
	ASSERT(hWndNames);
	ASSERT(hWndValues);
	ASSERT(pData);
	HRESULT hr = S_OK;

	//Obtain the values from a specified ListView
	//And place them into our pData structure according to our bindings...
	//this method is mainly used for InsertRow and SetData operations...
	CHAR szBuffer[MAX_COL_SIZE+1];
	DBSTATUS dwStatus = 0;

	//Loop through all Columns
	for(ULONG i=0; i<cBindings; i++)
	{
		ASSERT(rgBindings);

		//Get the Status from the 'insert' ListView
		LV_GetItemText(hWndNames, i, 2, szBuffer, MAX_COL_SIZE);
		dwStatus = GetStatusValue(szBuffer);
		
		//Get the Item from the 'insert' ListView
		LV_GetItemText(hWndValues, i, 0, szBuffer, MAX_COL_SIZE);

		//Set the ColumnData in our pData buffer
		TESTC(hr = m_pCRowset->SetColumnData(&rgBindings[i], pData, dwStatus, szBuffer));

		//Reset the Item in the ListView in case it got truncated
		LV_SetItemText(hWndValues, i, 0, szBuffer);
	}

CLEANUP:
	return hr;
}
					

////////////////////////////////////////////////////////////////
// CMDIChild::RowChangeProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::RowChangeProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static BOOL bBeginEdit = FALSE;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN

			Busy();
			bBeginEdit = FALSE;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset* pCRowset = pThis->m_pCRowset;
			DWORD dwConvFlags = pThis->GetOptionsObj()->m_dwConvFlags; 
			void* pData = pCRowset->m_pData;
			HRESULT hr = S_OK;

			CHAR szBuffer[MAX_COL_SIZE+1];
			ULONG	 i,dwLength = 0;
			DBSTATUS dwStatus = DBSTATUS_S_OK;//DBSTATUS_S_ISNULL;
			DBTYPE   wSubType = 0;

			//We need to bring up a 2 ListViews.
			//left - has column names, 
			//right - is blank for entering data for the corrsponding column
			
			//Setup column headers
			HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
			SOURCE eSource   = pThis->m_eSource;

			//Setup ImageList
			HIMAGELIST hImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );
			
			//IDI_NORMAL
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_NORMAL));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_READONLY - readonly checked icon
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_COL_INFO - column header
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_COL_INFO));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_COL_ERROR - column header
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_COL_ERROR));
			ImageList_AddIcon(hImageList, hIcon);

			//Set image list to the ListView
			ListView_SetImageList(hWndValues, hImageList, LVSIL_SMALL);
//			ImageList_Destroy(hImageList);

			//Use Extended ListView Styles!
			SendMessage(hWndNames, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndValues, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//Update Controls
			EnableWindow(GetDlgItem(hWnd, IDB_BINDUPDATECOLS),	(BOOL)pCRowset->m_pIRowsetChange);
			EnableWindow(GetDlgItem(hWnd, IDB_BINDALLCOLS),		(BOOL)pCRowset->m_pIRowsetChange);
			EnableWindow(GetDlgItem(hWnd, IDB_ACCESSOR),		(BOOL)pCRowset->m_pIRowsetChange);
			CheckRadioButton(hWnd, IDB_BINDUPDATECOLS, IDB_BINDALLCOLS, IDB_BINDUPDATECOLS);

			//Update Title and Status
			if(eSource == ROWSET_INSERTROW)
			{
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"IRowsetChange::InsertRow");
				SendMessage(GetDlgItem(hWnd, IDT_HELPMSG), WM_SETTEXT, 0, (LPARAM)"Inserts the desired row of data into the Rowset");
				SendMessage(GetDlgItem(hWnd, IDOK), WM_SETTEXT, 0, (LPARAM)"InsertRow");
			}
			else if(pCRowset->m_pIRowsetChange)
			{
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"IRowsetChange::SetData");
				SendMessage(GetDlgItem(hWnd, IDT_HELPMSG), WM_SETTEXT, 0, (LPARAM)"Modifies the row data in the Rowset");
				SendMessage(GetDlgItem(hWnd, IDOK), WM_SETTEXT, 0, (LPARAM)"SetData");
			}
			else
			{
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"Detailed Row Information");
				SendMessage(GetDlgItem(hWnd, IDT_HELPMSG), WM_SETTEXT, 0, (LPARAM)"Detailed Row Info, Status, Length, Value, SubType...");
			}


			//Insert Column Headers
			LV_InsertColumn(hWndNames,   0, "Column");
			LV_InsertColumn(hWndNames,   1, "Length");
			LV_InsertColumn(hWndNames,   2, "Status");
			LV_InsertColumn(hWndNames,   3, "Type");
			LV_InsertColumn(hWndNames,   4, "SubType");
			LV_InsertColumn(hWndValues,  0, "Data");
			
			//Get row handle for the selected row
			HROW hRow = NULL;
			if(pThis->m_iSelectedRow != LVM_ERR)
			{
				hRow = LV_GetItemParam(pThis->m_hWndListView, pThis->m_iSelectedRow, 0);
			
				//GetData for this row
				//GetData wrapper with Argument checking...
				hr = pCRowset->GetData(hRow);
				
				//Relax the errors here.  With Get*Data both DB_S/DB_E will return a bad
				//status for 1 or more columns.  Or DataGrid will just display the column
				//status if not S_OK.  So for these errors just display the data anyway...
				if(FAILED(hr) && hr!= DB_E_ERRORSOCCURRED)
					goto CLEANUP2;
				hr = S_OK;
			}
			
			//Display ColumnNames in LeftPane, and data in the right pane
			for(i=0; i<pCRowset->m_cBindings; i++)
			{
				DBBINDING* pBinding = &pCRowset->m_rgBindings[i];
				DBCOLUMNINFO* pColInfo = pCRowset->GetColInfo(pBinding->iOrdinal);

				szBuffer[0] = EOL;
				if(pThis->m_iSelectedRow != LVM_ERR)
				{
					//Get the Length, Status, Data for this Column
					pCRowset->GetColumnData(pBinding, pData, &dwStatus, &dwLength, &wSubType, szBuffer, MAX_COL_SIZE, dwConvFlags, pColInfo->wType);
				}
				
				//Insert the Data into the list (make an "easy" edit)
				LV_InsertItem(hWndValues, i, 0, szBuffer, PARAM_NONE, GetColumnImage(pColInfo, dwStatus));

				//Insert the ColumnName
				sprintf(szBuffer, "%S", pCRowset->GetColName(pBinding->iOrdinal));
				LV_InsertItem(hWndNames, i, 0, szBuffer);
				
				//Insert the Length into the List
				sprintf(szBuffer, "%d", dwLength);
				LV_InsertItem(hWndNames, i, 1, szBuffer);

				//Insert the Status into the List
				LV_InsertItem(hWndNames, i, 2, GetStatusName(dwStatus));

				//Insert the Type into the List
				sprintf(szBuffer, "%S", GetDBTypeName(pColInfo->wType));
				LV_InsertItem(hWndNames, i, 3, szBuffer);

				//Insert the SubType into the List
				if(pBinding->wType == DBTYPE_VARIANT)
				{
					sprintf(szBuffer, "%s", GetVariantTypeName(wSubType));
					LV_InsertItem(hWndNames, i, 4, szBuffer);
				}
			}

		CLEANUP2:
			Busy(OFF);
			//AutoSize Columns
			for(i=0; i<=4; i++)
				SendMessage(hWndNames, LVM_SETCOLUMNWIDTH, (WPARAM)i,	(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			SendMessage(hWndValues, LVM_SETCOLUMNWIDTH, 0,	(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			CenterDialog(hWnd);

			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
				break;

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDMENU_DBSTATUS_S_OK:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_OK");
					return 0;
				}

				case IDMENU_DBSTATUS_S_ISNULL:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_ISNULL");
					return 0;
				}
				
				case IDMENU_DBSTATUS_S_DEFAULT:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_DEFAULT");
					return 0;
				}

				case IDMENU_DISPLAY_HEX:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CHAR szBuffer[MAX_COL_SIZE+1];
					
					HWND hWndValues   = GetDlgItem(hWnd, IDL_VALUES);
					DWORD dwConvFlags = pThis->GetOptionsObj()->m_dwConvFlags; 
					
					//Find the Selected Row
					LONG iSelRow = SendMessage(hWndValues, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					//Get the Text from the Row
					szBuffer[0] = EOL;
					LV_GetItemText(hWndValues, iSelRow, 0, szBuffer, MAX_COL_SIZE);

					//Convert using the Requested converions
					if(SUCCEEDED(ConvertString(szBuffer, MAX_COL_SIZE, CONV_HEX)))
					{
						//Insert the Data into the list (make an "easy" edit)
						LV_SetItemText(hWndValues, iSelRow, 0, szBuffer);
					}
					return 0;
				}

				case IDOK:
				{
					//Get the "this" pointer
					Busy();
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CListBox* pCListBox = pThis->m_pCListBox;
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
					HRESULT hr = S_OK;

					ULONG i=0;
					HROW hRow = NULL;

					HACCESSOR hAccessor = pCRowset->m_hAccessor;
					ULONG cBindings = pCRowset->m_cBindings;
					DBBINDING* rgBindings = pCRowset->m_rgBindings;
					void* pData = pCRowset->m_pData;
					SOURCE eSource = pThis->m_eSource;

					//The ListView will produce IDOK if hitting return after entering
					//a value.  The easist way arround this is to just exit if 
					//we haven't yet received the ENDEDIT message
					if(bBeginEdit)
						goto CLEANUP;
					
					if(pCRowset->m_pIRowsetChange == NULL)
						goto CLEANUP;
					
					//Obtain the ListView Values into our pData buffer
					TESTC(hr = pThis->GetListViewValues(hWndNames, hWndValues, cBindings, rgBindings, pData));
					
					//Create Accessor if only binding updatable columns...
					if(IsDlgButtonChecked(hWnd, IDB_BINDUPDATECOLS) && cBindings)
					{
						SAFE_ALLOC(rgBindings, DBBINDING, cBindings);
						cBindings = 0;
						
						//Loop through current bindings, and find updatable ones
						for(i=0; i<pCRowset->m_cBindings; i++)
						{
							DBBINDING* pBinding = &pCRowset->m_rgBindings[i];
							DBCOLUMNINFO* pColInfo = pCRowset->GetColInfo(pBinding->iOrdinal);

							//Copy this binding (if updateable)
							if(pColInfo->dwFlags & DBCOLUMNFLAGS_WRITE || pColInfo->dwFlags & DBCOLUMNFLAGS_WRITEUNKNOWN)
							{
					 			memcpy(&rgBindings[cBindings], pBinding, sizeof(DBBINDING));
								cBindings++;
							}
						}
						
						//Now create the Accessor
						TESTC(hr = pCRowset->CreateAccessor(DBACCESSOR_ROWDATA, cBindings, rgBindings, NULL, &hAccessor));
					}

					//Need to obtain the Current hRow value (lParam)
					if(eSource == ROWSET_SETDATA)
					{
						hRow = LV_GetItemParam(pThis->m_hWndListView, pThis->m_iSelectedRow, 0);
										
						//Now that we have setup the buffer, SetData into the rowset
						pCListBox->OutputPreMethod("IRowsetChange::SetData(0x%08x, 0x%08x, 0x%08x)", hRow, hAccessor, pData);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetChange->SetData(hRow, hAccessor, pData));
						pCListBox->OutputPostMethod(hr, "IRowsetChange::SetData(0x%08x, 0x%08x, 0x%08x)", hRow, hAccessor, pData);

					}
					else
					{
						//Now that we have setup the buffer, Insert the data into the rowset
						pCListBox->OutputPreMethod("IRowsetChange::InsertRow(NULL, 0x%08x, 0x%08x, 0x%08x)", hAccessor, pData, NULL);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetChange->InsertRow(NULL, hAccessor, pData, NULL/*&hRow*/));
						pCListBox->OutputPostMethod(hr, "IRowsetChange::InsertRow(NULL, 0x%08x, 0x%08x, 0x%08x)", hAccessor, pData, NULL);
					}

					if(hr == DB_S_ERRORSOCCURRED || hr == DB_E_ERRORSOCCURRED)
						DisplayBindingErrors(hWnd, cBindings, rgBindings, pData);
					if(FAILED(hr))
						goto CLEANUP;

					//Its our responsiblity to free the allocated (outofline) data...
					TESTC(FreeBindingData(cBindings, rgBindings, pData));

					if(eSource == ROWSET_SETDATA)
					{
						//Need to indicate row was modified, use "changed" icon
						LV_SetItemImage(pThis->m_hWndListView, pThis->m_iSelectedRow, 0, IMAGE_ROW_CHANGE);

						//Display the Data for this Row
						TESTC(hr = pThis->DisplayData(IID_IRowset, hRow, pThis->m_iSelectedRow));
					}

				CLEANUP:
					Busy(OFF);
					//Free Bindings if not using "All Columns" Accessor
					if(rgBindings != pCRowset->m_rgBindings)
					{
						FreeBindings(&cBindings, &rgBindings);
						pCRowset->ReleaseAccessor(&hAccessor);
					}
	
					if(SUCCEEDED(hr))
						EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					bBeginEdit = FALSE;
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND


		case WM_CONTEXTMENU:
		{	
			HWND hWndSelected = (HWND)wParam;
			HWND hWndNames = GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndValues = GetDlgItem(hWnd, IDL_VALUES);
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			
			//Must have selected a row to change status
			LONG iSel = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
			if(iSel == LVM_ERR)
				return FALSE;

			//IDL_NAMES
			if(hWndSelected == hWndNames)
			{
				//Don't need to change the status if readonly
				if(pThis->m_pCRowset->m_pIRowsetChange == NULL)
					return FALSE;

				//Display Menu
				DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_CHANGESTATUS, 
								LOWORD(lParam),
								HIWORD(lParam),
								hWnd
								);
			}

			//IDL_VALUES
			if(hWndSelected == hWndValues)
			{
				//Display Menu
				DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_CHANGEVALUE, 
								LOWORD(lParam),
								HIWORD(lParam),
								hWnd
								);
			}
			return FALSE;
		}

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
				{
					//Obtain the SelectedRow
					LONG iSel = SendMessage(GetDlgItem(hWnd, IDL_VALUES), LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSel == LVM_ERR)
						return 0;

					//Need to Send LVM_EDITLABEL
					SendMessage(GetDlgItem(hWnd, IDL_VALUES), LVM_EDITLABEL, iSel, 0);
					return 0;
				}

				case LVN_BEGINLABELEDIT:
					bBeginEdit = TRUE;
					return FALSE;//allow the user to change the value of the item.
					
				case LVN_ENDLABELEDIT:
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
					bBeginEdit = FALSE;								

					//Now update the ListView with the new value
					//If IRowsetChange is supported...
					if(pDispInfo->item.pszText && pThis->m_pCRowset->m_pIRowsetChange)
						LV_SetItemText(hWndValues, pDispInfo->item.iItem, 0, pDispInfo->item.pszText);

					return TRUE; //Allow the edited change
				}

				case LVN_ITEMCHANGED:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
					bBeginEdit = FALSE;								

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_VALUES)
						{
							SyncSibling(hWndNames, hWndValues);
	           				return HANDLED_MSG;
						}

						if(wParam == IDL_NAMES)
						{
							SyncSibling(hWndValues, hWndNames);
	                		return HANDLED_MSG;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}
		}//WM_NOTIFY
	}//switch(message);

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::AxisInfoProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::AxisInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static BOOL bBeginEdit = FALSE;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			Busy();
			bBeginEdit = FALSE;
			HRESULT hr = S_OK;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CDataset* pCDataset = pThis->m_pCRowset->m_pCDataset;
			ULONG cAxis;
			MDAXISINFO *rgAxisInfo;
			CHAR szBuffer[256];

			//Setup column headers and values for axisinfo listview
			HWND hWndAxisInfo   = GetDlgItem(hWnd, IDL_AXISINFO);
			
			//Use Extended ListView Styles!
			SendMessage(hWndAxisInfo, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//Insert Column Headers
			LV_InsertColumn(hWndAxisInfo, 0, "Dimension Names");
			LV_InsertColumn(hWndAxisInfo, 1, "Columns");
			
			// get the axis info from the dataset
			hr = pCDataset->GetAxisInfo(&cAxis, &rgAxisInfo);
			
			if (SUCCEEDED(hr) && cAxis != 0) 
			{
				// fill in the axis selection combo
				for (ULONG iAxis=0; iAxis<cAxis-1; iAxis++)
				{
					switch (iAxis)
					{
					case 0:
						SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Columns");
						break;

					case 1:
						SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Rows");
						break;

					default:
						_ltoa(iAxis, szBuffer, 10);
						SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)szBuffer);
						break;
					}
				}
				SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Slicer");
				SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_SETCURSEL, 0, (LPARAM)0);

				_ltoa(rgAxisInfo->cDimensions, szBuffer, 10);
				SendMessage(GetDlgItem(hWnd, IDC_DIMENSIONS), WM_SETTEXT, 0, (LPARAM)(LPCTSTR)szBuffer);

				_ltoa(rgAxisInfo->cCoordinates, szBuffer, 10);
				SendMessage(GetDlgItem(hWnd, IDC_COORDINATES), WM_SETTEXT, 0, (LPARAM)(LPCTSTR)szBuffer);

				//Display Dimension Names in LeftPane, and Column Count in right pane
				for(ULONG iDim=0; iDim<rgAxisInfo->cDimensions; iDim++)
				{
					wcstombs(szBuffer, rgAxisInfo->rgpwszDimensionNames[iDim], sizeof(szBuffer));
					LV_InsertItem(hWndAxisInfo, iDim, 0, szBuffer);
				
					_ltoa(rgAxisInfo->rgcColumns[iDim], szBuffer, 10);
					LV_InsertItem(hWndAxisInfo, iDim, 1, szBuffer);
				}
			}

			//AutoSize Columns
			SendMessage(hWndAxisInfo, LVM_SETCOLUMNWIDTH, (WPARAM)0, (LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			SendMessage(hWndAxisInfo, LVM_SETCOLUMNWIDTH, (WPARAM)1, (LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			CenterDialog(hWnd);
			break;
		}

		case WM_COMMAND:
		{
			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					Busy();
					HRESULT hr = S_OK;
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

					//The ListView will produce IDOK if hitting return after 
					//entering a value.  The easist way arround this is to just exit if 
					//we haven't yet received the ENDEDIT message
					if (bBeginEdit)
						return FALSE;
					
					EndDialog(hWnd, TRUE);
					break;
				}
				case IDCOMBO_AXIS:
				{
					switch(GET_WM_COMMAND_CMD(wParam, lParam))
					{
						//Selection change in axis combo box
						case CBN_SELCHANGE:
						{	
							HRESULT hr = S_OK;
							ULONG cAxis;
							MDAXISINFO *rgAxisInfo;
							CHAR szBuffer[256];
							CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
							CDataset* pCDataset = pThis->m_pCRowset->m_pCDataset;
							HWND hWndAxisInfo = GetDlgItem(hWnd, IDL_AXISINFO);
							ULONG iAxis = SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_GETCURSEL, 0, 0);
							SendMessage(hWndAxisInfo, LVM_DELETEALLITEMS, 0, 0);

							// get the axis info from the dataset
							hr = pCDataset->GetAxisInfo(&cAxis, &rgAxisInfo);
							
							if (SUCCEEDED(hr) && cAxis >= iAxis) 
							{
								_ltoa(rgAxisInfo[iAxis].cDimensions, szBuffer, 10);
								SendMessage(GetDlgItem(hWnd, IDC_DIMENSIONS), WM_SETTEXT, 0, (LPARAM)(LPCTSTR)szBuffer);

								_ltoa(rgAxisInfo[iAxis].cCoordinates, szBuffer, 10);
								SendMessage(GetDlgItem(hWnd, IDC_COORDINATES), WM_SETTEXT, 0, (LPARAM)(LPCTSTR)szBuffer);

								//Display Dimension Names in LeftPane, and Column Count in right pane
								for(ULONG iDim=0; iDim<rgAxisInfo[iAxis].cDimensions; iDim++)
								{
									wcstombs(szBuffer, rgAxisInfo[iAxis].rgpwszDimensionNames[iDim], sizeof(szBuffer));
									LV_InsertItem(hWndAxisInfo, iDim, 0, szBuffer);
								
									_ltoa(rgAxisInfo[iAxis].rgcColumns[iDim], szBuffer, 10);
									LV_InsertItem(hWndAxisInfo, iDim, 1, szBuffer);
								}
							}
							break;
						}
					}
				}
			}
			break;
		}//WM_COMMAND
	}//switch(message);
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::AxisRowsetProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::AxisRowsetProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			//Save the "this" pointer
			Busy();
			HRESULT hr = S_OK;
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CDataset* pCDataset = pThis->m_pCRowset->m_pCDataset;
			ULONG cAxis;
			MDAXISINFO *rgAxisInfo;
			CHAR szBuffer[24];

			// get the axis info from the dataset
			hr = pCDataset->GetAxisInfo(&cAxis, &rgAxisInfo);
			
			if (SUCCEEDED(hr) && cAxis != 0) 
			{
				// fill in the axis selection combo
				for (ULONG iAxis=0; iAxis<cAxis-1; iAxis++)
				{
					switch (iAxis)
					{
					case 0:
						SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Columns");
						break;

					case 1:
						SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Rows");
						break;

					default:
						_ltoa(iAxis, szBuffer, 10);
						SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)szBuffer);
						break;
					}
				}
				SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Slicer");
				SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_SETCURSEL, 0, (LPARAM)0);
			}
			break;
		}

		case WM_COMMAND:
		{
			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CDataset* pCDataset = pThis->m_pCRowset->m_pCDataset;
					ULONG iAxis = SendMessage(GetDlgItem(hWnd, IDCOMBO_AXIS), CB_GETCURSEL, 0, 0);
					pCDataset->SetAxisRowset(iAxis);
					EndDialog(hWnd, TRUE);
					break;
				}
				case IDCANCEL:
					EndDialog(hWnd, FALSE);
					break;
			}
			break;
		}//WM_COMMAND
	}//switch(message);
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ColumnChangeProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::ColumnChangeProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static BOOL bBeginEdit = FALSE;
	static HACCESSOR hAccessor = NULL;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN

			Busy();
			bBeginEdit = FALSE;
			CHAR szBuffer[MAX_COL_SIZE+1];
			ULONG	 dwLength = 0;
			DBSTATUS dwStatus = 0;
			DBTYPE   wSubType = 0;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			DWORD dwConvFlags = pThis->GetOptionsObj()->m_dwConvFlags; 
			ULONG i,iItemCount = 0;

			ASSERT(pCRowset->m_cBindings);
			ASSERT(pCRowset->m_rgBindings);

			HRESULT hr = S_OK;
			ASSERT(pThis->m_iSelectedCol < pCRowset->m_cBindings);
			DBBINDING* pBinding = &pCRowset->m_rgBindings[pThis->m_iSelectedCol];
			void* pData = pCRowset->m_pData;

			//We need to bring up a 2 ListViews.
			//left - has column names, 
			//right - is blank for entering data for the corrsponding column
			
			//Setup column headers
			HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
			
			//Use Extended ListView Styles!
			SendMessage(hWndNames, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndValues, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//Setup ImageList
			HIMAGELIST hImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );
			
			//IDI_NORMAL
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_NORMAL));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_READONLY - readonly checked icon
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_COL_INFO - column header
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_COL_INFO));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_COL_ERROR - column header
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_COL_ERROR));
			ImageList_AddIcon(hImageList, hIcon);

			//Set image list to the ListView
			ListView_SetImageList(hWndValues, hImageList, LVSIL_SMALL);
//			ImageList_Destroy(hImageList);

			//Update Controls
			EnableWindow(GetDlgItem(hWnd, IDB_BINDUPDATECOLS),	FALSE);
			EnableWindow(GetDlgItem(hWnd, IDB_BINDALLCOLS),		FALSE);
			EnableWindow(GetDlgItem(hWnd, IDB_ACCESSOR),		FALSE);
			CheckRadioButton(hWnd, IDB_BINDUPDATECOLS, IDB_BINDALLCOLS, IDB_BINDUPDATECOLS);

			//Update Title and Status
			if(pCRowset->m_pIRowsetChange)
			{
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"IRowsetChange::SetData");
				SendMessage(GetDlgItem(hWnd, IDT_HELPMSG), WM_SETTEXT, 0, (LPARAM)"Modifies the row data in the Rowset");
				SendMessage(GetDlgItem(hWnd, IDOK), WM_SETTEXT, 0, (LPARAM)"SetData");
			}
			else
			{
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"Detailed Row Information");
				SendMessage(GetDlgItem(hWnd, IDT_HELPMSG), WM_SETTEXT, 0, (LPARAM)"Detailed Row Info, Status, Length, Value, SubType...");
			}

			//Insert Column Headers
			LV_InsertColumn(hWndNames,   0, pCRowset->m_eRowsetSource == ROWSET_FROMCOMMANDDATASET ? "Cell Ordinal" : "Row Handle");
			LV_InsertColumn(hWndNames,   1, "Length");
			LV_InsertColumn(hWndNames,   2, "Status");
			LV_InsertColumn(hWndNames,   3, "Type");
			LV_InsertColumn(hWndNames,   4, "SubType");
			
			//Column header is the ColumnName
			DBCOLUMNINFO* pColInfo = pCRowset->GetColInfo(pBinding->iOrdinal); 
			sprintf(szBuffer, "%S", pCRowset->GetColName(pBinding->iOrdinal));
			LV_InsertColumn(hWndValues, 0, szBuffer, GetColumnImage(pColInfo));
			
			//Create An Accessor binding only this column
			//Much quicker to get and set using only the column we need.
			EXC_TEST(hr = pCRowset->CreateAccessor(DBACCESSOR_ROWDATA, 1, pBinding, 0, &hAccessor));
			if(FAILED(hr))
				goto CLEANUP2;
			
			//Display Data in the ListView
			iItemCount = SendMessage(pThis->m_hWndListView, LVM_GETITEMCOUNT, 0, 0);
			for(i=0; i<iItemCount; i++)
			{
				//Get row handle for the selected row
				HROW hRow = LV_GetItemParam(pThis->m_hWndListView, i, 0);

				//GetData for this row and Column
				//GetData wrapper with Argument checking...
				hr = pCRowset->GetData(hRow, hAccessor);
				//Relax the errors here.  With Get*Data both DB_S/DB_E will return a bad
				//status for 1 or more columns.  Or DataGrid will just display the column
				//status if not S_OK.  So for these errors just display the data anyway...
				if(FAILED(hr) && hr!= DB_E_ERRORSOCCURRED)
					goto CLEANUP2;
				hr = S_OK;

				//Get the Length, Status, Data for this Column
				pCRowset->GetColumnData(pBinding, pData, &dwStatus, &dwLength, &wSubType, szBuffer, MAX_COL_SIZE, dwConvFlags, pColInfo->wType);

				//Insert the Data into the list (make an "easy" edit)
				LV_InsertItem(hWndValues, i, 0, szBuffer, PARAM_NONE, GetColumnImage(pColInfo, dwStatus));

				//Display the hRow in the ListView
				sprintf(szBuffer, "0x%x", hRow);
				LV_InsertItem(hWndNames, i, 0, szBuffer, 0, 0);
				
				//Insert the Length into the List
				sprintf(szBuffer, "%d", dwLength);
				LV_InsertItem(hWndNames, i, 1, szBuffer);

				//Insert the Status into the List
				LV_InsertItem(hWndNames, i, 2, GetStatusName(dwStatus));

				//Insert the Type into the List
				sprintf(szBuffer, "%S", GetDBTypeName(pColInfo->wType));
				LV_InsertItem(hWndNames, i, 3, szBuffer);

				//Insert the SubType into the List
				if(pBinding->wType == DBTYPE_VARIANT)
				{
					sprintf(szBuffer, "%s", GetVariantTypeName(wSubType));
					LV_InsertItem(hWndNames, i, 4, szBuffer);
				}
			}

			//AutoSize Columns
			for(i=0; i<=4; i++)
				SendMessage(hWndNames, LVM_SETCOLUMNWIDTH, (WPARAM)i,	(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			SendMessage(hWndValues, LVM_SETCOLUMNWIDTH, 0,	(LPARAM)LVSCW_AUTOSIZE_USEHEADER);

		CLEANUP2:
			Busy(OFF);
			CenterDialog(hWnd);
			if(FAILED(hr))
			{
				pCRowset->ReleaseAccessor(&hAccessor);
				EndDialog(hWnd, FALSE);
			}

			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDMENU_DBSTATUS_S_OK:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_OK");
					return 0;
				}

				case IDMENU_DBSTATUS_S_ISNULL:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_ISNULL");
					return 0;
				}
				
				case IDMENU_DBSTATUS_S_DEFAULT:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_DEFAULT");
					return 0;
				}

				case IDMENU_DISPLAY_HEX:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CHAR szBuffer[MAX_COL_SIZE+1];
					
					HWND hWndValues   = GetDlgItem(hWnd, IDL_VALUES);
					DWORD dwConvFlags = pThis->GetOptionsObj()->m_dwConvFlags; 
					
					//Find the Selected Row
					LONG iSelRow = SendMessage(hWndValues, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					//Get the Text from the Row
					szBuffer[0] = EOL;
					LV_GetItemText(hWndValues, iSelRow, 0, szBuffer, MAX_COL_SIZE);

					//Convert using the Requested converions
					if(SUCCEEDED(ConvertString(szBuffer, MAX_COL_SIZE, CONV_HEX)))
					{
						//Insert the Data into the list (make an "easy" edit)
						LV_SetItemText(hWndValues, iSelRow, 0, szBuffer);
					}
					return 0;
				}

				case IDOK:
				{
					Busy();
					CHAR szBuffer[MAX_COL_SIZE+1];

					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
					LONG i,iItemCount = 0;

					HRESULT hr = S_OK;
					ASSERT(pThis->m_iSelectedCol < pCRowset->m_cBindings);
					DBBINDING* pBinding = &pCRowset->m_rgBindings[pThis->m_iSelectedCol];
					void* pData = pCRowset->m_pData;

					//The ListView will produce IDOK if hitting return after entering
					//a value.  The easist way arround this is to just exit if 
					//we haven't yet received the ENDEDIT message
					if(bBeginEdit)
						return 0;

					if(pCRowset->m_pIRowsetChange == NULL)
						goto CLEANUP;

					//This dialog is a little more complex since were allowing 
					//the user to change an entire column so every row must be set
					//To make our lives a little easier, we will first Get the Data
					//for the row, and then Set only the affected column...
					iItemCount = SendMessage(hWndValues, LVM_GETITEMCOUNT, 0, 0);
					for(i=0; i<iItemCount; i++)
					{
						//Get row handle
						HROW hRow = LV_GetItemParam(pThis->m_hWndListView, i, 0);

						//Get the ColumnStatus
						LV_GetItemText(hWndNames, i, 2, szBuffer, MAX_COL_SIZE);
						DBSTATUS dwStatus = GetStatusValue(szBuffer);
						
						//Set the ColumnData in our pData buffer
						LV_GetItemText(hWndValues, i, 0, szBuffer, MAX_COL_SIZE);
						TESTC(pCRowset->SetColumnData(pBinding, pData, dwStatus, szBuffer));
					
						//Now that we have setup the buffer, SetData into the rowset
						pCListBox->OutputPreMethod("IRowsetChange::SetData(0x%08x, 0x%08x, 0x%08x)", hRow, hAccessor, pData);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetChange->SetData(hRow, hAccessor, pData));
						pCListBox->OutputPostMethod(hr, "IRowsetChange::SetData(0x%08x, 0x%08x, 0x%08x)", hRow, hAccessor, pData);
						if(hr == DB_S_ERRORSOCCURRED || hr == DB_E_ERRORSOCCURRED)
							DisplayBindingErrors(hWnd, 1, pBinding, pData);
						if(FAILED(hr))
							goto CLEANUP;

						//Need to indicate row was modified, use "changed" icon
						LV_SetItemImage(pThis->m_hWndListView, pThis->m_iSelectedRow, 0, IMAGE_ROW_CHANGE);

						//Its our responsiblity to free the allocated (outofline) data...
						TESTC(FreeBindingData(1, pBinding, pData));

						//Display the Data for this Row
						TESTC(hr = pThis->DisplayData(IID_IRowset, hRow, i));
					}
					
				CLEANUP:
					Busy(OFF);
					if(SUCCEEDED(hr))
					{
						pCRowset->ReleaseAccessor(&hAccessor);
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;

					bBeginEdit = FALSE;
					pCRowset->ReleaseAccessor(&hAccessor);
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_CONTEXTMENU:
		{	
			HWND hWndSelected = (HWND)wParam;
			HWND hWndNames = GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndValues = GetDlgItem(hWnd, IDL_VALUES);
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			
			//Must have selected a row to change status
			LONG iSel = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
			if(iSel == LVM_ERR)
				return FALSE;

			//IDL_NAMES
			if(hWndSelected == hWndNames)
			{
				//Don't need to change the status if readonly
				if(pThis->m_pCRowset->m_pIRowsetChange == NULL)
					return FALSE;

				//Display Menu
				DisplayContextMenu(	pThis->m_hInst, 
									hWnd,
									IDMENU_CHANGESTATUS, 
									LOWORD(lParam),
									HIWORD(lParam),
									hWnd
									);
			}

			//IDL_VALUES
			if(hWndSelected == hWndValues)
			{
				//Display Menu
				DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_CHANGEVALUE, 
								LOWORD(lParam),
								HIWORD(lParam),
								hWnd
								);
			}
			return FALSE;
		}

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
				{
					//Save the SelectedRow so the new dialog box knows which row were concerned with...
					LONG iSel = SendMessage(GetDlgItem(hWnd, IDL_VALUES), LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSel == LVM_ERR)
						return 0;

					//Need to Send LVM_EDITLABEL
					SendMessage(GetDlgItem(hWnd, IDL_VALUES), LVM_EDITLABEL, iSel, 0);
					return FALSE;
				}

				case LVN_BEGINLABELEDIT:
					bBeginEdit = TRUE;
					return FALSE;//allow the user to change the value of the item.
					
				case LVN_ENDLABELEDIT:
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
					bBeginEdit = FALSE;								

					//Now update the ListView with the new value
					if(pDispInfo->item.pszText && pThis->m_pCRowset->m_pIRowsetChange)
						LV_SetItemText(hWndValues, pDispInfo->item.iItem, 0, pDispInfo->item.pszText);

					return TRUE; //Allow the edited change
				}

				case LVN_ITEMCHANGED:
				{
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_VALUES);
					bBeginEdit = FALSE;								

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_VALUES)
						{
							SyncSibling(hWndNames, hWndValues);
	           				return HANDLED_MSG;
						}

						if(wParam == IDL_NAMES)
						{
							SyncSibling(hWndValues, hWndNames);
	                		return HANDLED_MSG;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}
		}//WM_NOTIFY
	}//switch(message);

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetColInfoProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetColInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			
			Busy();
			CHAR szBuffer[MAX_NAME_LEN+1];
			WCHAR wszBuffer[MAX_NAME_LEN+1];

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CDataSource* pCDataSource = pCRowset->m_pCDataSource;
			HRESULT hr = S_OK;

			ULONG i,cColumns = 0;
			DBCOLUMNINFO* rgColInfo = NULL;
			WCHAR* pStringBuffer = NULL;
			IColumnsInfo* pIColumnsInfo = NULL;

			//Setup column headers
			//We have 2 listviews.
			// 1.  Left - ColInfo types...
			// 2.  Rigth - All ColInfo for all columns
			HWND hWndName	= GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndCol	= GetDlgItem(hWnd, IDL_VALUES);
			HWND hWndHelp	= GetDlgItem(hWnd, IDT_HELPMSG);
			
			//Set Window Titles
			SendMessage(hWnd,		WM_SETTEXT, 0, (LPARAM)"IColumnsInfo::GetColumnsInfo");
			SendMessage(hWndHelp,	WM_SETTEXT, 0, (LPARAM)"Displays the (meta-data) Column Information");
			
			//Create the Col ImageList
			HIMAGELIST hColImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );

			//IDI_ROWNORMAL - for row icon
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_NORMAL));
			ImageList_AddIcon(hColImageList, hIcon);
			//IDI_CHECK - for "true" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_CHECK));
			ImageList_AddIcon(hColImageList, hIcon);
			//IDI_UNCHECK - for "false" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_UNCHECK));
			ImageList_AddIcon(hColImageList, hIcon);
			//IDI_READONLY - for "false" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));
			ImageList_AddIcon(hColImageList, hIcon);

			//Set image list to the Table Window 
			ListView_SetImageList(hWndCol, hColImageList, LVSIL_SMALL);
//			ImageList_Destroy(hColImageList);

			//Obtain IColumnInfo
			if(pThis->m_eSource == ROWSET)
			{
				//From rowset if we have a rowset
				pIColumnsInfo = pCRowset->m_pIColumnsInfo;
			}
			else 
			{
				//From Command if we have a command
				pIColumnsInfo = pCRowset->m_pCCommand->m_pIColumnsInfo;
			}
			
			//Now Obtain ColumnsInfo
			ASSERT(pIColumnsInfo);
			TESTC(pCListBox->OutputPreMethod("IColumnsInfo::GetColumnInfo(&%d, &0x%08x, &0x%08x)", cColumns, rgColInfo, pStringBuffer));
			XTEST(hWnd, hr = pIColumnsInfo->GetColumnInfo(&cColumns, &rgColInfo, &pStringBuffer));
			TESTC(pCListBox->OutputPostMethod(hr, "IColumnsInfo::GetColumnInfo(&%d, &0x%08x, &0x%08x)", cColumns, rgColInfo, pStringBuffer));

			//We need to the ListView
			//Headers/Columns contain ColInfo information 
			//Rows are per columns
			
			//Use Extended ListView Styles!
			SendMessage(hWndName, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndCol, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//ListView NAMES
			LV_InsertColumn(hWndName,	0,			"ColName");
			LV_InsertItem(hWndName,		1,		0,	"Ordinal");
			LV_InsertItem(hWndName,		2,		0,	"Type");
			LV_InsertItem(hWndName,		3,		0,	"ColummSize");
			LV_InsertItem(hWndName,		4,		0, 	"Precision");
			LV_InsertItem(hWndName,		5,		0,	"Scale");
			LV_InsertItem(hWndName,		6,		0,	"TypeInfo");
			LV_InsertItem(hWndName,		7,		0,	"ColumnID");
			LV_InsertItem(hWndName,		8,		0,	"dwFlags");
			LV_InsertItem(hWndName,		9,		0,	"CACHEDEFERRED");
			LV_InsertItem(hWndName,		10,		0,	"ISBOOKMARK");
			LV_InsertItem(hWndName,		11,		0,	"ISFIXEDLENGTH");
			LV_InsertItem(hWndName,		12,		0,	"ISLONG");
			LV_InsertItem(hWndName,		13,		0,	"ISNULLABLE");
			LV_InsertItem(hWndName,		14,		0,	"ISROWID");
			LV_InsertItem(hWndName,		15,		0,	"ISROWVER");
			LV_InsertItem(hWndName,		16,		0,	"MAYBENULL");
			LV_InsertItem(hWndName,		17,		0,	"MAYDEFER");
			LV_InsertItem(hWndName,		18,		0,	"WRITE");
			LV_InsertItem(hWndName,		19,		0,	"WRITEUNKNOWN");
			LV_InsertItem(hWndName,		20,		0,	"ISCHAPTER");
			LV_InsertItem(hWndName,		21,		0,	"SCALEISNEGATIVE");
			LV_InsertItem(hWndName,		22,		0,	"KEYCOLUMN");
			
			//AutoSize column
			SendMessage(hWndName, LVM_SETCOLUMNWIDTH, 0,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);

			for(i=0; i<cColumns; i++)
			{	
				ASSERT(rgColInfo);
				DBCOLUMNINFO* pColInfo = &rgColInfo[i];

				//Column Header
				ConvertToMBCS(pCRowset->GetColName(pColInfo->iOrdinal), szBuffer, MAX_NAME_LEN);
				LV_InsertColumn(hWndCol, i, szBuffer, GetColumnImage(pColInfo)==IMAGE_READONLY ? STATE_UNCHECKED+1 : IMAGE_NONE);

				//Ordinal (SubItem)
				sprintf(szBuffer, "%d", pColInfo->iOrdinal);
				LV_InsertItem(hWndCol, 0, i, szBuffer);

				//TYPE (subitem)
				ConvertToMBCS(GetDBTypeName(pColInfo->wType), szBuffer, MAX_NAME_LEN);
				LV_InsertItem(hWndCol, 1, i, szBuffer);
				
				//ColumnSize (SubItem)
				sprintf(szBuffer, "%d", pColInfo->ulColumnSize);
				LV_InsertItem(hWndCol, 2, i, szBuffer);

				//Precision (SubItem)
				sprintf(szBuffer, "%d", pColInfo->bPrecision);
				LV_InsertItem(hWndCol, 3, i, szBuffer);

				//Scale (SubItem)
				sprintf(szBuffer, "%d", pColInfo->bScale);
				LV_InsertItem(hWndCol, 4, i, szBuffer);
				
				//TypeInfo (SubItem)
				sprintf(szBuffer, "0x%08x", pColInfo->pTypeInfo);
				LV_InsertItem(hWndCol, 5, i, szBuffer);

				//ColumnID (SubItem)  DBID
				DBIDToString(&pColInfo->columnid, wszBuffer, MAX_NAME_LEN);
				ConvertToMBCS(wszBuffer, szBuffer, MAX_NAME_LEN);
				LV_InsertItem(hWndCol, 6, i, szBuffer);

				//dwFlags
				sprintf(szBuffer, "0x%08x", pColInfo->dwFlags);
				LV_InsertItem(hWndCol, 7, i, szBuffer);

				//FLAGS (SubItem)
				LV_InsertItem(hWndCol, 8,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_CACHEDEFERRED	? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 9,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISBOOKMARK		? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 10,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISFIXEDLENGTH	? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 11,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISLONG			? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 12,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISNULLABLE		? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 13,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISROWID			? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 14,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISROWVER			? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 15,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_MAYBENULL		? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 16,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_MAYDEFER			? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 17,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_WRITE			? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 18,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_WRITEUNKNOWN		? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 19,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_ISCHAPTER		? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 20,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_SCALEISNEGATIVE	? STATE_CHECKED : STATE_UNCHECKED);
				LV_InsertItem(hWndCol, 21,	i, NULL, PARAM_NONE, pColInfo->dwFlags & DBCOLUMNFLAGS_KEYCOLUMN		? STATE_CHECKED : STATE_UNCHECKED);
			}

			//AutoSize all columns
			for(i=0; i<cColumns; i++)
				SendMessage(hWndCol, LVM_SETCOLUMNWIDTH, (WPARAM)i,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
						
		CLEANUP:
			Busy(OFF);
			CenterDialog(hWnd);
			SAFE_FREE(rgColInfo);
			SAFE_FREE(pStringBuffer);
			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			//ListView
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
					return 0;

				case LVN_ITEMCHANGED:
				{
					HWND hWndName  = GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndCol   = GetDlgItem(hWnd, IDL_VALUES);

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_VALUES)
						{
							SyncSibling(hWndName, hWndCol);
	           				return FALSE;
						}

						if(wParam == IDL_NAMES)
						{
							SyncSibling(hWndCol, hWndName);
	                		return FALSE;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}


		}//WM_NOTIFY
	}//switch message

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetNextRowsProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetNextRowsProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG s_lOffset	= 0;	//Default to lOffset==0
	static LONG s_cRows		= 1;	//Default to cRows==1
	
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			HRESULT hr = S_OK;

			//Setup Window Handles
			HWND hWndOffset		= GetDlgItem(hWnd, IDE_OFFSET);
			HWND hWndcRows		= GetDlgItem(hWnd, IDE_CROWS);
			HWND hWndSpinOffset	= GetDlgItem(hWnd, IDC_SPIN_OFFSET);
			HWND hWndSpincRows	= GetDlgItem(hWnd, IDC_SPIN_CROWS);
			
			//Supply Defaults to the lOffset and cRows
			SendMessageFmt(hWndOffset, WM_SETTEXT, 0, "%d", s_lOffset);
			SendMessageFmt(hWndcRows, WM_SETTEXT, 0, "%d", s_cRows);

			CenterDialog(hWnd);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HRESULT hr = S_OK;

					//Setup Window Handles
					HWND hWndOffset		= GetDlgItem(hWnd, IDE_OFFSET);
					HWND hWndcRows		= GetDlgItem(hWnd, IDE_CROWS);
					HWND hWndSpinOffset	= GetDlgItem(hWnd, IDC_SPIN_OFFSET);
					HWND hWndSpincRows	= GetDlgItem(hWnd, IDC_SPIN_CROWS);
					
					//Obtain Defaults to the lOffset and cRows
					GetEditBoxValue(hWndOffset, LONG_MIN, LONG_MAX, &s_lOffset, FALSE);
					GetEditBoxValue(hWndcRows, LONG_MIN, LONG_MAX, &s_cRows, FALSE);

					//Display the indicated rows
					TESTC(hr = pThis->DisplayRows(s_lOffset, s_cRows));

				CLEANUP:
					if(SUCCEEDED(hr))
						EndDialog(hWnd, TRUE);
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_NOTIFY:
		{
			NM_UPDOWN* pUpDown = (NM_UPDOWN*)lParam;
			
			//lOffset
			if(pUpDown->hdr.idFrom == IDC_SPIN_OFFSET)
			{
				s_lOffset += pUpDown->iDelta;
				SendMessageFmt(GetDlgItem(hWnd, IDE_OFFSET), WM_SETTEXT, 0, "%d", s_lOffset);
			}

			//cRows
			if(pUpDown->hdr.idFrom == IDC_SPIN_CROWS)
			{
				s_cRows += pUpDown->iDelta;
				SendMessageFmt(GetDlgItem(hWnd, IDE_CROWS), WM_SETTEXT, 0, "%d", s_cRows);
			}

			break;
		}//WM_NOTIFY
	}//switch message

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetBindingsProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetBindingsProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN

			Busy();
			CHAR szBuffer[MAX_NAME_LEN+1];

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CCommand* pCCommand = pCRowset->m_pCCommand;
			HRESULT hr = S_OK;

			ULONG i,cBindings = 0;
			DBBINDING* rgBindings = NULL;
			DBACCESSORFLAGS dwAccessorFlags = 0;
			HACCESSOR hAccessor = NULL;
			IAccessor* pIAccessor = NULL;

			//Setup column headers
			HWND hWndName		= GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndValue		= GetDlgItem(hWnd, IDL_VALUES);
			HWND hWndHelp		= GetDlgItem(hWnd, IDT_HELPMSG);
			
			//Set Window Titles
			SendMessage(hWnd,		WM_SETTEXT, 0, (LPARAM)"IAccessor::GetBindings");
			SendMessage(hWndHelp,	WM_SETTEXT, 0, (LPARAM)"Displays the rgBindings from the Accessor");

			//Create the Col ImageList
			HIMAGELIST hColImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );

			//IDI_ROWNORMAL - for row icon
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_ROW_NORMAL));
			ImageList_AddIcon(hColImageList, hIcon);
			//IDI_READONLY - for "false" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));
			ImageList_AddIcon(hColImageList, hIcon);
			//Set image list to the Window 
			ListView_SetImageList(hWndValue, hColImageList, LVSIL_SMALL);

			//Obtain IAccessor
			if(pThis->m_eSource == ROWSET)
			{
				//From rowset if we have a rowset
				pIAccessor = pCRowset->m_pIAccessor;
				hAccessor = pCRowset->m_hAccessor;
			}
			else 
			{
				//From Command if we have a command
				pIAccessor = pCCommand->m_pIAccessor;
				hAccessor = pCRowset->m_hAccessor;
			}
			
			//Now IAccessor::GetBindings
			ASSERT(pIAccessor);
			TESTC(pCListBox->OutputPreMethod("IAccessor::GetBindings(0x%08x, &%d, &%d, &0x%08x)", hAccessor, dwAccessorFlags, cBindings, rgBindings));
			XTEST(hWnd, hr = pIAccessor->GetBindings(hAccessor, &dwAccessorFlags, &cBindings, &rgBindings));
			TESTC(pCListBox->OutputPostMethod(hr, "IAccessor::GetBindings(0x%08x, &%d, &%d, &0x%08x)", hAccessor, dwAccessorFlags, cBindings, rgBindings));

			//We need to the ListView
			//Headers/Columns contain ColInfo information 
			//Rows are per columns
			
			//Use Extended ListView Styles!
			SendMessage(hWndName,	LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndValue,LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//ListView Columns
			LV_InsertColumn(hWndName,	0,		"ColName");
			LV_InsertItem(hWndName,		0,		0,	"Ordinal");
			LV_InsertItem(hWndName,		1,		0,	"obValue");
			LV_InsertItem(hWndName,		2,		0,	"obLength");
			LV_InsertItem(hWndName,		3,		0, 	"obStatus");
			LV_InsertItem(hWndName,		4,		0,	"pTypeInfo");
			LV_InsertItem(hWndName,		5,		0,	"pObject");
			LV_InsertItem(hWndName,		6,		0,	"pBindExt");
			LV_InsertItem(hWndName,		7,		0,	"dwPart");
			LV_InsertItem(hWndName,		8,		0,	"dwMemOwner");
			LV_InsertItem(hWndName,		9,		0,	"eParamIO");
			LV_InsertItem(hWndName,		10,		0,	"cbMaxLen");
			LV_InsertItem(hWndName,		11,		0,	"dwFlags");
			LV_InsertItem(hWndName,		12,		0,	"wType");
			LV_InsertItem(hWndName,		13,		0,	"bPrecision");
			LV_InsertItem(hWndName,		14,		0,	"bScale");
			
			//AutoSize column
			SendMessage(hWndName, LVM_SETCOLUMNWIDTH, 0,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);

			for(i=0; i<cBindings; i++)
			{	
				ASSERT(rgBindings);
				DBBINDING* pBinding = &rgBindings[i];
				DBCOLUMNINFO* pColInfo = pCRowset->GetColInfo(pBinding->iOrdinal);

				//Column Header
				ConvertToMBCS(pCRowset->GetColName(pColInfo->iOrdinal), szBuffer, MAX_NAME_LEN);
				LV_InsertColumn(hWndValue, i, szBuffer, GetColumnImage(pColInfo)==IMAGE_READONLY ? IMAGE_READONLY : IMAGE_NONE);

				//Ordinal (SubItem)
				sprintf(szBuffer, "%d", pBinding->iOrdinal);
				LV_InsertItem(hWndValue, 0, i, szBuffer);

				//obValue (SubItem)
				sprintf(szBuffer, "%d", pBinding->obValue);
				LV_InsertItem(hWndValue, 1, i, szBuffer);

				//obLength (SubItem)
				sprintf(szBuffer, "%d", pBinding->obLength);
				LV_InsertItem(hWndValue, 2, i, szBuffer);
				
				//obStatus (SubItem)
				sprintf(szBuffer, "%d", pBinding->obStatus);
				LV_InsertItem(hWndValue, 3, i, szBuffer);
				
				//pTypeInfo (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->pTypeInfo);
				LV_InsertItem(hWndValue, 4, i, szBuffer);

				//pObject (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->pObject);
				LV_InsertItem(hWndValue, 5, i, szBuffer);

				//pBindExt (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->pBindExt);
				LV_InsertItem(hWndValue, 6, i, szBuffer);

				//dwPart (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->dwPart);
				LV_InsertItem(hWndValue, 7, i, szBuffer);

				//dwMemOwner (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->dwMemOwner);
				LV_InsertItem(hWndValue, 8, i, szBuffer);

				//eParamIO (SubItem)
				sprintf(szBuffer, "%d", pBinding->eParamIO);
				LV_InsertItem(hWndValue, 9, i, szBuffer);

				//cbMaxLen (SubItem)
				sprintf(szBuffer, "%d", pBinding->cbMaxLen);
				LV_InsertItem(hWndValue, 10, i, szBuffer);

				//dwFlags (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->dwFlags);
				LV_InsertItem(hWndValue, 11, i, szBuffer);

				//TYPE (subitem)
				ConvertToMBCS(GetDBTypeName(pBinding->wType), szBuffer, MAX_NAME_LEN);
				LV_InsertItem(hWndValue, 12, i, szBuffer);
				
				//Precision (SubItem)
				sprintf(szBuffer, "%d", pBinding->bPrecision);
				LV_InsertItem(hWndValue, 13, i, szBuffer);

				//Scale (SubItem)
				sprintf(szBuffer, "%d", pBinding->bScale);
				LV_InsertItem(hWndValue, 14, i, szBuffer);
			}

			//AutoSize all columns
			for(i=0; i<cBindings; i++)
				SendMessage(hWndValue, LVM_SETCOLUMNWIDTH, (WPARAM)i,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
						
		CLEANUP:
			Busy(OFF);
			CenterDialog(hWnd);
			SAFE_FREE(rgBindings);
			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			//ListView
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
					return 0;

				case LVN_ITEMCHANGED:
				{
					HWND hWndName		= GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndValue	= GetDlgItem(hWnd, IDL_VALUES);

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_VALUES)
						{
							SyncSibling(hWndName, hWndValue);
	           				return FALSE;
						}

						if(wParam == IDL_NAMES)
						{
							SyncSibling(hWndValue, hWndName);
	                		return FALSE;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}


		}//WM_NOTIFY
	}//switch message

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CreateAccessorProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::CreateAccessorProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//Bindings
	static ULONG cBindings = 0;
	static DBBINDING* rgBindings = NULL;
	static ULONG cRowSize = 0;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN

			Busy();
			CHAR szBuffer[MAX_NAME_LEN+1];

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CCommand* pCCommand = pCRowset->m_pCCommand;
			HRESULT hr = S_OK;

			ULONG i = 0;
			BOOL fBindBookmark = pThis->GetOptionsObj()->m_dwRowsetOpts & ROWSET_BINDBOOKMARK;

			//Setup column headers
			HWND hWndValue	= GetDlgItem(hWnd, IDL_COLUMNS);
			//Use Extended ListView Styles!
			SendMessage(hWndValue, LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES | LVS_EX_CHECKBOXES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES | LVS_EX_CHECKBOXES);
			
			//Create the Col ImageList
			HIMAGELIST hColImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );
			HIMAGELIST hCheckImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );

			//IDI_ROWNORMAL - for row icon
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_NORMAL));
			ImageList_AddIcon(hColImageList, hIcon);
			//IDI_READONLY - for "false" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));
			ImageList_AddIcon(hColImageList, hIcon);

			//IDI_CHECK - normal checked icon
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_CHECK));
			ImageList_AddIcon(hCheckImageList, hIcon);
			//IDI_UNCHECK - normal unchecked icon
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_UNCHECK));
			ImageList_AddIcon(hCheckImageList, hIcon);
			
			//Set image list to the Window 
			ListView_SetImageList(hWndValue, hColImageList, LVSIL_SMALL);
			ListView_SetImageList(hWndValue, hCheckImageList, LVSIL_STATE);

			//Obtain IAccessor
			if(pThis->m_eSource == ROWSET)
			{
				//Setup Bindings
				pCRowset->GetColInfo();
				pCRowset->SetupBindings(BIND_ALLCOLS, &cBindings, &rgBindings, &cRowSize, NULL); 
			}
			else 
			{
				//Setup Bindings
				pCRowset->GetColInfo(pCCommand->m_pIColumnsInfo);
				pCRowset->SetupBindings(BIND_ALLCOLS, &cBindings, &rgBindings, &cRowSize, NULL); 
			}
			
			//We need to the ListView
			//Headers/Columns contain ColInfo information 
			//Rows are per columns
			
			//ListView Columns
			LV_InsertColumn(hWndValue,		0,		"ColName");
			LV_InsertColumn(hWndValue,		1,		"Ordinal");
			LV_InsertColumn(hWndValue,		2,		"obValue");
			LV_InsertColumn(hWndValue,		3,		"obLength");
			LV_InsertColumn(hWndValue,		4,		"obStatus");
			LV_InsertColumn(hWndValue,		5,		"pTypeInfo");
			LV_InsertColumn(hWndValue,		6,		"pObject");
			LV_InsertColumn(hWndValue,		7,		"pBindExt");
			LV_InsertColumn(hWndValue,		8,		"dwPart");
			LV_InsertColumn(hWndValue,		9,		"dwMemOwner");
			LV_InsertColumn(hWndValue,		10,		"eParamIO");
			LV_InsertColumn(hWndValue,		11,		"cbMaxLen");
			LV_InsertColumn(hWndValue,		12,		"dwFlags");
			LV_InsertColumn(hWndValue,		13,		"wType");
			LV_InsertColumn(hWndValue,		14,		"bPrecision");
			LV_InsertColumn(hWndValue,		15,		"bScale");
			
			for(i=0; i<cBindings; i++)
			{	
				ASSERT(rgBindings);
				DBBINDING* pBinding = &rgBindings[i];
				DBCOLUMNINFO* pColInfo = pCRowset->GetColInfo(pBinding->iOrdinal);

				//Column Header
				ConvertToMBCS(pCRowset->GetColName(pColInfo->iOrdinal), szBuffer, MAX_NAME_LEN);
				LV_InsertItem(hWndValue, i, 0, szBuffer, PARAM_NONE, GetColumnImage(pColInfo)==IMAGE_READONLY ? IMAGE_READONLY : IMAGE_NONE);

				//Ordinal (SubItem)
				sprintf(szBuffer, "%d", pBinding->iOrdinal);
				LV_InsertItem(hWndValue, i, 1, szBuffer);

				//obValue (SubItem)
				sprintf(szBuffer, "%d", pBinding->obValue);
				LV_InsertItem(hWndValue, i, 2, szBuffer);

				//obLength (SubItem)
				sprintf(szBuffer, "%d", pBinding->obLength);
				LV_InsertItem(hWndValue, i, 3, szBuffer);
				
				//obStatus (SubItem)
				sprintf(szBuffer, "%d", pBinding->obStatus);
				LV_InsertItem(hWndValue, i, 4, szBuffer);
				
				//pTypeInfo (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->pTypeInfo);
				LV_InsertItem(hWndValue, i, 5, szBuffer);

				//pObject (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->pObject);
				LV_InsertItem(hWndValue, i, 6, szBuffer);

				//pBindExt (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->pBindExt);
				LV_InsertItem(hWndValue, i, 7, szBuffer);

				//dwPart (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->dwPart);
				LV_InsertItem(hWndValue, i, 8, szBuffer);

				//dwMemOwner (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->dwMemOwner);
				LV_InsertItem(hWndValue, i, 9, szBuffer);

				//eParamIO (SubItem)
				sprintf(szBuffer, "%d", pBinding->eParamIO);
				LV_InsertItem(hWndValue, i, 10, szBuffer);

				//cbMaxLen (SubItem)
				sprintf(szBuffer, "%d", pBinding->cbMaxLen);
				LV_InsertItem(hWndValue, i, 11, szBuffer);

				//dwFlags (SubItem)
				sprintf(szBuffer, "0x%08x", pBinding->dwFlags);
				LV_InsertItem(hWndValue, i, 12, szBuffer);

				//TYPE (subitem)
				ConvertToMBCS(GetDBTypeName(pBinding->wType), szBuffer, MAX_NAME_LEN);
				LV_InsertItem(hWndValue, i, 13, szBuffer);
				
				//Precision (SubItem)
				sprintf(szBuffer, "%d", pBinding->bPrecision);
				LV_InsertItem(hWndValue, i, 14, szBuffer);

				//Scale (SubItem)
				sprintf(szBuffer, "%d", pBinding->bScale);
				LV_InsertItem(hWndValue, i, 15, szBuffer);

				//Default to unchecked
				LV_SetItemState(hWndValue, i, 0,  INDEXTOSTATEIMAGEMASK(STATE_UNCHECKED),  LVIS_STATEIMAGEMASK);
			}


			//Go through and check the existing columns, that are in our current bindings
			for(i=0; i<pCRowset->m_cBindings; i++)
			{
				ULONG iOrdinal = pCRowset->m_rgBindings[i].iOrdinal;
				ULONG iIndex = (iOrdinal && !pCRowset->m_fContainsBmk) ? iOrdinal-1 : iOrdinal;
				LV_SetItemState(hWndValue, iIndex, 0,  INDEXTOSTATEIMAGEMASK(STATE_CHECKED),  LVIS_STATEIMAGEMASK);
			}

			//AutoSize columns (column headers);
			for(i=0; i<=15; i++)
				SendMessage(hWndValue, LVM_SETCOLUMNWIDTH, i, (LPARAM)LVSCW_AUTOSIZE_USEHEADER);

			Busy(OFF);
			CenterDialog(hWnd);
			
			if(FAILED(hr))
			{
				//Free Bindings
				FreeBindings(&cBindings, &rgBindings);
				EndDialog(hWnd, FALSE);
			}

			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CCommand* pCCommand = pCRowset->m_pCCommand;

					ULONG cSelBindings = 0;
					DBBINDING* rgSelBindings = NULL;
					HWND hWndValue	= GetDlgItem(hWnd, IDL_COLUMNS);
					HACCESSOR hAccessor = NULL;
					DBACCESSORFLAGS dwAccessorFlags = DBACCESSOR_ROWDATA;

					LONG i=0;
					HRESULT hr = S_OK;

					//Now that the user has selected all the columns they wish to 
					//have in the Accessor, we need to loop through all the 
					//checked columns and add them to our list...
					LONG iItems = SendMessage(hWndValue, LVM_GETITEMCOUNT, 0, 0);
					SAFE_ALLOC(rgSelBindings, DBBINDING, iItems);
					
					for(i=0; i<iItems; i++)
					{
						ASSERT(cBindings);
						ASSERT(rgBindings);

						//Get the Image
						BOOL bChecked = LV_GetItemState(hWndValue, i, LVIS_STATEIMAGEMASK) & INDEXTOSTATEIMAGEMASK(STATE_CHECKED);

						//Only interested in checked items
						if(!bChecked)
							continue;

						//Mark this Ordinal as checked
					 	memcpy(&rgSelBindings[cSelBindings], &rgBindings[i], sizeof(DBBINDING));
						cSelBindings++;
					}

					//Now that we have the columns, Create the Accessor
					if(pThis->m_eSource == ROWSET)
					{
						hr = pCRowset->CreateAccessor(dwAccessorFlags, cSelBindings, rgSelBindings, 0, &hAccessor);
					}
					else
					{
						hr = pCCommand->CreateAccessor(dwAccessorFlags, cSelBindings, rgSelBindings, 0, &hAccessor);
					}

					//Free Bindings
					FreeBindings(&cBindings, &rgBindings);
					
					if(SUCCEEDED(hr))
					{
						//Release Previous Accessor
						if(pThis->m_eSource == ROWSET)
							pCRowset->ReleaseAccessor(&pCRowset->m_hAccessor);
						else
							pCCommand->ReleaseAccessor(&pCRowset->m_hAccessor);
						
						//FreeBindings
						FreeBindings(&pCRowset->m_cBindings, &pCRowset->m_rgBindings);
						
						//Use the new Bindings
						pCRowset->m_hAccessor = hAccessor;
						pCRowset->m_cBindings = cSelBindings;
						pCRowset->m_rgBindings = rgSelBindings;

						//Now actually refetch the Data with the new Accessor
						if(pThis->m_eSource == ROWSET)
						{
							hr = pThis->RestartPosition();
							hr = pThis->RefreshData();
						}

						EndDialog(hWnd, TRUE);
						return 0;
					}
				
				CLEANUP:
					//Free Bindings
					FreeBindings(&cBindings, &rgBindings);
					FreeBindings(&cSelBindings, &rgSelBindings);
					return 0;
				}

				case IDCANCEL:
				{
					//Free Bindings
					FreeBindings(&cBindings, &rgBindings);
					EndDialog(hWnd, FALSE);
					return 0;
				}
				
				case IDB_SELECTALL:
				{
					//Get the "this" pointer
					CPropDlg* pThis = (CPropDlg*)GetThis(hWnd);
					HRESULT hr = S_OK;

					HWND hWndValue  = GetDlgItem(hWnd, IDL_COLUMNS);

					//Now that the user has selected to select all columns
					//We need to loop through all the unchecked and check them...
					LONG iItems = SendMessage(hWndValue, LVM_GETITEMCOUNT, 0, 0);
					for(LONG i=0; i<iItems; i++)
					{
						//Get the Image and Param
						BOOL bChecked = LV_GetItemState(hWndValue, i, LVIS_STATEIMAGEMASK) & INDEXTOSTATEIMAGEMASK(STATE_CHECKED);

						//Check the property state
						if(!bChecked)
							LV_SetItemState(hWndValue, i, 0,  INDEXTOSTATEIMAGEMASK(STATE_CHECKED),  LVIS_STATEIMAGEMASK);
					}

					return 0;
				}

				case IDB_UNSELECTALL:
				{
					//Get the "this" pointer
					CPropDlg* pThis = (CPropDlg*)GetThis(hWnd);
					HRESULT hr = S_OK;

					HWND hWndValue  = GetDlgItem(hWnd, IDL_COLUMNS);

					//Now that the user has selected to clear all columns
					//We need to loop through all the checked and uncheck them...
					LONG iItems = SendMessage(hWndValue, LVM_GETITEMCOUNT, 0, 0);
					for(LONG i=0; i<iItems; i++)
					{
						//Get the Image and Param
						BOOL bChecked = LV_GetItemState(hWndValue, i, LVIS_STATEIMAGEMASK) & INDEXTOSTATEIMAGEMASK(STATE_CHECKED);

						//Uncheck the property state
						if(bChecked)
							LV_SetItemState(hWndValue, i, 0,  INDEXTOSTATEIMAGEMASK(STATE_UNCHECKED),  LVIS_STATEIMAGEMASK);
					}

					return 0;
				}
			}
			break;
		}//WM_COMMAND

	}//switch message

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::SetParameterInfoProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::SetParameterInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedType	= CB_ERR;
	static LONG iSavedFlags = CB_ERR;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CCommand* pCCommand = pCRowset->m_pCCommand;
			LONG iSel = 0;
			HRESULT hr = S_OK;

			//Controls
			HWND hWndOrdinal	= GetDlgItem(hWnd, IDE_ORDINAL);
			HWND hWndParamName	= GetDlgItem(hWnd, IDE_NAME);
			HWND hWndFlags		= GetDlgItem(hWnd, IDC_FLAGS);
			HWND hWndTypes		= GetDlgItem(hWnd, IDC_TYPE);
			HWND hWndSize		= GetDlgItem(hWnd, IDE_SIZE);
			HWND hWndPrecision	= GetDlgItem(hWnd, IDE_PRECISION);
			HWND hWndScale		= GetDlgItem(hWnd, IDE_SCALE);
			
			//Set Ordinal
			SendMessage(hWndOrdinal, WM_SETTEXT, 0, (LPARAM)"1");
			//Set Parameter Name		
			SendMessage(hWndParamName, WM_SETTEXT, 0, (LPARAM)"Parameter1");
		
			//Fill-in Type Combo with DBTypes
			for(ULONG i=0; i<g_cDBTypes; i++)
				wSendMessage(hWndTypes, CB_ADDSTRING, 0, g_rgDBTypes[i].pwszName);
			
			//Add Extra Standard Type Names (defined in SetParameterInfo)
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_CHAR");
			iSel = SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_VARCHAR");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_LONGVARCHAR");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_WCHAR");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_WVARCHAR");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_WLONGVARCHAR");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_BINARY");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_VARBINARY");
			SendMessage(hWndTypes, CB_ADDSTRING, 0, (LPARAM)"DBTYPE_LONGVARBINARY");
			
			//Set current Selection
			iSavedType = SendMessage(hWndTypes, CB_SETCURSEL, iSavedType!=CB_ERR ? iSavedType : iSel, 0);

			const static NAMEMAP g_rgParamFlags[] = 
			{
				VALUE_CHAR(DBPARAMFLAGS_ISINPUT),
				VALUE_CHAR(DBPARAMFLAGS_ISOUTPUT),
				VALUE_CHAR(DBPARAMFLAGS_ISSIGNED),
				VALUE_CHAR(DBPARAMFLAGS_ISNULLABLE),
				VALUE_CHAR(DBPARAMFLAGS_ISLONG),
				VALUE_CHAR(DBPARAMFLAGS_SCALEISNEGATIVE),
			};
			const static ULONG g_cParamFlags = NUMELE(g_rgParamFlags);

			//Fill-in Flags Combo
			for(i=0; i<g_cParamFlags; i++)
			{
				iSel = SendMessage(hWndFlags, CB_ADDSTRING, 0, (LPARAM)g_rgParamFlags[i].pszName);
				SendMessage(hWndFlags, CB_SETITEMDATA, iSel, (LPARAM)g_rgParamFlags[i].lItem);
			}
			iSavedFlags = SendMessage(hWndFlags, CB_SETCURSEL, iSavedFlags!=CB_ERR ? iSavedFlags : 0, 0);
			
			//Send a selection change to the ComboBox so it updates everything
			//Size, Precision, and Scale
			SendMessage(hWnd, WM_COMMAND, GET_WM_COMMAND_MPS(IDC_TYPE, hWnd, LBN_SELCHANGE));

			Busy(OFF);
			CenterDialog(hWnd);
			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			//LBN_SELCHANGE ListBox Selection change
			switch(GET_WM_COMMAND_CMD(wParam, lParam))
			{
				//Selection change in a list box occurred
				case LBN_SELCHANGE:
				{	
					//See which combo box has changed
					switch(GET_WM_COMMAND_ID(wParam, lParam))
					{
						case IDC_TYPE:
						{
							WCHAR wszBuffer[MAX_NAME_LEN+1];
							HWND hWndTypes		= GetDlgItem(hWnd, IDC_TYPE);
							HWND hWndSize		= GetDlgItem(hWnd, IDE_SIZE);
							HWND hWndPrecision	= GetDlgItem(hWnd, IDE_PRECISION);
							HWND hWndScale		= GetDlgItem(hWnd, IDE_SCALE);

							//Get the Selected Type
							CB_GetSelectedText(hWndTypes, wszBuffer, MAX_NAME_LEN);
							DBTYPE wType = GetDBType(wszBuffer);

							//Get Default Size,Prec,Scale for this type...
							ULONG ulMaxSize;
							BYTE  bPrecision, bScale;
							GetDBTypeMaxSize(wType, &ulMaxSize, &bPrecision, &bScale);

							//Set Size
							SendMessageFmt(hWndSize,		WM_SETTEXT, 0, "%d", ulMaxSize!=0 ? ulMaxSize : 255);
							//Set Precision
							SendMessageFmt(hWndPrecision,	WM_SETTEXT, 0, "%d", bPrecision);
							//Set Scale
							SendMessageFmt(hWndScale,		WM_SETTEXT, 0, "%d", bScale);
							return 0;
						}
					}
					break;
				}
			
				return FALSE;
			}
							
			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CCommand* pCCommand = pCRowset->m_pCCommand;
					WCHAR wszNameBuffer[MAX_NAME_LEN];
					WCHAR wszTypeBuffer[MAX_NAME_LEN];
					HRESULT hr = S_OK;

					//Controls
					HWND hWndOrdinal	= GetDlgItem(hWnd, IDE_ORDINAL);
					HWND hWndParamName	= GetDlgItem(hWnd, IDE_NAME);
					HWND hWndFlags		= GetDlgItem(hWnd, IDC_FLAGS);
					HWND hWndTypes		= GetDlgItem(hWnd, IDC_TYPE);
					HWND hWndSize		= GetDlgItem(hWnd, IDE_SIZE);
					HWND hWndPrecision	= GetDlgItem(hWnd, IDE_PRECISION);
					HWND hWndScale		= GetDlgItem(hWnd, IDE_SCALE);
			
					LONG lValue = 0;
					ULONG cParams = 0;
					ULONG* rgParamOrdinals = NULL;
					DBPARAMBINDINFO* rgParamBindInfo = NULL;

					//Alloc Params
					cParams = 1;
					ULONG ulParamOrdinal = 0;
					DBPARAMBINDINFO dbParamBindInfo;

					//Setup ParamBindInfo
					wSendMessage(hWndParamName, WM_GETTEXT, MAX_NAME_LEN, wszNameBuffer);
					dbParamBindInfo.pwszName = wszNameBuffer;
					
					GetEditBoxValue(hWndOrdinal,	0, LONG_MAX, &lValue);
					ulParamOrdinal = (ULONG)lValue;

					GetEditBoxValue(hWndSize,		0, LONG_MAX, &lValue);
					dbParamBindInfo.ulParamSize = (ULONG)lValue;
						
					GetEditBoxValue(hWndPrecision,	0, UCHAR_MAX, &lValue);
					dbParamBindInfo.bPrecision = (BYTE)lValue;
					
					GetEditBoxValue(hWndScale,		0, UCHAR_MAX, &lValue);
					dbParamBindInfo.bScale = (BYTE)lValue;

					//Get Type
					iSavedType = CB_GetSelectedText(hWndTypes, wszTypeBuffer, MAX_NAME_LEN);
					dbParamBindInfo.pwszDataSourceType = wszTypeBuffer;

					//Get Flags
					iSavedFlags = SendMessage(hWndFlags, CB_GETCURSEL, 0, 0);
					dbParamBindInfo.dwFlags = (ULONG)SendMessage(hWndFlags, CB_GETITEMDATA, iSavedFlags, 0);

					//SetParameterInfo
					ASSERT(pCCommand->m_pICommandWithParameters);
					TESTC(pCListBox->OutputPreMethod("ICommandWithParameters::SetParameterInfo(%d, &%d, 0x%08x)", cParams, ulParamOrdinal, &dbParamBindInfo));
					XTEST(hWnd, hr = pCCommand->m_pICommandWithParameters->SetParameterInfo(cParams, &ulParamOrdinal, &dbParamBindInfo));
					TESTC(pCListBox->OutputPostMethod(hr, "ICommandWithParameters::SetParameterInfo(%d, &%d, 0x%08x)", cParams, ulParamOrdinal, &dbParamBindInfo));
									
				CLEANUP:
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

	}//switch message

	return FALSE;
}



////////////////////////////////////////////////////////////////
// CMDIChild::GetParameterInfoProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetParameterInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN

			Busy();
			CHAR szBuffer[MAX_NAME_LEN+1];

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CCommand* pCCommand = pCRowset->m_pCCommand;
			HRESULT hr = S_OK;

			ULONG i,cParams = 0;
			DBPARAMINFO* rgParamInfo = NULL;
			WCHAR* pwszNamesBuffer = NULL;

			//Setup column headers
			HWND hWndName		= GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndValue		= GetDlgItem(hWnd, IDL_VALUES);
			HWND hWndHelp		= GetDlgItem(hWnd, IDT_HELPMSG);
			
			//Set Window Titles
			SendMessage(hWnd,		WM_SETTEXT, 0, (LPARAM)"ICommandWithParameters::GetParameterInfo");
			SendMessage(hWndHelp,	WM_SETTEXT, 0, (LPARAM)"ParameterInfo");

			//Create the Col ImageList
			HIMAGELIST hColImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );

			//IDI_ROWNORMAL - for row icon
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_ROW_NORMAL));
			ImageList_AddIcon(hColImageList, hIcon);
			//IDI_READONLY - for "false" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_READONLY));
			ImageList_AddIcon(hColImageList, hIcon);
			//Set image list to the Window 
			ListView_SetImageList(hWndValue, hColImageList, LVSIL_SMALL);

			//Now ICommandWithParameters::GetParameterInfo
			TESTC(pCListBox->OutputPreMethod("ICommandWithParameters::GetParameterInfo(&%d, &0x%08x, &0x%08x)", cParams, rgParamInfo, pwszNamesBuffer));
			XTEST(hWnd, hr = pCCommand->m_pICommandWithParameters->GetParameterInfo(&cParams, &rgParamInfo, &pwszNamesBuffer));
			TESTC(pCListBox->OutputPostMethod(hr, "ICommandWithParameters::GetParameterInfo(&%d, &0x%08x, &0x%08x)", cParams, rgParamInfo, pwszNamesBuffer));

			//We need to the ListView
			//Headers/Columns contain ColInfo information 
			//Rows are per columns
			
			//Use Extended ListView Styles!
			SendMessage(hWndName,	LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndValue,	LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//ListView Columns
			LV_InsertColumn(hWndName,	0,		"ParamName");
			LV_InsertItem(hWndName,		0,		0,	"Ordinal");
			LV_InsertItem(hWndName,		1,		0,	"dwFlags");
			LV_InsertItem(hWndName,		2,		0,	"pTypeInfo");
			LV_InsertItem(hWndName,		3,		0,	"wType");
			LV_InsertItem(hWndName,		4,		0, 	"ulParamSize");
			LV_InsertItem(hWndName,		5,		0,	"bPrecision");
			LV_InsertItem(hWndName,		6,		0,	"bScale");
			
			//AutoSize column
			SendMessage(hWndName, LVM_SETCOLUMNWIDTH, 0,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);

			for(i=0; i<cParams; i++)
			{	
				ASSERT(rgParamInfo);
				DBPARAMINFO* pParamInfo = &rgParamInfo[i];

				//Column Header
				ConvertToMBCS(pParamInfo->pwszName, szBuffer, MAX_NAME_LEN);
				LV_InsertColumn(hWndValue, i, szBuffer, IMAGE_NONE);

				//Ordinal (SubItem)
				sprintf(szBuffer, "%d", pParamInfo->iOrdinal);
				LV_InsertItem(hWndValue, 0, i, szBuffer);

				//dwFlags (SubItem)
				sprintf(szBuffer, "0x%08x", pParamInfo->dwFlags);
				LV_InsertItem(hWndValue, 1, i, szBuffer);

				//pTypeInfo (SubItem)
				sprintf(szBuffer, "0x%08x", pParamInfo->pTypeInfo);
				LV_InsertItem(hWndValue, 2, i, szBuffer);
				
				//TYPE (subitem)
				ConvertToMBCS(GetDBTypeName(pParamInfo->wType), szBuffer, MAX_NAME_LEN);
				LV_InsertItem(hWndValue, 3, i, szBuffer);

				//ulParamSize (SubItem)
				sprintf(szBuffer, "%d", pParamInfo->ulParamSize);
				LV_InsertItem(hWndValue, 4, i, szBuffer);
				
				//Precision (SubItem)
				sprintf(szBuffer, "%d", pParamInfo->bPrecision);
				LV_InsertItem(hWndValue, 5, i, szBuffer);

				//Scale (SubItem)
				sprintf(szBuffer, "%d", pParamInfo->bScale);
				LV_InsertItem(hWndValue, 6, i, szBuffer);
			}

			//AutoSize all columns
			for(i=0; i<cParams; i++)
				SendMessage(hWndValue, LVM_SETCOLUMNWIDTH, (WPARAM)i,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
						
		CLEANUP:
			Busy(OFF);
			CenterDialog(hWnd);
			SAFE_FREE(rgParamInfo);
			SAFE_FREE(pwszNamesBuffer);
			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			//ListView
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
					return 0;

				case LVN_ITEMCHANGED:
				{
					HWND hWndName		= GetDlgItem(hWnd, IDL_NAMES);
					HWND hWndValue	= GetDlgItem(hWnd, IDL_VALUES);

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_VALUES)
						{
							SyncSibling(hWndName, hWndValue);
	           				return FALSE;
						}

						if(wParam == IDL_NAMES)
						{
							SyncSibling(hWndValue, hWndName);
	                		return FALSE;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}


		}//WM_NOTIFY
	}//switch message

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ParamExecuteProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::ParamExecuteProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static BOOL bBeginEdit = FALSE;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			bBeginEdit = FALSE;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CCommand* pCCommand = pCRowset->m_pCCommand;
			HRESULT hr = S_OK;

			//Setup column headers
			HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
			HWND hWndValues		= GetDlgItem(hWnd, IDL_PARAMVALUES);
			
			//Create the Col ImageList
			HIMAGELIST hColImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );

			//IDI_ROWNORMAL - for row icon
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_ROW_NORMAL));
			ImageList_AddIcon(hColImageList, hIcon);
			//Set image list to the Window 
			ListView_SetImageList(hWndValues, hColImageList, LVSIL_SMALL);

			//HACCESSOR
			HACCESSOR hAccessor = pCCommand->m_ParamInfo.hAccessor;
			void* pData = pCCommand->m_ParamInfo.pData;	
			ULONG cBindings = pCCommand->m_cParamBindings;
			DBBINDING* rgBindings = pCCommand->m_rgParamBindings;

			DWORD		dwConvFlags = pThis->GetOptionsObj()->m_dwConvFlags; 
			ULONG		dwLength = 0;
			DBSTATUS	dwStatus = DBSTATUS_S_OK;
			CHAR		szBuffer[MAX_COL_SIZE];

			//We need to the ListView
			//Headers/Columns contain ColInfo information 
			//Rows are per columns
			
			//Use Extended ListView Styles!
			SendMessage(hWndNames,	LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndValues,	LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//ListView Columns
			LV_InsertColumn(hWndNames,	0,		"Parameter");
			LV_InsertColumn(hWndNames,	1,		"Length");
			LV_InsertColumn(hWndNames,	2,		"Status");
			LV_InsertColumn(hWndValues,	0,		"Value");
			
			for(ULONG i=0; i<cBindings; i++)
			{	
				ASSERT(rgBindings);
				DBBINDING* pBinding = &rgBindings[i];

				//Value
				//Get the Length, Status, Data for this Column
				pCRowset->GetColumnData(pBinding, pData, &dwStatus, &dwLength, NULL, szBuffer, MAX_COL_SIZE, dwConvFlags, pBinding->wType);

				//Insert the Data into the list (make an "easy" edit)
				LV_InsertItem(hWndValues, i, 0, szBuffer, PARAM_NONE, 0);

				//Insert Parameter Name
				sprintf(szBuffer, "Parameter %d", i+1);
				LV_InsertItem(hWndNames, i, 0, szBuffer);

				//Insert the Length into the List
				sprintf(szBuffer, "%d", dwLength);
				LV_InsertItem(hWndNames, i, 1, szBuffer);

				//Insert the Status into the List
				LV_InsertItem(hWndNames, i, 2, dwStatus==DBSTATUS_S_ISNULL ? GetStatusName(dwStatus) : GetStatusName(DBSTATUS_S_OK));
			}

			if(cBindings == 0)
			{
				LV_InsertItem(hWndNames, 0, 0,	"Parameter 1");
				LV_InsertItem(hWndNames, 0, 1,	"0");
				LV_InsertItem(hWndNames, 0, 2,	"DBSTATUS_S_OK");
				LV_InsertItem(hWndValues, 0, 0,	"Enter Parameter Value...");
			}
			
			//AutoSize column
			SendMessage(hWndNames, LVM_SETCOLUMNWIDTH, 0,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			SendMessage(hWndNames, LVM_SETCOLUMNWIDTH, 1,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			SendMessage(hWndNames, LVM_SETCOLUMNWIDTH, 2,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			SendMessage(hWndValues, LVM_SETCOLUMNWIDTH, 0,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
			
			Busy(OFF);
			CenterDialog(hWnd);
			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CCommand* pCCommand = pCRowset->m_pCCommand;
					HRESULT hr = S_OK;

					//Setup column headers
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					HWND hWndValues		= GetDlgItem(hWnd, IDL_PARAMVALUES);

					DBPARAMS* pParamInfo = &pCCommand->m_ParamInfo;

					//Setup ParamInfo
					ULONG i,iItems= 0;
					ULONG cParams = 0;
					ULONG cbRowSize = 0;
					DBPARAMINFO* rgParamInfo = NULL;

					//The ListView will produce IDOK if hitting return after entering
					//a value.  The easist way arround this is to just exit if 
					//we haven't yet received the ENDEDIT message
					if(bBeginEdit)
						goto CLEANUP;

					//Obtain the number of parameters (Items) in the list
					iItems = SendMessage(hWndNames, LVM_GETITEMCOUNT, 0, 0);
					cParams = iItems != LVM_ERR ? iItems : 0;
					
					SAFE_ALLOC(rgParamInfo, DBPARAMINFO, cParams);
					for(i=0; i<cParams; i++)
					{
						rgParamInfo[i].iOrdinal = i+1;
						rgParamInfo[i].dwFlags = DBPARAMFLAGS_ISINPUT;
						rgParamInfo[i].pwszName = NULL;
						rgParamInfo[i].ulParamSize = MAX_COL_SIZE;
						rgParamInfo[i].pTypeInfo = NULL;
						rgParamInfo[i].wType = DBTYPE_STR;
						rgParamInfo[i].bPrecision = 0;
						rgParamInfo[i].bScale = 0;
					}

					//Create Parameter Accessor
					pParamInfo->cParamSets = 1;
					TESTC(hr = pCCommand->CreateParamAccessor(cParams, rgParamInfo));
					
					//Setup Data Buffer
					TESTC(pThis->GetListViewValues(hWndNames, hWndValues, pCCommand->m_cParamBindings, pCCommand->m_rgParamBindings, pParamInfo->pData));
				
				CLEANUP:
					SAFE_FREE(rgParamInfo);
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					else
					{
						pParamInfo->cParamSets = 0;
					}
					return 0;
				}

				case IDCANCEL:
				{
					bBeginEdit = FALSE;
					EndDialog(hWnd, FALSE);
					return 0;
				}

				case IDB_ADDPARAM:
				{
					bBeginEdit = FALSE;
					CHAR szBuffer[MAX_NAME_LEN];

					//Setup column headers
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					HWND hWndValues		= GetDlgItem(hWnd, IDL_PARAMVALUES);

					//Get the Total Number of ListView Items
					LONG iItems = SendMessage(hWndNames, LVM_GETITEMCOUNT, 0, 0);
					if(iItems != LVM_ERR)
					{
						//Insert a new Parameter
						sprintf(szBuffer, "Parameter %d", iItems+1);
						LV_InsertItem(hWndNames,	iItems, 0,	szBuffer);
						LV_InsertItem(hWndNames,	iItems, 1,	"0");
						LV_InsertItem(hWndNames,	iItems, 2,	"DBSTATUS_S_OK");
						LV_InsertItem(hWndValues,	iItems, 0,	"Enter Parameter Value...");
					}
					return 0;
				}

				case IDB_DELPARAM:
				{
					bBeginEdit = FALSE;

					//Setup column headers
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					HWND hWndValues		= GetDlgItem(hWnd, IDL_PARAMVALUES);

					//Get the Total Number of ListView Items
					LONG iItems = SendMessage(hWndNames, LVM_GETITEMCOUNT, 0, 0);
					if(iItems != LVM_ERR)
					{
						//Delete the Last Item
						SendMessage(hWndNames, LVM_DELETEITEM, iItems-1, 0);
						SendMessage(hWndValues, LVM_DELETEITEM, iItems-1, 0);
					}
					return 0;
				}
				case IDMENU_DBSTATUS_S_OK:
				{
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_OK");
					return 0;
				}

				case IDMENU_DBSTATUS_S_ISNULL:
				{
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_ISNULL");
					return 0;
				}
				
				case IDMENU_DBSTATUS_S_DEFAULT:
				{
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					
					//Insert the Status into the List
					LONG iSelRow = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSelRow == LVM_ERR)
						return 0;

					LV_InsertItem(hWndNames, iSelRow, 2, "DBSTATUS_S_DEFAULT");
						return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_CONTEXTMENU:
		{	
			HWND hWndSelected = (HWND)wParam;
			HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
			HWND hWndValues		= GetDlgItem(hWnd, IDL_PARAMVALUES);
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			
			//Must have selected a row to change status
			LONG iSel = SendMessage(hWndNames, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
			if(iSel == LVM_ERR)
				return FALSE;

			//IDL_PARAMNAMES
			if(hWndSelected == hWndNames)
			{
				//Display Menu
				DisplayContextMenu(	pThis->m_hInst, 
									hWnd,
									IDMENU_CHANGESTATUS, 
									LOWORD(lParam),
									HIWORD(lParam),
									hWnd
									);
			}
			return FALSE;
		}

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
				{
					//Obtain the SelectedRow
					LONG iSel = SendMessage(GetDlgItem(hWnd, IDL_PARAMVALUES), LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					if(iSel == LVM_ERR)
						return 0;

					//Need to Send LVM_EDITLABEL
					SendMessage(GetDlgItem(hWnd, IDL_PARAMVALUES), LVM_EDITLABEL, iSel, 0);
					return FALSE;
				}

				case LVN_BEGINLABELEDIT:
					bBeginEdit = TRUE;
					return FALSE;//allow the user to change the value of the item.
					
				case LVN_ENDLABELEDIT:
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndValues  = GetDlgItem(hWnd, IDL_PARAMVALUES);
					bBeginEdit = FALSE;								

					//Now update the ListView with the new value
					//If IRowsetChange is supported...
					if(pDispInfo->item.pszText)
						LV_SetItemText(hWndValues, pDispInfo->item.iItem, 0, pDispInfo->item.pszText);

					return TRUE; //Allow the edited change
				}

				case LVN_ITEMCHANGED:
				{
					HWND hWndNames		= GetDlgItem(hWnd, IDL_PARAMNAMES);
					HWND hWndValues		= GetDlgItem(hWnd, IDL_PARAMVALUES);
					bBeginEdit = FALSE;								

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_PARAMVALUES)
						{
							SyncSibling(hWndNames, hWndValues);
	           				return FALSE;
						}

						if(wParam == IDL_PARAMNAMES)
						{
							SyncSibling(hWndValues, hWndNames);
	                		return FALSE;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}


		}//WM_NOTIFY
	}//switch message

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetLiteralInfoProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetLiteralInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_NAME_LEN+1];

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CListBox* pCListBox = pThis->m_pCListBox;
			CRowset* pCRowset = pThis->m_pCRowset;
			CDataSource* pCDataSource = pThis->m_pCRowset->m_pCDataSource;
			HRESULT hr = S_OK;

			ULONG i,cLiteralInfo = 0;
			DBLITERALINFO* rgLiteralInfo = NULL;
			WCHAR* pStringBuffer = NULL;

			//Setup column headers
			HWND hWndLiterals   = GetDlgItem(hWnd, IDL_VALUES);
			HWND hWndNames		= GetDlgItem(hWnd, IDL_NAMES);
			HWND hWndHelp		= GetDlgItem(hWnd, IDT_HELPMSG);
			
			//Set Window Titles
			SendMessage(hWnd,		WM_SETTEXT, 0, (LPARAM)"IDBInfo::GetLiteralInfo");
			SendMessage(hWndHelp,	WM_SETTEXT, 0, (LPARAM)"Information about literals used in text DDL");

			//Create the ImageList
			HIMAGELIST hImageList = ImageList_Create(16, 16, ILC_MASK, 1, 0 );

			const static NAMEMAP rgLiterals[] =
			{
				VALUE_CHAR(DBLITERAL_INVALID	),
				VALUE_CHAR(DBLITERAL_BINARY_LITERAL	),
				VALUE_CHAR(DBLITERAL_CATALOG_NAME	),
				VALUE_CHAR(DBLITERAL_CATALOG_SEPARATOR	),
				VALUE_CHAR(DBLITERAL_CHAR_LITERAL	),
				VALUE_CHAR(DBLITERAL_COLUMN_ALIAS	),
				VALUE_CHAR(DBLITERAL_COLUMN_NAME	),
				VALUE_CHAR(DBLITERAL_CORRELATION_NAME	),
				VALUE_CHAR(DBLITERAL_CURSOR_NAME	),
				VALUE_CHAR(DBLITERAL_ESCAPE_PERCENT	),
				VALUE_CHAR(DBLITERAL_ESCAPE_UNDERSCORE	),
				VALUE_CHAR(DBLITERAL_INDEX_NAME	),
				VALUE_CHAR(DBLITERAL_LIKE_PERCENT	),
				VALUE_CHAR(DBLITERAL_LIKE_UNDERSCORE	),
				VALUE_CHAR(DBLITERAL_PROCEDURE_NAME	),
				VALUE_CHAR(DBLITERAL_QUOTE_PREFIX	),
				VALUE_CHAR(DBLITERAL_SCHEMA_NAME	),
				VALUE_CHAR(DBLITERAL_TABLE_NAME	),
				VALUE_CHAR(DBLITERAL_TEXT_COMMAND	),
				VALUE_CHAR(DBLITERAL_USER_NAME	),
				VALUE_CHAR(DBLITERAL_VIEW_NAME	),
				
				VALUE_CHAR(DBLITERAL_CUBE_NAME	),
				VALUE_CHAR(DBLITERAL_DIMENSION_NAME	),
				VALUE_CHAR(DBLITERAL_HIERARCHY_NAME	),
				VALUE_CHAR(DBLITERAL_LEVEL_NAME	),
				VALUE_CHAR(DBLITERAL_MEMBER_NAME	),
				VALUE_CHAR(DBLITERAL_PROPERTY_NAME	),

				//2.0
				VALUE_CHAR(DBLITERAL_SCHEMA_SEPARATOR	),
				VALUE_CHAR(DBLITERAL_QUOTE_SUFFIX	),
			};

			//IDI_ROWNORMAL - for row icon
			HICON hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_NORMAL));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_CHECK - for "true" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_CHECK));
			ImageList_AddIcon(hImageList, hIcon);
			//IDI_UNCHECK - for "false" flags
			hIcon = LoadIcon(pThis->m_hInst, MAKEINTRESOURCE(IDI_UNCHECK));
			ImageList_AddIcon(hImageList, hIcon);

			//Set image list to the Table Window 
			ListView_SetImageList(hWndLiterals, hImageList, LVSIL_SMALL);
//			ImageList_Destroy(hImageList);

			//Obtain GetLiteralInfo (for all supported literals)
			ASSERT(pCDataSource->m_pIDBInfo);
			TESTC(pCListBox->OutputPreMethod("IDBInfo::GetLiteralInfo(&%d, &0x%08x, 0x%08x)", cLiteralInfo, rgLiteralInfo, pStringBuffer));
			XTEST(hWnd, hr = pCDataSource->m_pIDBInfo->GetLiteralInfo(0, NULL, &cLiteralInfo, &rgLiteralInfo, &pStringBuffer));
			TESTC(pCListBox->OutputPostMethod(hr, "IDBInfo::GetLiteralInfo(&%d, &0x%08x, 0x%08x)", cLiteralInfo, rgLiteralInfo, pStringBuffer));

			//We need to the ListView
			//Headers/Columns contain ColInfo information 
			//Rows are per columns
			
			//Use Extended ListView Styles!
			SendMessage(hWndLiterals,	LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);
			SendMessage(hWndNames,		LVM_SETEXTENDEDLISTVIEWSTYLE, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_TWOCLICKACTIVATE | LVS_EX_SUBITEMIMAGES);

			//ListView NAMES
			LV_InsertColumn(hWndNames,	0,				"DBLITERAL");
			LV_InsertItem(hWndNames,	0,		0,	"LiteralValue");
			LV_InsertItem(hWndNames,	1,		0,	"InvalidChars");
			LV_InsertItem(hWndNames,	2,		0,	"InvalidStartingChars");
			LV_InsertItem(hWndNames,	3,		0, 	"Supported");
			LV_InsertItem(hWndNames,	4,		0,	"MaxLen");
			
			//AutoSize column
			SendMessage(hWndNames, LVM_SETCOLUMNWIDTH, 0,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);

			for(i=0; i<cLiteralInfo; i++)
			{	
				ASSERT(rgLiteralInfo);
				DBLITERALINFO* pLiteralInfo = &rgLiteralInfo[i];

				//Try to find the Actual "DBLITERAL" name...
				CHAR* pszLiteralName = NULL;
				for(LONG j=0; j<NUMELE(rgLiterals); j++)
				{
					if(pLiteralInfo->lt == (ULONG)rgLiterals[j].lItem)
						pszLiteralName = rgLiterals[j].pszName;
				}
				

				//Column Header (DBLITERAL)
				sprintf(szBuffer, "%d", pLiteralInfo->lt);
				LV_InsertColumn(hWndLiterals, i, pszLiteralName ? pszLiteralName : szBuffer);

				//LiteralValue (SubItem)
				sprintf(szBuffer, "%S", pLiteralInfo->pwszLiteralValue);
				LV_InsertItem(hWndLiterals, 0, i, pLiteralInfo->pwszLiteralValue ? szBuffer : NULL);

				//InvalidChars (subitem)
				sprintf(szBuffer, "%S", pLiteralInfo->pwszInvalidChars);
				LV_InsertItem(hWndLiterals, 1, i, pLiteralInfo->pwszInvalidChars ? szBuffer : NULL);
				
				//InvalidChars (subitem)
				sprintf(szBuffer, "%S", pLiteralInfo->pwszInvalidStartingChars);
				LV_InsertItem(hWndLiterals, 2, i, pLiteralInfo->pwszInvalidStartingChars ? szBuffer : NULL);

				//Supported (SubItem)
				LV_InsertItem(hWndLiterals, 3, i, NULL, PARAM_NONE, pLiteralInfo->fSupported ? STATE_CHECKED : STATE_UNCHECKED);

				//cbMaxLen (SubItem)
				sprintf(szBuffer, "%d", pLiteralInfo->cchMaxLen);
				LV_InsertItem(hWndLiterals, 4, i, szBuffer);
			}	

			//AutoSize all columns
			for(i=0; i<cLiteralInfo; i++)
				SendMessage(hWndLiterals, LVM_SETCOLUMNWIDTH, (WPARAM)i,		(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
						
		CLEANUP:
			Busy(OFF);
			CenterDialog(hWnd);
			SAFE_FREE(rgLiteralInfo);
			SAFE_FREE(pStringBuffer);
			if(FAILED(hr))
				EndDialog(hWnd, FALSE);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND

		case WM_NOTIFY:
		{
			LV_DISPINFO* pDispInfo = (LV_DISPINFO*)lParam;
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			
			//ListView
			switch(pDispInfo->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
					return 0;

				case LVN_ITEMCHANGED:
				{
					HWND hWndLiterals  = GetDlgItem(hWnd, IDL_VALUES);
					HWND hWndNames   = GetDlgItem(hWnd, IDL_NAMES);

					if(pListView->uNewState & LVNI_FOCUSED &&
				 		pListView->uNewState & LVNI_SELECTED)
					{
						if(wParam == IDL_VALUES)
						{
							SyncSibling(hWndNames, hWndLiterals);
	           				return FALSE;
						}

						if(wParam == IDL_NAMES)
						{
							SyncSibling(hWndLiterals, hWndNames);
	                		return FALSE;
						}
						return UNHANDLED_MSG; //No return Value
					}
				}
			}


		}//WM_NOTIFY
	}

	return FALSE;
}



////////////////////////////////////////////////////////////////
// CMDIChild::StartLocalTxnProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::StartLocalTxnProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis				= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset			= pThis->m_pCRowset;
			CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
			HRESULT			hr					= S_OK;

			ISOLEVEL		isoLevel			= 0;
			ULONG			ulTransactionLevel	= 0;
			HWND			hWndIsoLevel		= GetDlgItem(hWnd, IDC_ISOLEVEL);

			//Title
			if(pThis->m_eSource == TRANSACTIONLOCAL)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"ITransactionLocal::StartTransaction");

			//Need to fill in the ISOLEVEL ComboBox
			for(ULONG i=0; i<g_cIsoLevels; i++)
			{
				LONG iSel = SendMessage(hWndIsoLevel, CB_ADDSTRING,	0, (LPARAM)g_rgIsoLevels[i].pszName);
				SendMessage(hWndIsoLevel, CB_SETITEMDATA, iSel, (LPARAM)g_rgIsoLevels[i].lItem);
			}

			//SetDefault - READUNCOMMITED
			SendMessage(hWndIsoLevel, CB_SETCURSEL,	2, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild*		pThis				= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox			= pThis->m_pCListBox;
					CRowset*		pCRowset			= pThis->m_pCRowset;
					CSession*		pCSession			= pCRowset->m_pCSession;
					CTransaction*	pCTransaction		= pCSession->m_pCTransaction;

					CHAR			szBuffer[MAX_NAME_LEN+1];

					HRESULT			hr					= S_OK;

					ULONG			ulTransactionLevel	= 0;
					HWND			hWndIsoLevel		= GetDlgItem(hWnd, IDC_ISOLEVEL);
					ITransaction*	pITransaction		= NULL;
					LONG			iSel				= 0;
					
					szBuffer[0] = EOL;

					//Just Need to Obtain selected ISOLEVEL from Combo
					iSel = SendMessage(hWndIsoLevel, CB_GETCURSEL, 0, 0);
					SendMessage(hWndIsoLevel, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					ISOLEVEL isoLevel = (ULONG)SendMessage(hWndIsoLevel, CB_GETITEMDATA, iSel, 0);
					
					ASSERT(pCSession->m_pITransactionLocal);

					//ITransactionLocal::StartTransaction
					pCListBox->OutputPreMethod("ITransactionLocal::StartTransaction(%s, 0, NULL, &%d)", szBuffer, ulTransactionLevel);
					XTEST(hWnd, hr = pCSession->m_pITransactionLocal->StartTransaction(isoLevel, 0, NULL, &ulTransactionLevel));
					pCListBox->OutputPostMethod(hr, "ITransactionLocal::StartTransaction(%s, 0, NULL, &%d)", szBuffer, ulTransactionLevel);

					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::FreeMTSTxn
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::FreeMTSTxn(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef TXNJOIN			//MTS SDK
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis				= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset			= pThis->m_pCRowset;
			CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
			CSession*		pCSession			= pCRowset->m_pCSession;
			CTransaction*	pCTransaction		= pCSession->m_pCTransaction;			
			HRESULT			hr					= S_OK;

			HWND			hWndMTSTxn			= GetDlgItem(hWnd, IDC_MTSTXN);
			CHAR			szBuffer[MAX_NAME_LEN+1];
			ULONG			i					= 0;
			LONG			iSel				= 0;
			szBuffer[0] = EOL;

			//Title
			if(pThis->m_eSource == MTSTRANSACTION)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"Free MTS Transactions");

			//Need to fill in the Txn ComboBox
			for (i=0;i<pThis->m_pCMainWindow->m_listTransactions.GetCount();i++)
			{
				sprintf(szBuffer, "%d", i);
				iSel = SendMessage(hWndMTSTxn, CB_ADDSTRING,	0, (LPARAM)szBuffer);
				SendMessage(hWndMTSTxn, CB_SETITEMDATA, iSel, (LPARAM)i);
			}
			//SetDefault - 1st txn
			SendMessage(hWndMTSTxn, CB_SETCURSEL,	0, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild*		pThis				= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox			= pThis->m_pCListBox;
					CRowset*		pCRowset			= pThis->m_pCRowset;
					CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
					CSession*		pCSession			= pCRowset->m_pCSession;
					CTransaction*	pCTransaction		= pCSession->m_pCTransaction;

					HRESULT			hr					= S_OK;
					CHAR			szBuffer[MAX_NAME_LEN+1];

					HWND			hWndMTSTxn			= GetDlgItem(hWnd, IDC_MTSTXN);
					ITransaction*	pITransaction		= NULL;
					LONG			iSel				= 0;
					LONG			lPosInList			= 0;
					LISTPOS			posSave;

					szBuffer[0] = EOL;
					
					//get the ITransactionPointer
					iSel = SendMessage(hWndMTSTxn, CB_GETCURSEL, 0, 0);
					SendMessage(hWndMTSTxn, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					lPosInList = (LONG)SendMessage(hWndMTSTxn, CB_GETITEMDATA, iSel, 0);
					posSave=pThis->m_pCMainWindow->m_listTransactions.FindIndex(lPosInList);
					//get MTS ITransaction pointer from the list that matches the one picked by the uses
					pITransaction = pThis->m_pCMainWindow->m_listTransactions.GetAt(posSave);

					//Now Start the Transaction
					ASSERT(pITransaction);
					
					//Remove from list
					pThis->m_pCMainWindow->m_listTransactions.RemoveAt(posSave);
						
					//Free pITransaction
					SAFE_RELEASE(pITransaction);
					
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}
#endif  //TXNJOIN
	return FALSE;
}

////////////////////////////////////////////////////////////////
// CMDIChild::GetMTSTxnInfo
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetMTSTxnInfo(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef TXNJOIN			//MTS SDK
		XACTTRANSINFO XactInfo = {0};
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis				= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset			= pThis->m_pCRowset;
			CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
			CSession*		pCSession			= pCRowset->m_pCSession;
			CTransaction*	pCTransaction		= pCSession->m_pCTransaction;			
			HRESULT			hr					= S_OK;

			HWND			hWndMTSTxn			= GetDlgItem(hWnd, IDC_MTSTXN);
			CHAR			szBuffer[MAX_NAME_LEN+1];
			ULONG			i					= 0;
			LONG			iSel				= 0;
			szBuffer[0] = EOL;

			//Title
			if(pThis->m_eSource == MTSTRANSACTION)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"MTS GetTransactionInfo");

			//Need to fill in the Txn ComboBox
			for (i=0;i<pThis->m_pCMainWindow->m_listTransactions.GetCount();i++)
			{
				sprintf(szBuffer, "%d", i);
				iSel = SendMessage(hWndMTSTxn, CB_ADDSTRING,	0, (LPARAM)szBuffer);
				SendMessage(hWndMTSTxn, CB_SETITEMDATA, iSel, (LPARAM)i);
			}
			//SetDefault - 1st txn
			SendMessage(hWndMTSTxn, CB_SETCURSEL,	0, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild*		pThis				= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox			= pThis->m_pCListBox;
					CRowset*		pCRowset			= pThis->m_pCRowset;
					CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
					CSession*		pCSession			= pCRowset->m_pCSession;
					CTransaction*	pCTransaction		= pCSession->m_pCTransaction;

					HRESULT			hr					= S_OK;
					CHAR			szBuffer[MAX_NAME_LEN+1];

					HWND			hWndMTSTxn			= GetDlgItem(hWnd, IDC_MTSTXN);
					ITransaction*	pITransaction		= NULL;
					LONG			iSel				= 0;
					LONG			lPosInList			= 0;
					LISTPOS			posSave;

					szBuffer[0] = EOL;
					
					//get the ITransactionPointer
					iSel = SendMessage(hWndMTSTxn, CB_GETCURSEL, 0, 0);
					SendMessage(hWndMTSTxn, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					lPosInList = (LONG)SendMessage(hWndMTSTxn, CB_GETITEMDATA, iSel, 0);
					posSave=pThis->m_pCMainWindow->m_listTransactions.FindIndex(lPosInList);
					//get MTS ITransaction pointer from the list that matches the one picked by the uses
					pITransaction = pThis->m_pCMainWindow->m_listTransactions.GetAt(posSave);

					//Now Start the Transaction
					ASSERT(pITransaction);
					
					//call to GetTransactionInfo
					pITransaction->GetTransactionInfo(&XactInfo);
//To be done
//Display info

					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}
#endif  //TXNJOIN
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::StartMTSTxnProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::StartMTSTxnProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef TXNJOIN			//MTS SDK
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis			= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset		= pThis->m_pCRowset;
			CDataSource*	pCDataSource	= pThis->m_pCRowset->m_pCDataSource;
			HRESULT			hr				= S_OK;

			ISOLEVEL		isoLevel			= 0;
			HWND			hWndIsoLevel		= GetDlgItem(hWnd, IDC_ISOLEVEL);

			//Title
			if(pThis->m_eSource == MTSTRANSACTION)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"TransactionDispensor::BeginTransaction");

			//Need to fill in the ISOLEVEL ComboBox
			for(ULONG i=0; i<g_cIsoLevels; i++)
			{
				LONG iSel = SendMessage(hWndIsoLevel, CB_ADDSTRING,	0, (LPARAM)g_rgIsoLevels[i].pszName);
				SendMessage(hWndIsoLevel, CB_SETITEMDATA, iSel, (LPARAM)g_rgIsoLevels[i].lItem);
			}

			//SetDefault - READUNCOMMITED
			SendMessage(hWndIsoLevel, CB_SETCURSEL,	2, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild*		pThis			= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox		= pThis->m_pCListBox;
					CRowset*		pCRowset		= pThis->m_pCRowset;
					CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
					CSession*		pCSession		= pCRowset->m_pCSession;
					CTransaction*	pCTransaction	= pCSession->m_pCTransaction;

					HWND		hWndIsoLevel   = GetDlgItem(hWnd, IDC_ISOLEVEL);

					CHAR		szBufferISO[MAX_NAME_LEN+1];
					HRESULT		hr = S_OK;
					szBufferISO[0] = EOL;

					//Just Need to Obtain selected ISOLEVEL from Combo
					LONG		iSel		= SendMessage(hWndIsoLevel, CB_GETCURSEL, 0, 0);
					SendMessage(hWndIsoLevel, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBufferISO);
					ISOLEVEL	isoLevel	= (ULONG)SendMessage(hWndIsoLevel, CB_GETITEMDATA, iSel, 0);
					
					//Get the Txn Name
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);				
					}	
					ITransactionDispenser	*pTransactionDispenser	= NULL;
					ITransaction			*pITransaction			= NULL;

					// Obtain the ITransactionDispenser Interface pointer
					// by calling DtcGetTransactionManager()
					hr = DtcGetTransactionManager	(
											NULL,								// LPTSTR	 pszHost,
											NULL,								// LPTSTR	 pszTmName,
											IID_ITransactionDispenser,			// /* in  */ REFIID rid,
											0,									// /* in  */ DWORD	dwReserved1,
											0, 									// /* in  */ WORD	wcbReserved2,
											NULL,								// /* in  */ void FAR * pvReserved2,
											(void**)&pTransactionDispenser 		// /* out */ void** ppvObject
													);
					if (FAILED (hr))
					{	
						return FALSE;
					}

					//Get isolation level for MTS Global Transaction
					//Just Need to Obtain selected ISOLEVEL from Combo
					iSel = SendMessage(hWndIsoLevel, CB_GETCURSEL, 0, 0);
					SendMessage(hWndIsoLevel, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBufferISO);
					isoLevel = (ULONG)SendMessage(hWndIsoLevel, CB_GETITEMDATA, iSel, 0);
					
					//start a global transaction
					hr = pTransactionDispenser->BeginTransaction	( 
													NULL,							//	/* [in]  */ IUnknown __RPC_FAR *punkOuter,
													isoLevel,						//	/* [in]  */ ISOLEVEL isoLevel,
													0,								// 	/* [in]  */ ULONG isoFlags,
													NULL,							//	/* [in]  */ ITransactionOptions *pOptions 
													(ITransaction**)&pITransaction	//	/* [out] */ ITransaction **ppTransaction
																	);
					pThis->m_pCMainWindow->m_listTransactions.AddTail(pITransaction);
					SAFE_RELEASE(pTransactionDispenser);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}
}
#endif  //TXNJOIN
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::StartJoinTxnProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::StartJoinTxnProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef TXNJOIN			//MTS SDK
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis				= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset			= pThis->m_pCRowset;
			CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
			CSession*		pCSession			= pCRowset->m_pCSession;
			CTransaction*	pCTransaction		= pCSession->m_pCTransaction;			
			HRESULT			hr					= S_OK;

			HWND			hWndMTSTxn			= GetDlgItem(hWnd, IDC_MTSTXN);
			CHAR			szBuffer[MAX_NAME_LEN+1];
			ISOLEVEL		isoLevel			= 0;
			HWND			hWndIsoLevel		= GetDlgItem(hWnd, IDC_ISOLEVEL);
			ULONG			i					= 0;
			LONG			iSel				= 0;			
			szBuffer[0] = EOL;

			//Title
			if(pThis->m_eSource == TRANSACTIONJOIN)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"ITransactionJoin::JoinTransaction");

			//Need to fill in the ISOLEVEL ComboBox
			for(i=0; i<g_cIsoLevels; i++)
			{
				LONG iSel = SendMessage(hWndIsoLevel, CB_ADDSTRING,	0, (LPARAM)g_rgIsoLevels[i].pszName);
				SendMessage(hWndIsoLevel, CB_SETITEMDATA, iSel, (LPARAM)g_rgIsoLevels[i].lItem);
			}
			//SetDefault - READUNCOMMITED
			SendMessage(hWndIsoLevel, CB_SETCURSEL,	2, (LPARAM)0);

			//Need to fill in the Txn ComboBox
			for (i=0;i<pThis->m_pCMainWindow->m_listTransactions.GetCount();i++)
			{
				sprintf(szBuffer, "%d", i);
				iSel = SendMessage(hWndMTSTxn, CB_ADDSTRING,	0, (LPARAM)szBuffer);
				SendMessage(hWndMTSTxn, CB_SETITEMDATA, iSel, (LPARAM)i);
			}
			//SetDefault - 1st txn
			SendMessage(hWndMTSTxn, CB_SETCURSEL,	0, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild*		pThis				= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox			= pThis->m_pCListBox;
					CRowset*		pCRowset			= pThis->m_pCRowset;
					CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
					CSession*		pCSession			= pCRowset->m_pCSession;
					CTransaction*	pCTransaction		= pCSession->m_pCTransaction;

					CHAR			szBuffer[MAX_NAME_LEN+1];

					HRESULT			hr					= S_OK;

					HWND			hWndIsoLevel		= GetDlgItem(hWnd, IDC_ISOLEVEL);
					HWND			hWndMTSTxn			= GetDlgItem(hWnd, IDC_MTSTXN);
					ITransaction*	pITransaction		= NULL;
					LONG			iSel				= 0;
					LONG			lPosInList			= 0;

					szBuffer[0] = EOL;

					//get the ITransactionPointer
					iSel = SendMessage(hWndMTSTxn, CB_GETCURSEL, 0, 0);
					SendMessage(hWndMTSTxn, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					lPosInList = (LONG)SendMessage(hWndMTSTxn, CB_GETITEMDATA, iSel, 0);
					//get MTS ITransaction pointer from the list that matches the one picked by the uses
					pITransaction = pThis->m_pCMainWindow->m_listTransactions.GetAt(pThis->m_pCMainWindow->m_listTransactions.FindIndex(lPosInList));

					//Just Need to Obtain selected ISOLEVEL from Combo
					iSel = SendMessage(hWndIsoLevel, CB_GETCURSEL, 0, 0);
					SendMessage(hWndIsoLevel, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					ISOLEVEL isoLevel = (ULONG)SendMessage(hWndIsoLevel, CB_GETITEMDATA, iSel, 0);
					
					//Now Start the Transaction
					ASSERT(pCSession->m_pITransactionJoin);
						
					//ITransactionJoin::JoinTransaction
					pCListBox->OutputPreMethod("ITransactionJoin::JoinTransaction(0x%08x, %s, 0, NULL)", pITransaction, szBuffer);
					XTEST(hWnd, hr = pCSession->m_pITransactionJoin->JoinTransaction(pITransaction, isoLevel, NULL, NULL));
					pCListBox->OutputPostMethod(hr, "ITransactionJoin::JoinTransaction(0x%08x, %s, 0, NULL)", pITransaction, szBuffer);

					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}
}
#endif  //TXNJOIN
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::AbortMTSTransactionProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::AbortMTSTransactionProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef TXNJOIN			//MTS SDK
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis			= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset		= pThis->m_pCRowset;
			CDataSource*	pCDataSource	= pThis->m_pCRowset->m_pCDataSource;
			CSession*		pCSession		= pCRowset->m_pCSession;
			CTransaction*	pCTransaction	= pCSession->m_pCTransaction;
			HRESULT			hr = S_OK;
			ULONG			i				= 0;
			HWND			hWndRetaining	= GetDlgItem(hWnd, IDC_RETAINING);
			HWND			hWndAsynch		= GetDlgItem(hWnd, IDC_ASYNCH);
			HWND			hWndMTSTxn		= GetDlgItem(hWnd, IDC_MTSTXN);
			CHAR			szBuffer[MAX_NAME_LEN+1];

			//Title
			if(pThis->m_eSource == MTSTRANSACTION)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"ITransaction::Abort");

			//Need to fill in the RETAINING ComboBox
			LONG iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"TRUE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)TRUE);
			iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"FALSE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)FALSE);
			//SetDefault - TRUE
			SendMessage(hWndRetaining, CB_SETCURSEL,	0, (LPARAM)0);
			
			//Need to fill in the ASYNCH ComboBox
			iSel = SendMessage(hWndAsynch, CB_ADDSTRING,	0, (LPARAM)"TRUE");
			SendMessage(hWndAsynch, CB_SETITEMDATA, iSel, (LPARAM)TRUE);
			iSel = SendMessage(hWndAsynch, CB_ADDSTRING,	0, (LPARAM)"FALSE");
			SendMessage(hWndAsynch, CB_SETITEMDATA, iSel, (LPARAM)FALSE);
			//SetDefault - FALSE
			SendMessage(hWndAsynch, CB_SETCURSEL,	1, 0);

			//Need to fill in the MTS Txn ComboBox
			for (i=0;i<pThis->m_pCMainWindow->m_listTransactions.GetCount();i++)
			{
				sprintf(szBuffer, "%d", i);
				LONG iSel = SendMessage(hWndMTSTxn, CB_ADDSTRING,	0, (LPARAM)szBuffer);
				SendMessage(hWndMTSTxn, CB_SETITEMDATA, iSel, (LPARAM)i);
			}
			//SetDefault - 1st txn
			SendMessage(hWndMTSTxn, CB_SETCURSEL,	0, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild*		pThis			= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox		= pThis->m_pCListBox;
					CRowset*		pCRowset		= pThis->m_pCRowset;
					CDataSource*	pCDataSource	= pThis->m_pCRowset->m_pCDataSource;
					CSession*		pCSession		= pCRowset->m_pCSession;
					CTransaction*	pCTransaction	= pCSession->m_pCTransaction;
					HRESULT			hr				= S_OK;
					ITransaction*	pITransaction	= NULL;
					LONG			lPosInList			= 0;
					CHAR			szBuffer[MAX_NAME_LEN+1];

					szBuffer[0] = EOL;

					HWND			hWndRetaining	= GetDlgItem(hWnd, IDC_RETAINING);
					HWND			hWndAsynch		= GetDlgItem(hWnd, IDC_ASYNCH);
					HWND			hWndMTSTxn		= GetDlgItem(hWnd, IDC_MTSTXN);

					//Just Need to Obtain selected RETAINING from Combo
					LONG iSel = SendMessage(hWndRetaining, CB_GETCURSEL, 0, 0);
					BOOL fRetaining = (BOOL)SendMessage(hWndRetaining, CB_GETITEMDATA, iSel, 0);
					
					//Just Need to Obtain selected ASYNCH from Combo
					iSel = SendMessage(hWndAsynch, CB_GETCURSEL, 0, 0);
					BOOL fAsynch = (BOOL)SendMessage(hWndAsynch, CB_GETITEMDATA, iSel, 0);

					//get the ITransactionPointer
					iSel = SendMessage(hWndMTSTxn, CB_GETCURSEL, 0, 0);
					SendMessage(hWndMTSTxn, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					lPosInList = (LONG)SendMessage(hWndMTSTxn, CB_GETITEMDATA, iSel, 0);
					//get MTS ITransaction pointer from the list that matches the one picked by the uses
					pITransaction = pThis->m_pCMainWindow->m_listTransactions.GetAt(pThis->m_pCMainWindow->m_listTransactions.FindIndex(lPosInList));


					ASSERT(pITransaction);
					pCListBox->OutputPreMethod("ITransaction::Abort(NULL, %s, %s)", fRetaining ? "TRUE" : "FALSE", fAsynch ? "TRUE" : "FALSE");
					XTEST(hWnd, hr = pITransaction->Abort(NULL, fRetaining, fAsynch));
					pCListBox->OutputPostMethod(hr, "ITransaction::Abort(NULL, %s, %s)", fRetaining ? "TRUE" : "FALSE", fAsynch ? "TRUE" : "FALSE");
					
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}
}
#endif  //TXNJOIN
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CommitTransactionProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::CommitMTSTransactionProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#ifdef TXNJOIN			//MTS SDK
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild*		pThis			= (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset*		pCRowset		= pThis->m_pCRowset;
			CDataSource*	pCDataSource	= pThis->m_pCRowset->m_pCDataSource;
			CSession*		pCSession		= pCRowset->m_pCSession;
			CTransaction*	pCTransaction	= pCSession->m_pCTransaction;
			HRESULT			hr = S_OK;
			ULONG			i				= 0;
			CHAR			szBuffer[MAX_NAME_LEN+1];


			HWND			hWndRetaining	= GetDlgItem(hWnd, IDC_RETAINING);
			HWND			hWndMTSTxn		= GetDlgItem(hWnd, IDC_MTSTXN);
			HWND			hWndXACTTC		= GetDlgItem(hWnd, IDC_XACTTC);
			
			//Title
			if(pThis->m_eSource == TRANSACTIONLOCAL)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"ITransactionLocal::Commit");

			//Need to fill in the RETAINING ComboBox
			LONG iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"TRUE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)TRUE);
			iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"FALSE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)FALSE);
			//SetDefault - FALSE
			SendMessage(hWndRetaining, CB_SETCURSEL,	1, 0);
			
			//Need to fill in the XACTTC ComboBox
			for(i=0; i<g_cXACTTC; i++)
			{
				iSel = SendMessage(hWndXACTTC, CB_ADDSTRING,	0, (LPARAM)g_rgXACTTC[i].pszName);
				SendMessage(hWndXACTTC, CB_SETITEMDATA, iSel, (LPARAM)g_rgXACTTC[i].lItem);
			}
			//SetDefault - XACTTC_SYNC_PHASETWO
			SendMessage(hWndXACTTC, CB_SETCURSEL,	1, 0);

			//Need to fill in the MTS Txn ComboBox
			for (i=0;i<pThis->m_pCMainWindow->m_listTransactions.GetCount();i++)
			{
				sprintf(szBuffer, "%d", i);
				LONG iSel = SendMessage(hWndMTSTxn, CB_ADDSTRING,	0, (LPARAM)szBuffer);
				SendMessage(hWndMTSTxn, CB_SETITEMDATA, iSel, (LPARAM)i);
			}
			//SetDefault - 1st txn
			SendMessage(hWndMTSTxn, CB_SETCURSEL,	0, (LPARAM)0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					CMDIChild*		pThis			= (CMDIChild*)GetThis(hWnd);
					CListBox*		pCListBox		= pThis->m_pCListBox;
					CRowset*		pCRowset		= pThis->m_pCRowset;
					CDataSource*	pCDataSource		= pThis->m_pCRowset->m_pCDataSource;
					CSession*		pCSession		= pCRowset->m_pCSession;
					CTransaction*	pCTransaction	= pCSession->m_pCTransaction;
					HRESULT			hr				= S_OK;
					ITransaction*	pITransaction	= NULL;
					CHAR			szBuffer[MAX_NAME_LEN+1];
					LONG			lPosInList			= 0;

					szBuffer[0] = EOL;

					HWND			hWndRetaining	= GetDlgItem(hWnd, IDC_RETAINING);
					HWND			hWndAsynch		= GetDlgItem(hWnd, IDC_ASYNCH);
					HWND			hWndMTSTxn		= GetDlgItem(hWnd, IDC_MTSTXN);
					HWND			hWndXACTTC		= GetDlgItem(hWnd, IDC_XACTTC);

					//Just Need to Obtain selected RETAINING from Combo
					LONG iSel = SendMessage(hWndRetaining, CB_GETCURSEL, 0, 0);
					BOOL fRetaining = (BOOL)SendMessage(hWndRetaining, CB_GETITEMDATA, iSel, 0);
					
					//Just Need to Obtain selected hWndXACTTC from Combo
					iSel = SendMessage(hWndXACTTC, CB_GETCURSEL, 0, 0);
					DWORD XACTTC = (DWORD)SendMessage(hWndXACTTC, CB_GETITEMDATA, iSel, 0);
					SendMessage(hWndXACTTC, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);

					//get the ITransactionPointer
					iSel = SendMessage(hWndMTSTxn, CB_GETCURSEL, 0, 0);
					SendMessage(hWndMTSTxn, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);
					lPosInList = (LONG)SendMessage(hWndMTSTxn, CB_GETITEMDATA, iSel, 0);
					//get MTS ITransaction pointer from the list that matches the one picked by the uses
					pITransaction = pThis->m_pCMainWindow->m_listTransactions.GetAt(pThis->m_pCMainWindow->m_listTransactions.FindIndex(lPosInList));

					ASSERT(pITransaction);
					//Now Commit the Transaction
					pCListBox->OutputPreMethod("ITransaction::Commit(%s, %s, 0)", fRetaining ? "TRUE" : "FALSE", szBuffer);
					XTEST(hWnd, hr = pITransaction->Commit(fRetaining, XACTTC, 0));
					pCListBox->OutputPostMethod(hr, "ITransaction::Commit(%s, %s, 0)", fRetaining ? "TRUE" : "FALSE", szBuffer);
					
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
					}
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}
}
#endif  //TXNJOIN
	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::AbortTransactionProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::AbortTransactionProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset* pCRowset = pThis->m_pCRowset;
			CDataSource* pCDataSource = pThis->m_pCRowset->m_pCDataSource;
			HRESULT hr = S_OK;

			HWND hWndRetaining  = GetDlgItem(hWnd, IDC_RETAINING);
			HWND hWndAsynch		= GetDlgItem(hWnd, IDC_ASYNCH);
			
			//Title
			if(pThis->m_eSource == TRANSACTIONLOCAL)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"ITransactionLocal::Abort");

			//Need to fill in the RETAINING ComboBox
			LONG iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"TRUE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)TRUE);
			iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"FALSE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)FALSE);
			//SetDefault - TRUE
			SendMessage(hWndRetaining, CB_SETCURSEL,	0, (LPARAM)0);
			
			//Need to fill in the ASYNCH ComboBox
			iSel = SendMessage(hWndAsynch, CB_ADDSTRING,	0, (LPARAM)"TRUE");
			SendMessage(hWndAsynch, CB_SETITEMDATA, iSel, (LPARAM)TRUE);
			iSel = SendMessage(hWndAsynch, CB_ADDSTRING,	0, (LPARAM)"FALSE");
			SendMessage(hWndAsynch, CB_SETITEMDATA, iSel, (LPARAM)FALSE);
			//SetDefault - FALSE
			SendMessage(hWndAsynch, CB_SETCURSEL,	1, 0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CSession* pCSession = pCRowset->m_pCSession;
					HRESULT hr = S_OK;

					HWND hWndRetaining  = GetDlgItem(hWnd, IDC_RETAINING);
					HWND hWndAsynch		= GetDlgItem(hWnd, IDC_ASYNCH);

					//Just Need to Obtain selected RETAINING from Combo
					LONG iSel = SendMessage(hWndRetaining, CB_GETCURSEL, 0, 0);
					BOOL fRetaining = (BOOL)SendMessage(hWndRetaining, CB_GETITEMDATA, iSel, 0);
					
					//Just Need to Obtain selected ASYNCH from Combo
					iSel = SendMessage(hWndAsynch, CB_GETCURSEL, 0, 0);
					BOOL fAsynch = (BOOL)SendMessage(hWndAsynch, CB_GETITEMDATA, iSel, 0);

					//Now Abort the Transaction
					if(pThis->m_eSource == TRANSACTION)
					{
						ASSERT(pCSession->m_pCTransaction->m_pITransaction);
						pCListBox->OutputPreMethod("ITransaction::Abort(NULL, %s, %s)", fRetaining ? "TRUE" : "FALSE", fAsynch ? "TRUE" : "FALSE");
						XTEST(hWnd, hr = pCSession->m_pCTransaction->m_pITransaction->Abort(NULL, fRetaining, fAsynch));
						pCListBox->OutputPostMethod(hr, "ITransaction::Abort(NULL, %s, %s)", fRetaining ? "TRUE" : "FALSE", fAsynch ? "TRUE" : "FALSE");
					}
					else
					{
						ASSERT(pCSession->m_pITransactionLocal);
						pCListBox->OutputPreMethod("ITransactionLocal::Abort(NULL, %s, %s)", fRetaining ? "TRUE" : "FALSE", fAsynch ? "TRUE" : "FALSE");
						XTEST(hWnd, hr = pCSession->m_pITransactionLocal->Abort(NULL, fRetaining, fAsynch));
						pCListBox->OutputPostMethod(hr, "ITransactionLocal::Abort(NULL, %s, %s)", fRetaining ? "TRUE" : "FALSE", fAsynch ? "TRUE" : "FALSE");
					}
					
					if(SUCCEEDED(hr))
						EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CommitTransactionProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::CommitTransactionProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset* pCRowset = pThis->m_pCRowset;
			CDataSource* pCDataSource = pThis->m_pCRowset->m_pCDataSource;
			HRESULT hr = S_OK;

			HWND hWndRetaining  = GetDlgItem(hWnd, IDC_RETAINING);
			HWND hWndXACTTC		= GetDlgItem(hWnd, IDC_XACTTC);
			
			//Title
			if(pThis->m_eSource == TRANSACTIONLOCAL)
				SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)"ITransactionLocal::Commit");

			//Need to fill in the RETAINING ComboBox
			LONG iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"TRUE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)TRUE);
			iSel = SendMessage(hWndRetaining, CB_ADDSTRING,	0, (LPARAM)"FALSE");
			SendMessage(hWndRetaining, CB_SETITEMDATA, iSel, (LPARAM)FALSE);
			//SetDefault - FALSE
			SendMessage(hWndRetaining, CB_SETCURSEL,	1, 0);
			
			//Need to fill in the XACTTC ComboBox
			for(ULONG i=0; i<g_cXACTTC; i++)
			{
				iSel = SendMessage(hWndXACTTC, CB_ADDSTRING,	0, (LPARAM)g_rgXACTTC[i].pszName);
				SendMessage(hWndXACTTC, CB_SETITEMDATA, iSel, (LPARAM)g_rgXACTTC[i].lItem);
			}

			//SetDefault - XACTTC_SYNC_PHASETWO
			SendMessage(hWndXACTTC, CB_SETCURSEL,	1, 0);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CSession* pCSession = pCRowset->m_pCSession;
					CHAR szBuffer[MAX_NAME_LEN+1];
					szBuffer[0] = EOL;
					HRESULT hr = S_OK;

					HWND hWndRetaining  = GetDlgItem(hWnd, IDC_RETAINING);
					HWND hWndXACTTC		= GetDlgItem(hWnd, IDC_XACTTC);

					//Just Need to Obtain selected RETAINING from Combo
					LONG iSel = SendMessage(hWndRetaining, CB_GETCURSEL, 0, 0);
					BOOL fRetaining = (BOOL)SendMessage(hWndRetaining, CB_GETITEMDATA, iSel, 0);
					
					//Just Need to Obtain selected hWndXACTTC from Combo
					iSel = SendMessage(hWndXACTTC, CB_GETCURSEL, 0, 0);
					DWORD XACTTC = (DWORD)SendMessage(hWndXACTTC, CB_GETITEMDATA, iSel, 0);
					SendMessage(hWndXACTTC, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szBuffer);

					//Now Abort the Transaction
					if(pThis->m_eSource == TRANSACTION)
					{
						//Now Commit the Transaction
						ASSERT(pCSession->m_pCTransaction->m_pITransaction);
						pCListBox->OutputPreMethod("ITransaction::Commit(%s, %s, 0)", fRetaining ? "TRUE" : "FALSE", szBuffer);
						XTEST(hWnd, hr = pCSession->m_pCTransaction->m_pITransaction->Commit(fRetaining, XACTTC, 0));
						pCListBox->OutputPostMethod(hr, "ITransaction::Commit(%s, %s, 0)", fRetaining ? "TRUE" : "FALSE", szBuffer);
					}
					else
					{
						//Now Commit the Transaction
						ASSERT(pCSession->m_pITransactionLocal);
						pCListBox->OutputPreMethod("ITransactionLocal::Commit(%s, %s, 0)", fRetaining ? "TRUE" : "FALSE", szBuffer);
						XTEST(hWnd, hr = pCSession->m_pITransactionLocal->Commit(fRetaining, XACTTC, 0));
						pCListBox->OutputPostMethod(hr, "ITransactionLocal::Commit(%s, %s, 0)", fRetaining ? "TRUE" : "FALSE", szBuffer);
					}
					
					if(SUCCEEDED(hr))
						EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::SetTransactionOptionsProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::SetTransactionOptionsProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);

			HWND hWndTimeout	= GetDlgItem(hWnd, IDE_TIMEOUT);
			HWND hWndDescription= GetDlgItem(hWnd, IDE_DESCRIPTION);
			
			//Defaults
			SendMessage(hWndTimeout, WM_SETTEXT, 0, (LPARAM)"0");
			SendMessage(hWndDescription, WM_SETTEXT, 0, (LPARAM)"");
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CSession* pCSession = pCRowset->m_pCSession;
					CTransaction* pCTransaction = pCSession->m_pCTransaction;
					HRESULT hr = S_OK;

					HWND hWndTimeout	= GetDlgItem(hWnd, IDE_TIMEOUT);
					HWND hWndDescription= GetDlgItem(hWnd, IDE_DESCRIPTION);

					XACTOPT XactOptions;
					XactOptions.ulTimeout = 0;
					XactOptions.szDescription[0] = EOL;

					//Need to Obtain Entered Timeout Value
					if(!GetEditBoxValue(hWndTimeout, 0, LONG_MAX-1, (LONG*)&XactOptions.ulTimeout))
						return FALSE;

					//Need to Obtain Description
					SendMessage(hWndDescription, WM_GETTEXT, 40-1, (LPARAM)XactOptions.szDescription);

					//ITransactionOptions::SetOptions
					ASSERT(pCTransaction->m_pITransactionOptions);
					pCListBox->OutputPreMethod("ITransactionOptions::SetOptions(%d, %s)", XactOptions.ulTimeout, XactOptions.szDescription);
					XTEST(hWnd, hr = pCTransaction->m_pITransactionOptions->SetOptions(&XactOptions));
					pCListBox->OutputPostMethod(hr, "ITransactionOptions::SetOptions(%d, \"%s\")", XactOptions.ulTimeout, XactOptions.szDescription);
					
					if(SUCCEEDED(hr))
						EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::CanConvertProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::CanConvertProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static DBTYPE wSavedFromType = 0;
	static DBTYPE wSavedToType = 0; 

	static LONG iSavedFromSel = 28;		//WSTR - order in the combo
	static LONG iSavedToSel = 28;		//WSTR - order in the combo
	
	//We have a problem with DBCONVERTFLAGS being orable, but _COLUMN == 0!
	//We will need to keep track of the 0 and non-0 flags, 
	//inorder to restore the users previous selections correctly...
	static LONG fSelColumnFlag = TRUE;						//Default to COLUMN
	static LONG dwSavedConvFlags = DBCONVERTFLAGS_COLUMN;	//Default to COLUMN

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset* pCRowset = pThis->m_pCRowset;
			CDataSource* pCDataSource = pThis->m_pCRowset->m_pCDataSource;
			LONG iSel = 0;
			HRESULT hr = S_OK;

			HWND hWndFromType	= GetDlgItem(hWnd, IDC_FROMTYPE);
			HWND hWndToType		= GetDlgItem(hWnd, IDC_TOTYPE);
			HWND hWndConvFlags	= GetDlgItem(hWnd, IDL_CONVFLAGS);
			
			const static NAMEMAP rgConvertFlags[] =
			{						   
				VALUE_CHAR(DBCONVERTFLAGS_COLUMN	),
				VALUE_CHAR(DBCONVERTFLAGS_PARAMETER	),
				VALUE_CHAR(DBCONVERTFLAGS_ISLONG	),
				VALUE_CHAR(DBCONVERTFLAGS_ISFIXEDLENGTH	),
			};

			//Need to fill in the From and To Type ComboBoxs
			for(ULONG i=0; i<g_cDBTypes; i++)
			{
				WCHAR* pwszName = g_rgDBTypes[i].pwszName;
				DBTYPE wType = (DBTYPE)g_rgDBTypes[i].lItem;

				//FromType
				iSel = wSendMessage(hWndFromType, CB_ADDSTRING,	0, pwszName);
				SendMessage(hWndFromType, CB_SETITEMDATA, iSel, (LPARAM)wType);
				//ToType
				iSel = wSendMessage(hWndToType, CB_ADDSTRING,	0, pwszName);
				SendMessage(hWndToType, CB_SETITEMDATA, iSel, (LPARAM)wType);
			}

			//Need to select Defaults
			SendMessage(hWndFromType, CB_SETCURSEL, iSavedFromSel, 0);
			SendMessage(hWndToType, CB_SETCURSEL, iSavedToSel, 0);
			
			//Need to also select Default Modifiers
			CheckDlgButton(hWnd, IDB_FROM_BYREF,	wSavedFromType & DBTYPE_BYREF ? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hWnd, IDB_FROM_ARRAY,	wSavedFromType & DBTYPE_ARRAY ? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hWnd, IDB_FROM_VECTOR,	wSavedFromType & DBTYPE_VECTOR ? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hWnd, IDB_TO_BYREF,		wSavedToType & DBTYPE_BYREF ? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hWnd, IDB_TO_ARRAY,		wSavedToType & DBTYPE_ARRAY ? BST_CHECKED : BST_UNCHECKED);
			CheckDlgButton(hWnd, IDB_TO_VECTOR,		wSavedToType & DBTYPE_VECTOR ? BST_CHECKED : BST_UNCHECKED);
			
			//Need to fill in the ConvertFlags (ListBox)
			SendMessage(hWndConvFlags, LB_RESETCONTENT, 0, 0);
			for(i=0; i<NUMELE(rgConvertFlags); i++)
			{
				LONG iSel = SendMessage(hWndConvFlags, LB_ADDSTRING, 0, (LPARAM)rgConvertFlags[i].pszName);
				SendMessage(hWndConvFlags,	LB_SETITEMDATA,	iSel, (LPARAM)rgConvertFlags[i].lItem);

				//Select Saved ConvFlags
				if((dwSavedConvFlags & rgConvertFlags[i].lItem) || (fSelColumnFlag && rgConvertFlags[i].lItem == DBCONVERTFLAGS_COLUMN))
					 SendMessage(hWndConvFlags, LB_SETSEL, TRUE, i);
			}

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CListBox* pCListBox = pThis->m_pCListBox;
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pThis->m_pCRowset->m_pCDataSource;
					IConvertType* pIConvertType = NULL;
					HRESULT hr = S_OK;

					HWND hWndFromType	= GetDlgItem(hWnd, IDC_FROMTYPE);
					HWND hWndToType		= GetDlgItem(hWnd, IDC_TOTYPE);
					HWND hWndConvFlags	= GetDlgItem(hWnd, IDL_CONVFLAGS);
					HWND hWndResult		= GetDlgItem(hWnd, IDT_RESULT);

					//Just Need to Obtain selected FromType from Combo
					iSavedFromSel = SendMessage(hWndFromType, CB_GETCURSEL, 0, 0);
					wSavedFromType = (DBTYPE)SendMessage(hWndFromType, CB_GETITEMDATA, iSavedFromSel, 0);
					
					//Need to obtain any type modifier for the FromType
					if(IsDlgButtonChecked(hWnd, IDB_FROM_BYREF))
						wSavedFromType |= DBTYPE_BYREF;
					if(IsDlgButtonChecked(hWnd, IDB_FROM_ARRAY))
						wSavedFromType |= DBTYPE_ARRAY;
					if(IsDlgButtonChecked(hWnd, IDB_FROM_VECTOR))
						wSavedFromType |= DBTYPE_VECTOR;

					//Just Need to Obtain selected ToType from Combo
					iSavedToSel = SendMessage(hWndToType, CB_GETCURSEL, 0, 0);
					wSavedToType = (DBTYPE)SendMessage(hWndToType, CB_GETITEMDATA, iSavedToSel, 0);

					//Need to obtain any type modifier for the ToType
					if(IsDlgButtonChecked(hWnd, IDB_TO_BYREF))
						wSavedToType |= DBTYPE_BYREF;
					if(IsDlgButtonChecked(hWnd, IDB_TO_ARRAY))
						wSavedToType |= DBTYPE_ARRAY;
					if(IsDlgButtonChecked(hWnd, IDB_TO_VECTOR))
						wSavedToType |= DBTYPE_VECTOR;

					//Obtain all Selected ConvertFlag items...
					LONG iSelCount = SendMessage(hWndConvFlags, LB_GETSELCOUNT, 0, 0);
					ASSERT(iSelCount < 20);
					LONG rgSelItems[20];
					SendMessage(hWndConvFlags, LB_GETSELITEMS, (WPARAM)20, (LPARAM)rgSelItems);

					fSelColumnFlag = FALSE;
					dwSavedConvFlags = 0;
					for(LONG i=0; i<iSelCount; i++)
					{
						DWORD dwSelFlag = SendMessage(hWndConvFlags, LB_GETITEMDATA, rgSelItems[i], 0);
						if(dwSelFlag == DBCONVERTFLAGS_COLUMN)
							fSelColumnFlag = TRUE;
						dwSavedConvFlags |= dwSelFlag;
					}

					//Obtain the Correct IConvertType interface
					if(pThis->m_eSource == COMMAND)
					{
						pIConvertType = pCRowset->m_pCCommand->m_pIConvertType;
					}
					else
					{
						pIConvertType = pCRowset->m_pIConvertType;
					}

					//Now Just call IConvertType::CanConvert
					ASSERT(pIConvertType);
					pCListBox->OutputPreMethod("IConvertType::CanConvert(%d=0x%08x, %d=0x%08x, %d)", wSavedFromType, wSavedFromType, wSavedToType, wSavedToType, dwSavedConvFlags);
					hr = pIConvertType->CanConvert(wSavedFromType, wSavedToType, dwSavedConvFlags);
					pCListBox->OutputPostMethod(hr, "IConvertType::CanConvert(%d=0x%08x, %d=0x%08x, %d)", wSavedFromType, wSavedFromType, wSavedToType, wSavedToType, dwSavedConvFlags);
					
					//Now display the results
					//We always want to display the result even on error...
					SendMessageFmt(hWndResult, WM_SETTEXT, 0, " %S", GetErrorName(hr));
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetInterfaceProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetInterfaceProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedSel = 12;	//IOpenRowset

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			LONG iSel = 0;

			HWND hWndMethodName	= GetDlgItem(hWnd, IDT_METHOD);
			HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
			
			//Interface List...
			for(ULONG i=0; i<g_cInterfaceMaps; i++)
			{
				//Interface Name
				iSel = SendMessage(hWndInterface, CB_ADDSTRING,	0, (LPARAM)g_rgInterfaceMap[i].pszName);
				SendMessage(hWndInterface, CB_SETITEMDATA, iSel, (LPARAM)&g_rgInterfaceMap[i]);

				if(pThis->m_iidSource == *(g_rgInterfaceMap[i].pGuid))
					iSavedSel = i;
			}

			//Update Title and Window
			ASSERT(pThis->m_pwszSource);
			SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)pThis->m_pwszSource);
			SendMessage(hWndMethodName, WM_SETTEXT, 0, (LPARAM)pThis->m_pwszSource);
			pThis->m_pwszSource = NULL;

			//Set Default...
			SendMessage(hWndInterface, CB_SETCURSEL, iSavedSel, 0);
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
					
					iSavedSel = SendMessage(hWndInterface, CB_GETCURSEL, 0, 0);
					GUIDMAP* pGuidMap = (GUIDMAP*)SendMessage(hWndInterface, CB_GETITEMDATA, iSavedSel, 0);
					
					//Setup m_iidSource with the selected Guid
					ASSERT(pGuidMap);
					memcpy(&pThis->m_iidSource, pGuidMap->pGuid, sizeof(GUID));
					EndDialog(hWnd, TRUE);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}

							
////////////////////////////////////////////////////////////////
// CMDIChild::OpenRowsetProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::OpenRowsetProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedSel = 30;		//IRowset
	static BOOL fUseProps = TRUE;	//Default to TRUE

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_QUERY_LEN+1];
			szBuffer[0] = EOL;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			LONG iSel = 0;

			HWND hWndTableID	= GetDlgItem(hWnd, IDE_TABLEID);
			HWND hWndIndexID	= GetDlgItem(hWnd, IDE_INDEXID);
			HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);

			//Fill In TableID as Default
			GetEditBoxSelection(pThis->m_hWndEditBox, szBuffer, MAX_QUERY_LEN);
			SendMessage(hWndTableID, WM_SETTEXT, 0, (LPARAM)szBuffer);

			//Use Properties
			CheckDlgButton(hWnd, IDB_USEPROPERTIES,	fUseProps ? BST_CHECKED : BST_UNCHECKED);

			//Interface List...
			for(ULONG i=0; i<g_cInterfaceMaps; i++)
			{
				//Interface Name
				iSel = SendMessage(hWndInterface, CB_ADDSTRING,	0, (LPARAM)g_rgInterfaceMap[i].pszName);
				SendMessage(hWndInterface, CB_SETITEMDATA, iSel, (LPARAM)&g_rgInterfaceMap[i]);
			}

			//Set Default...
			SendMessage(hWndInterface, CB_SETCURSEL, iSavedSel, 0);
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDB_SETPROPERTIES:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;
					pThis->m_pCPropDlg->SetProperties(hWnd, ROWSET, pCRowset->m_pIRowsetInfo, pCDataSource->m_pIDBProperties, &pThis->m_cPropSets, &pThis->m_rgPropSets);
					return 0;
				}

				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndTableID	= GetDlgItem(hWnd, IDE_TABLEID);
					HWND hWndIndexID	= GetDlgItem(hWnd, IDE_INDEXID);
					HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
					WCHAR wszTableName[MAX_QUERY_LEN+1];
					WCHAR wszIndexName[MAX_QUERY_LEN+1];
					HRESULT hr = S_OK;

					ULONG cPropSets = 0;
					DBPROPSET* rgPropSets = NULL;

					//Interface
					iSavedSel = SendMessage(hWndInterface, CB_GETCURSEL, 0, 0);
					GUIDMAP* pGuidMap = (GUIDMAP*)SendMessage(hWndInterface, CB_GETITEMDATA, iSavedSel, 0);
					
					//TableID
					DBID TableID;
					TableID.eKind = DBKIND_NAME;
					TableID.uName.pwszName = wszTableName;
					wSendMessage(hWndTableID, WM_GETTEXT, MAX_QUERY_LEN, wszTableName);

					//IndexID
					DBID IndexID;
					IndexID.eKind = DBKIND_NAME;
					IndexID.uName.pwszName = wszIndexName;
					wSendMessage(hWndIndexID, WM_GETTEXT, MAX_QUERY_LEN, wszIndexName);

					//Use Properties
					fUseProps = IsDlgButtonChecked(hWnd, IDB_USEPROPERTIES);
					if(fUseProps)
					{
						cPropSets = pThis->m_cPropSets;
						rgPropSets = pThis->m_rgPropSets;
					}

					//IOpenRowset::OpenRowset
					hr = pThis->CreateRowset(ROWSET_FROMOPENROWSET, wszTableName[0] ? &TableID : NULL, wszIndexName[0] ? &IndexID : NULL, cPropSets, rgPropSets, *(pGuidMap->pGuid), NULL, 1);
					if(SUCCEEDED(hr))
					{
						//Now just need to place this name in the EditBox
						//Inserted after the current "caret"
						CHAR szBuffer[MAX_QUERY_LEN];
						ConvertToMBCS(wszTableName, szBuffer, MAX_QUERY_LEN);
						ReplaceEditBoxSelection(pThis->m_hWndEditBox, szBuffer);
						EndDialog(hWnd, TRUE);
						return 0;
					}
					
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::AdminCreateDataSourceProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::AdminCreateDataSourceProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedSel = 12;		//IOpenRowset
	static BOOL fUseProps = TRUE;	//Default to TRUE

	static ULONG cAdminPropSets = 0;
	static DBPROPSET* rgAdminPropSets = NULL;

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_QUERY_LEN+1];
			szBuffer[0] = EOL;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			LONG iSel = 0;

			HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);

			//Use Properties
			CheckDlgButton(hWnd, IDB_USEPROPERTIES,	fUseProps ? BST_CHECKED : BST_UNCHECKED);
			cAdminPropSets = 0;
			rgAdminPropSets = NULL;

			//Interface List...
			for(ULONG i=0; i<g_cInterfaceMaps; i++)
			{
				//Interface Name
				iSel = SendMessage(hWndInterface, CB_ADDSTRING,	0, (LPARAM)g_rgInterfaceMap[i].pszName);
				SendMessage(hWndInterface, CB_SETITEMDATA, iSel, (LPARAM)&g_rgInterfaceMap[i]);
			}

			//Set Default...
			SendMessage(hWndInterface, CB_SETCURSEL, iSavedSel, 0);
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDB_SETPROPERTIES:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;
					pThis->m_pCPropDlg->SetProperties(hWnd, DATASOURCEINIT, pCDataSource->m_pIDBProperties, pCDataSource->m_pIDBProperties, &cAdminPropSets, &rgAdminPropSets);
					return 0;
				}

				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;

					HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
					HRESULT hr = S_OK;

					ULONG cPropSets = 0;
					DBPROPSET* rgPropSets = NULL;
					IUnknown* pUnkOuter = NULL;
					IUnknown* pSession = NULL;

					//Interface
					iSavedSel = SendMessage(hWndInterface, CB_GETCURSEL, 0, 0);
					GUIDMAP* pGuidMap = (GUIDMAP*)SendMessage(hWndInterface, CB_GETITEMDATA, iSavedSel, 0);
					
					//Use Properties
					fUseProps = IsDlgButtonChecked(hWnd, IDB_USEPROPERTIES);
					if(fUseProps)
					{
						cPropSets = cAdminPropSets;
						rgPropSets = rgAdminPropSets;
					}

					//IDBDataSourceAdmin::CreateDataSource
					pThis->m_pCListBox->OutputPreMethod("IDBDataSourceAdmin::CreateDataSource(%d, 0x%08x, 0x%08x, %s, 0x%08x)", cPropSets, rgPropSets, pUnkOuter, GetInterfaceName(*(pGuidMap->pGuid)), pSession);
					XTEST(hWnd, hr = pCDataSource->m_pIDBDataSourceAdmin->CreateDataSource(cPropSets, rgPropSets, pUnkOuter, *(pGuidMap->pGuid), &pSession));
					pThis->m_pCListBox->OutputPostMethod(hr, "IDBDataSourceAdmin::CreateDataSource(%d, 0x%08x, 0x%08x, %s, 0x%08x)", cPropSets, rgPropSets, pUnkOuter, GetInterfaceName(*(pGuidMap->pGuid)), pSession);

					//Display Property Errors.
					if(hr == DB_S_ERRORSOCCURRED || hr == DB_E_ERRORSOCCURRED)
						DisplayPropErrors(hWnd, cPropSets, rgPropSets);

					//Release
					SAFE_RELEASE(pSession);
					if(SUCCEEDED(hr))
					{	
						FreeProperties(&cAdminPropSets, &rgAdminPropSets);
						EndDialog(hWnd, TRUE);
						return 0;
					}
					
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					FreeProperties(&cAdminPropSets, &rgAdminPropSets);
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::DropIndexProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::DropIndexProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_QUERY_LEN+1];
			szBuffer[0] = EOL;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);

			HWND hWndTableID	= GetDlgItem(hWnd, IDE_TABLEID);
			HWND hWndIndexID	= GetDlgItem(hWnd, IDE_INDEXID);

			//Fill In TableID as Default
			GetEditBoxSelection(pThis->m_hWndEditBox, szBuffer, MAX_QUERY_LEN);
			SendMessage(hWndTableID, WM_SETTEXT, 0, (LPARAM)szBuffer);

			//Fill In IndexID as Default
			SendMessage(hWndIndexID, WM_SETTEXT, 0, (LPARAM)szBuffer);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CSession* pCSession = pThis->m_pCRowset->m_pCSession;
					HWND hWndTableID	= GetDlgItem(hWnd, IDE_TABLEID);
					HWND hWndIndexID	= GetDlgItem(hWnd, IDE_INDEXID);
					WCHAR wszTableName[MAX_QUERY_LEN+1];
					WCHAR wszIndexName[MAX_QUERY_LEN+1];
					WCHAR wszTableDBID[MAX_QUERY_LEN+1];
					WCHAR wszIndexDBID[MAX_QUERY_LEN+1];
					HRESULT hr = S_OK;

					//TableID
					DBID TableID;
					TableID.eKind = DBKIND_NAME;
					TableID.uName.pwszName = wszTableName;
					wSendMessage(hWndTableID, WM_GETTEXT, MAX_QUERY_LEN, wszTableName);
					DBIDToString(&TableID, wszTableDBID, MAX_QUERY_LEN);

					//IndexID
					DBID IndexID;
					IndexID.eKind = DBKIND_NAME;
					IndexID.uName.pwszName = wszIndexName;
					wSendMessage(hWndIndexID, WM_GETTEXT, MAX_QUERY_LEN, wszIndexName);
					DBIDToString(&IndexID, wszIndexDBID, MAX_QUERY_LEN);

					//IIndexDefinition::DropIndex
					pThis->m_pCListBox->OutputPreMethod("IIndexDefinition::DropIndex(%S, %S)", wszTableDBID, wszIndexDBID);
					XTEST(hWnd, hr = pCSession->m_pIIndexDefinition->DropIndex(&TableID, &IndexID));
					pThis->m_pCListBox->OutputPostMethod(hr, "IIndexDefinition::DropIndex(%S, %S)", wszTableDBID, wszIndexDBID);
					
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
						return 0;
					}
					
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::DropTableProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::DropTableProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_QUERY_LEN+1];
			szBuffer[0] = EOL;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			HWND hWndTableID	= GetDlgItem(hWnd, IDE_TABLEID);

			//Fill In TableID as Default
			GetEditBoxSelection(pThis->m_hWndEditBox, szBuffer, MAX_QUERY_LEN);
			SendMessage(hWndTableID, WM_SETTEXT, 0, (LPARAM)szBuffer);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CSession* pCSession = pThis->m_pCRowset->m_pCSession;
					HWND hWndTableID	= GetDlgItem(hWnd, IDE_TABLEID);
					WCHAR wszTableName[MAX_QUERY_LEN+1];
					WCHAR wszTableDBID[MAX_QUERY_LEN+1];
					HRESULT hr = S_OK;

					//TableID
					DBID TableID;
					TableID.eKind = DBKIND_NAME;
					TableID.uName.pwszName = wszTableName;
					wSendMessage(hWndTableID, WM_GETTEXT, MAX_QUERY_LEN, wszTableName);
					DBIDToString(&TableID, wszTableDBID, MAX_QUERY_LEN);

					//ITableDefinition::DropTable
					pThis->m_pCListBox->OutputPreMethod("ITableDefinition::DropTable(%S)", wszTableDBID);
					XTEST(hWnd, hr = pCSession->m_pITableDefinition->DropTable(&TableID));
					pThis->m_pCListBox->OutputPostMethod(hr, "ITableDefinition::DropTable(%S)", wszTableDBID);
					
					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
						return 0;
					}
					
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ExecuteProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::ExecuteProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedSel = 30;			//IRowset
	static BOOL fUseParams = FALSE;		//Default to FALSE

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_QUERY_LEN];
			szBuffer[0] = EOL;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			DWORD dwCommandOpts = pThis->GetOptionsObj()->m_dwCommandOpts;
			LONG iSel = 0;

			HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
			HWND hWndCmdText	= GetDlgItem(hWnd, IDE_COMMANDTEXT);

			//Fill In CommandText as Default
			GetEditBoxSelection(pThis->m_hWndEditBox, szBuffer, MAX_QUERY_LEN);
			SendMessage(hWndCmdText, WM_SETTEXT, 0, (LPARAM)szBuffer);

			//Use Parameters
			CheckDlgButton(hWnd, IDB_USEPARAMS,	fUseParams ? BST_CHECKED : BST_UNCHECKED);
			//SetCommandText
			CheckDlgButton(hWnd, IDB_SETCOMMANDTEXT, dwCommandOpts & COMMAND_NOCOMMANDTEXT ? BST_UNCHECKED : BST_CHECKED);

			//Interface List...
			for(ULONG i=0; i<g_cInterfaceMaps; i++)
			{
				//Interface Name
				iSel = SendMessage(hWndInterface, CB_ADDSTRING,	0, (LPARAM)g_rgInterfaceMap[i].pszName);
				SendMessage(hWndInterface, CB_SETITEMDATA, iSel, (LPARAM)&g_rgInterfaceMap[i]);
			}

			//Set Default...
			SendMessage(hWndInterface, CB_SETCURSEL, iSavedSel, 0);
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDB_SETPARAMS:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;
					
					//Setup Parameters
					DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_PARAMEXECUTE), hWnd, ParamExecuteProc, (LPARAM)pThis);
					return 0;
				}

				case IDB_SETPROPERTIES:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CCommand* pCCommand = pCRowset->m_pCCommand;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;
				
					//We should release the Previous Rowset at this point
					//So user doesn't Get DB_E_OPENOBJECT
					if(pThis->GetOptionsObj()->m_dwCommandOpts & COMMAND_RELEASEROWSET)
					{
						pCRowset->ReleaseRowset();
						pThis->RefreshControls();
					}	
					
					//ICommandProperties::SetProperties
					pThis->m_pCPropDlg->SetProperties(hWnd, COMMAND, pCCommand->m_pICommandProperties, pCDataSource->m_pIDBProperties);
					return 0;
				}

				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
					HWND hWndCmdText	= GetDlgItem(hWnd, IDE_COMMANDTEXT);
					WCHAR wszBuffer[MAX_QUERY_LEN];
					wszBuffer[0] = wEOL;
					HRESULT hr = S_OK;

					//Command Text
					DBID TableID;
					TableID.eKind = DBKIND_NAME;
					TableID.uName.pwszName = wszBuffer;
					wSendMessage(hWndCmdText, WM_GETTEXT, MAX_QUERY_LEN, wszBuffer);

					//Interface
					iSavedSel = SendMessage(hWndInterface, CB_GETCURSEL, 0, 0);
					GUIDMAP* pGuidMap = (GUIDMAP*)SendMessage(hWndInterface, CB_GETITEMDATA, iSavedSel, 0);
					
					//Use Parameters
					fUseParams = IsDlgButtonChecked(hWnd, IDB_USEPARAMS);
					//SetCommandText
					ENABLE_BIT(pThis->GetOptionsObj()->m_dwCommandOpts, COMMAND_NOCOMMANDTEXT, IsDlgButtonChecked(hWnd, IDB_SETCOMMANDTEXT)==BST_UNCHECKED);

					//Execute the Command
					TESTC(hr = pThis->CreateRowset(fUseParams ? ROWSET_FROMCOMMANDWITHPARAMETERS : ROWSET_FROMCOMMAND, &TableID, NULL, 0, NULL, *(pGuidMap->pGuid)));
					
				CLEANUP:
					if(SUCCEEDED(hr))
					{
						//Now just need to place this name in the EditBox
						//Inserted after the current "caret"
						CHAR szBuffer[MAX_QUERY_LEN];
						ConvertToMBCS(wszBuffer, szBuffer, MAX_QUERY_LEN);
						ReplaceEditBoxSelection(pThis->m_hWndEditBox, szBuffer);
						EndDialog(hWnd, TRUE);
					}

					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::SetCommandTextProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::SetCommandTextProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static BOOL fRelPrevRowset = TRUE;
	
	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();
			CHAR szBuffer[MAX_QUERY_LEN];
			szBuffer[0] = EOL;

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			COptionsDlg* pCOptionsDlg = pThis->GetOptionsObj();
			HWND hWndDialect	= GetDlgItem(hWnd, IDC_DIALECT);
			HWND hWndCmdText	= GetDlgItem(hWnd, IDE_COMMANDTEXT);

			//Fill in GuidDialect as Default
			const static GUIDMAP g_rgDialect[] = 
			{
				& VALUE_CHAR(DBGUID_DEFAULT),
				& VALUE_CHAR(DBGUID_DBSQL),
				& VALUE_CHAR(DBGUID_SQL),
			};
			const static ULONG g_cDialect = NUMELE(g_rgDialect);

			//Fill-in Dialect Combo
			for(ULONG i=0; i<g_cDialect; i++)
			{
				LONG iSel = SendMessage(hWndDialect, CB_ADDSTRING, 0, (LPARAM)g_rgDialect[i].pszName);
				iSel = SendMessage(hWndDialect, CB_SETITEMDATA, iSel, (LPARAM)g_rgDialect[i].pGuid);
			}
			
			//Select Saved Dialect
			CB_SelectText(hWndDialect, pCOptionsDlg->m_wszDialect, FALSE);
			
			//Fill In CommandText as Default
			GetEditBoxSelection(pThis->m_hWndEditBox, szBuffer, MAX_QUERY_LEN);
			SendMessage(hWndCmdText, WM_SETTEXT, 0, (LPARAM)szBuffer);

			//Release Previous Rowset Option
			CheckDlgButton(hWnd, IDB_RELEASEPREVROWSET,	fRelPrevRowset ? BST_CHECKED : BST_UNCHECKED);

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					COptionsDlg* pCOptionsDlg = pThis->GetOptionsObj();
					CRowset* pCRowset = pThis->m_pCRowset;
					CCommand* pCCommand = pCRowset->m_pCCommand;

					HWND hWndDialect	= GetDlgItem(hWnd, IDC_DIALECT);
					HWND hWndCmdText	= GetDlgItem(hWnd, IDE_COMMANDTEXT);
					WCHAR wszBuffer[MAX_QUERY_LEN];
					wszBuffer[0] = wEOL;
					HRESULT hr = S_OK;

					//Get Guid Dialect					
					LONG iSel = CB_GetSelectedText(hWndDialect, pCOptionsDlg->m_wszDialect, MAX_NAME_LEN);
					if(iSel != CB_ERR)
					{
						//Get ItemData which is the Guid Pointer
						GUID* pGuid = (GUID*)SendMessage(hWndDialect, CB_GETITEMDATA, iSel, 0);
						ASSERT(pGuid && (LONG)pGuid!=CB_ERR);
						memcpy(&pCOptionsDlg->m_guidDialect, pGuid, sizeof(GUID));
					}
					else
					{
						//Convert Users String to a Guid
						XTESTC(hWnd, hr = CLSIDFromString(pCOptionsDlg->m_wszDialect, &pCOptionsDlg->m_guidDialect));
						if(FAILED(hr)) 
						{
							wcscpy(pCOptionsDlg->m_wszDialect, L"DBGUID_DEFAULT");
							memcpy(&pCOptionsDlg->m_guidDialect, &DBGUID_DEFAULT, sizeof(GUID));
						}
					}
					
					//Release Previous Rowset Option
					fRelPrevRowset = IsDlgButtonChecked(hWnd, IDB_RELEASEPREVROWSET);
					if(fRelPrevRowset)
					{
						pCRowset->ReleaseRowset();
						pThis->RefreshControls();
					}	

					//ICommand::SetCommandText
					wSendMessage(hWndCmdText, WM_GETTEXT, MAX_QUERY_LEN, wszBuffer);
					TESTC(hr = pCCommand->SetCommandText(wszBuffer));
					
				CLEANUP:
					if(SUCCEEDED(hr))
					{
						//Now just need to place this name in the EditBox
						//Inserted after the current "caret"
						CHAR szBuffer[MAX_QUERY_LEN];
						ConvertToMBCS(wszBuffer, szBuffer, MAX_QUERY_LEN);
						ReplaceEditBoxSelection(pThis->m_hWndEditBox, szBuffer);
						EndDialog(hWnd, TRUE);
					}

					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetColumnsRowsetProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetColumnsRowsetProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedSel = 30;			//IRowset
	static BOOL fUseProps = FALSE;		//Default
	static BOOL fOptColumns = TRUE;	//Default

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			LONG iSel = 0;
			HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);

			//Use Optional Columns
			CheckDlgButton(hWnd, IDB_USEOPTCOLUMNS,	fOptColumns ? BST_CHECKED : BST_UNCHECKED);
			//Use Properties
			CheckDlgButton(hWnd, IDB_USEPROPERTIES,	fUseProps ? BST_CHECKED : BST_UNCHECKED);

			//Interface List...
			for(ULONG i=0; i<g_cInterfaceMaps; i++)
			{
				//Interface Name
				iSel = SendMessage(hWndInterface, CB_ADDSTRING,	0, (LPARAM)g_rgInterfaceMap[i].pszName);
				SendMessage(hWndInterface, CB_SETITEMDATA, iSel, (LPARAM)&g_rgInterfaceMap[i]);
			}

			//Set Default...
			SendMessage(hWndInterface, CB_SETCURSEL, iSavedSel, 0);
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDB_SETPROPERTIES:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;
					pThis->m_pCPropDlg->SetProperties(hWnd, ROWSET, pCRowset->m_pIRowsetInfo, pCDataSource->m_pIDBProperties, &pThis->m_cPropSets, &pThis->m_rgPropSets);
					return 0;
				}

				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
					HRESULT hr = S_OK;

					ULONG cPropSets = 0;
					DBPROPSET* rgPropSets = NULL;

					//Interface
					iSavedSel = SendMessage(hWndInterface, CB_GETCURSEL, 0, 0);
					GUIDMAP* pGuidMap = (GUIDMAP*)SendMessage(hWndInterface, CB_GETITEMDATA, iSavedSel, 0);
					
					//Use Properties
					fUseProps = IsDlgButtonChecked(hWnd, IDB_USEPROPERTIES);
					if(fUseProps)
					{
						cPropSets = pThis->m_cPropSets;
						rgPropSets = pThis->m_rgPropSets;
					}

					//Use Optional Columns
					fOptColumns = IsDlgButtonChecked(hWnd, IDB_USEOPTCOLUMNS);
					
					//IColumnsRowset::GetColumnsRowset
					hr = pThis->CreateRowset(pThis->m_eSource == COMMAND ? ROWSET_FROMCOMMANDCOLUMNSROWSET : ROWSET_FROMROWSETCOLUMNSROWSET, NULL, NULL, cPropSets, rgPropSets, *(pGuidMap->pGuid), NULL, fOptColumns);

					//Have to exit, even if failure.  The failure can happen at any
					//point, ie: during accessor creation.  So we end up with a 
					//valid rowset, but not neccessaryliy something that supports 
					//IColumnsRowset...
					EndDialog(hWnd, TRUE);
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::GetSourcesRowsetProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::GetSourcesRowsetProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG iSavedSel = 30;			//IRowset
	static BOOL fUseProps = FALSE;		//Default

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			LONG iSel = 0;
			HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);

			//Use Properties
			CheckDlgButton(hWnd, IDB_USEPROPERTIES,	fUseProps ? BST_CHECKED : BST_UNCHECKED);

			//Interface List...
			for(ULONG i=0; i<g_cInterfaceMaps; i++)
			{
				//Interface Name
				iSel = SendMessage(hWndInterface, CB_ADDSTRING,	0, (LPARAM)g_rgInterfaceMap[i].pszName);
				SendMessage(hWndInterface, CB_SETITEMDATA, iSel, (LPARAM)&g_rgInterfaceMap[i]);
			}

			//Set Default...
			SendMessage(hWndInterface, CB_SETCURSEL, iSavedSel, 0);
			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDB_SETPROPERTIES:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CDataSource* pCDataSource = pCRowset->m_pCDataSource;
					pThis->m_pCPropDlg->SetProperties(hWnd, ROWSET, pCRowset->m_pIRowsetInfo, pCDataSource->m_pIDBProperties, &pThis->m_cPropSets, &pThis->m_rgPropSets);
					return 0;
				}

				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					HWND hWndInterface	= GetDlgItem(hWnd, IDC_INTERFACE);
					HRESULT hr = S_OK;

					ULONG cPropSets = 0;
					DBPROPSET* rgPropSets = NULL;

					//Interface
					iSavedSel = SendMessage(hWndInterface, CB_GETCURSEL, 0, 0);
					GUIDMAP* pGuidMap = (GUIDMAP*)SendMessage(hWndInterface, CB_GETITEMDATA, iSavedSel, 0);
					
					//Use Properties
					fUseProps = IsDlgButtonChecked(hWnd, IDB_USEPROPERTIES);
					if(fUseProps)
					{
						cPropSets = pThis->m_cPropSets;
						rgPropSets = pThis->m_rgPropSets;
					}

					//ISourcesRowset::GetSourcesRowset
					hr = pThis->CreateRowset(ROWSET_FROMENUM, NULL, NULL, cPropSets, rgPropSets, *(pGuidMap->pGuid));
					
					EndDialog(hWnd, TRUE);
					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::FindNextRowProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::FindNextRowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LONG	iSavedCol	= 1;		//Default column
	static LONG	iSavedOp	= 2;		//Default DBCOMPAREOPS_EQ
	static LONG	cSavedRows	= 1;		//Default to cRows=1

	switch(message)
	{
		case WM_INITDIALOG:
		{
			EXC_BEGIN
			Busy();

			//Save the "this" pointer
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CRowset* pCRowset = pThis->m_pCRowset;
			LONG iSel = 0;
			
			HWND hWndColumn		= GetDlgItem(hWnd, IDC_COLUMN);
			HWND hWndCompareOp	= GetDlgItem(hWnd, IDC_COMPAREOP);
			HWND hWndcRows		= GetDlgItem(hWnd, IDE_CROWS);
			HWND hWndValue		= GetDlgItem(hWnd, IDE_VALUE);

			//Column List...
			for(ULONG i=0; i<pCRowset->m_cBindings; i++)
			{
				//Column Ordinal - Column Name
				ULONG iOrdinal = pCRowset->m_rgBindings[i].iOrdinal;
				iSel = wSendMessageFmt(hWndColumn, CB_ADDSTRING,	0, L"%2d - %s", iOrdinal, pCRowset->GetColName(iOrdinal));
				SendMessage(hWndColumn, CB_SETITEMDATA, iSel, (LPARAM)i);
			}

			//Set Default...
			SendMessage(hWndColumn, CB_SETCURSEL, iSavedCol < (LONG)pCRowset->m_cBindings && iSavedCol!=CB_ERR ? iSavedCol : 0, 0);
			
			const static NAMEMAP rgCompareOps[] = 
			{
				VALUE_CHAR(DBCOMPAREOPS_LT),
				VALUE_CHAR(DBCOMPAREOPS_LE),
				VALUE_CHAR(DBCOMPAREOPS_EQ),
				VALUE_CHAR(DBCOMPAREOPS_GE),
				VALUE_CHAR(DBCOMPAREOPS_GT),
				VALUE_CHAR(DBCOMPAREOPS_BEGINSWITH),
				VALUE_CHAR(DBCOMPAREOPS_CONTAINS),
				VALUE_CHAR(DBCOMPAREOPS_NE),
				VALUE_CHAR(DBCOMPAREOPS_IGNORE),
				VALUE_CHAR(DBCOMPAREOPS_CASESENSITIVE),
				VALUE_CHAR(DBCOMPAREOPS_CASEINSENSITIVE),
				VALUE_CHAR(DBCOMPAREOPS_NOTBEGINSWITH),
				VALUE_CHAR(DBCOMPAREOPS_NOTCONTAINS),
			};
			
			//CompareOp List...
			for(i=0; i<NUMELE(rgCompareOps); i++)
			{
				iSel = SendMessage(hWndCompareOp, CB_ADDSTRING,	0, (LPARAM)rgCompareOps[i].pszName);
				SendMessage(hWndCompareOp, CB_SETITEMDATA, iSel, (LPARAM)rgCompareOps[i].lItem);
			}

			//Set Default...
			iSavedOp = SendMessage(hWndCompareOp, CB_SETCURSEL, iSavedOp != CB_ERR ? iSavedOp : 0, 0);
			
			//cRows
			SendMessageFmt(hWndcRows, WM_SETTEXT, 0, "%d", cSavedRows);

			//Value
			SendMessage(hWndValue, WM_SETTEXT, 0, (LPARAM)"");

			CenterDialog(hWnd);
			Busy(OFF);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					CRowset* pCRowset = pThis->m_pCRowset;
					CListBox* pCListBox = pThis->m_pCListBox;
					HRESULT hr = S_OK;
					
					HWND hWndColumn		= GetDlgItem(hWnd, IDC_COLUMN);
					HWND hWndCompareOp	= GetDlgItem(hWnd, IDC_COMPAREOP);
					HWND hWndcRows		= GetDlgItem(hWnd, IDE_CROWS);
					HWND hWndValue		= GetDlgItem(hWnd, IDE_VALUE);

					CHAR szBuffer[MAX_QUERY_LEN];
					HACCESSOR hAccessor = NULL;

					//Bookmark
					ULONG cbBookmark = 0;
					BYTE* pBookmark = NULL;
					void* pBookmarkData = NULL;

					HROW hRow = NULL;
					void* pData = pCRowset->m_pData;
					LONG lOffset = 0;
					ULONG cRowsObtained = 0;
					HROW* rghRows = NULL;
					LONG iSelRow = 0;
					
					//Column
					iSavedCol = SendMessage(hWndColumn, CB_GETCURSEL, 0, 0);
					ULONG iBinding = (ULONG)SendMessage(hWndColumn, CB_GETITEMDATA, iSavedCol!=CB_ERR ? iSavedCol : 0, 0);
					DBBINDING* pBinding = &pCRowset->m_rgBindings[iBinding];
					 
					//CompareOp
					iSavedOp = SendMessage(hWndCompareOp, CB_GETCURSEL, 0, 0);
					DBCOMPAREOP dwCompareOp = (DBCOMPAREOP)SendMessage(hWndCompareOp, CB_GETITEMDATA, iSavedOp != CB_ERR ? iSavedOp : 0, 0);
					
					//cRows
					GetEditBoxValue(hWndcRows, 0, LONG_MAX, &cSavedRows, FALSE);
					
					//Value
					SendMessage(hWndValue, WM_GETTEXT, MAX_QUERY_LEN, (LPARAM)szBuffer);
					
					//Create An Accessor binding only this column
					TESTC(pCRowset->CreateAccessor(DBACCESSOR_ROWDATA, 1, pBinding, 0, &hAccessor));

					//Setup the pData buffer containg the users value
					TESTC(hr = pCRowset->SetColumnData(pBinding, pData, DBSTATUS_S_OK, szBuffer));

					//Obtain the First selected Row (to use as a bookmark)
					iSelRow = SendMessage(pThis->m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
					hRow = LV_GetItemParam(pThis->m_hWndListView, iSelRow, 0);

					//Obtain the bookmark(s) for the selected row(s)...
					if(iSelRow!=LVM_ERR)
					{
						hr = pCRowset->GetBookmark(hRow, &cbBookmark, (BYTE**)&pBookmark, &pBookmarkData);
					}

					//IRowsetFind::FindNextRow
					TESTC(pCListBox->OutputPreMethod("IRowsetFind::FindNextRow(NULL, 0x%08x, \"%s\", %d, %d, 0x%08x, %d, %d, &%d, &0x%08x)", hAccessor, szBuffer, dwCompareOp, cbBookmark, pBookmark, lOffset, cSavedRows,  cRowsObtained, rghRows));
					XTEST(hWnd, hr = pCRowset->m_pIRowsetFind->FindNextRow(NULL, hAccessor, pData, dwCompareOp, cbBookmark, pBookmark, lOffset, cSavedRows, &cRowsObtained, &rghRows));
					TESTC(pCListBox->OutputPostMethod(hr, "IRowsetFind::FindNextRow(NULL, 0x%08x, \"%s\", %d, %d, 0x%08x, %d, %d, &%d, &0x%08x)", hAccessor, szBuffer, dwCompareOp, cbBookmark, pBookmark, lOffset, cSavedRows,  cRowsObtained, rghRows));

				CLEANUP:
					pCRowset->ReleaseAccessor(&hAccessor);
					SAFE_FREE(pBookmarkData);
					SAFE_FREE(rghRows);

					if(SUCCEEDED(hr))
					{
						EndDialog(hWnd, TRUE);
						return 0;
					}

					SetFocus(hWnd);
					return 0;
				}

				case IDCANCEL:
				{
					EndDialog(hWnd, FALSE);
					return 0;
				}
			}
			break;
		}//WM_COMMAND
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::DumpRow
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::DumpRow
(
	HROW			hRow,
	ULONG			cBindings,
	DBBINDING*		rgBindings,
	void*			pData,
	ULONG			iIndex
    )
{
	HRESULT hr = S_OK;
	
	DWORD dwStatus = 0;
	DWORD dwLength = 0;
	DBBINDING* pBinding = NULL;
	DBCOLUMNINFO* pColInfo = NULL;
	CHAR szBuffer[MAX_COL_SIZE+1];
	DWORD dwConvFlags = GetOptionsObj()->m_dwConvFlags; 

	//First, Set Text and save hRow
//	sprintf(szBuffer, "0x%x", hRow);
//	LV_SetItemText(m_hWndListView, iIndex, 0, szBuffer);
//	LV_SetItemParam(m_hWndListView, iIndex, 0, hRow);

	//Display all Columns
	for(ULONG i=0; i<cBindings; i++)
	{
		ASSERT(rgBindings);
		ASSERT(pData);

		//Obtain STATUS, LENGTH, VALUE
		pBinding = &rgBindings[i];
		pColInfo = m_pCRowset->GetColInfo(pBinding->iOrdinal);
		hr = m_pCRowset->GetColumnData(pBinding, pData, &dwStatus, &dwLength, NULL, szBuffer, MAX_COL_SIZE, dwConvFlags, pColInfo->wType);

		//Set item in ListView
	   	LV_SetItemText(m_hWndListView, iIndex, i+1, szBuffer);
		LV_SetItemImage(m_hWndListView, iIndex, i+1, GetColumnImage(NULL, dwStatus));
		
		//Clean outof memory data
		if(SUCCEEDED(hr))
			FreeBindingData(1, pBinding, pData);
		hr = S_OK;
	}

	return hr;
}


////////////////////////////////////////////////////////////////
// BOOL CMDIChild::WantedMenuPos
//
/////////////////////////////////////////////////////////////////
BOOL CMDIChild::WantedMenuPos(HMENU hMenu, UINT uPos, DWORD* pdwFlags)
{
	ASSERT(pdwFlags);
	*pdwFlags = 0;
	
	ULONG ulMenuID = GetMenuItemID(hMenu, uPos);

	//SubMenu
	if(ulMenuID == ULONG_MAX)
	{
		//Recursive Alogorytm
		HMENU hSubMenu = GetSubMenu(hMenu, uPos);
		INT iItems = GetMenuItemCount(hSubMenu);
		for(LONG i=0; i<iItems; i++)
		{
			if(WantedMenuPos(hSubMenu, i, pdwFlags))
			{
				*pdwFlags = 0;
				return TRUE;
			}
		}
	
		return FALSE;
	}
	
	//Make our lives a little easier...
	CListBox*		pCListBox	= m_pCListBox;
	CRowset*		pCRowset	= m_pCRowset; 
	CDataSource*	pCDataSource= pCRowset->m_pCDataSource; 
	CSession*		pCSession	= pCRowset->m_pCSession; 
	CCommand*		pCCommand	= pCRowset->m_pCCommand; 
	CRowPos*		pCRowPos	= pCRowset->m_pCRowPos; 
	CTransaction*	pCTransaction = pCSession->m_pCTransaction;

	//Item
	switch(ulMenuID)
	{
		//Edit Window
		case IDMENU_CUTEDITWINDOW:
		case IDMENU_COPYEDITWINDOW:
		case IDMENU_PASTEEDITWINDOW:
		case IDMENU_CLEAREDITWINDOW:
			return TRUE;

		//Notification Window
		case IDMENU_CUTNOTIFYWINDOW:
		case IDMENU_COPYNOTIFYWINDOW:
		case IDMENU_PASTENOTIFYWINDOW:
		case IDMENU_CLEARNOTIFYWINDOW:
			return TRUE;

		//Menu Items that are always on
		case IDMENU_PROVIDERINFO:
		case IDMENU_BROWSE_TABLENAME:
			return TRUE;

		//Errors
		case IDMENU_GETERRORINFO:
		case IDMENU_SETERRORINFO:
		case IDMENU_DISPLAYERRORINFO:
			return TRUE;

		//IErrorInfo
		case IDMENU_ERROR_ADDREF:
		case IDMENU_ERROR_RELEASE:
		case IDMENU_ERROR_QUERYINTERFACE:
		case IDMENU_ERROR_RELEASEALL:
			return (BOOL)m_pCError->m_pIUnknown;

		//IErrorInfo
		case IDMENU_ERRORINFO_GETDESCRIPTION:
			return (BOOL)m_pCError->m_pIErrorInfo;

		//IErrorRecords
		case IDMENU_ERRORRECORDS_GETRECORDCOUNT:
			return (BOOL)m_pCError->m_pIErrorRecords;

		//IDataInitialize
		case IDMENU_IDATAINITIALIZE_GETINITIALIZATIONSTRING:
		case IDMENU_IDATAINITIALIZE_GETINITIALIZATIONSTRING_NOPASSWORD:
		case IDMENU_IDATAINITIALIZE_WRITESTRINGTOSTORAGE:
			return GetConnectObj()->pIDataInitialize() && pCDataSource->m_pIUnknown;
				
		//Menu items that are dependent upon interfaces
		case IDMENU_INITIALIZE:
		case IDMENU_UNINITIALIZE:
			return (BOOL)pCDataSource->m_pIDBInitialize;
		
		case IDMENU_DATASOURCE_ADDREF: 
		case IDMENU_DATASOURCE_RELEASE: 
		case IDMENU_DATASOURCE_QUERYINTERFACE: 
		case IDMENU_DATASOURCE_RELEASEALL: 
			return (BOOL)pCDataSource->m_pIUnknown && !pCDataSource->m_pISourcesRowset;

		case IDMENU_GETPROPERTYINFO:
		case IDMENU_DATASOURCE_GETPROPERTIES:
		case IDMENU_DATASOURCE_SETPROPERTIES:
			return (BOOL)pCDataSource->m_pIDBProperties && !pCDataSource->m_pISourcesRowset;

		case IDMENU_PERSIST_GETCLASSID:
			return (BOOL)pCDataSource->m_pIPersist;

		case IDMENU_PERSISTFILE_LOAD: 
		case IDMENU_PERSISTFILE_SAVE: 
		case IDMENU_PERSISTFILE_SAVECOMPLETED: 
		case IDMENU_PERSISTFILE_GETCURFILE: 
		case IDMENU_PERSISTFILE_ISDIRTY: 
			return (BOOL)pCDataSource->m_pIPersistFile;

		case IDMENU_GETSOURCESROWSET:
			return (BOOL)pCDataSource->m_pISourcesRowset;

		case IDMENU_CREATESESSION:
		case IDMENU_CREATESESSIONWINDOW:
			return (BOOL)pCDataSource->m_pIDBCreateSession;
		
		case IDMENU_GETKEYWORDS:
		case IDMENU_GETLITERALINFO:
			return (BOOL)pCDataSource->m_pIDBInfo;

		//IDBDataSourceAdmin
		case IDMENU_DATASOURCEADMIN_CREATEDATASOURCE:
		case IDMENU_DATASOURCEADMIN_DESTROYDATASOURCE:
		case IDMENU_DATASOURCEADMIN_GETCREATIONPROPERTIES:
		case IDMENU_DATASOURCEADMIN_MODIFYDATASOURCE:
			return (BOOL)pCDataSource->m_pIDBDataSourceAdmin;

		case IDMENU_OPENROWSET: 
			return (BOOL)pCSession->m_pIOpenRowset;

		case IDMENU_SESSION_ADDREF: 
		case IDMENU_SESSION_RELEASE: 
		case IDMENU_SESSION_QUERYINTERFACE: 
		case IDMENU_SESSION_RELEASEALL: 
			return (BOOL)pCSession->m_pIUnknown;

		case IDMENU_SESSION_GETPROPERTIES:
		case IDMENU_SESSION_SETPROPERTIES:
			return (BOOL)pCSession->m_pISessionProperties;

		case IDMENU_GETDATASOURCE: 
			return (BOOL)pCSession->m_pIGetDataSource;

		case IDMENU_COMMAND_GETCOLUMNSROWSET:
			return (BOOL)pCCommand->m_pIColumnsRowset;

		case IDMENU_ROWSET_GETCOLUMNSROWSET:
			return (BOOL)pCRowset->m_pIColumnsRowset;

		case IDMENU_GETSCHEMAS:
		case IDMENU_GETSCHEMAROWSET:
			return (BOOL)pCSession->m_pIDBSchemaRowset;
		
		//CommandWithParameters
		case IDMENU_GETPARAMETERINFO: 
		case IDMENU_SETPARAMETERINFO: 
//		case IDMENU_MAPPARAMETERNAMES: 
			return (BOOL)pCCommand->m_pICommandWithParameters;

		//Command Accessor
		case IDMENU_COMMAND_ACCESSOR_GETBINDINGS: 
		case IDMENU_COMMAND_ACCESSOR_ADDREFACCESSOR: 
		case IDMENU_COMMAND_ACCESSOR_RELEASEACCESSOR: 
		case IDMENU_COMMAND_ACCESSOR_CREATEACCESSOR: 
			return (BOOL)pCCommand->m_pIAccessor;


		//Rowset Accessor
		case IDMENU_ROWSET_ACCESSOR_GETBINDINGS: 
		case IDMENU_ROWSET_ACCESSOR_ADDREFACCESSOR: 
		case IDMENU_ROWSET_ACCESSOR_RELEASEACCESSOR: 
		case IDMENU_ROWSET_ACCESSOR_CREATEACCESSOR: 
			return (BOOL)pCRowset->m_pIAccessor;

		case IDMENU_TRANSACTIONLOCAL_ABORT:
		case IDMENU_TRANSACTIONLOCAL_COMMIT:
		case IDMENU_TRANSACTIONLOCAL_GETTRANSACTIONINFO:
		case IDMENU_TRANSACTIONLOCAL_GETOPTIONSOBJECT:
		case IDMENU_TRANSACTIONLOCAL_STARTTRANSACTION:
			return (BOOL)pCSession->m_pITransactionLocal;

		case IDMENU_TRANSACTIONOBJECT_GETTRANSACTIONOBJECT:
			return (BOOL)pCSession->m_pITransactionObject;
		case IDMENU_TRANSACTIONJOIN_GETOPTIONSOBJECT:
			return (BOOL)pCSession->m_pITransactionJoin;
		case IDMENU_TRANSACTIONJOIN_JOINTRANSACTION:
			return (BOOL)pCSession->m_pITransactionJoin || !m_pCMainWindow->m_listTransactions.IsEmpty();

#ifdef TXNJOIN			//MTS SDK
  		case IDMENU_MTS_TRANSACTION_ABORT:
  		case IDMENU_MTS_TRANSACTION_COMMIT:
  		case IDMENU_MTS_TRANSACTION_GETTRANSACTIONINFO:
  		case IDMENU_MTS_FREETRANSACTION:
  			return !m_pCMainWindow->m_listTransactions.IsEmpty();

		case IDMENU_ITRANSACTIONJOIN_TRANSACTIONDISPENSOR_BEGINTRANSACTION:
  			return TRUE;
#endif					//TXNJOIN
 
		case IDMENU_TRANSACTION_ADDREF: 
		case IDMENU_TRANSACTION_RELEASE: 
		case IDMENU_TRANSACTION_QUERYINTERFACE: 
		case IDMENU_TRANSACTION_RELEASEALL: 
			return (BOOL)pCTransaction->m_pIUnknown;

		case IDMENU_TRANSACTION_ABORT:
		case IDMENU_TRANSACTION_COMMIT:
		case IDMENU_TRANSACTION_GETTRANSACTIONINFO:
			return (BOOL)pCTransaction->m_pITransaction;

		case IDMENU_TRANSACTION_SUPPORTERRORINFO:
			return (BOOL)pCTransaction->m_pISupportErrorInfo;

		case IDMENU_TRANSACTIONOPTIONS_GETOPTIONS:
		case IDMENU_TRANSACTIONOPTIONS_SETOPTIONS:
			return (BOOL)pCTransaction->m_pITransactionOptions;

		case IDMENU_COMMAND_GETPROPERTIES:
		case IDMENU_COMMAND_SETPROPERTIES:
			return (BOOL)pCCommand->m_pICommandProperties;

		case IDMENU_CREATECOMMAND:
		case IDMENU_CREATECOMMANDWINDOW:
			return (BOOL)pCSession->m_pIDBCreateCommand;

		case IDMENU_COMMAND_CANCONVERT:
			return (BOOL)pCCommand->m_pIConvertType;

		case IDMENU_SETCOMMANDTEXT:
		case IDMENU_GETCOMMANDTEXT:
			return (BOOL)pCCommand->m_pICommandText;

		case IDMENU_COMMAND_GETCOLUMNINFO:
			return (BOOL)pCCommand->m_pIColumnsInfo && !pCDataSource->IsMDProvider();

		//ICommand
		case IDMENU_EXECUTE: 
		case IDMENU_COMMAND_CANCEL: 
		case IDMENU_COMMAND_GETDBSESSION: 
		case IDMENU_COMMAND_CLEARPROPERTIES:
			return (BOOL)pCCommand->m_pICommand;

  		case IDMENU_EXECUTE_DATASET: 
  			return ((BOOL)pCCommand->m_pICommand && pCDataSource->IsMDProvider());

		case IDMENU_COMMAND_ADDREF: 
		case IDMENU_COMMAND_RELEASE: 
		case IDMENU_COMMAND_QUERYINTERFACE: 
		case IDMENU_COMMAND_RELEASEALL: 
			return (BOOL)pCCommand->m_pIUnknown;

		//ICommandPrepare
		case IDMENU_COMMANDPREPARE:
		case IDMENU_COMMANDUNPREPARE:
			return (BOOL)pCCommand->m_pICommandPrepare;

		//IRowset - IUnknown
		case IDMENU_ROWSET_ADDREF: 
		case IDMENU_ROWSET_RELEASE: 
		case IDMENU_ROWSET_QUERYINTERFACE: 
		case IDMENU_ROWSET_RELEASEALL: 
			return (BOOL)pCRowset->m_pIUnknown;

		//IRowset
		case IDMENU_GETDATA:
		case IDMENU_GETNEXTROWS:
		case IDMENU_RELEASEROWS:
		case IDMENU_ADDREFROWS:
		case IDMENU_REFRESH:					
		case IDMENU_RESTARTPOSITION:					
		case IDMENU_RELEASEALLROWS:
			return (BOOL)pCRowset->m_pIRowset;

		//Context RowMenu
		case IDMENU_MOVECURSOR:
		{	
			LONG iSelRow = SendMessage(m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
			return pCRowset->m_pIRowset && iSelRow!=LVM_ERR;
		}

		//IRowsetChange
		case IDMENU_INSERTROW:           
		case IDMENU_DELETEROWS:
		case IDMENU_SETDATA:    
			return (BOOL)pCRowset->m_pIRowsetChange;

		//IRowsetScroll
		case IDMENU_ROWSETSCROLL_GETAPPROXIMATEPOSITION:
//		case IDMENU_ROWSETSCROLL_GETROWSATRATIO:
			return (BOOL)pCRowset->m_pIRowsetScroll;

		//IRowsetLocate
		case IDMENU_ROWSETLOCATE_COMPARE:
		case IDMENU_ROWSETLOCATE_GETROWSAT:
		case IDMENU_ROWSETLOCATE_GETROWSBYBOOKMARK:
		case IDMENU_ROWSETLOCATE_HASH:
			return (BOOL)pCRowset->m_pIRowsetLocate;
		
		//IRowsetFind
		case IDMENU_ROWSETFIND_FINDNEXTROW:
			return (BOOL)pCRowset->m_pIRowsetFind;

		//IColumnsInfo
		case IDMENU_ROWSET_GETCOLUMNINFO:
			return (BOOL)pCRowset->m_pIColumnsInfo;
		
		//IRowsetInfo
		case IDMENU_ROWSET_GETPROPERTIES:
		case IDMENU_GETSPECIFICATION:
		case IDMENU_GETREFERENCEDROWSET:
			return (BOOL)pCRowset->m_pIRowsetInfo;

		//IConvertType
		case IDMENU_ROWSET_CANCONVERT:
			return (BOOL)pCRowset->m_pIConvertType;

		//IMultipleResults
		case IDMENU_MULTIPLERESULTS_ADDREF:
		case IDMENU_MULTIPLERESULTS_RELEASE:
		case IDMENU_MULTIPLERESULTS_QUERYINTERFACE:
		case IDMENU_MULTIPLERESULTS_RELEASEALL:
			return (BOOL)pCRowset->m_pCMultipleResults->m_pIUnknown;

		case IDMENU_MULTIPLERESULTS_GETRESULT: 
			return (BOOL)pCRowset->m_pCMultipleResults->m_pIMultipleResults;

		//IRowsetResynch
		case IDMENU_GETVISIBLEDATA:
		case IDMENU_RESYNCHROWS:
			return (BOOL)pCRowset->m_pIRowsetResynch;

		//IRowsetUpdate
		case IDMENU_UNDO:			
		case IDMENU_UPDATE:			
		case IDMENU_GETPENDINGROWS:			
		case IDMENU_GETROWSTATUS:
		case IDMENU_GETORIGINALDATA:			
			return (BOOL)pCRowset->m_pIRowsetUpdate;

		//IRowPosition - IUnknown
		case IDMENU_ROWPOS_ADDREF: 
		case IDMENU_ROWPOS_RELEASE: 
		case IDMENU_ROWPOS_QUERYINTERFACE: 
			return (BOOL)pCRowPos->m_pIUnknown;

		// Dataset menu
  		case IDMENU_DATASET_GETAXISINFO:
  		case IDMENU_DATASET_FREEAXISINFO:
  		case IDMENU_DATASET_GETAXISROWSET:
  		case IDMENU_DATASET_GETCELLDATA: 
  			return (BOOL)m_pCRowset->m_pCDataset->m_pIMDDataset;
  		case IDMENU_DATASET_GETCOLUMNINFO:
  			return (BOOL)m_pCRowset->m_pCDataset->m_pIColumnsInfo;
  		case IDMENU_DATASET_RELEASE:
  			return (BOOL)m_pCRowset->m_pCDataset->m_pIMDDataset;

		//IRowPosition
		case IDMENU_ROWPOS_CLEARROWPOSITION:
		case IDMENU_ROWPOS_SETROWPOSITION:
		case IDMENU_ROWPOS_RELEASEALL: 
			return (BOOL)pCRowPos->m_pIRowPosition;

		//ITableDefinition
//		case IDMENU_TABLE_CREATETABLE:
//		case IDMENU_TABLE_ADDCOLUMN:
//		case IDMENU_TABLE_DROPCOLUMN:
		case IDMENU_TABLE_DROPTABLE:
			return (BOOL)pCSession->m_pITableDefinition;

		//IIndexDefinition
//		case IDMENU_INDEX_CREATEINDEX:
		case IDMENU_INDEX_DROPINDEX:
			return (BOOL)pCSession->m_pIIndexDefinition;

		case IDMENU_ROWSETINDENTITY_ISSAMEROW:
			return (BOOL)pCRowset->m_pIRowsetIdentity;

		//DataSource Connection Points
		case IDMENU_DATASOURCE_FINDCONNECTIONPOINT:
			return (BOOL)pCDataSource->m_pIConnectionPointContainer;
		case IDMENU_DATASOURCE_GETCONNECTIONINTERFACE:
			return (BOOL)pCDataSource->m_pIConnectionPoint;

		//Rowset Connection Points
		case IDMENU_ROWSET_FINDCONNECTIONPOINT:
			return (BOOL)pCRowset->m_pIConnectionPointContainer;
		case IDMENU_ROWSET_GETCONNECTIONINTERFACE:
			return (BOOL)pCRowset->m_pIConnectionPoint;

		//RowPosition Connection Points
		case IDMENU_ROWPOS_FINDCONNECTIONPOINT:
			return (BOOL)pCRowPos->m_pIConnectionPointContainer;
		case IDMENU_ROWPOS_GETCONNECTIONINTERFACE:
			return (BOOL)pCRowPos->m_pIConnectionPoint;

		//DataSource IDBAsynchStatus
		case IDMENU_DATASOURCE_IDBASYNCHSTATUS_ABORT:
		case IDMENU_DATASOURCE_IDBASYNCHSTATUS_GETSTATUS:
			return (BOOL)pCDataSource->m_pIDBAsynchStatus;

		//Rowset IDBAsynchStatus
		case IDMENU_ROWSET_IDBASYNCHSTATUS_ABORT:
		case IDMENU_ROWSET_IDBASYNCHSTATUS_GETSTATUS:
			return (BOOL)pCRowset->m_pIDBAsynchStatus;

		case IDMENU_DATASOURCE_SUPPORTERRORINFO:
			return (BOOL)pCDataSource->m_pISupportErrorInfo && !pCDataSource->m_pISourcesRowset;
		case IDMENU_SESSION_SUPPORTERRORINFO:
			return (BOOL)pCSession->m_pISupportErrorInfo;
		case IDMENU_COMMAND_SUPPORTERRORINFO:
			return (BOOL)pCCommand->m_pISupportErrorInfo;
		case IDMENU_ROWSET_SUPPORTERRORINFO:
			return (BOOL)pCRowset->m_pISupportErrorInfo;

		case IDMENU_ENUMERATOR_SUPPORTERRORINFO:
			return (BOOL)pCDataSource->m_pISupportErrorInfo && pCDataSource->m_pISourcesRowset;

		case IDMENU_ENUMERATOR_ADDREF: 
		case IDMENU_ENUMERATOR_RELEASE: 
		case IDMENU_ENUMERATOR_QUERYINTERFACE: 
		case IDMENU_ENUMERATOR_RELEASEALL: 
			return (BOOL)pCDataSource->m_pIUnknown && pCDataSource->m_pISourcesRowset;

		//IRowsetNotify Return Codes
		case IDMENU_IROWSETNOTIFY_S_OK:
		{	
			*pdwFlags = pCRowset->m_pCRowsetNotify->GetReturnValue() == S_OK ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWSETNOTIFY_S_FALSE:
		{	
			*pdwFlags = pCRowset->m_pCRowsetNotify->GetReturnValue() == S_FALSE ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWSETNOTIFY_S_UNWANTEDPHASE:
		{	
			*pdwFlags = pCRowset->m_pCRowsetNotify->GetReturnValue() == DB_S_UNWANTEDPHASE ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWSETNOTIFY_S_UNWANTEDREASON:
		{	
			*pdwFlags = pCRowset->m_pCRowsetNotify->GetReturnValue() == DB_S_UNWANTEDREASON ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWSETNOTIFY_E_FAIL:
		{	
			*pdwFlags = pCRowset->m_pCRowsetNotify->GetReturnValue() == E_FAIL ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}

		//IDBAsynchNotify Return Codes
		case IDMENU_IDBASYNCHNOTIFY_S_OK:
		{	
			*pdwFlags = pCRowset->m_pCAsynchNotify->GetReturnValue() == S_OK ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IDBASYNCHNOTIFY_S_FALSE:
		{	
			*pdwFlags = pCRowset->m_pCAsynchNotify->GetReturnValue() == S_FALSE ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IDBASYNCHNOTIFY_S_UNWANTEDPHASE:
		{	
			*pdwFlags = pCRowset->m_pCAsynchNotify->GetReturnValue() == DB_S_UNWANTEDPHASE ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IDBASYNCHNOTIFY_S_UNWANTEDREASON:
		{	
			*pdwFlags = pCRowset->m_pCAsynchNotify->GetReturnValue() == DB_S_UNWANTEDREASON ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IDBASYNCHNOTIFY_E_FAIL:
		{	
			*pdwFlags = pCRowset->m_pCAsynchNotify->GetReturnValue() == E_FAIL ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}

		//IRowPosition Return Codes
		case IDMENU_IROWPOSITION_S_OK:
		{	
			*pdwFlags = pCRowPos->m_pCRowPosChange->GetReturnValue() == S_OK ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWPOSITION_S_FALSE:
		{	
			*pdwFlags = pCRowPos->m_pCRowPosChange->GetReturnValue() == S_FALSE ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWPOSITION_S_UNWANTEDPHASE:
		{	
			*pdwFlags = pCRowPos->m_pCRowPosChange->GetReturnValue() == DB_S_UNWANTEDPHASE ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWPOSITION_S_UNWANTEDREASON:
		{	
			*pdwFlags = pCRowPos->m_pCRowPosChange->GetReturnValue() == DB_S_UNWANTEDREASON ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}
		case IDMENU_IROWPOSITION_E_FAIL:
		{	
			*pdwFlags = pCRowPos->m_pCRowPosChange->GetReturnValue() == E_FAIL ? MF_CHECKED : MF_UNCHECKED;
			return TRUE;
		}

		//Otherwise we have no clue what this command is...
		default:
			break;
	}

	return FALSE;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ProviderInfoProc
//
/////////////////////////////////////////////////////////////////
BOOL CALLBACK CMDIChild::ProviderInfoProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{	
			EXC_BEGIN
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)lParam);
			CDataSource* pCDataSource = pThis->m_pCRowset->m_pCDataSource;
			WCHAR* pwszString = NULL;
			WCHAR* pwszString2 = NULL;
			DWORD dwValue = 0;

			//PROVIDERFILENAME
			wSendMessage(GetDlgItem(hWnd, IDT_PROVIDERFILENAME), WM_SETTEXT, 0, pCDataSource->m_pwszProviderName ? pCDataSource->m_pwszProviderName : pCDataSource->m_EnumInfo.wszName);
			//PROVIDERDESC
			wSendMessage(GetDlgItem(hWnd, IDT_PROVIDERDESC), WM_SETTEXT, 0, pCDataSource->m_pwszProviderDesc ? pCDataSource->m_pwszProviderDesc : pCDataSource->m_EnumInfo.wszDescription);
			//PROVIDERVER / PROVIDEROLEDBVER
			
			//DBPROP_PROVIDERVER
			GetProperty(pCDataSource->m_pIUnknown, DBPROP_PROVIDERVER,			DBPROPSET_DATASOURCEINFO, &pwszString);
			//DBPROP_PROVIDEROLEDBVER
			GetProperty(pCDataSource->m_pIUnknown, DBPROP_PROVIDEROLEDBVER,		DBPROPSET_DATASOURCEINFO, &pwszString2);
			wSendMessageFmt(GetDlgItem(hWnd, IDT_PROVIDERVERSION), WM_SETTEXT, 0, L"Prov - %s   OLEDB - %s", pwszString ? pwszString : L"Unknown", pwszString2 ? pwszString2 : L"Unknown");
			SAFE_FREE(pwszString);
			SAFE_FREE(pwszString2);

			//DBMS / DBMSVER
			wSendMessageFmt(GetDlgItem(hWnd, IDT_DBMS), WM_SETTEXT, 0, L"%s %s", pCDataSource->m_pwszDBMS ? pCDataSource->m_pwszDBMS : L"", pCDataSource->m_pwszDBMSVer ? pCDataSource->m_pwszDBMSVer : L"");
			//DATASOURCE
			wSendMessage(GetDlgItem(hWnd, IDT_DATASOURCE), WM_SETTEXT, 0, pCDataSource->m_pwszDataSource);

			//DBPROP_CURRENTCATALOG
			GetProperty(pCDataSource->m_pIUnknown, DBPROP_CURRENTCATALOG,			DBPROPSET_DATASOURCE,	  &pwszString);
			wSendMessage(GetDlgItem(hWnd, IDT_CATALOG), WM_SETTEXT, 0, pwszString);
			SAFE_FREE(pwszString);

			//DBPROP_DSOTHREADMODEL
			GetProperty(pCDataSource->m_pIUnknown, DBPROP_DSOTHREADMODEL,			DBPROPSET_DATASOURCEINFO, &dwValue);
			SendMessage(GetDlgItem(hWnd, IDT_THREADMODEL), WM_SETTEXT, 0, (LPARAM)(dwValue & DBPROPVAL_RT_FREETHREAD ? "FreeThreaded" : dwValue & DBPROPVAL_RT_APTMTTHREAD ? "ApartmentModel" : dwValue & DBPROPVAL_RT_SINGLETHREAD ? "SingleThreaded" : "Unknown"));
			
			//DBPROP_DATASOURCEREADONLY
			GetProperty(pCDataSource->m_pIUnknown, DBPROP_DATASOURCEREADONLY,		DBPROPSET_DATASOURCEINFO, &dwValue);
			CheckDlgButton(hWnd, IDB_READONLY, dwValue ? BST_CHECKED : BST_UNCHECKED);
			
			CenterDialog(hWnd);
			EXC_END_(hWnd, EndDialog(hWnd, FALSE));
			return TRUE;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				return UNHANDLED_MSG;
			}

			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
				case IDCANCEL:
				{
					EndDialog(hWnd, TRUE);
					return TRUE;
				}
			}
			break;
		}//WM_COMMAND
	}
	
	return FALSE;   
}


////////////////////////////////////////////////////////////////
// CMDIChild::MDIWinProc
//
/////////////////////////////////////////////////////////////////
LONG CALLBACK CMDIChild::MDIWinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static int dwSizeEdge = 0;

	switch (message)
	{
		case WM_CREATE:
		{	
			//Save the "this" pointer
			//This window was created with WM_MIDCREATE so the 
			//lParam->lpCreateParams is a pointer to the MDICREATESTRUCT
			Busy();
			CREATESTRUCT* pCS = (CREATESTRUCT*)lParam;
			MDICREATESTRUCT* pMDICS = (MDICREATESTRUCT*)pCS->lpCreateParams;
			CMDIChild* pThis = (CMDIChild*)SetThis(hWnd, (LPARAM)pMDICS->lParam);
			
			EXC_TEST(pThis->InitControls(hWnd));
			SetFocus(hWnd);
			Busy(OFF);
			return 0;
		}

		case WM_COMMAND:
		{
			//Filter out any Control Notification codes
			if(GET_WM_COMMAND_CMD(wParam, lParam) > 1)
			{
				break;
			}

			//Get the "this" pointer
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			CListBox*		pCListBox   = pThis->m_pCListBox;
			CRowset*		pCRowset	= pThis->m_pCRowset;
			CError*			pCError		= pThis->m_pCError;
			CDataSource*	pCDataSource= pCRowset->m_pCDataSource;
			CSession*		pCSession	= pCRowset->m_pCSession;
			CCommand*		pCCommand	= pCRowset->m_pCCommand;
			CRowPos*		pCRowPos	= pCRowset->m_pCRowPos;
			CMultipleResults*	pCMultipleResults = pCRowset->m_pCMultipleResults;
			CTransaction*	pCTransaction = pCSession->m_pCTransaction;
			HRESULT			hr = S_OK;
			BOOL			bReturn = TRUE;

			//Most of these commands are "delegates" from CMainWindow, when dealing
			//with the ToolBar or Menu for items dealing with MDI children...
			switch(GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDMENU_INITIALIZE:
				if(pCDataSource->m_pIDBInitialize)
				{
					EXC_TEST(pCDataSource->Initialize());
					EXC_TEST(pThis->RefreshControls());
				}
				return 0;

				case IDMENU_UNINITIALIZE:
					if(pCDataSource->m_pIDBInitialize)
					{
						pCListBox->OutputPreMethod("IDBInitialize::Uninitialize()");
						XTEST(hWnd, hr = pCDataSource->m_pIDBInitialize->Uninitialize());
						pCListBox->OutputPostMethod(hr, "IDBInitialize::Uninitialize()");

						if(SUCCEEDED(hr))
							pCDataSource->m_fConnected = FALSE;
					}
					return 0;

				case IDMENU_GETLITERALINFO:
					if(pCDataSource->m_pIDBInfo)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETLISTVIEW), hWnd, GetLiteralInfoProc, (LPARAM)pThis));
					return 0;
				
				case IDMENU_PROVIDERINFO:
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_PROVIDERINFO), hWnd, ProviderInfoProc, (LPARAM)pThis));
					return 0;
				
				case IDMENU_BROWSE_TABLENAME:
					if(pThis->m_hWndEditBox)
					{
						CHAR szBuffer[MAX_QUERY_LEN];
						szBuffer[0] = EOL;
						
						//Display Common Dialog to obtain TableName...
						//This is for providers that use a file for TableName
						EXC_TEST(hr = BrowseOpenFileName(pThis->m_hInst, hWnd, "Browse for TableName", szBuffer, MAX_QUERY_LEN));
						if(SUCCEEDED(hr))
						{
							//Now just need to place this name in the EditBox
							//Inserted after the current "caret"
							ReplaceEditBoxSelection(pThis->m_hWndEditBox, szBuffer);
						}
					}
					return 0;

				case IDMENU_GETKEYWORDS:
					if(pCDataSource->m_pIDBInfo)
					{
						ASSERT(pCDataSource->m_pIDBInfo);
						WCHAR* pwszKeywords = NULL;

						//IDBInfo::GetKeywords
						pCListBox->OutputPreMethod("IDBInfo::GetKeywords(&\"%S\")", pwszKeywords);
						XTEST(hWnd, hr = pCDataSource->m_pIDBInfo->GetKeywords(&pwszKeywords));
						pCListBox->OutputPostMethod(hr, "IDBInfo::GetKeywords(&\"%S\")", pwszKeywords);
						
						SAFE_FREE(pwszKeywords);
					}
					return 0;

				//Create a Session...
				case IDMENU_CREATESESSION: 
					if(pCDataSource->m_pIDBCreateSession)
					{
						pThis->m_pwszSource = "IDBCreateSession::CreateSession";
						pThis->m_iidSource  = IID_IOpenRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							EXC_TEST(pCSession->CreateSession(pThis->m_iidSource));
							EXC_TEST(pThis->RefreshControls());
						}
					}
					return 0;

				//IDBDataSourceAdmin
				case IDMENU_DATASOURCEADMIN_CREATEDATASOURCE:
					if(pCDataSource->m_pIDBDataSourceAdmin)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_DATASOURCEADMIN_CREATEDATASOURCE), hWnd, AdminCreateDataSourceProc, (LPARAM)pThis));
					return 0;

				case IDMENU_DATASOURCEADMIN_DESTROYDATASOURCE:
					if(pCDataSource->m_pIDBDataSourceAdmin)
					{
						//IDBDataSourceAdmin::DestroyDataSource
						pThis->m_pCListBox->OutputPreMethod("IDBDataSourceAdmin::DestroyDataSource()");
						XTEST(hWnd, hr = pCDataSource->m_pIDBDataSourceAdmin->DestroyDataSource());
						pThis->m_pCListBox->OutputPostMethod(hr, "IDBDataSourceAdmin::DestroyDataSource()");
					}
					return 0;

				case IDMENU_DATASOURCEADMIN_GETCREATIONPROPERTIES:
					if(pCDataSource->m_pIDBDataSourceAdmin)
						EXC_TEST(pThis->m_pCPropDlg->GetPropertyInfo(hWnd, DATASOURCEADMIN, pCDataSource->m_pIDBDataSourceAdmin));
					return 0;

				case IDMENU_DATASOURCEADMIN_MODIFYDATASOURCE:
					if(pCDataSource->m_pIDBDataSourceAdmin)
						EXC_TEST(pThis->m_pCPropDlg->SetProperties(hWnd, DATASOURCEADMIN, pCDataSource->m_pIDBDataSourceAdmin, pCDataSource->m_pIDBDataSourceAdmin));
					return 0;

				//Create a new MDI window (using the Same DataSource, seperate session)...
				case IDMENU_CREATESESSIONWINDOW: 
					if(pCDataSource->m_pIDBCreateSession)
					{
						EXC_TEST(pThis->CreateNewSessionWindow());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				//Create a new MDI window (using the Same Session, seperate Command)...
				case IDMENU_CREATECOMMANDWINDOW: 
					if(pCSession->m_pIDBCreateCommand)
					{
						EXC_TEST(pThis->CreateNewCommandWindow());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_RUN:
					if(pCDataSource->m_pISourcesRowset) 
					{
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETSOURCESROWSET), hWnd, GetSourcesRowsetProc, (LPARAM)pThis));
						return 0;
					}
					
					if(pCSession->m_pIOpenRowset) 
					{
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_OPENROWSET), hWnd, OpenRowsetProc, (LPARAM)pThis));
						return 0;
					}
					return 0;

				//IOpenRowset::OpenRowset
				case IDMENU_OPENROWSET:
					if(pCSession->m_pIOpenRowset)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_OPENROWSET), hWnd, OpenRowsetProc, (LPARAM)pThis));
					return 0;

				//IGetDataSource::GetDataSource
				case IDMENU_GETDATASOURCE:
					if(pCSession->m_pIGetDataSource)
					{
						pThis->m_pwszSource = "IGetDataSource::GetDataSource";
						pThis->m_iidSource  = IID_IDBInitialize;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IGetDataSource::GetDataSource
							IUnknown* pIUnknown = NULL;
							pCListBox->OutputPreMethod("IGetDataSource::GetDataSource(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pIUnknown);
							XTEST(hWnd, hr = pCSession->m_pIGetDataSource->GetDataSource(pThis->m_iidSource, &pIUnknown));
							pCListBox->OutputPostMethod(hr, "IGetDataSource::GetDataSource(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pIUnknown);
							
							//Update the DataSource Object
							if(FAILED(hr) || FAILED(pCDataSource->SetInterface(pThis->m_iidSource, pIUnknown)))
								pCListBox->OutputRelease(&pIUnknown);
						}
					}
					return 0;

				//ICommand
				case IDMENU_EXECUTE:
					if(pCCommand->m_pICommand)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_EXECUTE), hWnd, ExecuteProc, (LPARAM)pThis));
					return 0;
										
				case IDMENU_COMMAND_CANCEL:
					if(pCCommand->m_pICommand)
					{
						//ICommand::Cancel
						pCListBox->OutputPreMethod("ICommand::Cancel()");
						XTEST(hWnd, hr = pCCommand->m_pICommand->Cancel());
						pCListBox->OutputPostMethod(hr, "ICommand::Cancel()");
					}
					return 0;

				case IDMENU_COMMAND_GETDBSESSION:
					if(pCCommand->m_pICommand)
					{
						pThis->m_pwszSource = "ICommand::GetDBSession";
						pThis->m_iidSource  = IID_IOpenRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ICommand::GetDBSession
							IUnknown* pIUnknown = NULL;
							pCListBox->OutputPreMethod("ICommand::GetDBSession(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pIUnknown);
							XTEST(hWnd, hr = pCCommand->m_pICommand->GetDBSession(pThis->m_iidSource, &pIUnknown));
							pCListBox->OutputPostMethod(hr, "ICommand::GetDBSession(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pIUnknown);
							
							//Update the Session Object
							if(FAILED(hr) || FAILED(pCSession->SetInterface(pThis->m_iidSource, pIUnknown)))
								pCListBox->OutputRelease(&pIUnknown);
						}
					}
					return 0;

 				case IDMENU_EXECUTE_DATASET:
  					if (pCCommand->m_pICommand)
  					{
  						pThis->UpdateWndTitle();
  						pThis->ExecuteDataset(ROWSET_FROMCOMMANDDATASET);
  					}
  					break;
  
  				case IDMENU_DATASET_GETAXISINFO:
  					DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_AXISINFO), hWnd, AxisInfoProc, (LPARAM)pThis);
  					break;
  
  				case IDMENU_DATASET_GETAXISROWSET:
  				case IDMENU_DATASET_GETCELLDATA:
  					if (pCCommand->m_pICommand)
  					{
  						ROWSETSOURCE eSource;
  						if (GET_WM_COMMAND_ID(wParam, lParam) == IDMENU_DATASET_GETAXISROWSET)
  						{
  							eSource = ROWSET_FROMAXISDATASET;
  							if (DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETAXISROWSET), 
  											hWnd, AxisRowsetProc, (LPARAM)pThis) == IDCANCEL)
  								break;	// skip out if canceled
  						}
  						else eSource = ROWSET_FROMCOMMANDDATASET;
  
  						// display axis rowset or the dataset in the list view
  						pThis->UpdateWndTitle();
  						pThis->CreateRowset(eSource);
  					}
  					else wMessageBox(pThis->m_hWnd, MB_OK | MB_ICONHAND| MB_SYSTEMMODAL, wsz_ERROR, L"This operation requires a Command object, please create command first...");
  					break;
  
  				case IDMENU_DATASET_RELEASE:
  					pThis->m_pCRowset->m_pCDataset->ReleaseDataset();
  					break;
  

			case IDMENU_DATASOURCE_ADDREF:
					if(pCDataSource->m_pIUnknown)
						EXC_TEST(pCDataSource->AddRef());
					return 0;
				case IDMENU_DATASOURCE_RELEASE:
					if(pCDataSource->m_pIUnknown)
						EXC_TEST(pCDataSource->Release());
					return 0;
				case IDMENU_DATASOURCE_QUERYINTERFACE:
					if(pCDataSource->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_IDBInitialize;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							pCDataSource->QueryInterface(pThis->m_iidSource);
						}
					}
					return 0;
				case IDMENU_DATASOURCE_RELEASEALL:
					if(pCDataSource->m_pIUnknown)
					{
						EXC_TEST(pCDataSource->ReleaseDataSource());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_SESSION_ADDREF:
					if(pCSession->m_pIUnknown)
						EXC_TEST(pCSession->AddRef());
					return 0;
				case IDMENU_SESSION_RELEASE:
					if(pCSession->m_pIUnknown)
						EXC_TEST(pCSession->Release());
					return 0;
				case IDMENU_SESSION_QUERYINTERFACE:
					if(pCSession->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_IOpenRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCSession->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_SESSION_RELEASEALL:
					if(pCSession->m_pIUnknown)
					{
						EXC_TEST(pCSession->ReleaseSession());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_COMMAND_ADDREF:
					if(pCCommand->m_pIUnknown)
						EXC_TEST(pCCommand->AddRef());
					return 0;
				case IDMENU_COMMAND_RELEASE:
					if(pCCommand->m_pIUnknown)
						EXC_TEST(pCCommand->Release());
					return 0;
				case IDMENU_COMMAND_QUERYINTERFACE:
					if(pCCommand->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_ICommand;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCCommand->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_COMMAND_RELEASEALL:
					if(pCCommand->m_pIUnknown)
					{
						EXC_TEST(pCCommand->ReleaseCommand());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_ENUMERATOR_ADDREF:
					if(pCDataSource->m_pISourcesRowset)
						EXC_TEST(pCDataSource->AddRef());
					return 0;
				case IDMENU_ENUMERATOR_RELEASE:
					if(pCDataSource->m_pISourcesRowset)
						EXC_TEST(pCDataSource->Release());
					return 0;
				case IDMENU_ENUMERATOR_QUERYINTERFACE:
					if(pCDataSource->m_pISourcesRowset)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_ISourcesRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCDataSource->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_ENUMERATOR_RELEASEALL:
					if(pCDataSource->m_pISourcesRowset)
					{
						EXC_TEST(pCDataSource->ReleaseDataSource());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_ROWPOS_ADDREF:
					if(pCRowPos->m_pIRowPosition)
						EXC_TEST(pCRowPos->AddRef());
					return 0;
				case IDMENU_ROWPOS_RELEASE:
					if(pCRowPos->m_pIRowPosition)
						EXC_TEST(pCRowPos->Release());
					return 0;
				case IDMENU_ROWPOS_QUERYINTERFACE:
					if(pCRowPos->m_pIRowPosition)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_IRowPosition;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCRowPos->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_ROWPOS_RELEASEALL:
					if(pCRowPos->m_pIRowPosition)
					{
						EXC_TEST(pCRowPos->ReleaseRowPos());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_ROWSET_ADDREF:
					if(pCRowset->m_pIUnknown)
						EXC_TEST(pCRowset->AddRef());
					return 0;
				case IDMENU_ROWSET_RELEASE:
					if(pCRowset->m_pIUnknown)
						EXC_TEST(pCRowset->Release());
					return 0;
				case IDMENU_ROWSET_QUERYINTERFACE:
					if(pCRowset->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_IRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCRowset->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_ROWSET_RELEASEALL:
					if(pCRowset->m_pIUnknown)
					{
						EXC_TEST(pCRowset->ReleaseRowset());
						EXC_TEST(pThis->ClearListView("No Rowset"));
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				
				//IMultipleResults
				case IDMENU_MULTIPLERESULTS_ADDREF:
					if(pCMultipleResults->m_pIUnknown)
						EXC_TEST(pCMultipleResults->AddRef());
					return 0;
				case IDMENU_MULTIPLERESULTS_RELEASE:
					if(pCMultipleResults->m_pIUnknown)
						EXC_TEST(pCMultipleResults->Release());
					return 0;
				case IDMENU_MULTIPLERESULTS_QUERYINTERFACE:
					if(pCMultipleResults->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_IMultipleResults;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCMultipleResults->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_MULTIPLERESULTS_RELEASEALL:
					if(pCMultipleResults->m_pIUnknown)
					{
						EXC_TEST(pCMultipleResults->ReleaseObject());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_MULTIPLERESULTS_GETRESULT: 
					if(pCMultipleResults->m_pIMultipleResults)
					{
						LONG cRowsAffected = 0;
						IUnknown* pIUnknown = NULL;

						pThis->m_pwszSource = "IMultipleResults::GetResult";
						pThis->m_iidSource  = IID_IRowset;
						EXC_TEST(bReturn= DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IMultipleResults::GetResult...
							EXC_TEST(hr = pCMultipleResults->GetResult(pThis->m_iidSource, &cRowsAffected, &pIUnknown));
							if(SUCCEEDED(hr) && pIUnknown)
							{
								EXC_TEST(hr = pCRowset->CreateRowset(pIUnknown));
								
								//Now Display the rowset 
								if(SUCCEEDED(hr))
									pThis->DisplayRowset();
							}
							pCListBox->OutputRelease(&pIUnknown);
						}
					}
					return 0;

				case IDMENU_TRANSACTIONLOCAL_ABORT:
					if(pCSession->m_pITransactionLocal)
					{
						pThis->m_eSource = TRANSACTIONLOCAL;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_ABORTTRANSACTION), hWnd, AbortTransactionProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_TRANSACTIONLOCAL_COMMIT:
					if(pCSession->m_pITransactionLocal)
					{
						pThis->m_eSource = TRANSACTIONLOCAL;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_COMMITTRANSACTION), hWnd, CommitTransactionProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_TRANSACTIONLOCAL_GETTRANSACTIONINFO:
					if(pCSession->m_pITransactionLocal)
					{
						XACTTRANSINFO XactInfo = {0};

						//ITransactionLocal::GetTransactionInfo
						pCListBox->OutputPreMethod("ITransactionLocal::GetTransactionInfo(&0x%08x)", XactInfo);
						XTEST(hWnd, hr = pCSession->m_pITransactionLocal->GetTransactionInfo(&XactInfo));
						pCListBox->OutputPostMethod(hr, "ITransactionLocal::GetTransactionInfo(%s, %d, %s, %d, %d, %d)", /*XactInfo.uow,*/ GetMapName(XactInfo.isoLevel, g_cIsoLevels, g_rgIsoLevels), XactInfo.isoFlags, GetMapName(XactInfo.grfTCSupported, g_cXACTTC, g_rgXACTTC) , XactInfo.grfRMSupported, XactInfo.grfTCSupportedRetaining, XactInfo.grfRMSupportedRetaining);
					}
					return 0;

				case IDMENU_TRANSACTIONLOCAL_STARTTRANSACTION:
					if(pCSession->m_pITransactionLocal)
					{
						pThis->m_eSource = TRANSACTIONLOCAL;
 						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_STARTTRANSACTION), hWnd, StartLocalTxnProc, (LPARAM)pThis));
 					}
					return 0;
				
				case IDMENU_TRANSACTIONLOCAL_GETOPTIONSOBJECT:
					if(pCSession->m_pITransactionLocal && pCTransaction->m_pITransactionOptions == NULL)
					{
						//ITransactionLocal::GetOptionsObject
						pCListBox->OutputPreMethod("ITransactionLocal::GetOptionsObject(&0x%08x)", pCTransaction->m_pITransactionOptions);
						XTEST(hWnd, hr = pCSession->m_pITransactionLocal->GetOptionsObject(&pCTransaction->m_pITransactionOptions));
						pCListBox->OutputPostMethod(hr, "ITransactionLocal::GetOptionsObject(&0x%08x)", pCTransaction->m_pITransactionOptions);
					}
					return 0;

				case IDMENU_TRANSACTIONJOIN_GETOPTIONSOBJECT:
					if(pCSession->m_pITransactionJoin && pCTransaction->m_pITransactionOptions == NULL)
					{
						//ITransactionJoin::GetOptionsObject
						pCListBox->OutputPreMethod("ITransactionJoin::GetOptionsObject(&0x%08x)", pCTransaction->m_pITransactionOptions);
						XTEST(hWnd, hr = pCSession->m_pITransactionJoin->GetOptionsObject(&pCTransaction->m_pITransactionOptions));
						pCListBox->OutputPostMethod(hr, "ITransactionJoin::GetOptionsObject(&0x%08x)", pCTransaction->m_pITransactionOptions);
					}
					return 0;

				//ITransaction
				case IDMENU_TRANSACTION_ADDREF:
					if(pCTransaction->m_pIUnknown)
						EXC_TEST(pCTransaction->AddRef());
					return 0;
				case IDMENU_TRANSACTION_RELEASE:
					if(pCTransaction->m_pIUnknown)
						EXC_TEST(pCTransaction->Release());
					return 0;
				case IDMENU_TRANSACTION_QUERYINTERFACE:
					if(pCTransaction->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_ITransaction;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCTransaction->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_TRANSACTION_RELEASEALL:
					if(pCTransaction->m_pIUnknown)
					{
						EXC_TEST(pCTransaction->ReleaseObject());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				case IDMENU_TRANSACTION_ABORT:
					if(pCTransaction->m_pITransaction)
					{
						pThis->m_eSource = TRANSACTION;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_ABORTTRANSACTION), hWnd, AbortTransactionProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_TRANSACTION_COMMIT:
					if(pCTransaction->m_pITransaction)
					{
						pThis->m_eSource = TRANSACTION;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_COMMITTRANSACTION), hWnd, CommitTransactionProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_TRANSACTION_GETTRANSACTIONINFO:
					if(pCTransaction->m_pITransaction)
					{
						XACTTRANSINFO XactInfo = {0};

						//ITransaction::GetTransactionInfo
						pCListBox->OutputPreMethod("ITransaction::GetTransactionInfo(&0x%08x)", XactInfo);
						XTEST(hWnd, hr = pCTransaction->m_pITransaction->GetTransactionInfo(&XactInfo));
						pCListBox->OutputPostMethod(hr, "ITransaction::GetTransactionInfo(%s, %d, %s, %d, %d, %d)", /*XactInfo.uow,*/ GetMapName(XactInfo.isoLevel, g_cIsoLevels, g_rgIsoLevels), XactInfo.isoFlags, GetMapName(XactInfo.grfTCSupported, g_cXACTTC, g_rgXACTTC) , XactInfo.grfRMSupported, XactInfo.grfTCSupportedRetaining, XactInfo.grfRMSupportedRetaining);
					}
					return 0;

				case IDMENU_TRANSACTIONOPTIONS_GETOPTIONS:
					if(pCTransaction->m_pITransactionOptions)
					{
						XACTOPT XactOptions = {0};

						//ITransactionOptions::GetOptions
						pCListBox->OutputPreMethod("ITransactionOptions::GetOptions(&0x%08x)", XactOptions);
						XTEST(hWnd, hr = pCTransaction->m_pITransactionOptions->GetOptions(&XactOptions));
						pCListBox->OutputPostMethod(hr, "ITransactionOptions::GetOptions(%d, \"%s\")", XactOptions.ulTimeout, XactOptions.szDescription);
					}
					return 0;

				case IDMENU_TRANSACTIONOPTIONS_SETOPTIONS:
					if(pCTransaction->m_pITransactionOptions)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_SETTRANSACTIONOPTIONS), hWnd, SetTransactionOptionsProc, (LPARAM)pThis));
					return 0;

#ifdef TXNJOIN			//MTS SDK
				case IDMENU_ITRANSACTIONJOIN_TRANSACTIONDISPENSOR_BEGINTRANSACTION:
					pThis->m_eSource = MTSTRANSACTION;
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_STARTTRANSACTION), hWnd, StartMTSTxnProc, (LPARAM)pThis));
					return 0;
 
 				case IDMENU_MTS_TRANSACTION_ABORT:
					pThis->m_eSource = MTSTRANSACTION;
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_MTSABORTTRANSACTION), hWnd, AbortMTSTransactionProc, (LPARAM)pThis));
					return 0;
 
				case IDMENU_MTS_TRANSACTION_COMMIT:
					pThis->m_eSource = MTSTRANSACTION;
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_MTSCOMMITTRANSACTION), hWnd, CommitMTSTransactionProc, (LPARAM)pThis));
 					return 0;
 
 				case IDMENU_MTS_TRANSACTION_GETTRANSACTIONINFO:
					pThis->m_eSource = MTSTRANSACTION;
					//ITransaction::GetTransactionInfo
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_MTSGETTRANSACTIONINFO), hWnd, GetMTSTxnInfo, (LPARAM)pThis));
					return 0;
 
 				case IDMENU_MTS_FREETRANSACTION:
					pThis->m_eSource = MTSTRANSACTION;
					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_MTSFREETRANSACTION), hWnd, FreeMTSTxn, (LPARAM)pThis));
					return 0;
#endif //TXNJOIN

    			case IDMENU_TRANSACTIONJOIN_JOINTRANSACTION:
    				if(pCSession->m_pITransactionJoin)
    				{
    					pThis->m_eSource = TRANSACTIONJOIN;
	 					EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_JOINTRANSACTION), hWnd, StartJoinTxnProc, (LPARAM)pThis));
    				}
    				return 0;


				case IDMENU_TRANSACTIONOBJECT_GETTRANSACTIONOBJECT:
					if(pCSession->m_pITransactionObject && pCTransaction->m_pITransaction == NULL)
					{
						//ITransactionObject::GetTransactionObject
						pCListBox->OutputPreMethod("ITransactionObject::GetTransactionObject(1, &0x%08x)", pCTransaction->m_pITransaction);
						XTEST(hWnd, hr = pCSession->m_pITransactionObject->GetTransactionObject(1, &pCTransaction->m_pITransaction));
						pCListBox->OutputPostMethod(hr, "ITransactionObject::GetTransactionObject(1, &0x%08x)", pCTransaction->m_pITransaction);
					}
					return 0;

				case IDMENU_COMMAND_GETCOLUMNINFO:
					if(pCCommand->m_pIColumnsInfo)
					{
						//Indicate This was called from the Command
						pThis->m_eSource = COMMAND;
					
						//Display GetColumnInfo dialog...
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETLISTVIEW), hWnd, GetColInfoProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_ROWSET_GETCOLUMNINFO:
					if(pCRowset->m_pIColumnsInfo)
					{
						//Indicate This was called from the Rowset
						pThis->m_eSource = ROWSET;

						//Display GetColumnInfo dialog...
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETLISTVIEW), hWnd, GetColInfoProc, (LPARAM)pThis));
					}
					return 0;

				//ColumnsRowset
				case IDMENU_COMMAND_GETCOLUMNSROWSET:
					if(pCCommand->m_pIColumnsRowset)
					{
						pThis->m_eSource = COMMAND;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETCOLUMNSROWSET), hWnd, GetColumnsRowsetProc, (LPARAM)pThis));
						return 0;
					}
					return 0;

				//ColumnsRowset
				case IDMENU_ROWSET_GETCOLUMNSROWSET:
					if(pCRowset->m_pIColumnsRowset)
					{
						pThis->m_eSource = ROWSET;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETCOLUMNSROWSET), hWnd, GetColumnsRowsetProc, (LPARAM)pThis));
						return 0;
					}
					return 0;

				//Enumerator
				case IDMENU_GETSOURCESROWSET:
					if(pCDataSource->m_pISourcesRowset)
					{
						pThis->m_eSource = ENUMERATOR;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETSOURCESROWSET), hWnd, GetSourcesRowsetProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_DELETEROWS:    
					if(pCRowset->m_pIRowsetChange)
						EXC_TEST(pThis->DeleteSelectedRows());
					return 0;
				
				case IDMENU_SETDATA:    
					if(pCRowset->m_pIRowsetChange)
						EXC_TEST(pThis->ChangeSelectedRow());
					return 0;

				case IDMENU_INSERTROW:           
					if(pCRowset->m_pIRowsetChange)
						EXC_TEST(pThis->InsertNewRow());
					return 0;

				case IDMENU_CLEAREDITWINDOW:				
//					SendMessage(pThis->m_hWndEditBox, WM_SETTEXT, 0, (LPARAM)"");
					//Select all the Text and Cut it...
					//This method allows the text to be undone...
					SendMessage(pThis->m_hWndEditBox, EM_SETSEL, 0, -1);
					SendMessage(pThis->m_hWndEditBox, WM_CUT, 0, 0);
					pThis->m_pCMainWindow->m_fWarnMaxEditBuffer = TRUE;
					return 0;

				case IDMENU_CUTEDITWINDOW:				
					EXC_TEST(SendMessage(pThis->m_hWndEditBox, WM_CUT, 0, 0));
					return 0;
				case IDMENU_COPYEDITWINDOW:				
					EXC_TEST(SendMessage(pThis->m_hWndEditBox, WM_COPY, 0, 0));
					return 0;
				case IDMENU_PASTEEDITWINDOW:
					EXC_TEST(SendMessage(pThis->m_hWndEditBox, WM_PASTE, 0, 0));
					return 0;

				case IDMENU_CLEARNOTIFYWINDOW:				
					pCListBox->ClearNotifications();
					return 0;

				case IDMENU_CUTNOTIFYWINDOW:				
					EXC_TEST(SendMessage(pCListBox->m_hWnd, WM_COPY, 0, 0));
					return 0;
				case IDMENU_COPYNOTIFYWINDOW:				
					EXC_TEST(SendMessage(pCListBox->m_hWnd, WM_COPY, 0, 0));
					return 0;
				case IDMENU_PASTENOTIFYWINDOW:
					EXC_TEST(SendMessage(pCListBox->m_hWnd, WM_PASTE, 0, 0));
					return 0;

				case IDMENU_GETERRORINFO:
					EXC_TEST(pCError->GetErrorInfo());
					return 0;

				case IDMENU_SETERRORINFO:
					EXC_TEST(pCError->SetErrorInfo());
					return 0;

				case IDMENU_DISPLAYERRORINFO:
					if(pCError)
					{
						EXC_TEST(DisplayAllErrorInfo(hWnd));
						return 0;
					}

				case IDMENU_ERROR_ADDREF:
					if(pCError->m_pIUnknown)
						EXC_TEST(pCError->AddRef());
					return 0;
				case IDMENU_ERROR_RELEASE:
					if(pCError->m_pIUnknown)
						EXC_TEST(pCError->Release());
					return 0;
				case IDMENU_ERROR_QUERYINTERFACE:
					if(pCError->m_pIUnknown)
					{
						pThis->m_pwszSource = "IUnknown::QueryInterface";
						pThis->m_iidSource  = IID_IErrorInfo;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IUnknown::QueryInterface
							EXC_TEST(pCError->QueryInterface(pThis->m_iidSource));
						}
					}
					return 0;
				case IDMENU_ERROR_RELEASEALL:
					if(pCError->m_pIUnknown)
					{
						EXC_TEST(pCError->ReleaseError());
						EXC_TEST(pThis->RefreshControls());
					}
					return 0;

				//IErrorInfo
				case IDMENU_ERRORINFO_GETDESCRIPTION:
					if(pCError->m_pIErrorInfo)
					{
						WCHAR* pwszDescription = NULL;
						
						//IErrorInfo::GetDescription
						pCListBox->OutputPreMethod("IErrorInfo::GetDescription(\"%S\")", pwszDescription);
						XTEST(hWnd, hr = pCError->m_pIErrorInfo->GetDescription(&pwszDescription));
						pCListBox->OutputPostMethod(hr, "IErrorInfo::GetDescription(\"%S\")", pwszDescription);
						SAFE_FREE(pwszDescription);
						return 0;
					}

				//IErrorRecords
				case IDMENU_ERRORRECORDS_GETRECORDCOUNT:
					if(pCError->m_pIErrorRecords)
					{
						ULONG ulCount = 0;

						//IErrorRecords::GetRecordCount
						pCListBox->OutputPreMethod("IErrorRecords::GetRecordCount(&%d)", ulCount);
						XTEST(hWnd, hr = pCError->m_pIErrorRecords->GetRecordCount(&ulCount));
						pCListBox->OutputPostMethod(hr, "IErrorRecords::GetRecordCount(&%d)", ulCount);
						return 0;
					}
				
				case IDMENU_RESTARTPOSITION:					
					if(pCRowset->m_pIRowset)
						EXC_TEST(pThis->RestartPosition());
					return 0;
								
				case IDMENU_MOVECURSOR:
					if(pCRowset->m_pIRowset)
						EXC_TEST(pThis->MoveCursor());
					return 0;
				
				case IDMENU_GETNEXTROWS:
					if(pCRowset->m_pIRowset)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETNEXTROWS), hWnd, GetNextRowsProc, (LPARAM)pThis));
					return 0;

				case IDMENU_RELEASEROWS:
					if(pCRowset->m_pIRowset)
						EXC_TEST(pThis->ReleaseRows(LV_ALLSELITEMS));
					return 0;

				case IDMENU_ADDREFROWS:
					if(pCRowset->m_pIRowset)
						EXC_TEST(pThis->AddRefRows(LV_ALLSELITEMS));
					return 0;

				case IDMENU_RELEASEALLROWS:
					if(pCRowset->m_pIRowset)
						EXC_TEST(pThis->ReleaseRows(LV_ALLITEMS));
					return 0;

				case IDMENU_SETCOMMANDTEXT:
					if(pCCommand->m_pICommandText)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_SETCOMMANDTEXT), hWnd, SetCommandTextProc, (LPARAM)pThis));
					return 0;

				case IDMENU_GETCOMMANDTEXT:
					if(pCCommand->m_pICommandText)
					{
						GUID guidDialec = DBGUID_DEFAULT;
						WCHAR wszBuffer[MAX_QUERY_LEN+1];
						WCHAR* pwszBuffer = NULL;
						wszBuffer[0] = wEOL;

						pCListBox->OutputPreMethod("ICommandText::GetCommandText(&%S, \"%S\")", wszBuffer, pwszBuffer);
						XTEST(hWnd, hr = pCCommand->m_pICommandText->GetCommandText(&guidDialec, &pwszBuffer));
						
						//Try to find a string respentation of the guidDialec
						if (guidDialec == DBGUID_DEFAULT)
							swprintf(wszBuffer, L"%s", L"DBGUID_DEFAULT");
						else if(guidDialec == DBGUID_DBSQL)
							swprintf(wszBuffer, L"%s", L"DBGUID_DBSQL");
						else if (guidDialec == DBGUID_SQL)
							swprintf(wszBuffer, L"%s", L"DBGUID_SQL");
 						else if (guidDialec == MDGUID_MDX)
 							swprintf(wszBuffer, L"%s", L"MDGUID_MDX");
						else
							StringFromGUID2(guidDialec, wszBuffer, MAX_QUERY_LEN);

						pCListBox->OutputPostMethod(hr, "ICommandText::GetCommandText(&%S, \"%S\")", wszBuffer, pwszBuffer);
						SAFE_FREE(pwszBuffer);
					}
					return 0;

				case IDMENU_COMMANDPREPARE:
					if(pCCommand->m_pICommandPrepare)
					{
						//ICommand::Prepare
						pCListBox->OutputPreMethod("ICommandPrepare::Prepare(0)");
						XTEST(hWnd, hr = pCCommand->m_pICommandPrepare->Prepare(0));
						pCListBox->OutputPostMethod(hr, "ICommandPrepare::Prepare(0)");
					}
					return 0;

				case IDMENU_COMMANDUNPREPARE:
					if(pCCommand->m_pICommandPrepare)
					{
						//ICommand::Unprepare
						pCListBox->OutputPreMethod("ICommandPrepare::Unprepare()");
						XTEST(hWnd, hr = pCCommand->m_pICommandPrepare->Unprepare());
						pCListBox->OutputPostMethod(hr, "ICommandPrepare::Unprepare()");
					}
					return 0;

				case IDMENU_GETSCHEMAS:
				case IDMENU_GETSCHEMAROWSET:
					if(pCSession->m_pIDBSchemaRowset)
						EXC_TEST(pThis->pCSchemaDlg()->Display());
					return 0;
				
				case IDMENU_DATASOURCE_GETPROPERTIES:
					if(pCDataSource->m_pIDBProperties)
						EXC_TEST(pThis->m_pCPropDlg->GetProperties(hWnd, DATASOURCE, pCDataSource->m_pIDBProperties));
					return 0;

				case IDMENU_SESSION_GETPROPERTIES:
					if(pCSession->m_pISessionProperties)
						EXC_TEST(pThis->m_pCPropDlg->GetProperties(hWnd, SESSION, pCSession->m_pISessionProperties));
					return 0;

				case IDMENU_COMMAND_GETPROPERTIES:
					if(pCCommand->m_pICommandProperties)
						EXC_TEST(pThis->m_pCPropDlg->GetProperties(hWnd, COMMAND, pCCommand->m_pICommandProperties));
					return 0;

				case IDMENU_ROWSET_GETPROPERTIES:
					if(pCRowset->m_pIRowsetInfo)
						EXC_TEST(pThis->m_pCPropDlg->GetProperties(hWnd, ROWSET, pCRowset->m_pIRowsetInfo, &pThis->m_cPropSets, &pThis->m_rgPropSets));
					return 0;

				//IRowsetInfo
				case IDMENU_GETSPECIFICATION:
					if(pCRowset->m_pIRowsetInfo)
					{
						pThis->m_pwszSource = "IRowsetInfo::GetSpecification";
						pThis->m_iidSource  = IID_IOpenRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IRowset::GetSpecification
							IUnknown* pIUnknown = NULL;
							pCListBox->OutputPreMethod("IRowset::GetSpecification(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pIUnknown);
							XTEST(hWnd, hr = pCRowset->m_pIRowsetInfo->GetSpecification(pThis->m_iidSource, &pIUnknown));
							pCListBox->OutputPostMethod(hr, "IRowset::GetSpecification(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pIUnknown);
							
							//Update either the Session or Command Object(s)
							if(FAILED(hr) || (FAILED(pCSession->SetInterface(pThis->m_iidSource, pIUnknown)) && FAILED(pCCommand->SetInterface(pThis->m_iidSource, pIUnknown))))
								pCListBox->OutputRelease(&pIUnknown);
						}
					}
					return 0;

				case IDMENU_GETREFERENCEDROWSET:
					if(pCRowset->m_pIRowsetInfo)
					{
						pThis->m_pwszSource = "IRowsetInfo::GetReferencedRowset";
						pThis->m_iidSource  = IID_IRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//IRowsetInfo::GetReferencedRowset
							IUnknown* pIUnknown = NULL;
							pCListBox->OutputPreMethod("IRowsetInfo::GetReferencedRowset(%d, %s, &0x%08x)", 0, GetInterfaceName(pThis->m_iidSource), pIUnknown);
							XTEST(hWnd, hr = pCRowset->m_pIRowsetInfo->GetReferencedRowset(0, pThis->m_iidSource, &pIUnknown));
							pCListBox->OutputPostMethod(hr, "IRowsetInfo::GetReferencedRowset(%d, %s, &0x%08x)", 0, GetInterfaceName(pThis->m_iidSource), pIUnknown);
							
							//Update the Rowset Object
							if(FAILED(hr) || FAILED(pCRowset->SetInterface(pThis->m_iidSource, pIUnknown)))
								pCListBox->OutputRelease(&pIUnknown);
						}
					}
					return 0;

				case IDMENU_DATASOURCE_SETPROPERTIES:
					if(pCDataSource->m_pIDBProperties)
						EXC_TEST(pThis->m_pCPropDlg->SetProperties(hWnd, pCDataSource->IsConnected() ? DATASOURCE : DATASOURCEINIT, pCDataSource->m_pIDBProperties, pCDataSource->m_pIDBProperties));
					return 0;

				case IDMENU_SESSION_SETPROPERTIES:
					if(pCSession->m_pISessionProperties)
						EXC_TEST(pThis->m_pCPropDlg->SetProperties(hWnd, SESSION, pCSession->m_pISessionProperties, pCDataSource->m_pIDBProperties));
					return 0;

				case IDMENU_COMMAND_SETPROPERTIES:
					if(pCCommand->m_pICommandProperties)
						EXC_TEST(pThis->m_pCPropDlg->SetProperties(hWnd, COMMAND, pCCommand->m_pICommandProperties, pCDataSource->m_pIDBProperties));
					return 0;

				case IDMENU_COMMAND_CLEARPROPERTIES:
					if(pCCommand->m_pIUnknown)
					{
						//A little more difficult than ROWSET_CLEARPROPERTIES
						//Since any properties set on a command object are set,
						//the only way to remove them is to either try and set them
						//to the opposite value, or create a new command object...
						EXC_TEST(pCCommand->CreateCommand());
					}
					return 0;
				
				case IDMENU_GETPROPERTYINFO:
					if(pCDataSource->m_pIDBProperties)
						EXC_TEST(pThis->m_pCPropDlg->GetPropertyInfo(hWnd, DATASOURCE, pCDataSource->m_pIDBProperties));
					return 0;

				case IDMENU_COMMAND_CANCONVERT:
					if(pCCommand->m_pIConvertType)
					{
						//Indicate This was called from the Command
						pThis->m_eSource = COMMAND;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_CANCONVERT), hWnd, CanConvertProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_ROWSET_CANCONVERT:
					if(pCRowset->m_pIConvertType)
					{
						//Indicate This was called from the Rowset
						pThis->m_eSource = ROWSET;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_CANCONVERT), hWnd, CanConvertProc, (LPARAM)pThis));
					}
					return 0;

				//Command Accessor
				case IDMENU_COMMAND_ACCESSOR_GETBINDINGS: 
					if(pCCommand->m_pIAccessor)
					{
						//Indicate This was called from the Rowset
						pThis->m_eSource = COMMAND;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETLISTVIEW), hWnd, GetBindingsProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_COMMAND_ACCESSOR_ADDREFACCESSOR: 
					if(pCCommand->m_pIAccessor)
					{
						ULONG ulRefCount = 0;

						//IAccessor::AddRefAccessor
						pCListBox->OutputPreMethod("IAccessor::AddRefAccessor(0x%08x, &%d)", pCRowset->m_hAccessor, ulRefCount);
						XTEST(hWnd, hr = pCCommand->m_pIAccessor->AddRefAccessor(pCRowset->m_hAccessor, &ulRefCount));
						pCListBox->OutputPostMethod(hr, "IAccessor::AddRefAccessor(0x%08x, &%d)", pCRowset->m_hAccessor, ulRefCount);
					}
					return 0;
				
				case IDMENU_COMMAND_ACCESSOR_CREATEACCESSOR: 
					if(pCCommand->m_pIAccessor)
					{
						//Indicate This was called from the Command
						pThis->m_eSource = COMMAND;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_CREATEACCESSOR), hWnd, CreateAccessorProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_COMMAND_ACCESSOR_RELEASEACCESSOR: 
					if(pCCommand->m_pIAccessor)
						EXC_TEST(pCCommand->ReleaseAccessor(&pCRowset->m_hAccessor));
					return 0;

				//Rowset Accessor
				case IDMENU_ROWSET_ACCESSOR_GETBINDINGS: 
					if(pCRowset->m_pIAccessor)
					{
						//Indicate This was called from the Rowset
						pThis->m_eSource = ROWSET;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETLISTVIEW), hWnd, GetBindingsProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_ROWSET_ACCESSOR_ADDREFACCESSOR: 
					if(pCRowset->m_pIAccessor)
					{
						ULONG ulRefCount = 0;

						//IAccessor::AddRefAccessor
						pCListBox->OutputPreMethod("IAccessor::AddRefAccessor(0x%08x, &%d)", pCRowset->m_hAccessor, ulRefCount);
						XTEST(hWnd, hr = pCRowset->m_pIAccessor->AddRefAccessor(pCRowset->m_hAccessor, &ulRefCount));
						pCListBox->OutputPostMethod(hr, "IAccessor::AddRefAccessor(0x%08x, &%d)", pCRowset->m_hAccessor, ulRefCount);
					}
					return 0;

				case IDMENU_ROWSET_ACCESSOR_CREATEACCESSOR: 
					if(pCRowset->m_pIAccessor)
					{
						//Indicate This was called from the Rowset
						pThis->m_eSource = ROWSET;
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_CREATEACCESSOR), hWnd, CreateAccessorProc, (LPARAM)pThis));
					}
					return 0;

				case IDMENU_ROWSET_ACCESSOR_RELEASEACCESSOR: 
					if(pCRowset->m_pIAccessor)
						EXC_TEST(pCRowset->ReleaseAccessor(&pCRowset->m_hAccessor));
					return 0;

				//ITableDefinition
				case IDMENU_TABLE_CREATETABLE:
				case IDMENU_TABLE_ADDCOLUMN:
				case IDMENU_TABLE_DROPCOLUMN:
					return 0;

				case IDMENU_TABLE_DROPTABLE:
					if(pCSession->m_pITableDefinition)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_DROPTABLE), hWnd, DropTableProc, (LPARAM)pThis));
					return 0;

				//IIndexDefinition
				case IDMENU_INDEX_CREATEINDEX:
					return 0;

				case IDMENU_INDEX_DROPINDEX:
					if(pCSession->m_pIIndexDefinition)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_DROPINDEX), hWnd, DropIndexProc, (LPARAM)pThis));
					return 0;

				//IRowsetIdentity
				case IDMENU_ROWSETINDENTITY_ISSAMEROW:
					if(pCRowset->m_pIRowsetIdentity)
					{
						HWND hWndListView = pThis->m_hWndListView;

						//Obtain the First selected Row
						LONG iSelRow	= SendMessage(hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
						LONG hRow1		= LV_GetItemParam(hWndListView, iSelRow, 0);

						//Obtain the Second selected Row
						LONG iSelRow2	= SendMessage(hWndListView, LVM_GETNEXTITEM, (WPARAM)iSelRow, (LPARAM)LVNI_SELECTED);
						LONG hRow2		= LV_GetItemParam(hWndListView, iSelRow2 != LVM_ERR ? iSelRow2 : iSelRow, 0);
						
						//IRowsetIdentity::IsSameRow
						pCListBox->OutputPreMethod("IRowsetIdentity::IsSameRow(0x%08x, 0x%08x)", hRow1, hRow2);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetIdentity->IsSameRow(hRow1, hRow2));
						pCListBox->OutputPostMethod(hr, "IRowsetIdentity::IsSameRow(0x%08x, 0x%08x)", hRow1, hRow2);
					}
					return 0;

				
				//IRowsetScroll
				case IDMENU_ROWSETSCROLL_GETAPPROXIMATEPOSITION:
					if(pCRowset->m_pIRowsetScroll)
					{
						HWND hWndListView = pThis->m_hWndListView;
						ULONG cbBookmark = 0;
						BYTE* pBookmark = NULL;
						void* pData = NULL;
						ULONG ulPosition = 0;
						ULONG cRows = 0;

						//Obtain the First selected Row
						LONG iSelRow	= SendMessage(hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
						LONG hRow		= LV_GetItemParam(hWndListView, iSelRow, 0);
						
						//Obtain the bookmark for the selected row...
						if(iSelRow!=LVM_ERR)
						{
							EXC_TEST(hr = pCRowset->GetBookmark(hRow, &cbBookmark, &pBookmark, &pData));
						}
						
						//IRowsetScroll::GetApproximatePosition
						pCListBox->OutputPreMethod("IRowsetScroll::GetApproximatePosition(NULL, %d, 0x%08x, &%d, &%d)", cbBookmark, pBookmark, ulPosition, cRows);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetScroll->GetApproximatePosition(NULL, cbBookmark, pBookmark, &ulPosition, &cRows));
						pCListBox->OutputPostMethod(hr, "IRowsetScroll::GetApproximatePosition(NULL, %d, 0x%08x, &%d, &%d)", cbBookmark, pBookmark, ulPosition, cRows);

						//Cleanup
						SAFE_FREE(pData);
					}
					return 0;


				//IRowsetLocate
				case IDMENU_ROWSETLOCATE_COMPARE:
					if(pCRowset->m_pIRowsetLocate)
					{
						HWND hWndListView = pThis->m_hWndListView;
						HROW  rghRows[2] = {NULL, NULL};
						ULONG rgcbBookmarks[2] = {0, 0};
						const BYTE* rgpBookmarks[2] = {NULL, NULL};
						void* rgpData[2] = {NULL, NULL};
						DBCOMPARE dwComparison = 0;

						//Obtain the First selected Row
						LONG iSelRow	= SendMessage(hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
						rghRows[0]		= LV_GetItemParam(hWndListView, iSelRow, 0);

						//Obtain the Second selected Row
						LONG iSelRow2	= SendMessage(hWndListView, LVM_GETNEXTITEM, (WPARAM)iSelRow, (LPARAM)LVNI_SELECTED);
						rghRows[1]		= LV_GetItemParam(hWndListView, iSelRow2 != LVM_ERR ? iSelRow2 : iSelRow, 0);
						
						//Obtain the bookmark(s) for the selected row(s)...
						if(iSelRow!=LVM_ERR)
						{
							EXC_TEST(hr = pCRowset->GetBookmark(rghRows[0], &rgcbBookmarks[0], (BYTE**)&rgpBookmarks[0], &rgpData[0]));
							EXC_TEST(hr = pCRowset->GetBookmark(rghRows[1], &rgcbBookmarks[1], (BYTE**)&rgpBookmarks[1], &rgpData[1]));
						}

						//IRowsetLocate::Compare
						pCListBox->OutputPreMethod("IRowsetLocate::Compare(NULL, %d, 0x%08x, %d, 0x%08x, &%d)", rgcbBookmarks[0], rgpBookmarks[0], rgcbBookmarks[1], rgpBookmarks[1], dwComparison);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetLocate->Compare(NULL, rgcbBookmarks[0], rgpBookmarks[0], rgcbBookmarks[1], rgpBookmarks[1], &dwComparison));
						pCListBox->OutputPostMethod(hr, "IRowsetLocate::Compare(NULL, %d, 0x%08x, %d, 0x%08x, &%d)", rgcbBookmarks[0], rgpBookmarks[0], rgcbBookmarks[1], rgpBookmarks[1], dwComparison);

						//Cleanup
						SAFE_FREE(rgpData[0]);
						SAFE_FREE(rgpData[1]);
					}
					return 0;

				case IDMENU_ROWSETLOCATE_HASH:
					if(pCRowset->m_pIRowsetLocate)
					{
						HWND hWndListView = pThis->m_hWndListView;
						ULONG cRows = 0;
						HROW* rghRows = NULL;
						ULONG rgcbBookmarks[MAX_OPENROWS+1];
						const BYTE* rgpBookmarks[MAX_OPENROWS+1];
						void* rgpData[MAX_OPENROWS+1];
						DBROWSTATUS rgHashedValues[MAX_OPENROWS+1];
						DBROWSTATUS rgBookmarkStatus[MAX_OPENROWS+1];

						//Obtain all Selected Rows
						LV_GetSelItems(hWndListView, &cRows, NULL, (LONG**)&rghRows);
						cRows = min(cRows, MAX_OPENROWS);

						//Obtain the bookmark(s) for the selected row(s)...
						for(ULONG i=0; i<cRows; i++)
							EXC_TEST(hr = pCRowset->GetBookmark(rghRows[i], &rgcbBookmarks[i], (BYTE**)&rgpBookmarks[i], &rgpData[i]))

						//IRowsetLocate::Hash
						pCListBox->OutputPreMethod("IRowsetLocate::Hash(NULL, %d, 0x%08x, 0x%08x, 0x%08x, 0x%08x)", cRows, rgcbBookmarks, rgpBookmarks, rgHashedValues, rgBookmarkStatus);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetLocate->Hash(NULL, cRows, rgcbBookmarks, rgpBookmarks, rgHashedValues, rgBookmarkStatus));
						pCListBox->OutputPostMethod(hr, "IRowsetLocate::Hash(NULL, %d, 0x%08x, 0x%08x, 0x%08x, 0x%08x)", cRows, rgcbBookmarks, rgpBookmarks, rgHashedValues, rgBookmarkStatus);

						//Cleanup
						SAFE_FREE(rghRows);
						for(i=0; i<cRows; i++)
							SAFE_FREE(rgpData[i]);
					}
					return 0;
		
				case IDMENU_ROWSETLOCATE_GETROWSBYBOOKMARK:
					if(pCRowset->m_pIRowsetLocate)
					{
						HWND hWndListView = pThis->m_hWndListView;
						ULONG cRows = 0;
						HROW* rghRows = NULL;
						ULONG rgcbBookmarks[MAX_OPENROWS+1];
						const BYTE* rgpBookmarks[MAX_OPENROWS+1];
						void* rgpData[MAX_OPENROWS+1];
						DBROWSTATUS rgRowStatus[MAX_OPENROWS+1];

						//Obtain all Selected Rows
						LV_GetSelItems(hWndListView, &cRows, NULL, (LONG**)&rghRows);
						cRows = min(cRows, MAX_OPENROWS);

						//Obtain the bookmark(s) for the selected row(s)...
						for(ULONG i=0; i<cRows; i++)
							EXC_TEST(hr = pCRowset->GetBookmark(rghRows[i], &rgcbBookmarks[i], (BYTE**)&rgpBookmarks[i], &rgpData[i]));

						//IRowsetLocate::GetRowsByBookmark
						pCListBox->OutputPreMethod("IRowsetLocate::GetRowsByBookmark(NULL, %d, 0x%08x, 0x%08x, 0x%08x, 0x%08x)", cRows, rgcbBookmarks, rgpBookmarks, rghRows, rgRowStatus);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetLocate->GetRowsByBookmark(NULL, cRows, rgcbBookmarks, rgpBookmarks, rghRows, rgRowStatus));
						pCListBox->OutputPostMethod(hr, "IRowsetLocate::GetRowsByBookmark(NULL, %d, 0x%08x, 0x%08x, 0x%08x, 0x%08x)", cRows, rgcbBookmarks, rgpBookmarks, rghRows, rgRowStatus);

						//Cleanup
						SAFE_FREE(rghRows);
						for(i=0; i<cRows; i++)
							SAFE_FREE(rgpData[i]);
					}
					return 0;
					
				case IDMENU_ROWSETLOCATE_GETROWSAT:
					if(pCRowset->m_pIRowsetLocate)
					{
						HWND hWndListView = pThis->m_hWndListView;
						LONG  lOffset = 0;
						LONG  cRowsSel = 0;
						HROW* rghRowsSel = NULL;
						ULONG cbBookmark = 0;
						BYTE* pBookmark = NULL;
						void* pData = NULL;
						ULONG cRowsObtained = 0;
						HROW* rghRows = NULL;

						//Obtain all Selected Rows
						LV_GetSelItems(hWndListView, (ULONG*)&cRowsSel, NULL, (LONG**)&rghRowsSel);
						cRowsSel = min(cRowsSel, MAX_OPENROWS);

						//Obtain the bookmark for the first row...
						EXC_TEST(hr = pCRowset->GetBookmark(rghRowsSel[0], &cbBookmark, &pBookmark, &pData))

						//IRowsetLocate::GetRowsAt
						pCListBox->OutputPreMethod("IRowsetLocate::GetRowsAt(NULL, NULL, %d, 0x%08x, %d, %d, &%d, &0x%08x)", cbBookmark, pBookmark, lOffset, cRowsSel, cRowsObtained, rghRows);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetLocate->GetRowsAt(NULL, NULL, cbBookmark, pBookmark, lOffset, cRowsSel, &cRowsObtained, &rghRows));
						pCListBox->OutputPostMethod(hr, "IRowsetLocate::GetRowsAt(NULL, NULL, %d, 0x%08x, %d, %d, &%d, &0x%08x)", cbBookmark, pBookmark, lOffset, cRowsSel, cRowsObtained, rghRows);

						//Cleanup
						SAFE_FREE(rghRowsSel);
						SAFE_FREE(rghRows);
						SAFE_FREE(pData);
					}
					return 0;
				

				//IRowsetFind
				case IDMENU_ROWSETFIND_FINDNEXTROW:
					if(pCRowset->m_pIRowsetFind)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_FINDNEXTROW), hWnd, FindNextRowProc, (LPARAM)pThis));
					return 0;


				//CommandWithParameters
				case IDMENU_MAPPARAMETERNAMES: 
					return 0;

				case IDMENU_SETPARAMETERINFO: 
					if(pCCommand->m_pICommandWithParameters)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_SETPARAMETERINFO), hWnd, SetParameterInfoProc, (LPARAM)pThis));
					return 0;

				case IDMENU_GETPARAMETERINFO: 
					if(pCCommand->m_pICommandWithParameters)
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_GETLISTVIEW), hWnd, GetParameterInfoProc, (LPARAM)pThis));
					return 0;

				case IDMENU_PERSIST_GETCLASSID:
					if(pCDataSource->m_pIPersist)
					{
						CLSID clsid;
						EXC_TEST(pCDataSource->GetClassID(clsid));
					}
					return 0;
				
				case IDMENU_PERSISTFILE_LOAD:
					if(pCDataSource->m_pIPersistFile)
					{
						WCHAR wszBuffer[MAX_QUERY_LEN];
						wszBuffer[0] = wEOL;
						
						//Display Common Dialog to obtain File To Load...
						EXC_TEST(hr = BrowseOpenFileName(pThis->m_hInst, hWnd, "IPersistFile::Load", wszBuffer, MAX_QUERY_LEN));
						if(SUCCEEDED(hr))
						{
							//IPersistFile::Load
							pCListBox->OutputPreMethod("IPersistFile::Load(\"%S\", STGM_READ)", wszBuffer);
							XTEST(hWnd, hr = pCDataSource->m_pIPersistFile->Load(wszBuffer, STGM_READ));
							pCListBox->OutputPostMethod(hr, "IPersistFile::Load(\"%S\", STGM_READ)", wszBuffer);
						}
					}
					return 0;

				case IDMENU_PERSISTFILE_SAVE:
					if(pCDataSource->m_pIPersistFile)
					{
						WCHAR wszBuffer[MAX_QUERY_LEN];
						wszBuffer[0] = wEOL;
						
						//Display Common Dialog to obtain File To Save...
						EXC_TEST(hr = BrowseSaveFileName(pThis->m_hInst, hWnd, "IPersistFile::Save", wszBuffer, MAX_QUERY_LEN));
						if(SUCCEEDED(hr))
						{
							//IPersistFile::Save
							pCListBox->OutputPreMethod("IPersistFile::Save(\"%S\", TRUE)", wszBuffer);
							XTEST(hWnd, hr = pCDataSource->m_pIPersistFile->Save(wszBuffer, TRUE));
							pCListBox->OutputPostMethod(hr, "IPersistFile::Save(\"%S\", TRUE)", wszBuffer);
						}
					}
					return 0;

				case IDMENU_PERSISTFILE_SAVECOMPLETED:
					if(pCDataSource->m_pIPersistFile)
					{
						WCHAR wszBuffer[MAX_QUERY_LEN];
						wszBuffer[0] = wEOL;
						
						//Display Common Dialog to obtain File To Save...
						EXC_TEST(hr = BrowseSaveFileName(pThis->m_hInst, hWnd, "IPersistFile::SaveCompleted", wszBuffer, MAX_QUERY_LEN));
						if(SUCCEEDED(hr))
						{
							//IPersistFile::Save
							pCListBox->OutputPreMethod("IPersistFile::SaveCompleted(\"%S\")", wszBuffer);
							XTEST(hWnd, hr = pCDataSource->m_pIPersistFile->SaveCompleted(wszBuffer));
							pCListBox->OutputPostMethod(hr, "IPersistFile::SaveCompleted(\"%S\")", wszBuffer);
						}
					}
					return 0;

				case IDMENU_PERSISTFILE_GETCURFILE:
					if(pCDataSource->m_pIPersistFile)
					{
						WCHAR* pwszFileName = NULL;

						//IPersistFile::GetCurFile
						pCListBox->OutputPreMethod("IPeristFile::GetCurFile(%S)", pwszFileName);
						XTEST(hWnd, hr = pCDataSource->m_pIPersistFile->GetCurFile(&pwszFileName));
						pCListBox->OutputPostMethod(hr, "IPeristFile::GetCurFile(%S)", pwszFileName);
					}
					return 0;
				
				case IDMENU_PERSISTFILE_ISDIRTY:
					if(pCDataSource->m_pIPersistFile)
					{		 
						//IPersistFile::IsDirty
						pCListBox->OutputPreMethod("IPeristFile::IsDirty()");
						XTEST(hWnd, hr = pCDataSource->m_pIPersistFile->IsDirty());
						pCListBox->OutputPostMethod(hr, "IPeristFile::IsDirty()");
					}
					return 0;

				case IDMENU_ROWPOS_CLEARROWPOSITION:
					if(pCRowPos->m_pIRowPosition)
					{
						pCListBox->OutputPreMethod("IRowPosition::ClearRowPosition()");
						XTEST(hWnd, hr = pCRowPos->m_pIRowPosition->ClearRowPosition());
						pCListBox->OutputPostMethod(hr, "IRowPosition::ClearRowPosition()");
					}
					return 0;

				case IDMENU_ROWPOS_SETROWPOSITION:
					if(pCRowPos->m_pIRowPosition)
					{
						//Find the SelectedRow
						LONG iSelRow = SendMessage(pThis->m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
						if(iSelRow == LVM_ERR)
						{
							wMessageBox(hWnd, MB_TASKMODAL | MB_ICONHAND | MB_OK | MB_DEFBUTTON1, 
								wsz_ERROR, L"Must first select a row...");
							return 0;
						}
						
						//Obtain row handle and row index from lParam stored in the ListView
						HROW hRow = LV_GetItemParam(pThis->m_hWndListView, iSelRow, 0);
						
						//Set RowPosition
						pCListBox->OutputPreMethod("IRowPosition::SetRowPosition(NULL, 0x%08x, %d)", hRow, DBPOSITION_OK);
						XTEST(hWnd, hr = pCRowPos->m_pIRowPosition->SetRowPosition(NULL, hRow, DBPOSITION_OK));
						pCListBox->OutputPostMethod(hr, "IRowPosition::SetRowPosition(NULL, 0x%08x, %d)", hRow, DBPOSITION_OK);
					}
					return 0;

				case IDMENU_GETDATA:
					if(pCRowset->m_pIRowset)
					{
						ULONG cRows = 0;
						LONG* rgItems = NULL;
						HROW* rghRows = NULL;
						
						//Find all Selected Rows
						LV_GetSelItems(pThis->m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);
						if(cRows == 0)
						{
							wMessageBox(hWnd, MB_TASKMODAL | MB_ICONHAND | MB_OK | MB_DEFBUTTON1, 
								wsz_ERROR, L"Must first select a row...");
						}

						
						for(ULONG i=0; i<cRows; i++)
						{
							//Display the Data for this row...
							EXC_TEST(pThis->DisplayData(IID_IRowset, rghRows[i], rgItems[i]));
						}
						SAFE_FREE(rgItems);
						SAFE_FREE(rghRows);
					}
					return 0;

				case IDMENU_REFRESH:					
					if(pCRowset->m_pIRowset)
					{
						//Similar to GetData except for all rows
						EXC_TEST(pThis->RestartPosition());
						EXC_TEST(pThis->RefreshData());
					}
					return 0;
				
				case IDMENU_GETVISIBLEDATA:
					if(pCRowset->m_pIRowsetResynch)
					{
						ULONG cRows = 0;
						LONG* rgItems = NULL;
						HROW* rghRows = NULL;
						
						//Find all Selected Rows
						LV_GetSelItems(pThis->m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);
						if(cRows == 0)
						{
							wMessageBox(hWnd, MB_TASKMODAL | MB_ICONHAND | MB_OK | MB_DEFBUTTON1, 
								wsz_ERROR, L"Must first select a row...");
						}

						for(ULONG i=0; i<cRows; i++)
						{
							//Display the Data for this row...
							EXC_TEST(pThis->DisplayData(IID_IRowsetResynch, rghRows[i], rgItems[i]));
						}
						SAFE_FREE(rgItems);
						SAFE_FREE(rghRows);
					}
					return 0;

				case IDMENU_RESYNCHROWS:
					if(pCRowset->m_pIRowsetResynch)
					{
						ULONG i,cRows = 0;
						HROW* rghRows = NULL;
						ULONG cRowsResynched = 0;
						HROW* rghRowsResynched = 0;
						DBROWSTATUS* rgRowStatus = NULL;
						LONG* rgItems = NULL;

						//Get all selected Rows
						LV_GetSelItems(pThis->m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);

						//IRowsetResynch::ResynchRows
						pCListBox->OutputPreMethod("IRowsetResynch::ResynchRows(%d, 0x%08x, &%d, &0x%08x, &0x%08x)", cRows, rghRows, cRowsResynched, rghRowsResynched, rgRowStatus);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetResynch->ResynchRows(cRows, rghRows, &cRowsResynched, &rghRowsResynched, &rgRowStatus));
						if(hr==DB_S_ERRORSOCCURRED || hr==DB_E_ERRORSOCCURRED)
							DisplayRowErrors(hWnd, cRowsResynched, rghRowsResynched, rgRowStatus);
						pCListBox->OutputPostMethod(hr, "IRowsetResynch::ResynchRows(%d, 0x%08x, &%d, &0x%08x, &0x%08x)", cRows, rghRows, cRowsResynched, rghRowsResynched, rgRowStatus);

						//Now GetData for all SelectedRows (a nice helper)
						//We won't worry about updating the case for (0,NULL), its not worth
						//trying to match the rhgRows returned to the correct hRows.  Worse case
						//is the user has to call GetData for one or all rows...
						for(i=0; i<cRows; i++)
						{
							//Display the Data for this row...
							EXC_TEST(pThis->DisplayData(IID_IRowset, rghRows[i], rgItems[i]));
						}

						//Cleanup
						SAFE_FREE(rghRows);
						SAFE_FREE(rghRowsResynched);
						SAFE_FREE(rgRowStatus);
						SAFE_FREE(rgItems);
					}
					return 0;

				case IDMENU_GETORIGINALDATA:			
					if(pCRowset->m_pIRowsetUpdate)
					{
						ULONG cRows = 0;
						LONG* rgItems = NULL;
						HROW* rghRows = NULL;
						
						//Find all Selected Rows
						LV_GetSelItems(pThis->m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);
						if(cRows == 0)
						{
							wMessageBox(hWnd, MB_TASKMODAL | MB_ICONHAND | MB_OK | MB_DEFBUTTON1, 
								wsz_ERROR, L"Must first select a row...");
						}

						for(ULONG i=0; i<cRows; i++)
						{
							//Display the Data for this row...
							EXC_TEST(pThis->DisplayData(IID_IRowsetUpdate, rghRows[i], rgItems[i]));
						}
						SAFE_FREE(rgItems);
						SAFE_FREE(rghRows);
					}
					return 0;

				case IDMENU_GETPENDINGROWS:			
					if(pCRowset->m_pIRowsetUpdate)
					{
						ULONG cPendingRows = 0;
						HROW* rgPendingRows = 0;
						DBPENDINGSTATUS* rgPendingStatus = NULL;

						//IRowsetUpdate::GetPendingStatus
						pCListBox->OutputPreMethod("IRowsetUpdate::GetPendingRows(NULL, DBPENDINGSTATUS_NEW | DBPENDINGSTATUS_CHANGED | DBPENDINGSTATUS_DELETED, &%d, &0x%08x, &0x%08x)", cPendingRows, rgPendingRows, rgPendingStatus);
						XTEST(hWnd, hr = pCRowset->m_pIRowsetUpdate->GetPendingRows(NULL, DBPENDINGSTATUS_NEW | DBPENDINGSTATUS_CHANGED | DBPENDINGSTATUS_DELETED, &cPendingRows, &rgPendingRows, &rgPendingRows));
						pCListBox->OutputPostMethod(hr, "IRowsetUpdate::GetPendingRows(NULL, DBPENDINGSTATUS_NEW | DBPENDINGSTATUS_CHANGED | DBPENDINGSTATUS_DELETED, &%d, &0x%08x, &0x%08x)", cPendingRows, rgPendingRows, rgPendingStatus);

						//Cleanup
						SAFE_FREE(rgPendingRows);
						SAFE_FREE(rgPendingStatus);
					}
					return 0;

				case IDMENU_GETROWSTATUS:
					if(pCRowset->m_pIRowsetUpdate)
					{
						//Find the SelectedRow
						LONG iSelRow = SendMessage(pThis->m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED);
						if(iSelRow != LVM_ERR)
						{
							HROW hRow = LV_GetItemParam(pThis->m_hWndListView, iSelRow, 0);
							DBPENDINGSTATUS dwPendingStatus = 0;

							//IRowsetUpdate::GetRowStatus
							pCListBox->OutputPreMethod("IRowsetUpdate::GetRowStatus(NULL, %d, &0x%08x, &0x%08x)", 1, hRow, dwPendingStatus);
							XTEST(hWnd, hr = pCRowset->m_pIRowsetUpdate->GetRowStatus(NULL, 1, &hRow, &dwPendingStatus));
							pCListBox->OutputPostMethod(hr, "IRowsetUpdate::GetRowStatus(NULL, %d, &0x%08x, &0x%08x)", 1, hRow, dwPendingStatus);
						}
					}
					return 0;

				case IDMENU_UNDO:			//Cancel the chagnes that were made.
					if(pCRowset->m_pIRowsetUpdate)
						EXC_TEST(pThis->UndoChanges());
					return 0;

				case IDMENU_UPDATE:			//Update the changes that were made.
					if(pCRowset->m_pIRowsetUpdate)
						EXC_TEST(pThis->UpdateChanges());
					return 0;

				case IDMENU_CREATECOMMAND:			
					if(pCSession->m_pIDBCreateCommand)
					{
						pThis->m_pwszSource = "IDBCreateCommand::CreateCommand";
						pThis->m_iidSource  = IID_ICommandText;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//Create a new Command Object
							EXC_TEST(pCCommand->CreateCommand(pThis->m_iidSource));
							EXC_TEST(pThis->RefreshControls());
						}
					}
					return 0;

				case IDMENU_DATASOURCE_SUPPORTERRORINFO:
					if(pCDataSource->m_pISupportErrorInfo)
					{
						pThis->m_pwszSource = "ISupportErrorInfo::InterfaceSupportsErrorInfo";
						pThis->m_iidSource  = IID_IDBInitialize;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ISupportErrorInfo::InterfaceSupportsErrorInfo
							pCListBox->OutputPreMethod("ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
							XTEST(hWnd, hr = pCDataSource->m_pISupportErrorInfo->InterfaceSupportsErrorInfo(pThis->m_iidSource));
							pCListBox->OutputPostMethod(hr, "ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
						}
					}
					return 0;

				case IDMENU_SESSION_SUPPORTERRORINFO:
					if(pCSession->m_pISupportErrorInfo)
					{
						pThis->m_pwszSource = "ISupportErrorInfo::InterfaceSupportsErrorInfo";
						pThis->m_iidSource  = IID_IOpenRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ISupportErrorInfo::InterfaceSupportsErrorInfo
							pCListBox->OutputPreMethod("ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
							XTEST(hWnd, hr = pCSession->m_pISupportErrorInfo->InterfaceSupportsErrorInfo(pThis->m_iidSource));
							pCListBox->OutputPostMethod(hr, "ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
						}
					}
					return 0;

				case IDMENU_COMMAND_SUPPORTERRORINFO:
					if(pCCommand->m_pISupportErrorInfo)
					{
						pThis->m_pwszSource = "ISupportErrorInfo::InterfaceSupportsErrorInfo";
						pThis->m_iidSource  = IID_ICommandText;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ISupportErrorInfo::InterfaceSupportsErrorInfo
							pCListBox->OutputPreMethod("ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
							XTEST(hWnd, hr = pCCommand->m_pISupportErrorInfo->InterfaceSupportsErrorInfo(pThis->m_iidSource));
							pCListBox->OutputPostMethod(hr, "ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
						}
					}
					return 0;

				case IDMENU_ROWSET_SUPPORTERRORINFO:
					if(pCRowset->m_pISupportErrorInfo)
					{
						pThis->m_pwszSource = "ISupportErrorInfo::InterfaceSupportsErrorInfo";
						pThis->m_iidSource  = IID_IRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ISupportErrorInfo::InterfaceSupportsErrorInfo
							pCListBox->OutputPreMethod("ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
							XTEST(hWnd, hr = pCRowset->m_pISupportErrorInfo->InterfaceSupportsErrorInfo(pThis->m_iidSource));
							pCListBox->OutputPostMethod(hr, "ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
						}
					}
					return 0;

				case IDMENU_ENUMERATOR_SUPPORTERRORINFO:
					if(pCDataSource->m_pISupportErrorInfo)
					{
						pThis->m_pwszSource = "ISupportErrorInfo::InterfaceSupportsErrorInfo";
						pThis->m_iidSource  = IID_ISourcesRowset;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ISupportErrorInfo::InterfaceSupportsErrorInfo
							pCListBox->OutputPreMethod("ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
							XTEST(hWnd, hr = pCDataSource->m_pISupportErrorInfo->InterfaceSupportsErrorInfo(pThis->m_iidSource));
							pCListBox->OutputPostMethod(hr, "ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
						}
					}
					return 0;
				
				case IDMENU_TRANSACTION_SUPPORTERRORINFO:
					if(pCDataSource->m_pISupportErrorInfo)
					{
						pThis->m_pwszSource = "ISupportErrorInfo::InterfaceSupportsErrorInfo";
						pThis->m_iidSource  = IID_ITransaction;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							//ISupportErrorInfo::InterfaceSupportsErrorInfo
							pCListBox->OutputPreMethod("ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
							XTEST(hWnd, hr = pCDataSource->m_pISupportErrorInfo->InterfaceSupportsErrorInfo(pThis->m_iidSource));
							pCListBox->OutputPostMethod(hr, "ISupportErrorInfo::InterfaceSupportsErrorInfo(%s)", GetInterfaceName(pThis->m_iidSource));
						}
					}
					return 0;

				//DataSource IConnectionPointContainer
				case IDMENU_DATASOURCE_FINDCONNECTIONPOINT:
					if(pCDataSource->m_pIConnectionPointContainer)
					{
						pThis->m_pwszSource = "IConnectionPointContainer::FindConnectionPoint";
						pThis->m_iidSource  = IID_IDBAsynchNotify;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							SAFE_RELEASE(pCDataSource->m_pIConnectionPoint);
							pCListBox->OutputPreMethod("IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pCDataSource->m_pIConnectionPoint);
							XTEST(hWnd, hr = pCDataSource->m_pIConnectionPointContainer->FindConnectionPoint(pThis->m_iidSource, &pCDataSource->m_pIConnectionPoint));
							pCListBox->OutputPostMethod(hr, "IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pCDataSource->m_pIConnectionPoint);
						}
					}
					return 0;

				//DataSource IConnectionPoint
				case IDMENU_DATASOURCE_GETCONNECTIONINTERFACE:
					if(pCDataSource->m_pIConnectionPoint)
					{
						IID iid;
						pCListBox->OutputPreMethod("IConnectionPoint::GetConnectionInterface(&NULL)");
						XTEST(hWnd, hr = pCDataSource->m_pIConnectionPoint->GetConnectionInterface(&iid));
						pCListBox->OutputPostMethod(hr, "IConnectionPoint::GetConnectionInterface(&%s)", GetInterfaceName(iid));
					}
					return 0;

				//Rowset IConnectionPointContainer
				case IDMENU_ROWSET_FINDCONNECTIONPOINT:
					if(pCRowset->m_pIConnectionPointContainer)
					{
						pThis->m_pwszSource = "IConnectionPointContainer::FindConnectionPoint";
						pThis->m_iidSource  = IID_IRowsetNotify;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						if(bReturn)
						{
							SAFE_RELEASE(pCRowset->m_pIConnectionPoint);
							pCListBox->OutputPreMethod("IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pCRowset->m_pIConnectionPoint);
							XTEST(hWnd, hr = pCRowset->m_pIConnectionPointContainer->FindConnectionPoint(pThis->m_iidSource, &pCRowset->m_pIConnectionPoint));
							pCListBox->OutputPostMethod(hr, "IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pCRowset->m_pIConnectionPoint);
						}
					}
					return 0;

				//Rowset IConnectionPoint
				case IDMENU_ROWSET_GETCONNECTIONINTERFACE:
					if(pCRowset->m_pIConnectionPoint)
					{
						IID iid;
						pCListBox->OutputPreMethod("IConnectionPoint::GetConnectionInterface(&NULL)");
						XTEST(hWnd, hr = pCRowset->m_pIConnectionPoint->GetConnectionInterface(&iid));
						pCListBox->OutputPostMethod(hr, "IConnectionPoint::GetConnectionInterface(&%s)", GetInterfaceName(iid));
					}
					return 0;

				//RowPosition IConnectionPointContainer
				case IDMENU_ROWPOS_FINDCONNECTIONPOINT:
					if(pCRowPos->m_pIConnectionPointContainer)
					{
						pThis->m_pwszSource = "IConnectionPointContainer::FindConnectionPoint";
						pThis->m_iidSource  = IID_IRowPositionChange;
						EXC_TEST(bReturn = DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_INTERFACE), hWnd, GetInterfaceProc, (LPARAM)pThis));
						{
							SAFE_RELEASE(pCRowPos->m_pIConnectionPoint);
							pCListBox->OutputPreMethod("IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pCRowPos->m_pIConnectionPoint);
							XTEST(hWnd, hr = pCRowPos->m_pIConnectionPointContainer->FindConnectionPoint(pThis->m_iidSource, &pCRowPos->m_pIConnectionPoint));
							pCListBox->OutputPostMethod(hr, "IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(pThis->m_iidSource), pCRowPos->m_pIConnectionPoint);
						}
					}
					return 0;

				//RowPosition IConnectionPoint
				case IDMENU_ROWPOS_GETCONNECTIONINTERFACE:
					if(pCRowPos->m_pIConnectionPoint)
					{
						IID iid;
						pCListBox->OutputPreMethod("IConnectionPoint::GetConnectionInterface(&NULL)");
						XTEST(hWnd, hr = pCRowPos->m_pIConnectionPoint->GetConnectionInterface(&iid));
						pCListBox->OutputPostMethod(hr, "IConnectionPoint::GetConnectionInterface(&%s)", GetInterfaceName(iid));
					}
					return 0;

				//DataSource IDBAsynchStatus
				case IDMENU_DATASOURCE_IDBASYNCHSTATUS_ABORT:
					if(pCDataSource->m_pIDBAsynchStatus)
					{
						pCListBox->OutputPreMethod("IDBAsynchStatus::Abort(NULL, DBASYNCHOP_OPEN)");
						XTEST(hWnd, hr = pCDataSource->m_pIDBAsynchStatus->Abort(NULL, DBASYNCHOP_OPEN));
						pCListBox->OutputPostMethod(hr, "IDBAsynchStatus::Abort(NULL, DBASYNCHOP_OPEN)");
					}
					return 0;

				case IDMENU_DATASOURCE_IDBASYNCHSTATUS_GETSTATUS:
					if(pCDataSource->m_pIDBAsynchStatus)
					{
						ULONG	ulProgress = 0;
						ULONG	ulProgressMax = 0;
						ULONG	ulAsynchPhase = 0;
						LPOLESTR pwszStatusText = NULL;

						pCListBox->OutputPreMethod("IDBAsynchStatus::GetStatus(NULL, DBASYNCHOP_OPEN, &%d, &%d, &%s, &%S)", ulProgress, ulProgressMax, GetAsynchPhase(ulAsynchPhase), pwszStatusText);
						XTEST(hWnd, hr = pCDataSource->m_pIDBAsynchStatus->GetStatus(NULL, DBASYNCHOP_OPEN, &ulProgress, &ulProgressMax, &ulAsynchPhase, &pwszStatusText));
						pCListBox->OutputPostMethod(hr, "IDBAsynchStatus::GetStatus(NULL, DBASYNCHOP_OPEN, &%d, &%d, &%s, &%S)", ulProgress, ulProgressMax, GetAsynchPhase(ulAsynchPhase), pwszStatusText);
						
						SAFE_FREE(pwszStatusText);
					}
					return 0;

				//Rowset IDBAsynchStatus
				case IDMENU_ROWSET_IDBASYNCHSTATUS_ABORT:
					if(pCRowset->m_pIDBAsynchStatus)
					{
						pCListBox->OutputPreMethod("IDBAsynchStatus::Abort(NULL, DBASYNCHOP_OPEN)");
						XTEST(hWnd, hr = pCRowset->m_pIDBAsynchStatus->Abort(NULL, DBASYNCHOP_OPEN));
						pCListBox->OutputPostMethod(hr, "IDBAsynchStatus::Abort(NULL, DBASYNCHOP_OPEN)");
					}
					return 0;

				case IDMENU_ROWSET_IDBASYNCHSTATUS_GETSTATUS:
					if(pCRowset->m_pIDBAsynchStatus)
					{
						ULONG	ulProgress = 0;
						ULONG	ulProgressMax = 0;
						ULONG	ulAsynchPhase = 0;
						LPOLESTR pwszStatusText = NULL;

						pCListBox->OutputPreMethod("IDBAsynchStatus::GetStatus(NULL, DBASYNCHOP_OPEN, &%d, &%d, &%s, &%S)", ulProgress, ulProgressMax, GetAsynchPhase(ulAsynchPhase), pwszStatusText);
						XTEST(hWnd, hr = pCRowset->m_pIDBAsynchStatus->GetStatus(NULL, DBASYNCHOP_OPEN, &ulProgress, &ulProgressMax, &ulAsynchPhase, &pwszStatusText));
						pCListBox->OutputPostMethod(hr, "IDBAsynchStatus::GetStatus(NULL, DBASYNCHOP_OPEN, &%d, &%d, &%s, &%S)", ulProgress, ulProgressMax, GetAsynchPhase(ulAsynchPhase), pwszStatusText);
						
						SAFE_FREE(pwszStatusText);
					}
					return 0;

				//IDataInitialize
				case IDMENU_IDATAINITIALIZE_GETINITIALIZATIONSTRING:
					if(pThis->GetConnectObj()->pIDataInitialize() && pCDataSource->m_pIUnknown)
						EXC_TEST(pThis->GetConnectObj()->GetInitString(pCDataSource->m_pIUnknown, TRUE, NULL));
					return 0;
				
				case IDMENU_IDATAINITIALIZE_GETINITIALIZATIONSTRING_NOPASSWORD:
					if(pThis->GetConnectObj()->pIDataInitialize() && pCDataSource->m_pIUnknown)
						EXC_TEST(pThis->GetConnectObj()->GetInitString(pCDataSource->m_pIUnknown, FALSE, NULL));
					return 0;

				//IDataInitialize
				case IDMENU_IDATAINITIALIZE_WRITESTRINGTOSTORAGE:
					if(pThis->GetConnectObj()->pIDataInitialize() && pCDataSource->m_pIUnknown)
					{
						WCHAR* pwszInitString = NULL;
						BOOL fIncludePassword = TRUE;

						//Get the InitString for this DataSource
						EXC_TEST(hr = pThis->GetConnectObj()->GetInitString(pCDataSource->m_pIUnknown, fIncludePassword, &pwszInitString));
						if(SUCCEEDED(hr))
						{
							//Find the FileName to Save as...
							WCHAR wszFileName[MAX_QUERY_LEN];
							wszFileName[0] = wEOL;
							
							//Display Common Dialog to obtain File To Save...
							EXC_TEST(hr = BrowseSaveFileName(pThis->m_hInst, hWnd, "IDataInitialize::WriteStringToStorage", wszFileName, MAX_QUERY_LEN));
							if(SUCCEEDED(hr))
								EXC_TEST(pThis->GetConnectObj()->SaveInitString(wszFileName, pwszInitString));
						}
						SAFE_FREE(pwszInitString);
					}
					return 0;

				//IRowsetNotify Return Codes
				case IDMENU_IROWSETNOTIFY_S_OK:
					EXC_TEST(pCRowset->m_pCRowsetNotify->SetReturnValue(S_OK));
					return 0;
				case IDMENU_IROWSETNOTIFY_S_FALSE:
					EXC_TEST(pCRowset->m_pCRowsetNotify->SetReturnValue(S_FALSE));
					return 0;
				case IDMENU_IROWSETNOTIFY_S_UNWANTEDPHASE:
					EXC_TEST(pCRowset->m_pCRowsetNotify->SetReturnValue(DB_S_UNWANTEDPHASE));
					return 0;
				case IDMENU_IROWSETNOTIFY_S_UNWANTEDREASON:
					EXC_TEST(pCRowset->m_pCRowsetNotify->SetReturnValue(DB_S_UNWANTEDREASON));
					return 0;
				case IDMENU_IROWSETNOTIFY_E_FAIL:
					EXC_TEST(pCRowset->m_pCRowsetNotify->SetReturnValue(E_FAIL));
					return 0;

				//IDBAsynchNotify Return Codes
				case IDMENU_IDBASYNCHNOTIFY_S_OK:
					EXC_TEST(pCRowset->m_pCAsynchNotify->SetReturnValue(S_OK));
					return 0;
				case IDMENU_IDBASYNCHNOTIFY_S_FALSE:
					EXC_TEST(pCRowset->m_pCAsynchNotify->SetReturnValue(S_FALSE));
					return 0;
				case IDMENU_IDBASYNCHNOTIFY_S_UNWANTEDPHASE:
					EXC_TEST(pCRowset->m_pCAsynchNotify->SetReturnValue(DB_S_UNWANTEDPHASE));
					return 0;
				case IDMENU_IDBASYNCHNOTIFY_S_UNWANTEDREASON:
					EXC_TEST(pCRowset->m_pCAsynchNotify->SetReturnValue(DB_S_UNWANTEDREASON));
					return 0;
				case IDMENU_IDBASYNCHNOTIFY_E_FAIL:
					EXC_TEST(pCRowset->m_pCAsynchNotify->SetReturnValue(E_FAIL));
					return 0;

				//IRowPosition Return Codes
				case IDMENU_IROWPOSITION_S_OK:
					EXC_TEST(pCRowPos->m_pCRowPosChange->SetReturnValue(S_OK));
					return 0;
				case IDMENU_IROWPOSITION_S_FALSE:
					EXC_TEST(pCRowPos->m_pCRowPosChange->SetReturnValue(S_FALSE));
					return 0;
				case IDMENU_IROWPOSITION_S_UNWANTEDPHASE:
					EXC_TEST(pCRowPos->m_pCRowPosChange->SetReturnValue(DB_S_UNWANTEDPHASE));
					return 0;
				case IDMENU_IROWPOSITION_S_UNWANTEDREASON:
					EXC_TEST(pCRowPos->m_pCRowPosChange->SetReturnValue(DB_S_UNWANTEDREASON));
					return 0;
				case IDMENU_IROWPOSITION_E_FAIL:
					EXC_TEST(pCRowPos->m_pCRowPosChange->SetReturnValue(E_FAIL));
					return 0;
			}
			break;
		}

		case WM_SIZING:
		{
			//Record which edge was touched...
			dwSizeEdge = wParam;
			return 0;
		}
		
		case WM_SIZE:
		{
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			CMainWindow* pCMainWindow = pThis->m_pCMainWindow;

			HWND hWndListView = pThis->m_hWndListView;
			HWND hWndListBox = pThis->m_pCListBox->m_hWnd;
			HWND hWndEditBox = pThis->m_hWndEditBox;
			HWND hWndScrollBar = pThis->m_hWndScrollBar;

			// move child windows with proper screen size for text display
			LONG wWidth = LOWORD(lParam);
			LONG wHeight = HIWORD(lParam);
			
			if(wWidth == 0 || wHeight == 0)
				return 0;
			
			//Obtain window sizes...
			SIZE sizeEditBox = GetWindowSize(hWndEditBox);
			SIZE sizeScrollBar = GetWindowSize(hWndScrollBar);
			SIZE sizeListBox = GetWindowSize(hWndListBox);
			SIZE sizeListView = GetWindowSize(hWndListView);

			//The MainWindow has been resized, we need to readjust all
			//Child controls, (ScrollBar, ListBox, ListView...)
			//Move Windows with respect to the new 

			switch(dwSizeEdge)
			{
				//Top was moved, resize the Editbox
				case WMSZ_TOP:
				case WMSZ_TOPLEFT:
				case WMSZ_TOPRIGHT:
					sizeEditBox.cy = max(0, wHeight - sizeListView.cy - sizeListBox.cy);
					break;	

				//Bottom was moved, resize the Listbox
				case WMSZ_BOTTOM:
				case WMSZ_BOTTOMLEFT:
				case WMSZ_BOTTOMRIGHT:
					sizeListBox.cy = max(0, wHeight - sizeListView.cy - sizeEditBox.cy);
					break;	
			}

			MoveWindow(hWndEditBox, 0, 0, wWidth, sizeEditBox.cy, TRUE);
			MoveWindow(hWndListBox, 0, wHeight-sizeListBox.cy, wWidth, sizeListBox.cy, TRUE);
			MoveWindow(hWndScrollBar, wWidth-sizeScrollBar.cx, sizeEditBox.cy, sizeScrollBar.cx, wHeight-sizeEditBox.cy-sizeListBox.cy, TRUE);
			MoveWindow(hWndListView, 0, sizeEditBox.cy, wWidth-sizeScrollBar.cx, wHeight-sizeEditBox.cy-sizeListBox.cy, TRUE);

			//Obtain the total number of avialable items (subtract for ScrollBar)
 			pThis->m_ulMaxViewItems = SendMessage(pThis->m_hWndListView, LVM_GETCOUNTPERPAGE, 0, 0)-1;
			dwSizeEdge = 0;

			// call default procedure first, to let MDI position the child & then move its children
			DefMDIChildProc(hWnd, message, wParam, lParam);
			return 0;
        }
                
		// Initialize popup menus
		case WM_INITMENUPOPUP:
        {
	        //Ignore the msg if it is for a system menu
			if(HIWORD(lParam))
				break;
			
			HMENU hPopupMenu = (HMENU)wParam;
			UINT  uPos  = LOWORD(lParam);

			//Get the "this" pointer
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			 
			//Go through the menu items for current popup menu
			//and enable/disable menu item, if required
			INT iItems = GetMenuItemCount(hPopupMenu);
			DWORD dwFlags = 0;
			for(LONG i=0; i<iItems; i++)
			{
				dwFlags = 0;
				if(pThis->WantedMenuPos(hPopupMenu, i, &dwFlags))
				{
					EnableMenuItem(hPopupMenu, i, MF_BYPOSITION | MF_ENABLED);
					CheckMenuItem(hPopupMenu, i, MF_BYPOSITION | dwFlags);
				}
			}
			return 0;
		}

		case WM_CLOSE:
		{	
			//Send Message to the MainWindow to Close
			//Mainly used so the MainWindow updates the ToolBar if there 
			//Are no more child windows...
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			SendMessage(pThis->m_pCMainWindow->m_hWnd, WM_COMMAND, GET_WM_COMMAND_MPS(IDMENU_CLOSE, hWnd, 0));
			return 0;
		}

		case WM_MDIACTIVATE:
		{	
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			
			//This message is called for both Activation and Destruction
			//So see if this is being activated
			if((HWND)lParam == pThis->m_hWnd)
			{
				//Refresh all Controls
				pThis->RefreshControls();
			}
			return 0;
		}
		
		case WM_SETFOCUS:
		{	
			// pass on the focus to the edit box for user to type in SQL
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			SetFocus(pThis->m_hWndEditBox);
			return 0;
		}

		case WM_NOTIFY:
		{
			//Get the "this" pointer
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			NM_LISTVIEW* pListView = (NM_LISTVIEW*)lParam;
			LV_KEYDOWN* pKeyDown = (LV_KEYDOWN*)lParam;
			
			switch(pListView->hdr.code)
			{
				//Since we have "TwoClickActive" on this will get sent
				//Whenever a row is clicked on twice!
				//This functionality used to be done with NM_DBCLK
				case LVN_ITEMACTIVATE:
				{
					if(pThis->m_pCRowset->m_pCDataSource->m_pISourcesRowset)
					{
						//If enumertor rowset, double-clicking on a row
						//brings up the ParseName object in another window
						EXC_TEST(pThis->CreateEnumChild());
					}
					else
					{
						//Otherwise we have a non-enumerator rowset,
						//So were are trying to edit a row
						if(LVM_ERR != SendMessage(pThis->m_hWndListView, LVM_GETNEXTITEM, (WPARAM)-1, (LPARAM)LVNI_SELECTED))
							EXC_TEST(pThis->ChangeSelectedRow());
					}
					return 0;
				}
				
				case LVN_COLUMNCLICK:
				{
					//Can't edit "Row-Handle" Column
					if(pListView->iSubItem == 0)
						return FALSE;

					//Save the SelectedCol so the new dialog box knows which Column were concerned with...
					pThis->m_iSelectedCol = pListView->iSubItem-1;

					//Create DialogBox pasing the "this" pointer
					if(SendMessage(pThis->m_hWndListView, LVM_GETITEMCOUNT, 0, 0))
						EXC_TEST(DialogBoxParam(pThis->m_hInst, MAKEINTRESOURCE(IDD_ROWCHANGE), hWnd, ColumnChangeProc, (LPARAM)pThis));
					return 0;	
				}

				//User clicks on a row in the ListView
				case LVN_ITEMCHANGED:
				{
					//Only interested in complete changes to a new item...
					if(pListView->uNewState & LVNI_FOCUSED && pListView->uNewState & LVNI_SELECTED)
					{
					}
					return 0;
				}

				//User presses a Key...
				case LVN_KEYDOWN:
				{
					HWND hWndListView = pThis->m_hWndListView;

					//case VK_DELETE:
					switch(pKeyDown->wVKey)
					{
						case VK_DELETE:
							PostMessage(pThis->m_hWnd, WM_COMMAND, GET_WM_COMMAND_MPS(IDMENU_DELETEROWS, 0, 0));
							return 0;
				
						case VK_INSERT:
							PostMessage(pThis->m_hWnd, WM_COMMAND, GET_WM_COMMAND_MPS(IDMENU_INSERTROW, 0, 0));
							return 0;
						
						case VK_UP:
							//Only scroll the data up if at the begining of the list view
							if(SendMessage(hWndListView, LVM_GETITEMSTATE, 0, (LPARAM)(UINT)LVIS_SELECTED) & LVIS_SELECTED)
							{
								//Scroll ListView up 1
								EXC_TEST(pThis->ScrollListView(-1));
							}
							return 0;
			
						case VK_DOWN:
						{	
							//Only scroll the ata down if the scrollbar down if at the end of the list
							int iCount = SendMessage(hWndListView, LVM_GETITEMCOUNT, 0, 0);
							if(SendMessage(hWndListView, LVM_GETITEMSTATE, (WPARAM)(iCount-1), (LPARAM)(UINT)LVIS_SELECTED) & LVIS_SELECTED)
							{
								//Scroll ListView down 1
								EXC_TEST(pThis->ScrollListView(1));
							}
							return 0;
						}

						case VK_PRIOR:
							//Scroll ListView up a page
							EXC_TEST(pThis->ScrollListView(-MAX_LISTVIEWROWS));
							return 0;

						case VK_NEXT:
							//Scroll ListView down a page
							EXC_TEST(pThis->ScrollListView(MAX_LISTVIEWROWS));
							return 0;
					}
					break;
				}
			}
			break;
		}//WM_NOTIFY:
	

		case WM_VSCROLL:
		{	
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

			switch(LOWORD(wParam))
			{
				case SB_LINEUP:
					//Scroll ListView up a row
					EXC_TEST(pThis->ScrollListView(-1));
					return 0;

				case SB_LINEDOWN:
					//Scroll ListView down a row
					EXC_TEST(pThis->ScrollListView(1));
					return 0;
				
				case SB_PAGEUP:
					//Scroll ListView up a page
					EXC_TEST(pThis->ScrollListView(-MAX_LISTVIEWROWS));
					return 0;

				case SB_PAGEDOWN:
					//Scroll ListView down a page
					EXC_TEST(pThis->ScrollListView(MAX_LISTVIEWROWS));
					return 0;
				
				case SB_THUMBTRACK:
				{	
					static SHORT iLastPos = 0;
					SHORT iCurPos = HIWORD(wParam);

					//No-op
					if(iCurPos == iLastPos)
						return 0;

					//Begining or Rowset
					if(iCurPos == 0)
					{
//						if(!pThis->m_fEndReached)
//							pThis->RestartPosition();
					}
					//End of Rowset
//					else if(iCurPos >= ((LONG)pThis->m_ulScrollMax-10))
//					{
//						if(!pThis->m_fEndReached)
//							pThis->ScrollListView(LONG_MAX);
//					}
					//NextRow
					else if(iCurPos > iLastPos)
					{
						EXC_TEST(pThis->ScrollListView(1));
					}
					//PrevRow
					else if(iCurPos < iLastPos)
					{
						EXC_TEST(pThis->ScrollListView(-1));
					}
					
					iLastPos = iCurPos;
					return 0;
				}

				case SB_THUMBPOSITION:
				{	
					//Get the current Position
					SHORT iCurPos = HIWORD(wParam);

					//If we are at the begining or end or the scrollbar, 
					//or we have hit the end of the rowset just exit.
					//These cases are covered in THUMBTRACK
					if(pThis->m_fEndReached || iCurPos==0 && iCurPos==(LONG)pThis->m_ulScrollMax)
						return 0;

					//Without IRowsetScroll we really have no clue how large
					//the rowset is without expensive traversal.  Even with
					//IRowsetScroll some providers may not return "exact" enough
					//ScrollInfo, so just place the thumb wherever they move it.
					EXC_TEST(pThis->SetScroll(iCurPos));
					return 0;
				}
			}

			break;
		}//WM_VSCROLL
		
		default:
			break;
	}

	return DefMDIChildProc(hWnd, message, wParam, lParam);
}


			
////////////////////////////////////////////////////////////////
// CMDIChild::SubClassEditBoxProc
//
/////////////////////////////////////////////////////////////////
LONG CALLBACK CMDIChild::SubClassEditBoxProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	//The "this" pointer was saved at CreateWindowEx time, no need to save it again...

	switch(message)
	{
		case WM_CONTEXTMENU:
		{	
			//xPos, yPos are in Screen Coordinates
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_EDITCONTEXT, 
								LOWORD(lParam),
								HIWORD(lParam),
								pThis->m_pCMainWindow->m_hWnd
								);
			return 0;
		}

		case WM_RBUTTONDOWN:
		{	
			//xPos, yPos are Relative to the Client Area...
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_EDITCONTEXT, 
								LOWORD(lParam),
								HIWORD(lParam),
								pThis->m_pCMainWindow->m_hWnd,
								TRUE
								);
			return 0;
		}

		case WM_KEYDOWN:
		{	
			switch (wParam)
			{
				case VK_RETURN:
				{	
					MSG msg;
					PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
					SendMessage(hWnd, WM_CHAR, wParam, MAKELONG(1, 28));
					return 0;
				}
				
				case VK_TAB:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

					MSG msg;
					SetFocus(pThis->m_hWndListView);
					PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
					return 0;
				}
			}
			break;
        }

		case WM_NCMOUSEMOVE:
		{	
			static HCURSOR hOldCursor = NULL;

			if(wParam == HTBORDER)
			{
				POINTS pts = MAKEPOINTS(lParam);					
				RECT rect;
				GetWindowRect(hWnd, &rect);
				INT iBorderCY = GetSystemMetrics(SM_CYBORDER);

				//Is the Mouse on the Bottom Border?
				if(pts.y >= (rect.bottom - iBorderCY - iBorderCY))
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					hOldCursor = SetCursor(pThis->m_pCMainWindow->m_hCurSizeNS);
					return 0;
				}
			}

			if(hOldCursor)
			{
				SetCursor(hOldCursor);
				hOldCursor = NULL;
			}

			//Break to default
			break;
		}

		case WM_NCLBUTTONDOWN:
		{	
			if(wParam == HTBORDER)
			{
				POINTS pts = MAKEPOINTS(lParam);
				RECT rectChild;
				GetWindowRect(hWnd, &rectChild);
				INT iBorderCY = GetSystemMetrics(SM_CYFIXEDFRAME);

				//Is the Mouse on the Bottom Border?
				if(pts.y >= (rectChild.bottom - iBorderCY - iBorderCY))
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

					//Obtain the width and height of the ChildWindow
					GetClientRect(pThis->m_hWnd, &rectChild);
					INT iWidth = rectChild.right;
				    INT iHeight = rectChild.bottom;

					//Obtain  width and height of the Control
					SIZE sizeEditBox = GetWindowSize(pThis->m_hWndEditBox);
					SIZE sizeListView = GetWindowSize(pThis->m_hWndListView);
					INT iMinPos = 0;
					INT iMaxPos = sizeEditBox.cy + sizeListView.cy;

					//Capture mouse so Frame window gets mouse messages
				    HDC hDC = GetDC(pThis->m_hWnd);
					SetCapture(pThis->m_hWnd);  
				    HCURSOR hOldCursor = SetCursor(pThis->m_pCMainWindow->m_hCurSizeNS);
					
				    //Draw initial split-bar
					pts.y = (SHORT)sizeEditBox.cy;
					PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);
				    
				   	BOOL bTracking = TRUE;
					MSG msgModal;

					//While the split-bar is being dragged
					while (bTracking)
				   	{   
						//Get mouse message
						GetMessage(&msgModal, NULL, WM_MOUSEFIRST, WM_MOUSELAST);
						switch (msgModal.message)
						{
							case WM_MOUSEMOVE:
							{	
								//Only redraw if different position than last time
								if(HIWORD(msgModal.lParam) != pts.y)
								{
									// Erase previous split-bar
									PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);

									// Get new mouse positions
									pts.x = LOWORD(msgModal.lParam);
									pts.y = HIWORD(msgModal.lParam);

									// Draw new split-bar if it has'nt been dragged 
									// off the client area of the frame                                                
									PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);
								}
								break;
							}

							// End of split-bar drag          
							case WM_LBUTTONUP:     
							case WM_LBUTTONDOWN:
							case WM_LBUTTONDBLCLK:
							case WM_RBUTTONUP:
							case WM_RBUTTONDOWN:
							case WM_RBUTTONDBLCLK:
							{
								// Erase the last split-bar 
								PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);
								
								// Get new mouse positions
								pts.x = LOWORD(msgModal.lParam);
								pts.y = HIWORD(msgModal.lParam);

								//We Now need to resize the Window
								//Only adjust windows if Mouse is within Max/Min Coords
								if(pts.y > iMinPos && pts.y < iMaxPos)
								{
									MoveWindow(hWnd, 0, 0, iWidth, pts.y, TRUE);
									SendMessage(pThis->m_hWnd, WM_SIZE, SIZE_RESTORED, MAKELONG(iWidth, iHeight));
								}
								
								bTracking = FALSE;  // Break out of tracking loop
								break;
							}
						}
					}

					ReleaseCapture();
				    SetCursor(hOldCursor);
	                ReleaseDC(hWnd, hDC);
					return 0;
				}
			}

			//Break to default
			break;
		}
	}

	//Otherwise just pass on message to orignal control
	CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
	return CallWindowProc(pThis->m_pSavedEditBoxProc, hWnd, message, wParam, lParam);
}



////////////////////////////////////////////////////////////////
// CMDIChild::SubClassListBoxProc
//
/////////////////////////////////////////////////////////////////
LONG CALLBACK CMDIChild::SubClassListBoxProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	//The "this" pointer was saved at CreateWindowEx time, no need to save it again...

	switch(message)
	{
		case WM_CONTEXTMENU:
		{	
			//xPos, yPos are in Screen Coordinates
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_NOTIFYCONTEXT, 
								LOWORD(lParam),
								HIWORD(lParam),
								pThis->m_pCMainWindow->m_hWnd
								);
			return 0;
		}

		case WM_RBUTTONDOWN:
		{	
			//xPos, yPos are Relative to the Client Area...
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_NOTIFYCONTEXT, 
								LOWORD(lParam),
								HIWORD(lParam),
								pThis->m_pCMainWindow->m_hWnd,
								TRUE
								);
			return 0;
		}

		case WM_KEYDOWN:
		{	
			switch (wParam)
			{
				case VK_TAB:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

					MSG msg;
					SetFocus(pThis->m_hWndEditBox);
					PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
					return 0;
				}
			}
			break;
        }

		case WM_NCMOUSEMOVE:
		{	
			static HCURSOR hOldCursor = NULL;

			if(wParam == HTBORDER)
			{
				POINTS pts = MAKEPOINTS(lParam);					
				RECT rect;
				GetWindowRect(hWnd, &rect);
				INT iBorderCY = GetSystemMetrics(SM_CYBORDER);

				//Is the Mouse on the Top Border?
				if(pts.y <= (rect.top + iBorderCY + iBorderCY))
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
					hOldCursor = SetCursor(pThis->m_pCMainWindow->m_hCurSizeNS);
					return 0;
				}
			}

			if(hOldCursor)
			{
				SetCursor(hOldCursor);
				hOldCursor = NULL;
			}

			//Break to default
			break;
		}

		case WM_NCLBUTTONDOWN:
		{	
			if(wParam == HTBORDER)
			{
				POINTS pts = MAKEPOINTS(lParam);
				RECT rectChild;
				GetWindowRect(hWnd, &rectChild);
				INT iBorderCY = GetSystemMetrics(SM_CYFIXEDFRAME);

				//Is the Mouse on the Bottom Border?
				if(pts.y <= (rectChild.top + iBorderCY + iBorderCY))
				{
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

					//Obtain the width and height of the ChildWindow
					GetClientRect(pThis->m_hWnd, &rectChild);
					INT iWidth = rectChild.right;
				    INT iHeight = rectChild.bottom;

					//Obtain  width and height of the Control
					SIZE sizeEditBox = GetWindowSize(pThis->m_hWndEditBox);
					SIZE sizeListBox = GetWindowSize(pThis->m_pCListBox->m_hWnd);
					INT iMinPos = sizeEditBox.cy;
					INT iMaxPos = rectChild.bottom;

					//Capture mouse so Frame window gets mouse messages
				    HDC hDC = GetDC(pThis->m_hWnd);
					SetCapture(pThis->m_hWnd);  
				    HCURSOR hOldCursor = SetCursor(pThis->m_pCMainWindow->m_hCurSizeNS);
					
				    //Draw initial split-bar
					pts.y = (SHORT)(rectChild.bottom - sizeListBox.cy);
					PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);
				    
				   	BOOL bTracking = TRUE;
					MSG msgModal;

					// While the split-bar is being dragged
					while (bTracking)  
				   	{   
						// Get mouse message
						GetMessage(&msgModal, NULL, WM_MOUSEFIRST, WM_MOUSELAST);
						switch (msgModal.message)
						{
							case WM_MOUSEMOVE:
							{	
								//Only redraw if different position than last time
								if(HIWORD(msgModal.lParam) != pts.y)
								{
									// Erase previous split-bar
									PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);

									// Get new mouse positions
									pts.x = LOWORD(msgModal.lParam);
									pts.y = HIWORD(msgModal.lParam);

									// Draw new split-bar if it has'nt been dragged 
									// off the client area of the frame                                                
									PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);
								}
								break;
							}

							// End of split-bar drag          
							case WM_LBUTTONUP:     
							case WM_LBUTTONDOWN:
							case WM_LBUTTONDBLCLK:
							case WM_RBUTTONUP:
							case WM_RBUTTONDOWN:
							case WM_RBUTTONDBLCLK:
							{
								// Erase the last split-bar 
								PatBlt(hDC, 0, pts.y, iWidth, iBorderCY, DSTINVERT);
								
								pts.x = LOWORD(msgModal.lParam);
								pts.y = HIWORD(msgModal.lParam);

								//We Now need to resize the Window
								//Only adjust windows if Mouse is within Max/Min Coords
								if(pts.y > iMinPos && pts.y < iMaxPos)
								{
									MoveWindow(hWnd, 0, pts.y, iWidth, rectChild.bottom - pts.y, TRUE);
									SendMessage(pThis->m_hWnd, WM_SIZE, SIZE_RESTORED, MAKELONG(iWidth, iHeight));
								}
								
								bTracking = FALSE;  // Break out of tracking loop
								break;
							}
						}
					}

					ReleaseCapture();
				    SetCursor(hOldCursor);
	                ReleaseDC(hWnd, hDC);
					return 0;
				}
			}

			//Break to default
			break;
		}
	}

	//Otherwise just pass on message to orignal control
	CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
	return CallWindowProc(pThis->m_pSavedListBoxProc, hWnd, message, wParam, lParam);
}


////////////////////////////////////////////////////////////////
// CMDIChild::SubClassListViewProc
//
/////////////////////////////////////////////////////////////////
LONG CALLBACK CMDIChild::SubClassListViewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	//The "this" pointer was saved at CreateWindowEx time, no need to save it again...

	switch(message)
	{
		case WM_CONTEXTMENU:
		{	
			CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
			DisplayContextMenu(	pThis->m_hInst, 
								hWnd,
								IDMENU_ROWCONTEXT, 
								LOWORD(lParam),
								HIWORD(lParam),
								pThis->m_pCMainWindow->m_hWnd
								);
			return FALSE;
		}

		case WM_KEYDOWN:
		{	
			switch (wParam)
			{
				case VK_TAB:
				{
					//Get the "this" pointer
					CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);

					MSG msg;
					SetFocus(pThis->m_pCListBox->m_hWnd);
					PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
					return 0;
				}
			}
			break;
        }
	}

	//Otherwise just pass on message to orignal control
	CMDIChild* pThis = (CMDIChild*)GetThis(hWnd);
	return CallWindowProc(pThis->m_pSavedListViewProc, hWnd, message, wParam, lParam);
}


////////////////////////////////////////////////////////////////
// CMDIChild::ReleaseRows
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::ReleaseRows(LONG iIndex)
{
	HRESULT hr = S_OK;
	IUnknown* pIUnknown = m_pCRowset->m_pIUnknown;
	ASSERT(pIUnknown);
	
	ULONG i,cRows = 0;
	LONG* rgItems = NULL;
	HROW* rghRows = NULL;
	ULONG* rgRefCounts = NULL;

	//Release all rows
	if(iIndex == LV_ALLITEMS)
	{
		//Find all Rows
		LV_GetAllItems(m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);
	}
	//Release all selected rows
	else if(iIndex == LV_ALLSELITEMS)
	{
		//Find all Selected Rows
		LV_GetSelItems(m_hWndListView, &cRows, &rgItems, (LONG**)&rghRows);
	}
	//Release 1 Row
	else
	{
		//First need to obtain the LPARAM (hRow) to Release it...
		cRows = 1;
		SAFE_ALLOC(rgItems, LONG, cRows);
		SAFE_ALLOC(rghRows, HROW, cRows);
		rgItems[0] = iIndex;
		rghRows[0] = LV_GetItemParam(m_hWndListView, iIndex, 0);
	}

	//Now ReleaseRows in 1 pass
	if (m_pCRowset->m_eRowsetSource != ROWSET_FROMCOMMANDDATASET)
	{
		SAFE_ALLOC(rgRefCounts, ULONG, cRows);
		TESTC(hr = m_pCRowset->ReleaseRows(cRows, rghRows, rgRefCounts));
	}

CLEANUP:
	//If any rows have a refcount of 0, we should NULL the row handle
	//so we can detect the error before GetData is called on a release row
	for(i=0; i<cRows; i++)
	{
		if(rgRefCounts[i] == 0)
			LV_SetItemParam(m_hWndListView, rgItems[i], 0, DB_NULL_HROW);
	}

	SAFE_FREE(rgItems);
	SAFE_FREE(rghRows);
	SAFE_FREE(rgRefCounts);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::AddRefRows
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::AddRefRows(LONG iIndex)
{
	HRESULT hr = S_OK;
	IUnknown* pIUnknown = m_pCRowset->m_pIUnknown;
	ASSERT(pIUnknown);
	
	ULONG cRows = 0;
	HROW* rghRows = NULL;
	ULONG* rgRefCounts = NULL;

	//AddRefRows all Rows
	if(iIndex == LV_ALLITEMS)
	{
		//Find all Rows
		LV_GetAllItems(m_hWndListView, &cRows, NULL, (LONG**)&rghRows);
	}
	//AddRefRows all selected rows
	else if(iIndex == LV_ALLSELITEMS)
	{
		//Find all Selected Rows
		LV_GetSelItems(m_hWndListView, &cRows, NULL, (LONG**)&rghRows);
	}
	//AddRefRows 1 Row
	else
	{
		//First need to obtain the LPARAM (hRow) to Release it...
		cRows = 1;
		rghRows[0] = LV_GetItemParam(m_hWndListView, iIndex, 0);
	}

	//Now AddRefRows in 1 pass
	if (m_pCRowset->m_eRowsetSource != ROWSET_FROMCOMMANDDATASET)
	{
	 	SAFE_ALLOC(rgRefCounts, ULONG, cRows);
		TESTC(hr = m_pCRowset->AddRefRows(cRows, rghRows, rgRefCounts));
	}

CLEANUP:
	SAFE_FREE(rghRows);
	SAFE_FREE(rgRefCounts);
	return hr;
}


////////////////////////////////////////////////////////////////
// CMDIChild::ClearListView
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::ClearListView(CHAR* pszEmptyName)
{
	// Delete all of the items.	(no need to release rows...)
	SendMessage(m_hWndListView, LVM_DELETEALLITEMS, 0, 0);

	// Delete all of the columns and their names.
	while(SendMessage(m_hWndListView, LVM_DELETECOLUMN, 0, 0));

	//Indicate no Rowset
	if(pszEmptyName)
	{
		LV_InsertColumn(m_hWndListView, 0, pszEmptyName);
		SendMessage(m_hWndListView, LVM_SETCOLUMNWIDTH, 0,	(LPARAM)LVSCW_AUTOSIZE_USEHEADER);
	}

	return S_OK;
}


////////////////////////////////////////////////////////////////
// CMDIChild::SetScroll
//
/////////////////////////////////////////////////////////////////
HRESULT CMDIChild::SetScroll(LONG lPos)
{
	//Make sure its in the scroll range
	lPos = min(lPos, (LONG)m_ulScrollMax);
	lPos = max(lPos, 0);

	//Set the new range
	SetScrollPos(m_hWndScrollBar, SB_CTL, lPos, TRUE);
	return S_OK;
}



//////////////////////////////////////////////////////////////////
// CListener
//
//////////////////////////////////////////////////////////////////
CListener::CListener(REFIID riid, CListBox* pCListBox)
	: m_riid(riid)
{
	ASSERT(pCListBox);
	m_pCListBox = pCListBox;
	
	m_cRef = 1;
	m_dwCookie = 0;
	m_hrReturn = S_OK;

//	m_riid = riid;
}

CListener::~CListener() 
{
}

HRESULT CListener::SetReturnValue(HRESULT hrReturn)
{
	m_hrReturn = hrReturn;
	return S_OK;
}

HRESULT CListener::GetReturnValue()
{
	return m_hrReturn;
}

HRESULT CListener::Advise(IConnectionPoint* pIConnectionPoint)
{
	HRESULT hr = S_OK;
	ASSERT(pIConnectionPoint);
	HWND hWnd = m_pCListBox->m_hWnd;

	//Now we can advise the connection
	TESTC(m_pCListBox->OutputPreMethod("IConnectionPoint::Advise(0x%08x, &0x%08x)", this, m_dwCookie));
	XTEST(hWnd, hr = pIConnectionPoint->Advise(this, &m_dwCookie));
	TESTC(m_pCListBox->OutputPostMethod(hr, "IConnectionPoint::Advise(0x%08x, &0x%08x)", this, m_dwCookie));

CLEANUP:
	return hr;
}

HRESULT CListener::Advise(IUnknown* pIUnknown)
{
	HRESULT hr = S_OK;
	HWND hWnd = m_pCListBox->m_hWnd;
	ASSERT(pIUnknown);

	IConnectionPoint* pICP = NULL;
	IConnectionPointContainer* pICPC = NULL;

	//Obtain the connection point container
	//IConnectionPointContainer is optional...
	hr = m_pCListBox->OutputQI(pIUnknown, IID_IConnectionPointContainer, (IUnknown**)&pICPC, "IUnknown");
	if(SUCCEEDED(hr))
	{
		//Obtain the IRowsetNotify connection point 
		//IRowsetNotify is also optional
		m_pCListBox->OutputPreMethod("IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(m_riid), pICP);
		hr = pICPC->FindConnectionPoint(m_riid, &pICP);
		m_pCListBox->OutputPostMethod(hr, "IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(m_riid), pICP);
		
		if(SUCCEEDED(hr))
		{
			//Now we can advise the connection
			TESTC(Advise(pICP));
		}
	}

CLEANUP:
	m_pCListBox->OutputRelease((IUnknown**)&pICP,	"IConnectionPoint");
	m_pCListBox->OutputRelease((IUnknown**)&pICPC,	"IConnectionPointContainer");
	return hr;
}

HRESULT CListener::Unadvise(IConnectionPoint* pIConnectionPoint)
{
	HRESULT hr = S_OK;
	ASSERT(pIConnectionPoint);
	HWND hWnd = m_pCListBox->m_hWnd;

	if(m_dwCookie)
	{
		//Now we can Unadvise the connection
		TESTC(m_pCListBox->OutputPreMethod("IConnectionPoint::Unadvise(0x%08x)", m_dwCookie));
		XTEST(hWnd, hr = pIConnectionPoint->Unadvise(m_dwCookie));
		TESTC(m_pCListBox->OutputPostMethod(hr, "IConnectionPoint::Unadvise(0x%08x)", m_dwCookie));
		m_dwCookie = 0;
	}

CLEANUP:
	return hr;
}

HRESULT CListener::Unadvise(IUnknown* pIUnknown)
{
	HRESULT hr = S_OK;
	HWND hWnd = m_pCListBox->m_hWnd;
	ASSERT(pIUnknown);

	IConnectionPoint* pICP = NULL;
	IConnectionPointContainer* pICPC = NULL;

	//Obtain the connection point container
	//IConnectionPointContainer is optional...
	hr = m_pCListBox->OutputQI(pIUnknown, IID_IConnectionPointContainer, (IUnknown**)&pICPC, "IUnknown");
	if(SUCCEEDED(hr))
	{
		//Obtain the IRowsetNotify connection point 
		//IRowsetNotify is also optional
		m_pCListBox->OutputPreMethod("IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(m_riid), pICP);
		hr = pICPC->FindConnectionPoint(m_riid, &pICP);
		m_pCListBox->OutputPostMethod(hr, "IConnectionPointContainer::FindConnectionPoint(%s, &0x%08x)", GetInterfaceName(m_riid), pICP);

		if(SUCCEEDED(hr))
		{
			//Now Unadvise the connection
			TESTC(Unadvise(pICP));
		}
	}

CLEANUP:
	m_pCListBox->OutputRelease((IUnknown**)&pICP,	"IConnectionPoint");
	m_pCListBox->OutputRelease((IUnknown**)&pICPC,	"IConnectionPointContainer");
	return hr;
}


ULONG	CListener::AddRef()
{
	return ++m_cRef;
}

ULONG	CListener::Release()
{
	ASSERT(m_cRef);
	if(--m_cRef)
		return m_cRef;
	
	delete this;
	return 0;
}

HRESULT CListener::QueryInterface(REFIID riid, LPVOID* ppv)
{
	// Simplified version...

	//TEST_ NULL
	if(ppv == NULL)
		return E_POINTER;

	//Support IID_IUnknown
	if(riid == IID_IUnknown)
	{
		*ppv = (IUnknown*)this;
		AddRef();
		return NOERROR;
	}
	
	return E_NOINTERFACE;
}



//////////////////////////////////////////////////////////////////
// CRowsetNotify
//
//////////////////////////////////////////////////////////////////
CRowsetNotify::CRowsetNotify(CListBox* pCListBox)
	: CListener(IID_IRowsetNotify, pCListBox)
{
}

CRowsetNotify::~CRowsetNotify() 
{
}

ULONG	CRowsetNotify::AddRef()
{
	return ++m_cRef;
}

ULONG	CRowsetNotify::Release()
{
	ASSERT(m_cRef);
	if(--m_cRef)
		return m_cRef;
	
	delete this;
	return 0;
}
HRESULT CRowsetNotify::QueryInterface(REFIID riid, LPVOID* ppv)
{
	// Simplified version...

	//TEST_ NULL
	if(ppv == NULL)
		return E_POINTER;

	//Support IID_IUnknown
	//Support IID_IRowsetNotify
	if(riid == IID_IUnknown ||
		riid == IID_IRowsetNotify)
	{
		*ppv = (void *) this;
		AddRef();
		return NOERROR;
	}
	
	return E_NOINTERFACE;
}

HRESULT STDMETHODCALLTYPE CRowsetNotify::OnFieldChange( 
            /* [in] */ IRowset __RPC_FAR* pIRowset,
            /* [in] */ HROW hRow,
            /* [in] */ ULONG cColumns,
            /* [size_is][in] */ ULONG __RPC_FAR rgColumns[  ],
            /* [in] */ DBREASON eReason,
            /* [in] */ DBEVENTPHASE ePhase,
            /* [in] */ BOOL fCantDeny)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IRowsetNotify::OnFieldChange(%s, %s, 0x%08x, 0x%08x, %d, 0x%08x, %s) - %S", GetReasonName(eReason), GetPhaseName(ePhase), pIRowset, hRow, cColumns, rgColumns, fCantDeny ? "TRUE" : "FALSE", GetErrorName(m_hrReturn));
	return m_hrReturn;
}
        
HRESULT STDMETHODCALLTYPE CRowsetNotify::OnRowChange( 
            /* [in] */ IRowset __RPC_FAR* pIRowset,
            /* [in] */ ULONG cRows,
            /* [size_is][in] */ const HROW __RPC_FAR rghRows[  ],
            /* [in] */ DBREASON eReason,
            /* [in] */ DBEVENTPHASE ePhase,
            /* [in] */ BOOL fCantDeny)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IRowsetNotify::OnRowChange(%s, %s, 0x%08x, %d, 0x%08x, %s) - %S", GetReasonName(eReason), GetPhaseName(ePhase), pIRowset, cRows, rghRows, fCantDeny ? "TRUE" : "FALSE", GetErrorName(m_hrReturn));
	return m_hrReturn;
}
        
HRESULT STDMETHODCALLTYPE CRowsetNotify::OnRowsetChange( 
            /* [in] */ IRowset __RPC_FAR* pIRowset,
            /* [in] */ DBREASON eReason,
            /* [in] */ DBEVENTPHASE ePhase,
            /* [in] */ BOOL fCantDeny)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IRowsetNotify::OnRowsetChange(%s, %s, 0x%08x, %s) - %S", GetReasonName(eReason), GetPhaseName(ePhase), pIRowset, fCantDeny ? "TRUE" : "FALSE", GetErrorName(m_hrReturn));
	return m_hrReturn;
}

//////////////////////////////////////////////////////////////////
// CAsynchNotify
//
//////////////////////////////////////////////////////////////////
CAsynchNotify::CAsynchNotify(CListBox* pCListBox)
	: CListener(IID_IDBAsynchNotify, pCListBox)
{
}

CAsynchNotify::~CAsynchNotify() 
{
}


ULONG	CAsynchNotify::AddRef()
{
	return ++m_cRef;
}

ULONG	CAsynchNotify::Release()
{
	ASSERT(m_cRef);
	if(--m_cRef)
		return m_cRef;
	
	delete this;
	return 0;
}
HRESULT CAsynchNotify::QueryInterface(REFIID riid, LPVOID* ppv)
{
	// Simplified version...

	//TEST_ NULL
	if(ppv == NULL)
		return E_POINTER;

	//Support IID_IUnknown
	//Support IID_IDBAsynchNotify
	if(riid == IID_IUnknown ||
		riid == IID_IDBAsynchNotify)
	{
		*ppv = (void *) this;
		AddRef();
		return NOERROR;
	}
	
	return E_NOINTERFACE;
}

HRESULT STDMETHODCALLTYPE CAsynchNotify::OnLowResource(DWORD dwReserved)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IDBAsynchNotify::OnLowResource(%d) - %S", dwReserved, GetErrorName(m_hrReturn));
	return m_hrReturn;
}
        
HRESULT STDMETHODCALLTYPE CAsynchNotify::OnProgress
		( 
            HCHAPTER hChapter,
            ULONG    ulOperation,
            ULONG    ulProgress,
            ULONG    ulProgressMax,
            ULONG    ulAsynchPhase,
            LPOLESTR pwszStatusText
		)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IDBAsynchNotify::OnProgress(%d, %s, %d, %d, %s, %S) - %S", hChapter, GetAsynchReason(ulOperation), ulProgress, ulProgressMax, GetAsynchPhase(ulAsynchPhase), pwszStatusText, GetErrorName(m_hrReturn));
	return m_hrReturn;
}
        
HRESULT STDMETHODCALLTYPE CAsynchNotify::OnStop
		( 
            HCHAPTER hChapter,
            ULONG    ulOperation,
           	HRESULT  hrStatus,
            LPOLESTR pwszStatusText
		)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IDBAsynchNotify::OnStop(%d, %s, %S, %S) - %S", hChapter, GetAsynchReason(ulOperation), GetErrorName(hrStatus), pwszStatusText, GetErrorName(m_hrReturn));
	return m_hrReturn;
}


///////////////////////////////////////////////////////////////////
// CRowPosChange
//
///////////////////////////////////////////////////////////////////
CRowPosChange::CRowPosChange(CListBox* pCListBox)
	: CListener(IID_IRowPositionChange, pCListBox)
{
}

CRowPosChange::~CRowPosChange()
{
}

ULONG	CRowPosChange::AddRef()
{
	return ++m_cRef;
}

ULONG	CRowPosChange::Release()
{
	ASSERT(m_cRef);
	if(--m_cRef)
		return m_cRef;
	
	delete this;
	return 0;
}
HRESULT CRowPosChange::QueryInterface(REFIID riid, LPVOID* ppv)
{
	// Simplified version...

	//TEST_ NULL
	if(ppv == NULL)
		return E_POINTER;

	//Support IID_IUnknown
	//Support IID_IRowPositionChange
	if(riid == IID_IUnknown ||
		riid == IID_IRowPositionChange)
	{
		*ppv = (void *) this;
		AddRef();
		return NOERROR;
	}
	
	return E_NOINTERFACE;
}


STDMETHODIMP_(HRESULT) CRowPosChange::OnRowPositionChange(
		DBREASON		eReason,
		DBEVENTPHASE	ePhase,
		BOOL			fCantDeny)
{
	//Output Notification
	m_pCListBox->OutputNotification(NOTIFY_IROWSETNOTIFY, "     IRowPositionChange::OnRowPositionChange(%s, %s, %s) - %S", GetReasonName(eReason), GetPhaseName(ePhase), fCantDeny ? "TRUE" : "FALSE", GetErrorName(m_hrReturn));
	return m_hrReturn;
}


//////////////////////////////////////////////////////////////////////////////
// Helper Routines
//
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// GetPhaseName
//
//////////////////////////////////////////////////////////////////////////////
CHAR* GetPhaseName(DBEVENTPHASE ePhase)
{
	const static NAMEMAP	rgPhase[] =
	{
		VALUE_CHAR(DBEVENTPHASE_OKTODO),
		VALUE_CHAR(DBEVENTPHASE_ABOUTTODO),
		VALUE_CHAR(DBEVENTPHASE_SYNCHAFTER),
		VALUE_CHAR(DBEVENTPHASE_DIDEVENT),
		VALUE_CHAR(DBEVENTPHASE_FAILEDTODO)
	};

	return GetMapName(ePhase, NUMELE(rgPhase), rgPhase);
}

//////////////////////////////////////////////////////////////////////////////
// GetReasonName
//
//////////////////////////////////////////////////////////////////////////////
CHAR* GetReasonName(DBREASON eReason)
{
	const static NAMEMAP	rgReason[] =
	{
		VALUE_CHAR(	DBREASON_ROWSET_FETCHPOSITIONCHANGE	),
		VALUE_CHAR(	DBREASON_ROWSET_RELEASE	),
		VALUE_CHAR(	DBREASON_COLUMN_SET	),
		VALUE_CHAR(	DBREASON_COLUMN_RECALCULATED	),
		VALUE_CHAR(	DBREASON_ROW_ACTIVATE	),
		VALUE_CHAR(	DBREASON_ROW_RELEASE	),
		VALUE_CHAR(	DBREASON_ROW_DELETE	),
		VALUE_CHAR(	DBREASON_ROW_FIRSTCHANGE	),
		VALUE_CHAR(	DBREASON_ROW_INSERT	),
		VALUE_CHAR(	DBREASON_ROW_RESYNCH	),
		VALUE_CHAR(	DBREASON_ROW_UNDOCHANGE	),
		VALUE_CHAR(	DBREASON_ROW_UNDOINSERT	),
		VALUE_CHAR(	DBREASON_ROW_UNDODELETE	),
		VALUE_CHAR(	DBREASON_ROW_UPDATE	),
		VALUE_CHAR(	DBREASON_ROWSET_CHANGED	),
		
		VALUE_CHAR( DBREASON_ROWPOSITION_CHANGED	),
		VALUE_CHAR(	DBREASON_ROWPOSITION_CHAPTERCHANGED	),
		VALUE_CHAR(	DBREASON_ROWPOSITION_CLEARED	),
		VALUE_CHAR(	DBREASON_ROW_ASYNCHINSERT	),
			  		
//		VALUE_CHAR(	DBREASON_ROWSET_ROWSADDED	),
//		VALUE_CHAR(	DBREASON_ROWSET_POPULATIONCOMPLETE	),
//		VALUE_CHAR(	DBREASON_ROWSET_POPULATIONSTOPPED	),
	};

	return GetMapName(eReason, NUMELE(rgReason), rgReason);
}


//////////////////////////////////////////////////////////////////////////////
// GetAsynchReason
//
//////////////////////////////////////////////////////////////////////////////
CHAR* GetAsynchReason(ULONG ulOperation)
{
	const static NAMEMAP	rgAsynchReason[] =
	{
		VALUE_CHAR(	DBASYNCHOP_OPEN	),
	};

	return GetMapName(ulOperation, NUMELE(rgAsynchReason), rgAsynchReason);
}

//////////////////////////////////////////////////////////////////////////////
// GetAsynchPhase
//
//////////////////////////////////////////////////////////////////////////////
CHAR* GetAsynchPhase(ULONG ulAsynchPhase)
{
	const static NAMEMAP	rgAsynchPhase[] =
	{
		VALUE_CHAR(DBASYNCHPHASE_INITIALIZATION),
		VALUE_CHAR(DBASYNCHPHASE_POPULATION),
		VALUE_CHAR(DBASYNCHPHASE_COMPLETE),
	};

	return GetMapName(ulAsynchPhase, NUMELE(rgAsynchPhase), rgAsynchPhase);
}
